/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import gnu.regexp.RE;
import java.util.Hashtable;
import java.util.LinkedList;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRule;

public class ParserRuleSet {
    private static ParserRuleSet[] standard = new ParserRuleSet[19];
    private static final int RULE_BUCKET_COUNT = 128;
    private String modeName;
    private String setName;
    private Hashtable props;
    private KeywordMap keywords;
    private int ruleCount;
    private ParserRule[] ruleMapFirst;
    private ParserRule[] ruleMapLast;
    private LinkedList imports;
    private int terminateChar = -1;
    private boolean ignoreCase = true;
    private byte defaultToken;
    private ParserRule escapeRule;
    private boolean highlightDigits;
    private RE digitRE;
    private String _noWordSep;
    private String noWordSep;
    private boolean builtIn;

    public static ParserRuleSet getStandardRuleSet(byte by) {
        return standard[by];
    }

    public ParserRuleSet(String string, String string2) {
        this.modeName = string;
        this.setName = string2;
        this.ruleMapFirst = new ParserRule[128];
        this.ruleMapLast = new ParserRule[128];
        this.imports = new LinkedList();
    }

    public String getModeName() {
        return this.modeName;
    }

    public String getSetName() {
        return this.setName;
    }

    public String getName() {
        return this.modeName + "::" + this.setName;
    }

    public Hashtable getProperties() {
        return this.props;
    }

    public void setProperties(Hashtable hashtable) {
        this.props = hashtable;
        this._noWordSep = null;
    }

    public void resolveImports() {
        for (ParserRuleSet parserRuleSet : this.imports) {
            for (int i = 0; i < parserRuleSet.ruleMapFirst.length; ++i) {
                ParserRule parserRule = parserRuleSet.ruleMapFirst[i];
                while (parserRule != null) {
                    this.addRule(parserRule);
                    parserRule = parserRule.next;
                }
            }
            if (parserRuleSet.keywords == null) continue;
            if (this.keywords == null) {
                this.keywords = new KeywordMap(this.ignoreCase);
            }
            this.keywords.add(parserRuleSet.keywords);
        }
        this.imports.clear();
    }

    public void addRuleSet(ParserRuleSet parserRuleSet) {
        this.imports.add(parserRuleSet);
    }

    public void addRule(ParserRule parserRule) {
        ++this.ruleCount;
        int n = Character.toUpperCase(parserRule.hashChar) % 128;
        ParserRule parserRule2 = this.ruleMapLast[n];
        if (parserRule2 == null) {
            this.ruleMapFirst[n] = this.ruleMapLast[n] = parserRule;
        } else {
            parserRule2.next = parserRule;
            this.ruleMapLast[n] = parserRule;
        }
    }

    public ParserRule getRules(char c) {
        int n = Character.toUpperCase(c) % 128;
        return this.ruleMapFirst[n];
    }

    public int getRuleCount() {
        return this.ruleCount;
    }

    public int getTerminateChar() {
        return this.terminateChar;
    }

    public void setTerminateChar(int n) {
        this.terminateChar = n >= 0 ? n : -1;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public KeywordMap getKeywords() {
        return this.keywords;
    }

    public void setKeywords(KeywordMap keywordMap) {
        this.keywords = keywordMap;
        this._noWordSep = null;
    }

    public boolean getHighlightDigits() {
        return this.highlightDigits;
    }

    public void setHighlightDigits(boolean bl) {
        this.highlightDigits = bl;
    }

    public RE getDigitRegexp() {
        return this.digitRE;
    }

    public void setDigitRegexp(RE rE) {
        this.digitRE = rE;
    }

    public ParserRule getEscapeRule() {
        return this.escapeRule;
    }

    public void setEscapeRule(ParserRule parserRule) {
        this.addRule(parserRule);
        this.escapeRule = parserRule;
    }

    public byte getDefault() {
        return this.defaultToken;
    }

    public void setDefault(byte by) {
        this.defaultToken = by;
    }

    public String getNoWordSep() {
        if (this._noWordSep == null) {
            this._noWordSep = this.noWordSep;
            if (this.noWordSep == null) {
                this.noWordSep = "";
            }
            if (this.keywords != null) {
                this.noWordSep = this.noWordSep + this.keywords.getNonAlphaNumericChars();
            }
        }
        return this.noWordSep;
    }

    public void setNoWordSep(String string) {
        this.noWordSep = string;
        this._noWordSep = null;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.modeName + "::" + this.setName + "]";
    }

    static {
        for (byte by = 0; by < standard.length; by = (byte)(by + 1)) {
            ParserRuleSet.standard[by] = new ParserRuleSet(null, null);
            standard[by].setDefault(by);
            ParserRuleSet.standard[by].builtIn = true;
        }
    }
}

