/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.ArrayList;
import java.util.List;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DisplayTokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;

class ChunkCache {
    private JEditTextArea textArea;
    private Buffer buffer;
    private LineInfo[] lineInfo;
    private ArrayList out;
    private int firstInvalidLine;
    private int lastScreenLineP;
    private int lastScreenLine;
    private boolean needFullRepaint;
    private DisplayTokenHandler tokenHandler;

    ChunkCache(JEditTextArea jEditTextArea) {
        this.textArea = jEditTextArea;
        this.out = new ArrayList();
        this.tokenHandler = new DisplayTokenHandler();
    }

    int getMaxHorizontalScrollWidth() {
        int n = 0;
        for (int i = 0; i < this.firstInvalidLine; ++i) {
            LineInfo lineInfo = this.lineInfo[i];
            if (lineInfo.width <= n) continue;
            n = lineInfo.width;
        }
        return n;
    }

    int getScreenLineOfOffset(int n, int n2) {
        if (this.lineInfo.length == 0) {
            return -1;
        }
        if (n < this.textArea.getFirstPhysicalLine()) {
            return -1;
        }
        if (n == this.textArea.getFirstPhysicalLine() && n2 < this.getLineInfo((int)0).offset) {
            return -1;
        }
        if (n > this.textArea.getLastPhysicalLine()) {
            return -1;
        }
        if (n == this.lastScreenLineP) {
            LineInfo lineInfo = this.getLineInfo(this.lastScreenLine);
            if (n2 >= lineInfo.offset && n2 < lineInfo.offset + lineInfo.length) {
                return this.lastScreenLine;
            }
        }
        int n3 = -1;
        for (int i = 0; i < this.textArea.getVisibleLines(); ++i) {
            LineInfo lineInfo = this.getLineInfo(i);
            if (lineInfo.physicalLine > n) {
                return i - 1;
            }
            if (lineInfo.physicalLine != n || n2 < lineInfo.offset || n2 >= lineInfo.offset + lineInfo.length) continue;
            n3 = i;
            break;
        }
        if (n3 == -1) {
            return -1;
        }
        this.lastScreenLineP = n;
        this.lastScreenLine = n3;
        return n3;
    }

    void recalculateVisibleLines() {
        int n;
        LineInfo[] lineInfoArray = new LineInfo[this.textArea.getVisibleLines()];
        if (this.lineInfo == null) {
            n = 0;
        } else {
            n = Math.min(this.lineInfo.length, lineInfoArray.length);
            System.arraycopy(this.lineInfo, 0, lineInfoArray, 0, n);
        }
        for (int i = n; i < lineInfoArray.length; ++i) {
            lineInfoArray[i] = new LineInfo();
        }
        this.lineInfo = lineInfoArray;
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void setBuffer(Buffer buffer) {
        this.buffer = buffer;
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void scrollDown(int n) {
        int n2 = this.textArea.getVisibleLines();
        System.arraycopy(this.lineInfo, n, this.lineInfo, 0, n2 - n);
        for (int i = n2 - n; i < n2; ++i) {
            this.lineInfo[i] = new LineInfo();
        }
        this.firstInvalidLine -= n;
        if (this.firstInvalidLine < 0) {
            this.firstInvalidLine = 0;
        }
        if (Debug.CHUNK_CACHE_DEBUG) {
            System.err.println("f > t.f: only " + n + " need updates");
        }
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void scrollUp(int n) {
        int n2;
        System.arraycopy(this.lineInfo, 0, this.lineInfo, n, this.textArea.getVisibleLines() - n);
        for (n2 = 0; n2 < n; ++n2) {
            this.lineInfo[n2] = new LineInfo();
        }
        n2 = this.firstInvalidLine;
        this.firstInvalidLine = 0;
        this.updateChunksUpTo(n);
        this.firstInvalidLine = n2 + n;
        if (this.firstInvalidLine > this.textArea.getVisibleLines()) {
            this.firstInvalidLine = this.textArea.getVisibleLines();
        }
        if (Debug.CHUNK_CACHE_DEBUG) {
            Log.log(1, this, "f > t.f: only " + n + " need updates");
        }
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void invalidateAll() {
        this.firstInvalidLine = 0;
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void invalidateChunksFrom(int n) {
        if (Debug.CHUNK_CACHE_DEBUG) {
            Log.log(1, this, "Invalidate from " + n);
        }
        this.firstInvalidLine = Math.min(n, this.firstInvalidLine);
        if (n <= this.lastScreenLine) {
            this.lastScreenLineP = -1;
            this.lastScreenLine = -1;
        }
    }

    void invalidateChunksFromPhys(int n) {
        for (int i = 0; i < this.firstInvalidLine; ++i) {
            LineInfo lineInfo = this.lineInfo[i];
            if (lineInfo.physicalLine != -1 && lineInfo.physicalLine < n) continue;
            this.firstInvalidLine = i;
            if (i > this.lastScreenLine) break;
            this.lastScreenLineP = -1;
            this.lastScreenLine = -1;
            break;
        }
    }

    LineInfo getLineInfo(int n) {
        this.updateChunksUpTo(n);
        return this.lineInfo[n];
    }

    int getLineSubregionCount(int n) {
        if (!this.textArea.displayManager.softWrap) {
            return 1;
        }
        this.out.clear();
        this.lineToChunkList(n, this.out);
        int n2 = this.out.size();
        if (n2 == 0) {
            return 1;
        }
        return n2;
    }

    int getSubregionOfOffset(int n, LineInfo[] lineInfoArray) {
        for (int i = 0; i < lineInfoArray.length; ++i) {
            LineInfo lineInfo = lineInfoArray[i];
            if (n < lineInfo.offset || n >= lineInfo.offset + lineInfo.length) continue;
            return i;
        }
        return -1;
    }

    int xToSubregionOffset(int n, int n2, int n3, boolean bl) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        if (n2 == -1) {
            n2 += lineInfoArray.length;
        }
        return this.xToSubregionOffset(lineInfoArray[n2], n3, bl);
    }

    int xToSubregionOffset(LineInfo lineInfo, int n, boolean bl) {
        int n2 = Chunk.xToOffset(lineInfo.chunks, n, bl);
        if (n2 == -1 || n2 == lineInfo.offset + lineInfo.length) {
            n2 = lineInfo.offset + lineInfo.length - 1;
        }
        return n2;
    }

    int subregionOffsetToX(int n, int n2) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        LineInfo lineInfo = lineInfoArray[this.getSubregionOfOffset(n2, lineInfoArray)];
        return this.subregionOffsetToX(lineInfo, n2);
    }

    int subregionOffsetToX(LineInfo lineInfo, int n) {
        return (int)Chunk.offsetToX(lineInfo.chunks, n);
    }

    int getSubregionStartOffset(int n, int n2) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        LineInfo lineInfo = lineInfoArray[this.getSubregionOfOffset(n2, lineInfoArray)];
        return this.textArea.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset;
    }

    int getSubregionEndOffset(int n, int n2) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        LineInfo lineInfo = lineInfoArray[this.getSubregionOfOffset(n2, lineInfoArray)];
        return this.textArea.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset + lineInfo.length;
    }

    int getBelowPosition(int n, int n2, int n3, boolean bl) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        int n4 = this.getSubregionOfOffset(n2, lineInfoArray);
        if (n4 != lineInfoArray.length - 1 && !bl) {
            return this.textArea.getLineStartOffset(n) + this.xToSubregionOffset(lineInfoArray[n4 + 1], n3, true);
        }
        int n5 = this.textArea.displayManager.getNextVisibleLine(n);
        if (n5 == -1) {
            return -1;
        }
        return this.textArea.getLineStartOffset(n5) + this.xToSubregionOffset(n5, 0, n3, true);
    }

    int getAbovePosition(int n, int n2, int n3, boolean bl) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        int n4 = this.getSubregionOfOffset(n2, lineInfoArray);
        if (n4 != 0 && !bl) {
            return this.textArea.getLineStartOffset(n) + this.xToSubregionOffset(lineInfoArray[n4 - 1], n3, true);
        }
        int n5 = this.textArea.displayManager.getPrevVisibleLine(n);
        if (n5 == -1) {
            return -1;
        }
        return this.textArea.getLineStartOffset(n5) + this.xToSubregionOffset(n5, -1, n3, true);
    }

    boolean needFullRepaint() {
        boolean bl = this.needFullRepaint;
        this.needFullRepaint = false;
        return bl;
    }

    LineInfo[] getLineInfosForPhysicalLine(int n) {
        this.out.clear();
        if (this.buffer.isLoaded()) {
            this.lineToChunkList(n, this.out);
        }
        if (this.out.size() == 0) {
            this.out.add(null);
        }
        ArrayList arrayList = new ArrayList(this.out.size());
        this.getLineInfosForPhysicalLine(n, arrayList);
        return arrayList.toArray(new LineInfo[this.out.size()]);
    }

    private void getLineInfosForPhysicalLine(int n, List list) {
        for (int i = 0; i < this.out.size(); ++i) {
            Chunk chunk = (Chunk)this.out.get(i);
            LineInfo lineInfo = new LineInfo();
            lineInfo.physicalLine = n;
            if (i == 0) {
                lineInfo.firstSubregion = true;
                lineInfo.offset = 0;
            } else {
                lineInfo.offset = chunk.offset;
            }
            if (i == this.out.size() - 1) {
                lineInfo.lastSubregion = true;
                lineInfo.length = this.textArea.getLineLength(n) - lineInfo.offset + 1;
            } else {
                lineInfo.length = ((Chunk)this.out.get((int)(i + 1))).offset - lineInfo.offset;
            }
            lineInfo.chunks = chunk;
            list.add(lineInfo);
        }
    }

    private void updateChunksUpTo(int n) {
        int n2;
        int n3;
        if (n >= this.lineInfo.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < this.firstInvalidLine) {
            return;
        }
        int n4 = 0;
        for (n3 = this.firstInvalidLine - 1; n3 >= 0; --n3) {
            if (!this.lineInfo[n3].lastSubregion) continue;
            n4 = n3 + 1;
            break;
        }
        n3 = n4 == 0 ? this.textArea.getFirstPhysicalLine() : ((n2 = this.lineInfo[n4 - 1].physicalLine) == -1 ? -1 : this.textArea.displayManager.getNextVisibleLine(n2));
        if (Debug.CHUNK_CACHE_DEBUG) {
            Log.log(1, this, "Updating chunks from " + n4 + " to " + n);
        }
        this.out.clear();
        n2 = 0;
        int n5 = 0;
        for (int i = n4; i <= n; ++i) {
            int n6;
            Chunk chunk;
            LineInfo lineInfo = this.lineInfo[i];
            if (this.out.size() == 0) {
                if (n3 != -1 && i != n4) {
                    n3 = this.textArea.displayManager.getNextVisibleLine(n3);
                }
                if (n3 == -1) {
                    lineInfo.chunks = null;
                    lineInfo.physicalLine = -1;
                    lineInfo.width = 0;
                    continue;
                }
                this.lineToChunkList(n3, this.out);
                lineInfo.firstSubregion = true;
                if (this.out.size() == 0) {
                    this.textArea.displayManager.setScreenLineCount(n3, 1);
                    if (i == 0 && this.textArea.displayManager.firstLine.skew > 0) {
                        Log.log(9, this, "BUG: skew=" + this.textArea.displayManager.firstLine.skew + ",out.size()=" + this.out.size());
                        this.textArea.displayManager.firstLine.skew = 0;
                        this.needFullRepaint = true;
                        n = this.lineInfo.length - 1;
                    }
                    chunk = null;
                    n2 = 0;
                    n5 = 1;
                } else {
                    this.textArea.displayManager.setScreenLineCount(n3, this.out.size());
                    if (i == 0) {
                        n6 = this.textArea.displayManager.firstLine.skew;
                        if (n6 >= this.out.size()) {
                            Log.log(9, this, "BUG: skew=" + n6 + ",out.size()=" + this.out.size());
                            n6 = 0;
                            this.needFullRepaint = true;
                            n = this.lineInfo.length - 1;
                        } else if (n6 > 0) {
                            lineInfo.firstSubregion = false;
                            for (int j = 0; j < n6; ++j) {
                                this.out.remove(0);
                            }
                        }
                    }
                    chunk = (Chunk)this.out.get(0);
                    this.out.remove(0);
                    n2 = chunk.offset;
                    n5 = this.out.size() != 0 ? ((Chunk)this.out.get((int)0)).offset - n2 : this.textArea.getLineLength(n3) - n2 + 1;
                }
            } else {
                lineInfo.firstSubregion = false;
                chunk = (Chunk)this.out.get(0);
                this.out.remove(0);
                n2 = chunk.offset;
                n5 = this.out.size() != 0 ? ((Chunk)this.out.get((int)0)).offset - n2 : this.textArea.getLineLength(n3) - n2 + 1;
            }
            int n7 = n6 = this.out.size() == 0 ? 1 : 0;
            if (i == n && n != this.lineInfo.length - 1) {
                if (this.tokenHandler.getLineContext() != lineInfo.lineContext) {
                    ++n;
                    this.needFullRepaint = true;
                } else if (lineInfo.physicalLine != n3 || lineInfo.lastSubregion != n6) {
                    ++n;
                    this.needFullRepaint = true;
                } else if (this.out.size() != 0) {
                    ++n;
                }
            }
            lineInfo.physicalLine = n3;
            lineInfo.lastSubregion = n6;
            lineInfo.offset = n2;
            lineInfo.length = n5;
            lineInfo.chunks = chunk;
            lineInfo.lineContext = this.tokenHandler.getLineContext();
        }
        this.firstInvalidLine = Math.max(n + 1, this.firstInvalidLine);
    }

    private void lineToChunkList(int n, List list) {
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        this.tokenHandler.init(textAreaPainter.getStyles(), textAreaPainter.getFontRenderContext(), textAreaPainter, list, this.textArea.displayManager.softWrap ? (float)this.textArea.displayManager.wrapMargin : 0.0f);
        this.buffer.markTokens(n, this.tokenHandler);
    }

    static class LineInfo {
        int physicalLine;
        int offset;
        int length;
        boolean firstSubregion;
        boolean lastSubregion;
        Chunk chunks;
        int width;
        TokenMarker.LineContext lineContext;

        LineInfo() {
        }
    }
}

