/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferChangeAdapter;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.LineManager;
import org.gjt.sp.jedit.gui.BeanShellErrorDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;

public class DisplayManager {
    public static long scanCount;
    public static long scannedLines;
    private static Map bufferMap;
    boolean softWrap;
    int wrapMargin;
    FirstLine firstLine;
    ScrollLineCount scrollLineCount;
    private boolean initialized;
    private boolean inUse;
    private Buffer buffer;
    private LineManager lineMgr;
    private JEditTextArea textArea;
    private BufferChangeHandler bufferChangeHandler;
    private int[] fvm;
    private int fvmcount;
    private int lastfvmget = -1;

    static DisplayManager getDisplayManager(Buffer buffer, JEditTextArea jEditTextArea) {
        DisplayManager displayManager2;
        LinkedList<DisplayManager> linkedList = (LinkedList<DisplayManager>)bufferMap.get(buffer);
        if (linkedList == null) {
            linkedList = new LinkedList<DisplayManager>();
            bufferMap.put(buffer, linkedList);
        }
        for (DisplayManager displayManager2 : linkedList) {
            if (displayManager2.inUse || displayManager2.textArea != jEditTextArea) continue;
            displayManager2.inUse = true;
            return displayManager2;
        }
        displayManager2 = new DisplayManager(buffer, jEditTextArea);
        displayManager2.inUse = true;
        linkedList.add(displayManager2);
        return displayManager2;
    }

    static void releaseDisplayManager(DisplayManager displayManager) {
        displayManager.inUse = false;
    }

    public static void bufferClosed(Buffer buffer) {
        bufferMap.remove(buffer);
    }

    static void textAreaDisposed(JEditTextArea jEditTextArea) {
        for (List list : bufferMap.values()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DisplayManager displayManager = (DisplayManager)iterator.next();
                if (displayManager.textArea != jEditTextArea) continue;
                displayManager.dispose();
                iterator.remove();
            }
        }
    }

    public final boolean isLineVisible(int n) {
        return this.fvmget(n) % 2 == 0;
    }

    public int getFirstVisibleLine() {
        return this.fvm[0];
    }

    public int getLastVisibleLine() {
        return this.fvm[this.fvmcount - 1] - 1;
    }

    public int getNextVisibleLine(int n) {
        if (n < 0 || n >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.fvmget(n);
        if (n2 % 2 != 0) {
            if (this.fvmcount == n2 + 1) {
                return -1;
            }
            return this.fvm[n2 + 1];
        }
        if (n == this.fvm[n2 + 1] - 1) {
            if (this.fvmcount == n2 + 2) {
                return -1;
            }
            return this.fvm[n2 + 2];
        }
        return n + 1;
    }

    public int getPrevVisibleLine(int n) {
        if (n < 0 || n >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.fvmget(n);
        if (n2 == -1) {
            return -1;
        }
        if (n2 % 2 == 1) {
            return this.fvm[n2] - 1;
        }
        if (n == this.fvm[n2]) {
            if (n2 == 0) {
                return -1;
            }
            return this.fvm[n2 - 1] - 1;
        }
        return n - 1;
    }

    public final int getScreenLineCount(int n) {
        if (this.lineMgr.isScreenLineCountValid(n)) {
            return this.lineMgr.getScreenLineCount(n);
        }
        int n2 = this.textArea.chunkCache.getLineSubregionCount(n);
        this.setScreenLineCount(n, n2);
        return n2;
    }

    public final int getScrollLineCount() {
        return this.scrollLineCount.scrollLine;
    }

    public void collapseFold(int n) {
        int n2 = this.buffer.getLineCount();
        int n3 = 0;
        int n4 = n2 - 1;
        if (n != 0 && n != this.buffer.getLineCount() - 1 && this.buffer.isFoldStart(n) && !this.isLineVisible(n + 1)) {
            --n;
        }
        int n5 = this.buffer.getFoldLevel(n);
        if (n != n2 - 1 && this.buffer.getFoldLevel(n + 1) > n5) {
            n3 = n + 1;
            for (int i = n + 1; i < n2; ++i) {
                if (this.buffer.getFoldLevel(i) > n5) continue;
                n4 = i - 1;
                break;
            }
        } else {
            int n6;
            boolean bl = false;
            for (n6 = n - 1; n6 >= 0; --n6) {
                if (this.buffer.getFoldLevel(n6) >= n5) continue;
                n3 = n6 + 1;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            for (n6 = n + 1; n6 < n2; ++n6) {
                if (this.buffer.getFoldLevel(n6) >= n5) continue;
                n4 = n6 - 1;
                break;
            }
        }
        this.hideLineRange(n3, n4);
        this._notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public int expandFold(int n, boolean bl) {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = this.buffer.getLineCount();
        int n6 = 0;
        int n7 = n5 - 1;
        int n8 = this.buffer.getFoldLevel(n);
        if (n != n5 - 1 && this.isLineVisible(n) && !this.isLineVisible(n + 1) && this.buffer.getFoldLevel(n + 1) > n8) {
            n3 = this.fvmget(n + 1);
            if (n3 == -1) {
                this.expandAllFolds();
                return -1;
            }
            n6 = this.fvm[n3];
            if (n3 != this.fvmcount - 1) {
                n7 = this.fvm[n3 + 1] - 1;
            } else {
                n6 = n + 1;
                for (n2 = n + 1; n2 < n5; ++n2) {
                    if (this.buffer.getFoldLevel(n2) > n8) continue;
                    n7 = n2 - 1;
                    break;
                }
            }
        } else {
            n3 = this.fvmget(n);
            if (n3 == -1) {
                this.expandAllFolds();
                return -1;
            }
            n6 = this.fvm[n3];
            if (n3 != this.fvmcount - 1) {
                n7 = this.fvm[n3 + 1] - 1;
            } else {
                for (n2 = n + 1; n2 < n5; ++n2) {
                    if ((!this.isLineVisible(n2) || this.buffer.getFoldLevel(n2) >= n8) && n2 != this.getLastVisibleLine()) continue;
                    n7 = n2 - 1;
                    break;
                }
            }
        }
        if (bl) {
            this.showLineRange(n6, n7);
        } else {
            n8 = this.buffer.getFoldLevel(n6);
            n3 = n6;
            for (n2 = n6; n2 <= n7; ++n2) {
                if (this.buffer.getFoldLevel(n2) <= n8) continue;
                if (n4 == -1 && n2 != 0 && this.buffer.isFoldStart(n2 - 1)) {
                    n4 = n2 - 1;
                }
                if (n3 != n2) {
                    this.showLineRange(n3, n2 - 1);
                }
                n3 = n2 + 1;
            }
            if (n3 != n7 + 1) {
                this.showLineRange(n3, n7);
            }
            if (!this.isLineVisible(n)) {
                this.expandFold(n, false);
                return n4;
            }
        }
        this._notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
        return n4;
    }

    public void expandAllFolds() {
        this.showLineRange(0, this.buffer.getLineCount() - 1);
        this._notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public void expandFolds(char c) {
        if (c < '1' || c > '9') {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.expandFolds(c - 49 + 1);
    }

    public void expandFolds(int n) {
        if (this.buffer.getFoldHandler() instanceof IndentFoldHandler) {
            n = (n - 1) * this.buffer.getIndentSize() + 1;
        }
        this.showLineRange(0, this.buffer.getLineCount() - 1);
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < this.buffer.getLineCount(); ++i) {
            if (bl && this.buffer.getFoldLevel(i) >= n) continue;
            if (n2 != i) {
                this.hideLineRange(n2, i - 1);
            }
            n2 = i + 1;
            bl = true;
        }
        if (n2 != this.buffer.getLineCount()) {
            this.hideLineRange(n2, this.buffer.getLineCount() - 1);
        }
        this._notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public void narrow(int n, int n2) {
        if (n > n2 || n < 0 || n2 >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n + ", " + n2);
        }
        if (n < this.getFirstVisibleLine() || n2 > this.getLastVisibleLine()) {
            this.expandAllFolds();
        }
        if (n != 0) {
            this.hideLineRange(0, n - 1);
        }
        if (n2 != this.buffer.getLineCount() - 1) {
            this.hideLineRange(n2 + 1, this.buffer.getLineCount() - 1);
        }
        if (n != this.buffer.getLineCount() - 1 && !this.isLineVisible(n + 1)) {
            this.expandFold(n, false);
        }
        GUIUtilities.getView(this.textArea).getStatus().setMessageAndClear(jEdit.getProperty("view.status.narrow"));
        this._notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    void init() {
        if (!this.initialized) {
            this.initialized = true;
            this.fvm = new int[2];
            if (this.buffer.isLoaded()) {
                this.bufferChangeHandler.foldHandlerChanged(this.buffer);
            } else {
                this.fvmreset();
            }
            this._notifyScreenLineChanges();
        } else {
            this.updateWrapSettings();
            if (this.buffer.isLoaded()) {
                this._notifyScreenLineChanges();
                this.textArea.updateScrollBars();
                this.textArea.recalculateLastPhysicalLine();
            }
        }
    }

    void setScreenLineCount(int n, int n2) {
        int n3 = this.lineMgr.getScreenLineCount(n);
        this.lineMgr.setScreenLineCount(n, n2);
        if (n2 != n3) {
            Iterator iterator = ((List)bufferMap.get(this.buffer)).iterator();
            while (iterator.hasNext()) {
                ((DisplayManager)iterator.next())._setScreenLineCount(n, n3, n2);
            }
        }
    }

    void updateWrapSettings() {
        String string = this.buffer.getStringProperty("wrap");
        this.softWrap = string.equals("soft");
        if (this.textArea.maxLineLen <= 0) {
            this.softWrap = false;
            this.wrapMargin = 0;
        } else {
            char[] cArray = new char[this.textArea.maxLineLen];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = 32;
            }
            TextAreaPainter textAreaPainter = this.textArea.getPainter();
            this.wrapMargin = (int)textAreaPainter.getFont().getStringBounds(cArray, 0, cArray.length, textAreaPainter.getFontRenderContext()).getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _notifyScreenLineChanges() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "_notifyScreenLineChanges()");
        }
        if (this.textArea.getDisplayManager() == this) {
            try {
                if (this.firstLine.callReset) {
                    this.firstLine.reset();
                } else if (this.firstLine.callChanged) {
                    this.firstLine.changed();
                }
                if (this.scrollLineCount.callReset) {
                    this.scrollLineCount.reset();
                } else if (this.scrollLineCount.callChanged) {
                    this.scrollLineCount.changed();
                }
            }
            finally {
                this.firstLine.callChanged = false;
                this.firstLine.callReset = false;
                this.scrollLineCount.callChanged = false;
                this.scrollLineCount.callReset = false;
            }
        }
    }

    private DisplayManager(Buffer buffer, JEditTextArea jEditTextArea) {
        this.buffer = buffer;
        this.lineMgr = buffer._getLineManager();
        this.textArea = jEditTextArea;
        this.scrollLineCount = new ScrollLineCount();
        this.firstLine = new FirstLine();
        this.bufferChangeHandler = new BufferChangeHandler();
        buffer.addBufferChangeListener(this.bufferChangeHandler, 1);
    }

    private void dispose() {
        this.buffer.removeBufferChangeListener(this.bufferChangeHandler);
    }

    private void fvmreset() {
        this.lastfvmget = -1;
        this.fvmcount = 2;
        this.fvm[0] = 0;
        this.fvm[1] = this.buffer.getLineCount();
    }

    private int fvmget(int n) {
        ++scanCount;
        if (n < this.fvm[0]) {
            return -1;
        }
        if (n >= this.fvm[this.fvmcount - 1]) {
            return this.fvmcount - 1;
        }
        if (this.lastfvmget != -1 && n >= this.fvm[this.lastfvmget] && (this.lastfvmget == this.fvmcount - 1 || n < this.fvm[this.lastfvmget + 1])) {
            return this.lastfvmget;
        }
        int n2 = 0;
        int n3 = this.fvmcount - 1;
        block4: while (true) {
            ++scannedLines;
            switch (n3 - n2) {
                case 0: {
                    this.lastfvmget = n2;
                    break block4;
                }
                case 1: {
                    int n4 = this.fvm[n3];
                    if (n4 <= n) {
                        this.lastfvmget = n3;
                        break block4;
                    }
                    this.lastfvmget = n2;
                    break block4;
                }
                default: {
                    int n5 = (n3 + n2) / 2;
                    int n4 = this.fvm[n5];
                    if (n4 == n) {
                        this.lastfvmget = n5;
                        break block4;
                    }
                    if (n4 < n) {
                        n2 = n5;
                        continue block4;
                    }
                    n3 = n5 - 1;
                    continue block4;
                }
            }
            break;
        }
        return this.lastfvmget;
    }

    private void fvmput(int n, int n2, int[] nArray) {
        int n3;
        int n4;
        if (Debug.FOLD_VIS_DEBUG) {
            StringBuffer stringBuffer = new StringBuffer("{");
            if (nArray != null) {
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (n4 != 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(nArray[n4]);
                }
            }
            stringBuffer.append("}");
            Log.log(1, this, "fvmput(" + n + "," + n2 + "," + stringBuffer + ")");
        }
        if (this.fvmcount + (n4 = (n3 = nArray == null ? 0 : nArray.length) - (n2 - n)) > this.fvm.length) {
            int[] nArray2 = new int[this.fvm.length * 2 + 1];
            System.arraycopy(this.fvm, 0, nArray2, 0, this.fvmcount);
            this.fvm = nArray2;
        }
        if (n4 != 0) {
            System.arraycopy(this.fvm, n2, this.fvm, n + n3, this.fvmcount - n2);
        }
        if (n3 != 0) {
            System.arraycopy(nArray, 0, this.fvm, n, nArray.length);
        }
        this.fvmcount += n4;
        this.fvmdump();
        if (this.fvmcount == 0) {
            throw new InternalError();
        }
    }

    private void fvmput2(int n, int n2, int n3, int n4) {
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "*fvmput2(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        }
        if (n != -1 && this.fvm[n] == n3) {
            if (n2 <= this.fvmcount - 2 && this.fvm[n2 + 1] == n4 + 1) {
                this.fvmput(n, n2 + 2, null);
            } else {
                this.fvmput(n, n2 + 1, new int[]{n4 + 1});
            }
        } else if (n2 != this.fvmcount - 1 && this.fvm[n2 + 1] == n4 + 1) {
            this.fvmput(n + 1, n2 + 2, new int[]{n3});
        } else {
            this.fvmput(n + 1, n2 + 1, new int[]{n3, n4 + 1});
        }
    }

    private void fvmdump() {
        if (Debug.FOLD_VIS_DEBUG) {
            StringBuffer stringBuffer = new StringBuffer("{");
            for (int i = 0; i < this.fvmcount; ++i) {
                if (i != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.fvm[i]);
            }
            stringBuffer.append("}");
            Log.log(1, this, "fvm = " + stringBuffer);
        }
    }

    private void showLineRange(int n, int n2) {
        int n3;
        int n4;
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "showLineRange(" + n + "," + n2 + ")");
        }
        for (n4 = n; n4 <= n2; ++n4) {
            if (this.isLineVisible(n4)) continue;
            n3 = this.getScreenLineCount(n4);
            if (this.firstLine.physicalLine >= n4) {
                this.firstLine.scrollLine += n3;
                this.firstLine.callChanged = true;
            }
            this.scrollLineCount.scrollLine += n3;
            this.scrollLineCount.callChanged = true;
        }
        n4 = this.fvmget(n);
        n3 = this.fvmget(n2);
        if (n4 % 2 == 0) {
            if (n3 % 2 == 0) {
                this.fvmput(n4 + 1, n3 + 1, null);
            } else if (n3 != this.fvmcount - 1 && this.fvm[n3 + 1] == n2 + 1) {
                this.fvmput(n4 + 1, n3 + 2, null);
            } else {
                this.fvmput(n4 + 1, n3, null);
                this.fvm[n4 + 1] = n2 + 1;
            }
        } else if (n3 % 2 == 0) {
            if (n4 != -1 && this.fvm[n4] == n) {
                this.fvmput(n4, n3 + 1, null);
            } else {
                this.fvmput(n4 + 1, n3, null);
                this.fvm[n4 + 1] = n;
            }
        } else {
            this.fvmput2(n4, n3, n, n2);
        }
        this.lastfvmget = -1;
    }

    private void hideLineRange(int n, int n2) {
        int n3;
        int n4;
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "hideLineRange(" + n + "," + n2 + ")");
        }
        if (!this.isLineVisible(n4 = n)) {
            n4 = this.getNextVisibleLine(n4);
        }
        while (n4 != -1 && n4 <= n2) {
            n3 = this.lineMgr.getScreenLineCount(n4);
            if (n4 < this.firstLine.physicalLine) {
                this.firstLine.scrollLine -= n3;
                this.firstLine.skew = 0;
                this.firstLine.callChanged = true;
            }
            this.scrollLineCount.scrollLine -= n3;
            this.scrollLineCount.callChanged = true;
            n4 = this.getNextVisibleLine(n4);
        }
        n3 = this.fvmget(n);
        int n5 = this.fvmget(n2);
        if (n3 % 2 == 0) {
            if (n5 % 2 == 0) {
                this.fvmput2(n3, n5, n, n2);
            } else if (n == this.fvm[0]) {
                this.fvmput(n3, n5 + 1, null);
            } else {
                this.fvmput(n3 + 1, n5, null);
                this.fvm[n3 + 1] = n;
            }
        } else if (n5 % 2 == 0) {
            if (n2 + 1 == this.fvm[this.fvmcount - 1]) {
                this.fvmput(n3 + 1, n5 + 2, null);
            } else {
                this.fvmput(n3 + 1, n5, null);
                this.fvm[n3 + 1] = n2 + 1;
            }
        } else {
            this.fvmput(n3 + 1, n5 + 1, null);
        }
        this.lastfvmget = -1;
        if (!this.isLineVisible(this.firstLine.physicalLine)) {
            int n6 = this.getFirstVisibleLine();
            if (this.firstLine.physicalLine < n6) {
                this.firstLine.physicalLine = n6;
                this.firstLine.scrollLine = 0;
            } else {
                this.firstLine.physicalLine = this.getPrevVisibleLine(this.firstLine.physicalLine);
                this.firstLine.scrollLine -= this.lineMgr.getScreenLineCount(this.firstLine.physicalLine);
            }
            this.firstLine.callChanged = true;
        }
    }

    private void _setScreenLineCount(int n, int n2, int n3) {
        if (!this.isLineVisible(n)) {
            return;
        }
        if (this.firstLine.physicalLine >= n) {
            if (this.firstLine.physicalLine == n) {
                this.firstLine.callChanged = true;
            } else {
                this.firstLine.scrollLine += n3 - n2;
                this.firstLine.callChanged = true;
            }
        }
        this.scrollLineCount.scrollLine += n3 - n2;
        this.scrollLineCount.callChanged = true;
    }

    static {
        bufferMap = new HashMap();
    }

    class BufferChangeHandler
    extends BufferChangeAdapter {
        boolean delayedUpdate;
        boolean delayedMultilineUpdate;
        int delayedUpdateStart;
        int delayedUpdateEnd;

        BufferChangeHandler() {
        }

        public void foldHandlerChanged(Buffer buffer) {
            DisplayManager.this.fvmreset();
            DisplayManager.this.firstLine.callReset = true;
            DisplayManager.this.scrollLineCount.callReset = true;
            int n = buffer.getIntegerProperty("collapseFolds", 0);
            if (n != 0) {
                DisplayManager.this.expandFolds(n);
            }
            DisplayManager.this._notifyScreenLineChanges();
        }

        public void foldLevelChanged(Buffer buffer, int n, int n2) {
            if (DisplayManager.this.textArea.getDisplayManager() == DisplayManager.this && n2 != 0 && buffer.isLoaded()) {
                DisplayManager.this.textArea.invalidateLineRange(n - 1, DisplayManager.this.textArea.getLastPhysicalLine());
            }
        }

        public void contentInserted(Buffer buffer, int n, int n2, int n3, int n4) {
            int n5;
            int n6;
            if (!buffer.isLoaded()) {
                DisplayManager.this.fvmreset();
                return;
            }
            int n7 = n + n3;
            if (n3 != 0) {
                this.delayedMultilineUpdate = true;
                n6 = DisplayManager.this.fvmget(n);
                int n8 = n5 = n6 + 1;
                while (n8 < DisplayManager.this.fvmcount) {
                    int[] nArray = DisplayManager.this.fvm;
                    int n9 = n8++;
                    nArray[n9] = nArray[n9] + n3;
                }
                DisplayManager.this.lastfvmget = -1;
                DisplayManager.this.fvmdump();
            }
            if (DisplayManager.this.textArea.getDisplayManager() == DisplayManager.this) {
                if (n3 != 0) {
                    this.contentInserted(DisplayManager.this.firstLine, n, n3);
                    this.contentInserted(DisplayManager.this.scrollLineCount, n, n3);
                }
                if (this.delayedUpdateEnd >= n) {
                    this.delayedUpdateEnd += n3;
                }
                this.delayedUpdate(n, n7);
                for (n6 = 0; n6 < ((DisplayManager)DisplayManager.this).textArea.selection.size(); ++n6) {
                    Selection selection = (Selection)((DisplayManager)DisplayManager.this).textArea.selection.elementAt(n6);
                    if (!selection.contentInserted(buffer, n, n2, n3, n4)) continue;
                    this.delayedUpdate(selection.startLine, selection.endLine);
                }
                n6 = DisplayManager.this.textArea.getCaretPosition();
                if (n6 >= n2) {
                    n5 = this.caretAutoScroll() ? JEditTextArea.ELECTRIC_SCROLL : JEditTextArea.NO_SCROLL;
                    DisplayManager.this.textArea.moveCaretPosition(n6 + n4, n5);
                } else {
                    n5 = this.caretAutoScroll() ? JEditTextArea.NORMAL_SCROLL : JEditTextArea.NO_SCROLL;
                    DisplayManager.this.textArea.moveCaretPosition(n6, n5);
                }
            } else {
                DisplayManager.this.firstLine.callReset = true;
                DisplayManager.this.scrollLineCount.callReset = true;
            }
        }

        public void preContentRemoved(Buffer buffer, int n, int n2, int n3, int n4) {
            if (!buffer.isLoaded()) {
                return;
            }
            if (DisplayManager.this.textArea.getDisplayManager() == DisplayManager.this) {
                if (n3 != 0) {
                    this.preContentRemoved(DisplayManager.this.firstLine, n, n3);
                    this.preContentRemoved(DisplayManager.this.scrollLineCount, n, n3);
                }
                if (this.delayedUpdateEnd >= n) {
                    this.delayedUpdateEnd -= n3;
                }
                this.delayedUpdate(n, n);
            } else {
                DisplayManager.this.firstLine.callReset = true;
                DisplayManager.this.scrollLineCount.callReset = true;
            }
            if (n3 == 0) {
                return;
            }
            this.delayedMultilineUpdate = true;
            int n5 = n + n3;
            int n6 = DisplayManager.this.fvmget(n);
            int n7 = DisplayManager.this.fvmget(n5);
            if (Math.abs(n6 % 2) == Math.abs(n7 % 2)) {
                if (n7 - n6 == DisplayManager.this.fvmcount) {
                    DisplayManager.this.fvmreset();
                    DisplayManager.this.firstLine.callReset = true;
                    DisplayManager.this.scrollLineCount.callReset = true;
                    n6 = 1;
                } else {
                    DisplayManager.this.fvmput(n6 + 1, n7 + 1, null);
                    ++n6;
                }
            } else if (n6 != -1 && DisplayManager.this.fvm[n6] == n) {
                if (n7 - n6 == DisplayManager.this.fvmcount - 1) {
                    DisplayManager.this.fvmreset();
                    DisplayManager.this.firstLine.callReset = true;
                    DisplayManager.this.scrollLineCount.callReset = true;
                    n6 = 1;
                } else {
                    DisplayManager.this.fvmput(n6, n7 + 1, null);
                }
            } else {
                DisplayManager.this.fvmput(n6 + 1, n7, null);
                ((DisplayManager)DisplayManager.this).fvm[n6 + 1] = n;
                n6 += 2;
            }
            int n8 = n6;
            while (n8 < DisplayManager.this.fvmcount) {
                int[] nArray = DisplayManager.this.fvm;
                int n9 = n8++;
                nArray[n9] = nArray[n9] - n3;
            }
            if (DisplayManager.this.firstLine.physicalLine <= DisplayManager.this.getLastVisibleLine() && DisplayManager.this.firstLine.physicalLine >= DisplayManager.this.getFirstVisibleLine() && !DisplayManager.this.isLineVisible(DisplayManager.this.firstLine.physicalLine)) {
                DisplayManager.this.firstLine.physicalLine = DisplayManager.this.getNextVisibleLine(DisplayManager.this.firstLine.physicalLine);
            }
            DisplayManager.this.lastfvmget = -1;
            DisplayManager.this.fvmdump();
        }

        public void contentRemoved(Buffer buffer, int n, int n2, int n3, int n4) {
            if (!buffer.isLoaded()) {
                return;
            }
            if (DisplayManager.this.textArea.getDisplayManager() == DisplayManager.this) {
                int n5;
                for (n5 = 0; n5 < ((DisplayManager)DisplayManager.this).textArea.selection.size(); ++n5) {
                    Selection selection = (Selection)((DisplayManager)DisplayManager.this).textArea.selection.elementAt(n5);
                    if (!selection.contentRemoved(buffer, n, n2, n3, n4)) continue;
                    this.delayedUpdate(selection.startLine, selection.endLine);
                    if (selection.start != selection.end) continue;
                    ((DisplayManager)DisplayManager.this).textArea.selection.removeElementAt(n5);
                    --n5;
                }
                n5 = DisplayManager.this.textArea.getCaretPosition();
                if (n5 >= n2 + n4) {
                    int n6 = this.caretAutoScroll() ? JEditTextArea.ELECTRIC_SCROLL : JEditTextArea.NO_SCROLL;
                    DisplayManager.this.textArea.moveCaretPosition(n5 - n4, n6);
                } else if (n5 >= n2) {
                    int n7 = this.caretAutoScroll() ? JEditTextArea.ELECTRIC_SCROLL : JEditTextArea.NO_SCROLL;
                    DisplayManager.this.textArea.moveCaretPosition(n2, n7);
                } else {
                    int n8 = this.caretAutoScroll() ? JEditTextArea.NORMAL_SCROLL : JEditTextArea.NO_SCROLL;
                    DisplayManager.this.textArea.moveCaretPosition(n5, n8);
                }
            }
        }

        public void transactionComplete(Buffer buffer) {
            if (DisplayManager.this.textArea.getDisplayManager() != DisplayManager.this) {
                this.delayedUpdate = false;
                return;
            }
            if (this.delayedUpdate) {
                this.doDelayedUpdate();
            }
            DisplayManager.this.textArea._finishCaretUpdate();
            this.delayedUpdate = false;
        }

        private void doDelayedUpdate() {
            int n = DisplayManager.this.textArea.getFirstPhysicalLine();
            int n2 = DisplayManager.this.textArea.getLastPhysicalLine();
            int n3 = this.delayedUpdateStart;
            if (!DisplayManager.this.isLineVisible(n3)) {
                n3 = DisplayManager.this.getNextVisibleLine(n3);
            }
            while (n3 != -1 && n3 <= this.delayedUpdateEnd) {
                if (n3 < n || n3 > n2) {
                    DisplayManager.this.getScreenLineCount(n3);
                }
                n3 = DisplayManager.this.getNextVisibleLine(n3);
            }
            DisplayManager.this._notifyScreenLineChanges();
            if (this.delayedMultilineUpdate) {
                DisplayManager.this.textArea.invalidateScreenLineRange(((DisplayManager)DisplayManager.this).textArea.chunkCache.getScreenLineOfOffset(this.delayedUpdateStart, 0), DisplayManager.this.textArea.getVisibleLines());
                this.delayedMultilineUpdate = false;
            } else {
                DisplayManager.this.textArea.invalidateLineRange(this.delayedUpdateStart, this.delayedUpdateEnd);
            }
            int n4 = DisplayManager.this.textArea.getVisibleLines();
            if (n4 != 0) {
                ((DisplayManager)DisplayManager.this).textArea.chunkCache.getLineInfo(n4 - 1);
            }
            DisplayManager.this.buffer.getFoldLevel(this.delayedUpdateEnd);
        }

        private void contentInserted(Anchor anchor, int n, int n2) {
            if (anchor.physicalLine >= n) {
                if (anchor.physicalLine != n) {
                    anchor.physicalLine += n2;
                }
                anchor.callChanged = true;
            }
        }

        private void preContentRemoved(Anchor anchor, int n, int n2) {
            if (anchor.physicalLine >= n) {
                if (anchor.physicalLine == n) {
                    anchor.callChanged = true;
                } else {
                    int n3 = Math.min(n + n2, anchor.physicalLine);
                    for (int i = n; i < n3; ++i) {
                        if (!DisplayManager.this.isLineVisible(i)) continue;
                        anchor.scrollLine -= DisplayManager.this.lineMgr.getScreenLineCount(i);
                    }
                    anchor.physicalLine -= n3 - n;
                    anchor.callChanged = true;
                }
            }
        }

        private void delayedUpdate(int n, int n2) {
            ((DisplayManager)DisplayManager.this).textArea.chunkCache.invalidateChunksFromPhys(n);
            if (!this.delayedUpdate) {
                this.delayedUpdateStart = n;
                this.delayedUpdateEnd = n2;
                this.delayedUpdate = true;
            } else {
                this.delayedUpdateStart = Math.min(this.delayedUpdateStart, n);
                this.delayedUpdateEnd = Math.max(this.delayedUpdateEnd, n2);
            }
        }

        private boolean caretAutoScroll() {
            View view = DisplayManager.this.textArea.getView();
            return view == jEdit.getActiveView() && view.getTextArea() == DisplayManager.this.textArea;
        }
    }

    class FirstLine
    extends Anchor {
        int skew;

        FirstLine() {
        }

        public void changed() {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "changed() before: " + this.physicalLine + ":" + this.scrollLine);
            }
            this.ensurePhysicalLineIsVisible();
            int n = DisplayManager.this.getScreenLineCount(this.physicalLine);
            if (this.skew >= n) {
                this.skew = n - 1;
            }
            if (Debug.SCROLL_VERIFY) {
                System.err.println("SCROLL_VERIFY");
                int n2 = 0;
                for (int i = 0; i < DisplayManager.this.buffer.getLineCount(); ++i) {
                    if (!DisplayManager.this.isLineVisible(i)) continue;
                    if (i >= this.physicalLine) break;
                    n2 += DisplayManager.this.getScreenLineCount(i);
                }
                if (n2 != this.scrollLine) {
                    Exception exception = new Exception(this.scrollLine + ":" + n2);
                    Log.log(9, this, exception);
                    new BeanShellErrorDialog(null, exception);
                }
            }
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "changed() after: " + this.physicalLine + ":" + this.scrollLine);
            }
            if (!DisplayManager.this.scrollLineCount.callChanged && !DisplayManager.this.scrollLineCount.callReset) {
                DisplayManager.this.textArea.updateScrollBars();
                DisplayManager.this.textArea.recalculateLastPhysicalLine();
            }
        }

        public void reset() {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "reset()");
            }
            String string = DisplayManager.this.buffer.getStringProperty("wrap");
            DisplayManager.this.softWrap = string.equals("soft");
            if (((DisplayManager)DisplayManager.this).textArea.maxLineLen <= 0) {
                DisplayManager.this.softWrap = false;
                DisplayManager.this.wrapMargin = 0;
            } else {
                char[] cArray = new char[((DisplayManager)DisplayManager.this).textArea.maxLineLen];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = 32;
                }
                TextAreaPainter textAreaPainter = DisplayManager.this.textArea.getPainter();
                DisplayManager.this.wrapMargin = (int)textAreaPainter.getFont().getStringBounds(cArray, 0, cArray.length, textAreaPainter.getFontRenderContext()).getWidth();
            }
            this.scrollLine = 0;
            int n = DisplayManager.this.getFirstVisibleLine();
            while (n < this.physicalLine) {
                this.scrollLine += DisplayManager.this.getScreenLineCount(n);
                int n2 = DisplayManager.this.getNextVisibleLine(n);
                if (n2 == -1) break;
                n = n2;
            }
            this.physicalLine = n;
            int n3 = DisplayManager.this.getScreenLineCount(this.physicalLine);
            if (this.skew >= n3) {
                this.skew = n3 - 1;
            }
            DisplayManager.this.textArea.updateScrollBars();
        }

        void physDown(int n, int n2) {
            int n3;
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "physDown() start: " + this.physicalLine + ":" + this.scrollLine);
            }
            this.skew = 0;
            if (!DisplayManager.this.isLineVisible(this.physicalLine)) {
                n3 = DisplayManager.this.getLastVisibleLine();
                if (this.physicalLine > n3) {
                    this.physicalLine = n3;
                } else {
                    int n4 = DisplayManager.this.getNextVisibleLine(this.physicalLine);
                    n -= n4 - this.physicalLine;
                    this.scrollLine += DisplayManager.this.getScreenLineCount(this.physicalLine);
                    this.physicalLine = n4;
                }
            }
            while ((n3 = DisplayManager.this.getNextVisibleLine(this.physicalLine)) != -1 && n3 <= this.physicalLine + n) {
                this.scrollLine += DisplayManager.this.getScreenLineCount(this.physicalLine);
                n -= n3 - this.physicalLine;
                this.physicalLine = n3;
            }
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "physDown() end: " + this.physicalLine + ":" + this.scrollLine);
            }
            this.callChanged = true;
            if (n2 < 0) {
                this.scrollUp(-n2);
            } else if (n2 > 0) {
                this.scrollDown(n2);
            }
        }

        void physUp(int n, int n2) {
            int n3;
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "physUp() start: " + this.physicalLine + ":" + this.scrollLine);
            }
            this.skew = 0;
            if (!DisplayManager.this.isLineVisible(this.physicalLine)) {
                n3 = DisplayManager.this.getFirstVisibleLine();
                if (this.physicalLine < n3) {
                    this.physicalLine = n3;
                } else {
                    int n4 = DisplayManager.this.getPrevVisibleLine(this.physicalLine);
                    n -= this.physicalLine - n4;
                }
            }
            while ((n3 = DisplayManager.this.getPrevVisibleLine(this.physicalLine)) != -1 && n3 >= this.physicalLine - n) {
                n -= this.physicalLine - n3;
                this.physicalLine = n3;
                this.scrollLine -= DisplayManager.this.getScreenLineCount(n3);
            }
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "physUp() end: " + this.physicalLine + ":" + this.scrollLine);
            }
            this.callChanged = true;
            if (n2 < 0) {
                this.scrollUp(-n2);
            } else if (n2 > 0) {
                this.scrollDown(n2);
            }
        }

        void scrollDown(int n) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "scrollDown()");
            }
            this.ensurePhysicalLineIsVisible();
            n += this.skew;
            this.skew = 0;
            while (n > 0) {
                int n2 = DisplayManager.this.getScreenLineCount(this.physicalLine);
                if (n < n2) {
                    this.skew = n;
                    break;
                }
                int n3 = DisplayManager.this.getNextVisibleLine(this.physicalLine);
                if (n3 == -1) break;
                boolean bl = DisplayManager.this.isLineVisible(this.physicalLine);
                this.physicalLine = n3;
                if (!bl) continue;
                n -= n2;
                this.scrollLine += n2;
            }
            this.callChanged = true;
        }

        void scrollUp(int n) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "scrollUp()");
            }
            this.ensurePhysicalLineIsVisible();
            if (n <= this.skew) {
                this.skew -= n;
            } else {
                int n2;
                n -= this.skew;
                this.skew = 0;
                while (n > 0 && (n2 = DisplayManager.this.getPrevVisibleLine(this.physicalLine)) != -1) {
                    this.physicalLine = n2;
                    int n3 = DisplayManager.this.getScreenLineCount(this.physicalLine);
                    this.scrollLine -= n3;
                    if (n < n3) {
                        this.skew = n3 - n;
                        break;
                    }
                    n -= n3;
                }
            }
            this.callChanged = true;
        }

        private void ensurePhysicalLineIsVisible() {
            if (!DisplayManager.this.isLineVisible(this.physicalLine)) {
                if (this.physicalLine > DisplayManager.this.getLastVisibleLine()) {
                    this.physicalLine = DisplayManager.this.getLastVisibleLine();
                    this.scrollLine = DisplayManager.this.getScrollLineCount() - 1;
                } else if (this.physicalLine < DisplayManager.this.getFirstVisibleLine()) {
                    this.physicalLine = DisplayManager.this.getFirstVisibleLine();
                    this.scrollLine = 0;
                } else {
                    this.physicalLine = DisplayManager.this.getNextVisibleLine(this.physicalLine);
                    this.scrollLine += DisplayManager.this.getScreenLineCount(this.physicalLine);
                }
            }
        }
    }

    class ScrollLineCount
    extends Anchor {
        ScrollLineCount() {
        }

        public void changed() {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "changed()");
            }
            DisplayManager.this.textArea.updateScrollBars();
            DisplayManager.this.textArea.recalculateLastPhysicalLine();
        }

        public void reset() {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "reset()");
            }
            this.physicalLine = DisplayManager.this.getFirstVisibleLine();
            this.scrollLine = 0;
            while (this.physicalLine != -1) {
                this.scrollLine += DisplayManager.this.getScreenLineCount(this.physicalLine);
                this.physicalLine = DisplayManager.this.getNextVisibleLine(this.physicalLine);
            }
            this.physicalLine = DisplayManager.this.buffer.getLineCount();
            DisplayManager.this.firstLine.ensurePhysicalLineIsVisible();
            DisplayManager.this.textArea.recalculateLastPhysicalLine();
            DisplayManager.this.textArea.updateScrollBars();
        }
    }

    static abstract class Anchor {
        int physicalLine;
        int scrollLine;
        boolean callChanged;
        boolean callReset;

        Anchor() {
        }

        abstract void reset();

        abstract void changed();

        public String toString() {
            return this.getClass().getName() + "[" + this.physicalLine + "," + this.scrollLine + "]";
        }
    }
}

