/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.base;

import de.grogra.reflect.Field;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.query.AttributeListPattern;
import java.util.Arrays;

public class FieldListPattern
extends AttributeListPattern {
    private final Field[] fields;

    public FieldListPattern(Type type, Type type2, Field[] fieldArray) {
        super(type, fieldArray.length);
        if (type2 != null && !Reflection.equal((Type)type2, (Type)this.getParameterType(0))) {
            throw new IllegalArgumentException("Illegal node type");
        }
        for (int i = 0; i < fieldArray.length; ++i) {
            if (fieldArray[i] == null || Reflection.equal((Type)this.getParameterType(i + 1), (Type)fieldArray[i].getType())) continue;
            throw new IllegalArgumentException("Illegal field type " + fieldArray[i].getType() + ", expected " + this.getParameterType(i + 1));
        }
        this.fields = fieldArray;
    }

    public FieldListPattern(Type type, Type type2, Field field) {
        this(type, type2, new Field[]{field});
    }

    public FieldListPattern(Type type, Field field) {
        this(null, type, new Field[]{field});
    }

    protected boolean getBoolean(Object object, int n) {
        try {
            return this.fields[n].getBoolean(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected byte getByte(Object object, int n) {
        try {
            return this.fields[n].getByte(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected short getShort(Object object, int n) {
        try {
            return this.fields[n].getShort(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected char getChar(Object object, int n) {
        try {
            return this.fields[n].getChar(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected int getInt(Object object, int n) {
        try {
            return this.fields[n].getInt(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected long getLong(Object object, int n) {
        try {
            return this.fields[n].getLong(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected float getFloat(Object object, int n) {
        try {
            return this.fields[n].getFloat(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected double getDouble(Object object, int n) {
        try {
            return this.fields[n].getDouble(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected Object getObject(Object object, int n) {
        try {
            return this.fields[n].getObject(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected String paramString() {
        return Arrays.toString(this.fields);
    }
}

