/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.base;

import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.impl.base.EdgeIterator;
import de.grogra.xl.impl.base.GraphQueue;
import de.grogra.xl.impl.base.RuntimeModel;
import de.grogra.xl.impl.queues.QueueCollection;
import de.grogra.xl.impl.queues.QueueDescriptor;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.MatchConsumer;
import de.grogra.xl.query.NodeData;
import de.grogra.xl.query.Pattern;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.util.EHashMap;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.Operators;
import de.grogra.xl.util.XBitSet;
import java.io.Serializable;
import java.util.Random;

public abstract class Graph
implements de.grogra.xl.query.Graph,
Cloneable {
    public static final int PARALLEL_MODE = 0;
    public static final int PARALLEL_NON_DETERMINISTIC_MODE = 1;
    public static final int SEQUENTIAL_MODE = 2;
    public static final int SEQUENTIAL_NON_DETERMINISTIC_MODE = 3;
    public static final int MODE_MASK = 3;
    public static final int INTERPRETIVE_FLAG = 4;
    public static final int EXCLUDE_DELETED_FLAG = 8;
    final RuntimeModel model;
    final ThreadLocal<ThreadData> data = new ThreadLocal();
    private static final Integer BRANCH_SUCCESSOR = 768;

    protected ThreadData getThreadData() {
        ThreadData threadData = this.data.get();
        if (threadData == null) {
            threadData = this.createThreadData();
            threadData.queues = new QueueCollection(this);
            this.data.set(threadData);
        }
        return threadData;
    }

    protected ThreadData createThreadData() {
        return new ThreadData();
    }

    public Graph(RuntimeModel runtimeModel) {
        this.model = runtimeModel;
    }

    public RuntimeModel getModel() {
        return this.model;
    }

    protected abstract GraphQueue createQueue(QueueCollection var1, QueueDescriptor var2);

    public QState createQueryState() {
        QState qState = new QState(this.getThreadData());
        qState.initialize();
        return qState;
    }

    public void allowNoninjectiveMatchesByDefault(boolean bl) {
        ThreadData threadData = this.getThreadData();
        threadData.defaultAllowNoninjective = bl;
        threadData.nextAllowNoninjective = bl;
    }

    @Deprecated
    public void allowNoninjectiveMatchesForNextQuery(boolean bl) {
        this.getThreadData().nextAllowNoninjective = bl;
    }

    public int getDerivationMode() {
        return this.getThreadData().derivationMode;
    }

    public void setDerivationMode(int n) {
        this.getThreadData().derivationMode = n;
        switch (n & 3) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                this.getThreadData().seqSegment = -1;
            }
        }
    }

    boolean applyMatch(QueryState queryState) {
        ThreadData threadData = this.getThreadData();
        switch (threadData.derivationMode & 3) {
            case 0: {
                return true;
            }
            case 1: {
                this.getQueues().startNewSegment();
                return true;
            }
            case 2: {
                queryState.breakMatching();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (threadData.seqSegment < 0) {
            threadData.seqSegment = this.getQueues().startNewSegment();
            threadData.seqMatchCount = 1;
            return true;
        }
        if ((threadData.derivationMode & 3) == 2 || Operators.getRandomGenerator().nextInt(++threadData.seqMatchCount) > 0) {
            return false;
        }
        threadData.queues.resetToSegment(threadData.seqSegment);
        return true;
    }

    public long derive() {
        ThreadData threadData = this.getThreadData();
        threadData.close();
        return threadData.stamp;
    }

    protected abstract void beginModifications();

    protected abstract void commitModifications();

    public QueueCollection getQueues() {
        ThreadData threadData = this.getThreadData();
        threadData.open();
        return threadData.queues;
    }

    public boolean canEnumerateNodes(Type type) {
        return Reflection.isSupertypeOrSame((Class)this.model.getNodeType(), (Type)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enumerateEdges(Object object, EdgeDirection edgeDirection, Type type, QueryState queryState, int n, int n2, Serializable serializable, int n3, MatchConsumer matchConsumer, int n4) {
        if (type.getTypeId() != 6) {
            return;
        }
        int n5 = n2 >= 0 ? queryState.ibound(n2) : (serializable != null ? ((Number)serializable).intValue() : -1);
        EdgeIterator edgeIterator = this.model.createEdgeIterator(object, edgeDirection);
        while (edgeIterator.hasEdge()) {
            block16: {
                Object object2;
                block15: {
                    block14: {
                        if (edgeDirection != EdgeDirection.UNDIRECTED) break block14;
                        object2 = object == edgeIterator.source ? edgeIterator.target : edgeIterator.source;
                        break block15;
                    }
                    Object object3 = object2 = edgeDirection == EdgeDirection.BACKWARD ? edgeIterator.source : edgeIterator.target;
                    if (object2 == object) break block16;
                }
                int n6 = edgeIterator.edgeBits;
                if (RuntimeModel.testEdgeBits(n6, n5)) {
                    switch (queryState.ibind(n3, n6)) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            queryState.amatch(n, object2, matchConsumer, n4);
                            break;
                        }
                        case 2: {
                            try {
                                queryState.amatch(n, object2, matchConsumer, n4);
                                break;
                            }
                            finally {
                                queryState.unbind(n3);
                            }
                        }
                    }
                }
            }
            edgeIterator.moveToNext();
        }
    }

    protected Object getPredecessor(Object object) {
        if (!this.canEnumerateEdges((EdgeDirection)EdgeDirection.BACKWARD, true, BRANCH_SUCCESSOR)) {
            return null;
        }
        EdgeIterator edgeIterator = this.model.createEdgeIterator(object, (EdgeDirection)EdgeDirection.BACKWARD);
        while (edgeIterator.hasEdge()) {
            if (edgeIterator.source != object && RuntimeModel.testEdgeBits(edgeIterator.edgeBits, 768)) {
                object = edgeIterator.source;
                edgeIterator.dispose();
                return object;
            }
            edgeIterator.moveToNext();
        }
        return null;
    }

    public Pattern.Matcher createMatcher(Pattern pattern, XBitSet xBitSet, IntList intList) {
        return pattern.createMatcher((de.grogra.xl.query.Graph)this, xBitSet, intList);
    }

    protected static class ThreadData {
        boolean isOpen = false;
        long stamp = Long.MIN_VALUE;
        QueueCollection queues;
        EHashMap excludeFromMatch = new EHashMap((EHashMap.Entry[])new NodeData[1], 32, 0.75f);
        NodeData key = new NodeData();
        boolean defaultAllowNoninjective = false;
        boolean nextAllowNoninjective = false;
        int seqMatchCount = 0;
        int seqSegment = -1;
        int derivationMode = 8;

        protected ThreadData() {
        }

        boolean isExcludedFromMatch(Object object) {
            this.key.setNode(object);
            return this.excludeFromMatch.get((EHashMap.Entry)this.key) != null;
        }

        void excludeFromMatch(Object object) {
            NodeData nodeData = (NodeData)this.excludeFromMatch.popEntryFromPool();
            if (nodeData == null) {
                nodeData = new NodeData();
            }
            nodeData.setNode(object);
            this.excludeFromMatch.getOrPut((EHashMap.Entry)nodeData);
        }

        void open() {
            if (this.isOpen) {
                return;
            }
            ((Graph)this.queues.getGraph()).beginModifications();
            this.seqSegment = -1;
            this.isOpen = true;
        }

        void close() {
            if (this.isOpen) {
                int[] nArray = null;
                if ((this.derivationMode & 3) == 1) {
                    int n = this.queues.startNewSegment();
                    nArray = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = i;
                    }
                    Random random = Operators.getRandomGenerator();
                    for (int i = 0; i < n; ++i) {
                        int n2 = random.nextInt(n);
                        int n3 = nArray[i];
                        nArray[i] = nArray[n2];
                        nArray[n2] = n3;
                    }
                }
                try {
                    if (this.queues.process(nArray)) {
                        ++this.stamp;
                    }
                    ((Graph)this.queues.getGraph()).commitModifications();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.excludeFromMatch.clear();
            }
            this.isOpen = false;
        }
    }

    public class QState
    extends QueryState {
        boolean allowNoninjective;
        ThreadData data;

        QState(ThreadData threadData) {
            super((de.grogra.xl.query.Graph)Graph.this);
            this.data = threadData;
            this.allowNoninjective = threadData.nextAllowNoninjective;
            threadData.nextAllowNoninjective = threadData.defaultAllowNoninjective;
        }

        protected boolean allowsNoninjectiveMatches() {
            return this.allowNoninjective;
        }

        protected boolean excludeFromMatch(Object object, boolean bl) {
            return !bl && this.data.isExcludedFromMatch(object);
        }

        public void injective() {
            this.allowNoninjective = false;
        }

        public void noninjective() {
            this.allowNoninjective = true;
        }
    }
}

