/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.queues;

import de.grogra.xl.impl.queues.Queue;
import de.grogra.xl.impl.queues.QueueDescriptor;
import de.grogra.xl.query.Graph;
import de.grogra.xl.query.RuntimeModel;
import de.grogra.xl.query.RuntimeModelException;
import de.grogra.xl.util.EHashMap;
import de.grogra.xl.util.ObjectList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueCollection {
    final Graph graph;
    final RuntimeModel model;
    private final QueueEntry queueKey = new QueueEntry();
    private final EHashMap queues = new EHashMap();
    private int currentSegment = -1;
    private final ObjectList<QueueDescriptor<?>> order = new ObjectList();

    public QueueCollection(Graph graph) {
        this.graph = graph;
        this.model = graph.getModel();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public RuntimeModel getModel() {
        return this.model;
    }

    public void clear() {
        QueueEntry queueEntry = (QueueEntry)this.queues.getFirstEntry();
        while (queueEntry != null) {
            ((Queue)queueEntry.value).clear();
            if (queueEntry.additionalQueues != null) {
                queueEntry.additionalQueues.clear();
            }
            queueEntry = (QueueEntry)queueEntry.listNext;
        }
        this.currentSegment = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(int[] nArray) throws RuntimeModelException {
        boolean bl = false;
        try {
            int n;
            QueueEntry queueEntry;
            QueueDescriptor queueDescriptor;
            int n2;
            this.order.clear();
            QueueDescriptor.addOrder(this.order);
            if (nArray != null) {
                for (n2 = 0; n2 < this.order.size(); ++n2) {
                    queueDescriptor = (QueueDescriptor)this.order.get(n2);
                    this.queueKey.setKey(queueDescriptor);
                    queueEntry = (QueueEntry)this.queues.get((EHashMap.Entry)this.queueKey);
                    if (queueEntry == null) continue;
                    ((Queue)queueEntry.value).clearSegmentsToExclude(nArray);
                    if (queueEntry.additionalQueues == null) continue;
                    for (n = 0; n < queueEntry.additionalQueues.size; ++n) {
                        ((Queue)queueEntry.additionalQueues.get(n)).clearSegmentsToExclude(nArray);
                    }
                }
            }
            for (n2 = 0; n2 < this.order.size(); ++n2) {
                queueDescriptor = (QueueDescriptor)this.order.get(n2);
                this.queueKey.setKey(queueDescriptor);
                queueEntry = (QueueEntry)this.queues.get((EHashMap.Entry)this.queueKey);
                if (queueEntry == null) continue;
                bl |= ((Queue)queueEntry.value).process(nArray);
                if (queueEntry.additionalQueues == null) continue;
                for (n = 0; n < queueEntry.additionalQueues.size; ++n) {
                    Queue queue = (Queue)queueEntry.additionalQueues.get(n);
                    bl |= queue.process(nArray);
                }
            }
        }
        finally {
            this.clear();
        }
        return bl;
    }

    public void getQueues(List<Queue> list) {
        QueueEntry queueEntry = (QueueEntry)this.queues.getFirstEntry();
        while (queueEntry != null) {
            list.add((Queue)queueEntry.value);
            if (queueEntry.additionalQueues != null) {
                list.addAll((Collection<Queue>)queueEntry.additionalQueues);
            }
            queueEntry = (QueueEntry)queueEntry.listNext;
        }
    }

    public <Q extends Queue> Q getQueue(QueueDescriptor<Q> queueDescriptor) {
        this.queueKey.setKey(queueDescriptor);
        QueueEntry queueEntry = (QueueEntry)this.queues.get((EHashMap.Entry)this.queueKey);
        if (queueEntry != null) {
            return (Q)((Queue)queueEntry.value);
        }
        queueEntry = (QueueEntry)this.queues.popEntryFromPool();
        if (queueEntry == null) {
            queueEntry = new QueueEntry();
        }
        queueEntry.setKey(queueDescriptor);
        Q q = queueDescriptor.createQueue(this);
        if (this.currentSegment >= 0) {
            q.markSegment(this.currentSegment);
        }
        queueEntry.value = q;
        this.queues.put((EHashMap.Entry)queueEntry);
        return q;
    }

    public void addQueue(Queue queue) {
        this.getQueue(queue.getDescriptor());
        this.queueKey.setKey(queue.getDescriptor());
        QueueEntry queueEntry = (QueueEntry)this.queues.get((EHashMap.Entry)this.queueKey);
        if (queueEntry.additionalQueues == null) {
            queueEntry.additionalQueues = new ObjectList();
        }
        queueEntry.additionalQueues.add((Object)queue);
    }

    public int startNewSegment() {
        ++this.currentSegment;
        QueueEntry queueEntry = (QueueEntry)this.queues.getFirstEntry();
        while (queueEntry != null) {
            ((Queue)queueEntry.value).markSegment(this.currentSegment);
            queueEntry = (QueueEntry)queueEntry.listNext;
        }
        return this.currentSegment;
    }

    public void resetToSegment(int n) {
        QueueEntry queueEntry = (QueueEntry)this.queues.getFirstEntry();
        while (queueEntry != null) {
            ((Queue)queueEntry.value).resetToSegment(n);
            queueEntry = (QueueEntry)queueEntry.listNext;
        }
        this.currentSegment = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class QueueEntry
    extends EHashMap.ObjectEntry<QueueDescriptor, Queue> {
        ObjectList<Queue> additionalQueues;

        private QueueEntry() {
        }
    }
}

