/*
 * Decompiled with CFR 0.152.
 */
package com.keypoint;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PngEncoder {
    public static final boolean ENCODE_ALPHA = true;
    public static final boolean NO_ALPHA = false;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_LAST = 2;
    protected static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    protected static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    protected static final byte[] IEND = new byte[]{73, 69, 78, 68};
    protected static final byte[] PHYS = new byte[]{112, 72, 89, 115};
    protected byte[] pngBytes;
    protected byte[] priorRow;
    protected byte[] leftBytes;
    protected Image image;
    protected int width;
    protected int height;
    protected int bytePos;
    protected int maxPos;
    protected CRC32 crc = new CRC32();
    protected long crcValue;
    protected boolean encodeAlpha;
    protected int filter;
    protected int bytesPerPixel;
    private int xDpi = 0;
    private int yDpi = 0;
    private static float INCH_IN_METER_UNIT = 0.0254f;
    protected int compressionLevel;

    public PngEncoder() {
        this(null, false, 0, 0);
    }

    public PngEncoder(Image image) {
        this(image, false, 0, 0);
    }

    public PngEncoder(Image image, boolean bl) {
        this(image, bl, 0, 0);
    }

    public PngEncoder(Image image, boolean bl, int n) {
        this(image, bl, n, 0);
    }

    public PngEncoder(Image image, boolean bl, int n, int n2) {
        this.image = image;
        this.encodeAlpha = bl;
        this.setFilter(n);
        if (n2 >= 0 && n2 <= 9) {
            this.compressionLevel = n2;
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.pngBytes = null;
    }

    public Image getImage() {
        return this.image;
    }

    public byte[] pngEncode(boolean bl) {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (this.image == null) {
            return null;
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.pngBytes = new byte[(this.width + 1) * this.height * 3 + 200];
        this.maxPos = 0;
        this.bytePos = this.writeBytes(byArray, 0);
        this.writeHeader();
        this.writeResolution();
        if (this.writeImageData()) {
            this.writeEnd();
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.maxPos);
        } else {
            this.pngBytes = null;
        }
        return this.pngBytes;
    }

    public byte[] pngEncode() {
        return this.pngEncode(this.encodeAlpha);
    }

    public void setEncodeAlpha(boolean bl) {
        this.encodeAlpha = bl;
    }

    public boolean getEncodeAlpha() {
        return this.encodeAlpha;
    }

    public void setFilter(int n) {
        this.filter = 0;
        if (n <= 2) {
            this.filter = n;
        }
    }

    public int getFilter() {
        return this.filter;
    }

    public void setCompressionLevel(int n) {
        if (n >= 0 && n <= 9) {
            this.compressionLevel = n;
        }
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    protected byte[] resizeByteArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n2, n));
        return byArray2;
    }

    protected int writeBytes(byte[] byArray, int n) {
        this.maxPos = Math.max(this.maxPos, n + byArray.length);
        if (byArray.length + n > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, byArray.length));
        }
        System.arraycopy(byArray, 0, this.pngBytes, n, byArray.length);
        return n + byArray.length;
    }

    protected int writeBytes(byte[] byArray, int n, int n2) {
        this.maxPos = Math.max(this.maxPos, n2 + n);
        if (n + n2 > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, n));
        }
        System.arraycopy(byArray, 0, this.pngBytes, n2, n);
        return n2 + n;
    }

    protected int writeInt2(int n, int n2) {
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return this.writeBytes(byArray, n2);
    }

    protected int writeInt4(int n, int n2) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return this.writeBytes(byArray, n2);
    }

    protected int writeByte(int n, int n2) {
        byte[] byArray = new byte[]{(byte)n};
        return this.writeBytes(byArray, n2);
    }

    protected void writeHeader() {
        int n = this.bytePos = this.writeInt4(13, this.bytePos);
        this.bytePos = this.writeBytes(IHDR, this.bytePos);
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.bytePos = this.writeInt4(this.width, this.bytePos);
        this.bytePos = this.writeInt4(this.height, this.bytePos);
        this.bytePos = this.writeByte(8, this.bytePos);
        this.bytePos = this.writeByte(this.encodeAlpha ? 6 : 2, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.crc.reset();
        this.crc.update(this.pngBytes, n, this.bytePos - n);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected void filterSub(byte[] byArray, int n, int n2) {
        int n3 = this.bytesPerPixel;
        int n4 = n + n3;
        int n5 = n2 * this.bytesPerPixel;
        int n6 = n3;
        int n7 = 0;
        for (int i = n4; i < n + n5; ++i) {
            this.leftBytes[n6] = byArray[i];
            byArray[i] = (byte)((byArray[i] - this.leftBytes[n7]) % 256);
            n6 = (n6 + 1) % 15;
            n7 = (n7 + 1) % 15;
        }
    }

    protected void filterUp(byte[] byArray, int n, int n2) {
        int n3 = n2 * this.bytesPerPixel;
        for (int i = 0; i < n3; ++i) {
            byte by = byArray[n + i];
            byArray[n + i] = (byte)((byArray[n + i] - this.priorRow[i]) % 256);
            this.priorRow[i] = by;
        }
    }

    protected boolean writeImageData() {
        int n = 0;
        this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        try {
            int n2;
            for (int i = this.height; i > 0; i -= n2) {
                n2 = Math.min(Short.MAX_VALUE / (this.width * (this.bytesPerPixel + 1)), i);
                n2 = Math.max(n2, 1);
                int[] nArray = new int[this.width * n2];
                PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, n, this.width, n2, nArray, 0, this.width);
                try {
                    pixelGrabber.grabPixels();
                }
                catch (Exception exception) {
                    System.err.println("interrupted waiting for pixels!");
                    return false;
                }
                if ((pixelGrabber.getStatus() & 0x80) != 0) {
                    System.err.println("image fetch aborted or errored");
                    return false;
                }
                byte[] byArray = new byte[this.width * n2 * this.bytesPerPixel + n2];
                if (this.filter == 1) {
                    this.leftBytes = new byte[16];
                }
                if (this.filter == 2) {
                    this.priorRow = new byte[this.width * this.bytesPerPixel];
                }
                int n3 = 0;
                int n4 = 1;
                for (int j = 0; j < this.width * n2; ++j) {
                    if (j % this.width == 0) {
                        byArray[n3++] = (byte)this.filter;
                        n4 = n3;
                    }
                    byArray[n3++] = (byte)(nArray[j] >> 16 & 0xFF);
                    byArray[n3++] = (byte)(nArray[j] >> 8 & 0xFF);
                    byArray[n3++] = (byte)(nArray[j] & 0xFF);
                    if (this.encodeAlpha) {
                        byArray[n3++] = (byte)(nArray[j] >> 24 & 0xFF);
                    }
                    if (j % this.width != this.width - 1 || this.filter == 0) continue;
                    if (this.filter == 1) {
                        this.filterSub(byArray, n4, this.width);
                    }
                    if (this.filter != 2) continue;
                    this.filterUp(byArray, n4, this.width);
                }
                deflaterOutputStream.write(byArray, 0, n3);
                n += n2;
            }
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n5 = byArray.length;
            this.crc.reset();
            this.bytePos = this.writeInt4(n5, this.bytePos);
            this.bytePos = this.writeBytes(IDAT, this.bytePos);
            this.crc.update(IDAT);
            this.bytePos = this.writeBytes(byArray, n5, this.bytePos);
            this.crc.update(byArray, 0, n5);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
            deflater.finish();
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
    }

    protected void writeEnd() {
        this.bytePos = this.writeInt4(0, this.bytePos);
        this.bytePos = this.writeBytes(IEND, this.bytePos);
        this.crc.reset();
        this.crc.update(IEND);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    public void setXDpi(int n) {
        this.xDpi = Math.round((float)n / INCH_IN_METER_UNIT);
    }

    public int getXDpi() {
        return Math.round((float)this.xDpi * INCH_IN_METER_UNIT);
    }

    public void setYDpi(int n) {
        this.yDpi = Math.round((float)n / INCH_IN_METER_UNIT);
    }

    public int getYDpi() {
        return Math.round((float)this.yDpi * INCH_IN_METER_UNIT);
    }

    public void setDpi(int n, int n2) {
        this.xDpi = Math.round((float)n / INCH_IN_METER_UNIT);
        this.yDpi = Math.round((float)n2 / INCH_IN_METER_UNIT);
    }

    protected void writeResolution() {
        if (this.xDpi > 0 && this.yDpi > 0) {
            int n = this.bytePos = this.writeInt4(9, this.bytePos);
            this.bytePos = this.writeBytes(PHYS, this.bytePos);
            this.bytePos = this.writeInt4(this.xDpi, this.bytePos);
            this.bytePos = this.writeInt4(this.yDpi, this.bytePos);
            this.bytePos = this.writeByte(1, this.bytePos);
            this.crc.reset();
            this.crc.update(this.pngBytes, n, this.bytePos - n);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
        }
    }
}

