/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.DockManager;
import de.grogra.docking.Dockable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class DockMenuListener
extends MouseAdapter
implements ActionListener,
Runnable {
    protected JPopupMenu menu;
    protected JMenuItem close;
    protected JMenuItem undock;
    protected WeakReference<Dockable> clicked;
    protected DockManager manager;
    private Dockable dockable;

    DockMenuListener(DockManager dockManager, Dockable dockable) {
        this.manager = dockManager;
        this.dockable = dockable;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed() || !mouseEvent.isPopupTrigger()) {
            return;
        }
        this.clicked = null;
        Dockable dockable = this.getDockable(mouseEvent);
        if (dockable == null) {
            return;
        }
        this.clicked = new WeakReference<Dockable>(dockable);
        if (this.menu == null) {
            this.createMenu();
        }
        this.configureMenu();
        this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    protected Dockable getDockable(MouseEvent mouseEvent) {
        return this.dockable;
    }

    protected void createMenu() {
        this.menu = new JPopupMenu();
        this.undock = this.createItem("undock");
        this.close = this.createItem("close");
    }

    private JMenuItem createItem(String string) {
        JMenuItem jMenuItem = this.menu.add(DockManager.RES_BUNDLE.getString(string + ".Name"));
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    protected void configureMenu() {
        this.close.setEnabled(((Dockable)this.clicked.get()).isClosable());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.clicked == null) {
            return;
        }
        Dockable dockable = (Dockable)this.clicked.get();
        if (dockable == null) {
            return;
        }
        if ("close".equals(actionEvent.getActionCommand()) && dockable.isClosable()) {
            dockable.checkClose(this);
        } else if ("undock".equals(actionEvent.getActionCommand())) {
            this.manager.floatDockable(dockable);
        }
    }

    public void run() {
        this.manager.closeDockable((Dockable)this.clicked.get());
    }
}

