/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.DockComponent;
import de.grogra.docking.DockContainer;
import de.grogra.docking.DockManager;
import de.grogra.docking.DockPositionList;
import de.grogra.docking.DockShape;
import de.grogra.docking.DockSplitPane;
import de.grogra.docking.Dockable;
import de.grogra.docking.DockableComponent;
import de.grogra.docking.DragDockableContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;

public final class DockPosition
implements Comparable {
    public static final int TOLERANCE = 10;
    public static final int TOLERANCE2 = 30;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int CENTER = 16;
    public static final int TAB = 32;
    public static final int VERTICAL_MASK = 3;
    public static final int HORIZONTAL_MASK = 12;
    public static final int TAB_MASK = 48;
    public static final int FIRST_EDGE = 5;
    public static final int SECOND_EDGE = 10;
    public static final int EDGE = 15;
    private static int nextId = 0;
    private final int id = DockPosition.getNextId();
    private DockComponent adjacent;
    private final int position;
    private final int absX;
    private final int absY;
    private final int dragX;
    private final int dragY;
    private final DockShape shape;

    private static synchronized int getNextId() {
        return nextId++;
    }

    public static void addDockPositions(DockPositionList dockPositionList, DockComponent dockComponent, int n, Point point, Container container, DockShape dockShape) {
        int n2 = point.x;
        int n3 = point.y;
        if (container != null) {
            DockManager.translate(point, container, (Component)((Object)dockComponent));
        }
        for (int i = 1; i <= 16; i <<= 1) {
            if ((n & i) == 0 || i == 16 && dockComponent instanceof DockSplitPane) continue;
            dockPositionList.addDockPosition(dockComponent, i, point, dockShape);
        }
        point.x = n2;
        point.y = n3;
    }

    DockPosition(DockComponent dockComponent, int n, int n2, int n3, int n4, int n5, DockShape dockShape) {
        this.adjacent = dockComponent;
        this.position = n;
        this.absX = n2;
        this.absY = n3;
        this.dragX = n4;
        this.dragY = n5;
        this.shape = dockShape;
    }

    DockPosition(DockComponent dockComponent, int n, Point point, Point point2, DockShape dockShape) {
        this(dockComponent, n, point.x - point2.x, point.y - point2.y, point2.x, point2.y, dockShape);
    }

    public DockComponent getAdjacent() {
        return this.adjacent;
    }

    public int getPosition() {
        return this.position;
    }

    public int getLength() {
        if ((this.position & 3) != 0) {
            return this.adjacent.getHeight();
        }
        if ((this.position & 0xC) != 0) {
            return this.adjacent.getWidth();
        }
        return 0;
    }

    public int getDragDelta() {
        switch (this.position) {
            case 1: {
                return -this.dragX;
            }
            case 2: {
                return this.adjacent.getWidth() - this.dragX;
            }
            case 4: {
                return -this.dragY;
            }
            case 8: {
                return this.adjacent.getHeight() - this.dragY;
            }
        }
        return 0;
    }

    public int getAbsX() {
        return this.absX;
    }

    public int getAbsY() {
        return this.absY;
    }

    public static DockPosition testDockPosition(DockComponent dockComponent, int n, Point point, Point point2, DockShape dockShape) {
        boolean bl;
        switch (n) {
            case 1: {
                bl = Math.abs(point2.x) < 30 && -30 < point2.y && point2.y < dockComponent.getHeight() + 30;
                break;
            }
            case 2: {
                bl = Math.abs(point2.x - dockComponent.getWidth() + 1) < 30 && -30 < point2.y && point2.y < dockComponent.getHeight() + 30;
                break;
            }
            case 4: {
                bl = Math.abs(point2.y) < 30 && -30 < point2.x && point2.x < dockComponent.getWidth() + 30;
                break;
            }
            case 8: {
                bl = Math.abs(point2.y - dockComponent.getHeight() + 1) < 30 && -30 < point2.x && point2.x < dockComponent.getWidth() + 30;
                break;
            }
            case 16: {
                bl = point2.x >= 0 && point2.y >= 0 && point2.x < dockComponent.getWidth() && point2.y < dockComponent.getHeight();
                break;
            }
            case 32: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            return new DockPosition(dockComponent, n, point, point2, dockShape);
        }
        return null;
    }

    private static int compare(int n, int n2) {
        return n < n2 ? -1 : (n > n2 ? 1 : 0);
    }

    private int compareImpl(DockPosition dockPosition) {
        if (this.position < dockPosition.position) {
            return 1;
        }
        if (this.position > dockPosition.position) {
            return -1;
        }
        int n = DockPosition.compare(this.getDragDelta(), dockPosition.getDragDelta());
        if (n != 0) {
            return n;
        }
        return DockPosition.compare(this.getLength(), dockPosition.getLength()) * ((this.position & 0xA) != 0 ? 1 : -1);
    }

    public int compareTo(Object object) {
        int n = this.compareImpl((DockPosition)object);
        return n != 0 ? n : DockPosition.compare(this.id, ((DockPosition)object).id);
    }

    public String toString() {
        return "DockPosition[" + this.position + ',' + this.getDragDelta() + ',' + this.getLength() + ',' + this.adjacent + ']';
    }

    void paintDockShape(Graphics graphics) {
        graphics.setColor(Color.darkGray);
        if (this.shape != null) {
            this.shape.paintDockShape(this, graphics);
        } else {
            block6: for (int i = this.position == 16 ? 1 : this.position; i <= (this.position == 16 ? 8 : this.position); i <<= 1) {
                switch (i) {
                    case 1: {
                        graphics.fillRect(this.absX - 2, this.absY - 2, 5, this.adjacent.getHeight() + 4);
                        continue block6;
                    }
                    case 2: {
                        graphics.fillRect(this.absX + this.adjacent.getWidth() - 2, this.absY - 2, 5, this.adjacent.getHeight() + 4);
                        continue block6;
                    }
                    case 4: {
                        graphics.fillRect(this.absX - 2, this.absY - 2, this.adjacent.getWidth() + 4, 5);
                        continue block6;
                    }
                    case 8: {
                        graphics.fillRect(this.absX - 2, this.absY + this.adjacent.getHeight() - 2, this.adjacent.getWidth() + 4, 5);
                    }
                }
            }
        }
    }

    boolean dockShapeEquals(DockPosition dockPosition) {
        if (this.shape != null) {
            return this.shape.equals(dockPosition.shape);
        }
        if (dockPosition.shape != null) {
            return false;
        }
        return this.position == dockPosition.position && (this.adjacent == dockPosition.adjacent || this.absX == dockPosition.absX && this.absY == dockPosition.absY && this.adjacent.getWidth() == dockPosition.adjacent.getWidth() && this.adjacent.getHeight() == dockPosition.adjacent.getHeight());
    }

    void drop(DragDockableContext dragDockableContext) {
        DockableComponent dockableComponent = dragDockableContext.getDockableComponent();
        Dockable dockable = dragDockableContext.getDockable();
        if (this.adjacent == dockableComponent) {
            return;
        }
        DockComponent dockComponent = this.adjacent instanceof DockableComponent ? ((DockableComponent)this.adjacent).getDockable() : this.adjacent;
        DockContainer dockContainer = dragDockableContext.getDockContainer();
        DockComponent dockComponent2 = dockContainer.remove(dockableComponent);
        if (dockComponent2 != dockContainer && dockComponent == dockContainer) {
            dockComponent = dockComponent2;
        }
        dragDockableContext.getManager().addImpl(dockable, this.position, dockComponent);
    }
}

