/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.awt;

import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Synchronizer;
import de.grogra.pf.ui.awt.AWTSynchronizer;
import de.grogra.pf.ui.awt.ContentPaneContainer;
import de.grogra.util.MutableTreeModel;
import java.awt.Component;
import java.awt.Container;
import javax.swing.RootPaneContainer;
import javax.swing.event.TreeModelListener;

public abstract class ComponentModel
implements MutableTreeModel,
Synchronizer.Callback,
ComponentWrapper {
    protected Container root;
    protected final AWTSynchronizer sync = new AWTSynchronizer(this);
    protected static final int INSERT = 0;
    protected static final int REMOVE = 1;
    protected static final int TREE_CHANGED = 2;
    protected static final int SET_ENABLED = 3;
    protected static final int ACTION_COUNT = 4;

    public Object run(int n, int n2, Object object, Object object2) {
        switch (n) {
            case 0: {
                Container container = this.getContentPane(object);
                n2 = n2 >= container.getComponentCount() - this.getPrefixComponentCount(container) ? container.getComponentCount() : (n2 += this.getPrefixComponentCount(container));
                if (object2 instanceof Component) {
                    container.add((Component)object2, n2);
                    break;
                }
                Object[] objectArray = (Object[])object2;
                container.add((Component)objectArray[0], objectArray[1], n2);
                break;
            }
            case 1: {
                Container container = this.getContentPane(object);
                container.remove(n2 + this.getPrefixComponentCount(container));
                container.repaint();
                break;
            }
            case 2: {
                this.treeChangedSync((Container)object);
                break;
            }
            case 3: {
                ((Component)object).setEnabled(n2 != 0);
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
        return null;
    }

    protected Container getContentPane(Object object) {
        return object instanceof RootPaneContainer ? ((RootPaneContainer)object).getContentPane() : (object instanceof ContentPaneContainer ? ((ContentPaneContainer)object).getContentPane() : (Container)object);
    }

    protected int getPrefixComponentCount(Container container) {
        return 0;
    }

    public boolean isLeaf(Object object) {
        return !(object instanceof Container);
    }

    public Object getChild(Object object, int n) {
        Container container = this.getContentPane(object);
        return container.getComponent(this.getPrefixComponentCount(container) + n);
    }

    public int getChildCount(Object object) {
        if (this.isLeaf(object)) {
            return 0;
        }
        Container container = this.getContentPane(object);
        return container == null ? 0 : container.getComponentCount() - this.getPrefixComponentCount(container);
    }

    public int getIndexOfChild(Object object, Object object2) {
        Container container = this.getContentPane(object);
        if (container != null) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (object2 != container.getComponent(i)) continue;
                return i - this.getPrefixComponentCount(container);
            }
        }
        return -1;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getComponent() {
        return this.root;
    }

    public void setRoot(Object object) {
        this.root = (Container)object;
    }

    public void insert(Object object, int n, Object objectArray, Object object2) {
        Object[] objectArray2;
        if (object2 == null) {
            objectArray2 = objectArray;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = objectArray;
            objectArray2 = objectArray3;
            objectArray3[1] = object2;
        }
        this.sync.invokeAndWait(0, n, object, objectArray2);
    }

    public void remove(Object object, int n) {
        this.sync.invokeAndWait(1, n, object, null);
    }

    public void treeChanged(Object object) {
        this.sync.invokeAndWait(2, object);
    }

    protected void setEnabled(Component component, boolean bl) {
        this.sync.invokeAndWait(3, bl ? 1 : 0, component, null);
    }

    protected abstract void treeChangedSync(Container var1);

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        throw new UnsupportedOperationException();
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        throw new UnsupportedOperationException();
    }
}

