/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.editor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.editor.DefaultAxisEditor;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.PaintSample;
import org.jfree.ui.StrokeChooserPanel;
import org.jfree.ui.StrokeSample;

class DefaultNumberAxisEditor
extends DefaultAxisEditor
implements FocusListener {
    private boolean autoRange;
    private double minimumValue;
    private double maximumValue;
    private JCheckBox autoRangeCheckBox;
    private JTextField minimumRangeValue;
    private JTextField maximumRangeValue;
    private PaintSample gridPaintSample;
    private StrokeSample gridStrokeSample;
    private StrokeSample[] availableStrokeSamples;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.editor.LocalizationBundle");

    public DefaultNumberAxisEditor(NumberAxis numberAxis) {
        super(numberAxis);
        this.autoRange = numberAxis.isAutoRange();
        this.minimumValue = numberAxis.getLowerBound();
        this.maximumValue = numberAxis.getUpperBound();
        this.gridPaintSample = new PaintSample((Paint)Color.blue);
        this.gridStrokeSample = new StrokeSample((Stroke)new BasicStroke(1.0f));
        this.availableStrokeSamples = new StrokeSample[3];
        this.availableStrokeSamples[0] = new StrokeSample((Stroke)new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample((Stroke)new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample((Stroke)new BasicStroke(3.0f));
        JTabbedPane jTabbedPane = this.getOtherTabs();
        JPanel jPanel = new JPanel((LayoutManager)new LCBLayout(3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(new JPanel());
        this.autoRangeCheckBox = new JCheckBox(localizationResources.getString("Auto-adjust_range"), this.autoRange);
        this.autoRangeCheckBox.setActionCommand("AutoRangeOnOff");
        this.autoRangeCheckBox.addActionListener(this);
        jPanel.add(this.autoRangeCheckBox);
        jPanel.add(new JPanel());
        jPanel.add(new JLabel(localizationResources.getString("Minimum_range_value")));
        this.minimumRangeValue = new JTextField(Double.toString(this.minimumValue));
        this.minimumRangeValue.setEnabled(!this.autoRange);
        this.minimumRangeValue.setActionCommand("MinimumRange");
        this.minimumRangeValue.addActionListener(this);
        this.minimumRangeValue.addFocusListener(this);
        jPanel.add(this.minimumRangeValue);
        jPanel.add(new JPanel());
        jPanel.add(new JLabel(localizationResources.getString("Maximum_range_value")));
        this.maximumRangeValue = new JTextField(Double.toString(this.maximumValue));
        this.maximumRangeValue.setEnabled(!this.autoRange);
        this.maximumRangeValue.setActionCommand("MaximumRange");
        this.maximumRangeValue.addActionListener(this);
        this.maximumRangeValue.addFocusListener(this);
        jPanel.add(this.maximumRangeValue);
        jPanel.add(new JPanel());
        jTabbedPane.add(localizationResources.getString("Range"), jPanel);
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("GridStroke")) {
            this.attemptGridStrokeSelection();
        } else if (string.equals("GridPaint")) {
            this.attemptGridPaintSelection();
        } else if (string.equals("AutoRangeOnOff")) {
            this.toggleAutoRange();
        } else if (string.equals("MinimumRange")) {
            this.validateMinimum();
        } else if (string.equals("MaximumRange")) {
            this.validateMaximum();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void attemptGridStrokeSelection() {
        StrokeChooserPanel strokeChooserPanel = new StrokeChooserPanel(null, this.availableStrokeSamples);
        int n = JOptionPane.showConfirmDialog(this, strokeChooserPanel, localizationResources.getString("Stroke_Selection"), 2, -1);
        if (n == 0) {
            this.gridStrokeSample.setStroke(strokeChooserPanel.getSelectedStroke());
        }
    }

    private void attemptGridPaintSelection() {
        Color color = JColorChooser.showDialog(this, localizationResources.getString("Grid_Color"), Color.blue);
        if (color != null) {
            this.gridPaintSample.setPaint((Paint)color);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.minimumRangeValue) {
            this.validateMinimum();
        } else if (focusEvent.getSource() == this.maximumRangeValue) {
            this.validateMaximum();
        }
    }

    public void toggleAutoRange() {
        this.autoRange = this.autoRangeCheckBox.isSelected();
        if (this.autoRange) {
            this.minimumRangeValue.setText(Double.toString(this.minimumValue));
            this.minimumRangeValue.setEnabled(false);
            this.maximumRangeValue.setText(Double.toString(this.maximumValue));
            this.maximumRangeValue.setEnabled(false);
        } else {
            this.minimumRangeValue.setEnabled(true);
            this.maximumRangeValue.setEnabled(true);
        }
    }

    public void validateMinimum() {
        double d;
        try {
            d = Double.parseDouble(this.minimumRangeValue.getText());
            if (d >= this.maximumValue) {
                d = this.minimumValue;
            }
        }
        catch (NumberFormatException numberFormatException) {
            d = this.minimumValue;
        }
        this.minimumValue = d;
        this.minimumRangeValue.setText(Double.toString(this.minimumValue));
    }

    public void validateMaximum() {
        double d;
        try {
            d = Double.parseDouble(this.maximumRangeValue.getText());
            if (d <= this.minimumValue) {
                d = this.maximumValue;
            }
        }
        catch (NumberFormatException numberFormatException) {
            d = this.maximumValue;
        }
        this.maximumValue = d;
        this.maximumRangeValue.setText(Double.toString(this.maximumValue));
    }

    public void setAxisProperties(Axis axis) {
        super.setAxisProperties(axis);
        NumberAxis numberAxis = (NumberAxis)axis;
        numberAxis.setAutoRange(this.autoRange);
        if (!this.autoRange) {
            numberAxis.setRange(this.minimumValue, this.maximumValue);
        }
    }
}

