/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectList;

public class LayeredBarRenderer
extends BarRenderer
implements Serializable {
    private static final long serialVersionUID = -8716572894780469487L;
    protected ObjectList seriesBarWidthList = new ObjectList();

    public double getSeriesBarWidth(int n) {
        double d = Double.NaN;
        Number number = (Number)this.seriesBarWidthList.get(n);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public void setSeriesBarWidth(int n, double d) {
        this.seriesBarWidthList.set(n, (Object)new Double(d));
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            double d = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = 0.0;
            if (n2 > 1) {
                d2 = categoryAxis.getCategoryMargin();
            }
            double d3 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d2);
            if (n3 * n2 > 0) {
                categoryItemRendererState.setBarWidth(d3 / (double)categoryDataset.getColumnCount());
            } else {
                categoryItemRendererState.setBarWidth(d3);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    protected void drawHorizontalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Object object2;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        double d2 = 0.0;
        double d3 = this.getLowerClip();
        double d4 = this.getUpperClip();
        if (d4 <= 0.0) {
            if (d >= d4) {
                return;
            }
            d2 = d4;
            if (d <= d3) {
                d = d3;
            }
        } else if (d3 <= 0.0) {
            if (d >= d4) {
                d = d4;
            } else if (d <= d3) {
                d = d3;
            }
        } else {
            if (d <= d3) {
                return;
            }
            d2 = d3;
            if (d >= d4) {
                d = d4;
            }
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d5 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d6 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d7 = Math.min(d5, d6);
        double d8 = Math.abs(d6 - d5);
        double d9 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        int n3 = this.getRowCount();
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 1.0;
        double d13 = this.getSeriesBarWidth(n);
        if (!Double.isNaN(d13)) {
            d12 = d13;
        }
        d11 = d12 * categoryItemRendererState.getBarWidth();
        d9 += (1.0 - d12) * categoryItemRendererState.getBarWidth() / 2.0;
        if (n3 > 1) {
            d10 = d11 * 0.2 / (double)(n3 - 1);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d7, d9 + (double)(n3 - 1 - n) * d10, d8, d11 - (double)(n3 - 1 - n) * d10 * 2.0);
        Paint paint = this.getItemPaint(n, n2);
        GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, (Shape)double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n, n2);
            object = this.getItemOutlinePaint(n, n2);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, (CategoryItemLabelGenerator)object2, double_, d5 > d6);
        }
        if (categoryItemRendererState.getInfo() != null && (object = categoryItemRendererState.getEntityCollection()) != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            object.add(categoryItemEntity);
        }
    }

    protected void drawVerticalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        EntityCollection entityCollection;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        int n3 = this.getRowCount();
        double d2 = number.doubleValue();
        double d3 = 0.0;
        double d4 = this.getLowerClip();
        double d5 = this.getUpperClip();
        if (d5 <= 0.0) {
            if (d2 >= d5) {
                return;
            }
            d3 = d5;
            if (d2 <= d4) {
                d2 = d4;
            }
        } else if (d4 <= 0.0) {
            if (d2 >= d5) {
                d2 = d5;
            } else if (d2 <= d4) {
                d2 = d4;
            }
        } else {
            if (d2 <= d4) {
                return;
            }
            d3 = this.getLowerClip();
            if (d2 >= d5) {
                d2 = d5;
            }
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d6 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d7 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d8 = Math.min(d7, d6);
        double d9 = categoryItemRendererState.getBarWidth();
        double d10 = Math.abs(d7 - d6);
        double d11 = 0.0;
        d9 = 0.0;
        double d12 = 1.0;
        double d13 = this.getSeriesBarWidth(n);
        if (!Double.isNaN(d13)) {
            d12 = d13;
        }
        d9 = d12 * categoryItemRendererState.getBarWidth();
        d += (1.0 - d12) * categoryItemRendererState.getBarWidth() / 2.0;
        if (n3 > 1) {
            d11 = d9 * 0.2 / (double)(n3 - 1);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d + (double)(n3 - 1 - n) * d11, d8, d9 - (double)(n3 - 1 - n) * d11 * 2.0, d10);
        Paint paint = this.getItemPaint(n, n2);
        GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, (Shape)double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            Stroke stroke = this.getItemOutlineStroke(n, n2);
            Paint paint2 = this.getItemOutlinePaint(n, n2);
            if (stroke != null && paint2 != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setPaint(paint2);
                graphics2D.draw(double_);
            }
        }
        double d14 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d15 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
        if (categoryItemLabelGenerator != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d14 > d15);
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            entityCollection.add(categoryItemEntity);
        }
    }
}

