/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.debug3d;

import de.grogra.ray.RTCamera;
import de.grogra.ray.RTObject;
import de.grogra.ray.RTScene;
import de.grogra.ray.RTSceneVisitor;
import de.grogra.ray.debug3d.Debug3dImpl;
import de.grogra.ray.debug3d.ExportableToVRML;
import de.grogra.ray.util.Ray;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Debug3dVRMLImpl
implements Debug3dImpl {
    private static final boolean EXPORT_RAY_WEIGHT = true;
    private static final String DEBUG_VRML_FILE = "../Raytracer/debug/debug.wrl";
    private static final float SCREEN_SCALE = 3.0f;
    private static final float CAMERA_SCALE = 15.0f;
    private static final float INFINITE_RAY_SCALE = 30.0f;
    private static final float NORMAL_SCALE = 0.1f;
    private static final float LIGHT_RAY_SCALE = 1.0f;
    private File m_file = null;
    private RTCamera m_camera = null;
    private RTScene m_scene = null;
    private Vector m_infiniteRays = new Vector();
    private Vector m_finiteRays = new Vector();
    private Vector m_normals = new Vector();
    private Vector m_lightRays = new Vector();

    private File getVRMLFile() {
        if (this.m_file == null) {
            this.m_file = new File(DEBUG_VRML_FILE);
        }
        return this.m_file;
    }

    private void setCamera(RTCamera rTCamera) {
        this.m_camera = rTCamera;
    }

    private void setScene(RTScene rTScene) {
        this.m_scene = rTScene;
    }

    private void addInfiniteRay(Ray ray, float f) {
        WeightedRay weightedRay = new WeightedRay();
        weightedRay.ray = new Ray(ray);
        weightedRay.weight = f;
        this.m_infiniteRays.add(weightedRay);
    }

    private void addFiniteRay(Ray ray, float f, float f2) {
        if (f > 1000.0f) {
            this.addInfiniteRay(ray, f2);
        } else {
            WeightedRay weightedRay = new WeightedRay();
            weightedRay.ray = new Ray(ray);
            weightedRay.ray.getDirection().scale(f);
            weightedRay.weight = f2;
            this.m_finiteRays.add(weightedRay);
        }
    }

    private void addNormal(Normal normal) {
        this.m_normals.add(normal);
    }

    private void addLightRay(Ray ray) {
        Ray ray2 = new Ray(ray);
        this.m_lightRays.add(ray2);
    }

    public void logCamera(RTCamera rTCamera) {
        this.setCamera(rTCamera);
    }

    public void logScene(RTScene rTScene) {
        this.setScene(rTScene);
    }

    public void logInfiniteRay(Ray ray, float f) {
        this.addInfiniteRay(ray, f);
    }

    public void logFiniteRay(Ray ray, float f, float f2) {
        this.addFiniteRay(ray, f, f2);
    }

    public void logNormal(Tuple3f tuple3f, Tuple3f tuple3f2) {
        this.addNormal(new Normal(tuple3f, tuple3f2));
    }

    public void logDirectLightRay(Ray ray) {
        this.addLightRay(ray);
    }

    public void flush() {
        this.exportAllToVRML(this.getVRMLFile());
    }

    public void clear() {
        this.m_infiniteRays.clear();
        this.m_finiteRays.clear();
        this.m_normals.clear();
        this.m_lightRays.clear();
    }

    private void exportAllToVRML(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("#VRML V2.0 utf8");
            bufferedWriter.newLine();
            bufferedWriter.write("");
            bufferedWriter.newLine();
            bufferedWriter.write("  Background { skyColor 1 1 1 }");
            bufferedWriter.newLine();
            bufferedWriter.write("");
            bufferedWriter.newLine();
            this.exportScreen(bufferedWriter);
            this.exportCamera(bufferedWriter);
            this.exportScene(bufferedWriter);
            this.exportInfiniteRays(bufferedWriter);
            this.exportFiniteRays(bufferedWriter);
            this.exportNormals(bufferedWriter);
            this.exportLightRays(bufferedWriter);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private void exportScreen(BufferedWriter bufferedWriter) throws IOException {
        if (this.m_camera != null) {
            Ray ray = new Ray();
            this.m_camera.getRayFromCoordinates(0.0, 0.0, ray);
            Point3f point3f = new Point3f(ray.getOrigin());
            Point3f point3f2 = new Point3f();
            Point3f point3f3 = new Point3f();
            Point3f point3f4 = new Point3f();
            Point3f point3f5 = new Point3f();
            this.m_camera.getRayFromCoordinates(-1.0, -1.0, ray);
            point3f2.scaleAdd(3.0f, (Tuple3f)ray.getDirection(), (Tuple3f)point3f);
            this.m_camera.getRayFromCoordinates(-1.0, 1.0, ray);
            point3f3.scaleAdd(3.0f, (Tuple3f)ray.getDirection(), (Tuple3f)point3f);
            this.m_camera.getRayFromCoordinates(1.0, -1.0, ray);
            point3f4.scaleAdd(3.0f, (Tuple3f)ray.getDirection(), (Tuple3f)point3f);
            this.m_camera.getRayFromCoordinates(1.0, 1.0, ray);
            point3f5.scaleAdd(3.0f, (Tuple3f)ray.getDirection(), (Tuple3f)point3f);
            bufferedWriter.write("  Shape {");
            bufferedWriter.newLine();
            bufferedWriter.write("    appearance Appearance {");
            bufferedWriter.newLine();
            bufferedWriter.write("      material Material {");
            bufferedWriter.newLine();
            bufferedWriter.write("        transparency 0.2");
            bufferedWriter.newLine();
            bufferedWriter.write("      }");
            bufferedWriter.newLine();
            bufferedWriter.write("      texture   ImageTexture {");
            bufferedWriter.newLine();
            bufferedWriter.write("        url     \"screen.png\"");
            bufferedWriter.newLine();
            bufferedWriter.write("      }");
            bufferedWriter.newLine();
            bufferedWriter.write("    }");
            bufferedWriter.newLine();
            bufferedWriter.write("    geometry IndexedFaceSet {");
            bufferedWriter.newLine();
            bufferedWriter.write("      solid FALSE");
            bufferedWriter.newLine();
            bufferedWriter.write("      coord Coordinate {");
            bufferedWriter.newLine();
            bufferedWriter.write("        point [");
            bufferedWriter.newLine();
            bufferedWriter.write("          " + point3f2.x + " " + point3f2.y + " " + point3f2.z + " #top left corner");
            bufferedWriter.newLine();
            bufferedWriter.write("          " + point3f3.x + " " + point3f3.y + " " + point3f3.z + " #top right corner");
            bufferedWriter.newLine();
            bufferedWriter.write("          " + point3f5.x + " " + point3f5.y + " " + point3f5.z + " #bottom right corner");
            bufferedWriter.newLine();
            bufferedWriter.write("          " + point3f4.x + " " + point3f4.y + " " + point3f4.z + " #bottom left corner");
            bufferedWriter.newLine();
            bufferedWriter.write("        ]");
            bufferedWriter.newLine();
            bufferedWriter.write("      }");
            bufferedWriter.newLine();
            bufferedWriter.write("      texCoord  TextureCoordinate {");
            bufferedWriter.newLine();
            bufferedWriter.write("        point [");
            bufferedWriter.newLine();
            bufferedWriter.write("          0 1,");
            bufferedWriter.newLine();
            bufferedWriter.write("          0 0,");
            bufferedWriter.newLine();
            bufferedWriter.write("          1 0,");
            bufferedWriter.newLine();
            bufferedWriter.write("          1 1");
            bufferedWriter.newLine();
            bufferedWriter.write("        ]");
            bufferedWriter.newLine();
            bufferedWriter.write("      }");
            bufferedWriter.newLine();
            bufferedWriter.write("      coordIndex [");
            bufferedWriter.newLine();
            bufferedWriter.write("        0, 1, 2, 3");
            bufferedWriter.newLine();
            bufferedWriter.write("      ]");
            bufferedWriter.newLine();
            bufferedWriter.write("      texCoordIndex [");
            bufferedWriter.newLine();
            bufferedWriter.write("        0, 1, 2, 3");
            bufferedWriter.newLine();
            bufferedWriter.write("      ]");
            bufferedWriter.newLine();
            bufferedWriter.write("    }");
            bufferedWriter.newLine();
            bufferedWriter.write("  }");
            bufferedWriter.newLine();
        }
    }

    private void exportCamera(BufferedWriter bufferedWriter) {
        if (this.m_camera != null) {
            Ray ray = new Ray();
            this.m_camera.getRayFromCoordinates(0.0, 0.0, ray);
            Point3f point3f = new Point3f(ray.getOrigin());
            Point3f point3f2 = new Point3f();
            Point3f point3f3 = new Point3f();
            Point3f point3f4 = new Point3f();
            Point3f point3f5 = new Point3f();
            this.m_camera.getRayFromCoordinates(-1.0, -1.0, ray);
            point3f2.scaleAdd(15.0f, (Tuple3f)ray.getDirection(), (Tuple3f)point3f);
            this.m_camera.getRayFromCoordinates(-1.0, 1.0, ray);
            point3f3.scaleAdd(15.0f, (Tuple3f)ray.getDirection(), (Tuple3f)point3f);
            this.m_camera.getRayFromCoordinates(1.0, -1.0, ray);
            point3f4.scaleAdd(15.0f, (Tuple3f)ray.getDirection(), (Tuple3f)point3f);
            this.m_camera.getRayFromCoordinates(1.0, 1.0, ray);
            point3f5.scaleAdd(15.0f, (Tuple3f)ray.getDirection(), (Tuple3f)point3f);
            try {
                bufferedWriter.write("  Shape {");
                bufferedWriter.newLine();
                bufferedWriter.write("    appearance Appearance {");
                bufferedWriter.newLine();
                bufferedWriter.write("      material Material {");
                bufferedWriter.newLine();
                bufferedWriter.write("        transparency 0.7");
                bufferedWriter.newLine();
                bufferedWriter.write("        diffuseColor 0 0 0.6");
                bufferedWriter.newLine();
                bufferedWriter.write("        emissiveColor 0 0 0.6");
                bufferedWriter.newLine();
                bufferedWriter.write("      }");
                bufferedWriter.newLine();
                bufferedWriter.write("    }");
                bufferedWriter.newLine();
                bufferedWriter.write("    geometry IndexedFaceSet {");
                bufferedWriter.newLine();
                bufferedWriter.write("      solid FALSE");
                bufferedWriter.newLine();
                bufferedWriter.write("      coord Coordinate {");
                bufferedWriter.newLine();
                bufferedWriter.write("        point [");
                bufferedWriter.newLine();
                bufferedWriter.write("          " + point3f.x + " " + point3f.y + " " + point3f.z + " #camera center point");
                bufferedWriter.newLine();
                bufferedWriter.write("          " + point3f2.x + " " + point3f2.y + " " + point3f2.z + " #top left corner");
                bufferedWriter.newLine();
                bufferedWriter.write("          " + point3f3.x + " " + point3f3.y + " " + point3f3.z + " #top right corner");
                bufferedWriter.newLine();
                bufferedWriter.write("          " + point3f4.x + " " + point3f4.y + " " + point3f4.z + " #bottom left corner");
                bufferedWriter.newLine();
                bufferedWriter.write("          " + point3f5.x + " " + point3f5.y + " " + point3f5.z + " #bottom right corner");
                bufferedWriter.newLine();
                bufferedWriter.write("        ]");
                bufferedWriter.newLine();
                bufferedWriter.write("      }");
                bufferedWriter.newLine();
                bufferedWriter.write("      coordIndex [");
                bufferedWriter.newLine();
                bufferedWriter.write("        0, 1, 2, 0, -1, #top triangle");
                bufferedWriter.newLine();
                bufferedWriter.write("        0, 2, 4, 0, -1, #right triangle");
                bufferedWriter.newLine();
                bufferedWriter.write("        0, 4, 3, 0, -1, #bottom triangle");
                bufferedWriter.newLine();
                bufferedWriter.write("        0, 3, 1, 0      #left triangle");
                bufferedWriter.newLine();
                bufferedWriter.write("      ]");
                bufferedWriter.newLine();
                bufferedWriter.write("    }");
                bufferedWriter.newLine();
                bufferedWriter.write("  }");
                bufferedWriter.newLine();
                bufferedWriter.write("  Shape {");
                bufferedWriter.newLine();
                bufferedWriter.write("    appearance Appearance {");
                bufferedWriter.newLine();
                bufferedWriter.write("      material Material {");
                bufferedWriter.newLine();
                bufferedWriter.write("        transparency 0.5");
                bufferedWriter.newLine();
                bufferedWriter.write("        diffuseColor 0 0 0.6");
                bufferedWriter.newLine();
                bufferedWriter.write("        emissiveColor 0 0 0.6");
                bufferedWriter.newLine();
                bufferedWriter.write("      }");
                bufferedWriter.newLine();
                bufferedWriter.write("    }");
                bufferedWriter.newLine();
                bufferedWriter.write("    geometry IndexedLineSet {");
                bufferedWriter.newLine();
                bufferedWriter.write("      coord Coordinate {");
                bufferedWriter.newLine();
                bufferedWriter.write("        point [");
                bufferedWriter.newLine();
                bufferedWriter.write("          " + point3f.x + " " + point3f.y + " " + point3f.z + " #camera center point");
                bufferedWriter.newLine();
                bufferedWriter.write("          " + point3f2.x + " " + point3f2.y + " " + point3f2.z + " #top left corner");
                bufferedWriter.newLine();
                bufferedWriter.write("          " + point3f3.x + " " + point3f3.y + " " + point3f3.z + " #top right corner");
                bufferedWriter.newLine();
                bufferedWriter.write("          " + point3f4.x + " " + point3f4.y + " " + point3f4.z + " #bottom left corner");
                bufferedWriter.newLine();
                bufferedWriter.write("          " + point3f5.x + " " + point3f5.y + " " + point3f5.z + " #bottom right corner");
                bufferedWriter.newLine();
                bufferedWriter.write("        ]");
                bufferedWriter.newLine();
                bufferedWriter.write("      }");
                bufferedWriter.newLine();
                bufferedWriter.write("      coordIndex [");
                bufferedWriter.newLine();
                bufferedWriter.write("        0, 1, -1, #top left corner");
                bufferedWriter.newLine();
                bufferedWriter.write("        0, 2, -1, #top right corner");
                bufferedWriter.newLine();
                bufferedWriter.write("        0, 4, -1, #bottom left corner");
                bufferedWriter.newLine();
                bufferedWriter.write("        0, 3      #bottom right corner");
                bufferedWriter.newLine();
                bufferedWriter.write("      ]");
                bufferedWriter.newLine();
                bufferedWriter.write("    }");
                bufferedWriter.newLine();
                bufferedWriter.write("  }");
                bufferedWriter.newLine();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    private void exportScene(BufferedWriter bufferedWriter) {
        if (this.m_scene != null) {
            RTSceneExportVisitor rTSceneExportVisitor = new RTSceneExportVisitor(bufferedWriter);
            this.m_scene.traversSceneObjects(rTSceneExportVisitor);
            this.m_scene.traversSceneLights(rTSceneExportVisitor);
            try {
                bufferedWriter.newLine();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    private void exportInfiniteRays(BufferedWriter bufferedWriter) {
        if (this.m_infiniteRays.size() > 0) {
            try {
                Point3f point3f = new Point3f();
                for (int i = 0; i < this.m_infiniteRays.size(); ++i) {
                    WeightedRay weightedRay = (WeightedRay)this.m_infiniteRays.elementAt(i);
                    point3f.scaleAdd(30.0f, (Tuple3f)weightedRay.ray.getDirection(), (Tuple3f)weightedRay.ray.getOrigin());
                    bufferedWriter.newLine();
                    bufferedWriter.write("  Shape {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    appearance Appearance {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      material Material {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        transparency " + (1.0f - weightedRay.weight));
                    bufferedWriter.newLine();
                    bufferedWriter.write("        diffuseColor 0.4 0.4 0.4");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    geometry IndexedLineSet {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      coord Coordinate {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        point [");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          " + weightedRay.ray.getOrigin().x + " " + weightedRay.ray.getOrigin().y + " " + weightedRay.ray.getOrigin().z);
                    bufferedWriter.newLine();
                    bufferedWriter.write("          " + point3f.x + " " + point3f.y + " " + point3f.z);
                    bufferedWriter.newLine();
                    bufferedWriter.write("        ]");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      coordIndex [");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        0, 1");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      ]");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("  }");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    private void exportFiniteRays(BufferedWriter bufferedWriter) {
        if (this.m_finiteRays.size() > 0) {
            try {
                Point3f point3f = new Point3f();
                for (int i = 0; i < this.m_finiteRays.size(); ++i) {
                    WeightedRay weightedRay = (WeightedRay)this.m_finiteRays.elementAt(i);
                    point3f.scaleAdd(1.0f, (Tuple3f)weightedRay.ray.getDirection(), (Tuple3f)weightedRay.ray.getOrigin());
                    bufferedWriter.newLine();
                    bufferedWriter.write("  Shape {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    appearance Appearance {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      material Material {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        transparency " + (1.0f - weightedRay.weight));
                    bufferedWriter.newLine();
                    bufferedWriter.write("        diffuseColor 0.0 0.7 0.0");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        emissiveColor 0.0 0.7 0.0");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    geometry IndexedLineSet {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      coord Coordinate {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        point [");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          " + weightedRay.ray.getOrigin().x + " " + weightedRay.ray.getOrigin().y + " " + weightedRay.ray.getOrigin().z);
                    bufferedWriter.newLine();
                    bufferedWriter.write("          " + point3f.x + " " + point3f.y + " " + point3f.z);
                    bufferedWriter.newLine();
                    bufferedWriter.write("        ]");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      coordIndex [");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        0, 1");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      ]");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("  }");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    private void exportNormals(BufferedWriter bufferedWriter) {
        if (this.m_normals.size() > 0) {
            try {
                Point3f point3f = new Point3f();
                for (int i = 0; i < this.m_normals.size(); ++i) {
                    Normal normal = (Normal)this.m_normals.elementAt(i);
                    point3f.scaleAdd(0.1f, normal.direction, normal.point);
                    bufferedWriter.newLine();
                    bufferedWriter.write("  Shape {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    appearance Appearance {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      material Material {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        transparency 0.5");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        diffuseColor 1 0 0");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        emissiveColor 1 0 0");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    geometry IndexedLineSet {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      coord Coordinate {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        point [");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          " + normal.point.x + " " + normal.point.y + " " + normal.point.z);
                    bufferedWriter.newLine();
                    bufferedWriter.write("          " + point3f.x + " " + point3f.y + " " + point3f.z);
                    bufferedWriter.newLine();
                    bufferedWriter.write("        ]");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      coordIndex [");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        0, 1");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      ]");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("  }");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    private void exportLightRays(BufferedWriter bufferedWriter) {
        if (this.m_lightRays.size() > 0) {
            try {
                Point3f point3f = new Point3f();
                for (int i = 0; i < this.m_lightRays.size(); ++i) {
                    Ray ray = (Ray)this.m_lightRays.elementAt(i);
                    point3f.scaleAdd(1.0f, (Tuple3f)ray.direction, (Tuple3f)ray.origin);
                    bufferedWriter.newLine();
                    bufferedWriter.write("  Shape {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    appearance Appearance {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      material Material {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        transparency 0.2");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        diffuseColor 1 1 0");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        emissiveColor 1 1 0");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    geometry IndexedLineSet {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      coord Coordinate {");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        point [");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          " + ray.origin.x + " " + ray.origin.y + " " + ray.origin.z);
                    bufferedWriter.newLine();
                    bufferedWriter.write("          " + point3f.x + " " + point3f.y + " " + point3f.z);
                    bufferedWriter.newLine();
                    bufferedWriter.write("        ]");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      coordIndex [");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        0, 1");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      ]");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    }");
                    bufferedWriter.newLine();
                    bufferedWriter.write("  }");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    private class Normal {
        public Tuple3f point = new Point3f();
        public Tuple3f direction = new Vector3f();

        public Normal(Tuple3f tuple3f, Tuple3f tuple3f2) {
            this.point.set(tuple3f);
            this.direction.set(tuple3f2);
        }
    }

    private class WeightedRay {
        public Ray ray = null;
        public float weight;

        private WeightedRay() {
        }
    }

    private class RTSceneExportVisitor
    implements RTSceneVisitor {
        private BufferedWriter m_writer;

        public RTSceneExportVisitor(BufferedWriter bufferedWriter) {
            this.m_writer = bufferedWriter;
        }

        public void visitObject(RTObject rTObject) {
            if (rTObject instanceof ExportableToVRML) {
                try {
                    this.m_writer.newLine();
                    ((ExportableToVRML)((Object)rTObject)).exportToVRML(this.m_writer);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
    }
}

