/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.intersection;

import de.grogra.ray.RTObject;
import de.grogra.ray.RTScene;
import de.grogra.ray.Raytracer;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.IntersectionProcessor;
import de.grogra.ray.quality.Timer;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;

public class DefaultIntersectionProcessor
implements IntersectionProcessor {
    private RTScene m_sceneGraph = null;
    private int m_evaluationParameters = 0;
    private RTObject[] m_objects = null;
    private RTObject[] m_fakeObjects = null;
    private Timer m_timer;
    private boolean m_isTimerEnabled = false;
    private float m_curT;
    private float m_minT;
    private int m_minIndex;

    public void setEvaluationParameters(int n) {
        this.m_evaluationParameters = n;
    }

    public void prepareProcessing(RTScene rTScene) {
        this.m_sceneGraph = rTScene;
        this.m_objects = Raytracer.getShadeables(this.m_sceneGraph);
    }

    public void cleanupProcessing() {
    }

    public boolean getFirstIntersectionDescription(Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription) {
        this.m_minT = Float.MAX_VALUE;
        this.m_minIndex = -1;
        for (int i = 0; i < this.m_objects.length; ++i) {
            if (this.m_objects[i] == rayContext.excludeObject) continue;
            this.m_curT = this.m_objects[i].getDistance(ray, rayContext);
            if (!(this.m_curT < this.m_minT)) continue;
            this.m_minIndex = i;
            this.m_minT = this.m_curT;
        }
        if (this.m_minIndex > -1) {
            this.m_objects[this.m_minIndex].getIntersectionDescription(intersectionDescription);
            return true;
        }
        return false;
    }

    public float getFirstIntersectionT(Ray ray, RayContext rayContext) {
        this.m_minT = Float.MAX_VALUE;
        for (int i = 0; i < this.m_objects.length; ++i) {
            if (this.m_objects[i] == rayContext.excludeObject) continue;
            this.m_curT = this.m_objects[i].getDistance(ray, rayContext);
            if (!(this.m_curT < this.m_minT)) continue;
            this.m_minT = this.m_curT;
        }
        if (this.m_minT < Float.MAX_VALUE) {
            return this.m_minT;
        }
        return Float.NaN;
    }
}

