/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.intersection;

import de.grogra.ray.intersection.CellGenerator;
import de.grogra.ray.intersection.Intersections;
import de.grogra.ray.intersection.OctreeCell;
import de.grogra.ray.util.Ray;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class EndlCellGenerator
implements CellGenerator {
    private OctreeCell m_root;
    private int m_maxDepth;
    private int m_maxAxisDivisions;
    private float[] m_cellLengthX;
    private float[] m_cellLengthY;
    private float[] m_cellLengthZ;
    private boolean m_isFirstCell = false;
    private BoxIntersectionInput m_intersectionInput = new BoxIntersectionInput();
    private BoxIntersectionLocals m_intersectionLocals = new BoxIntersectionLocals();
    private BoxIntersectionOutput m_intersectionOutput = new BoxIntersectionOutput();
    private OctreeCell m_nextToLastCell;
    private LastCell m_lastCell = new LastCell();
    private DeterminingCellLocals m_determiningCellLocals = new DeterminingCellLocals();
    private Point3d m_tmp_point = new Point3d();
    private boolean m_test = true;

    public void initialize(OctreeCell octreeCell, int n) {
        this.m_root = octreeCell;
        this.m_maxDepth = n;
        this.m_cellLengthX = new float[n + 2];
        this.m_cellLengthY = new float[n + 2];
        this.m_cellLengthZ = new float[n + 2];
        float f = this.m_root.getMaxValues().x - this.m_root.getMinValues().x;
        float f2 = this.m_root.getMaxValues().y - this.m_root.getMinValues().y;
        float f3 = this.m_root.getMaxValues().z - this.m_root.getMinValues().z;
        for (int i = 0; i < n + 2; ++i) {
            this.m_cellLengthX[i] = f;
            this.m_cellLengthY[i] = f2;
            this.m_cellLengthZ[i] = f3;
            f /= 2.0f;
            f2 /= 2.0f;
            f3 /= 2.0f;
        }
        this.m_maxAxisDivisions = 1 << n;
    }

    public void setRay(Ray ray) {
        this.m_intersectionInput.origin.set((Tuple3f)ray.getOrigin());
        this.m_intersectionInput.direction.set((Tuple3f)ray.getDirection());
        this.m_isFirstCell = true;
        this.m_nextToLastCell = null;
        this.m_lastCell.cell = null;
        this.m_lastCell.leavingPart = -1;
    }

    public void nextCell(CellGenerator.NextCellOutput nextCellOutput) {
        nextCellOutput.errorOccurred = false;
        if (this.m_isFirstCell) {
            this.getStartingCell(nextCellOutput);
            this.m_isFirstCell = false;
        } else {
            if (this.m_lastCell.cell == null) {
                return;
            }
            switch (this.m_lastCell.leavingPart) {
                case 1: {
                    if (this.m_lastCell.cell.getNeighbourFront() == null) {
                        nextCellOutput.nextCell = null;
                        return;
                    }
                    if (!this.m_lastCell.cell.getNeighbourFront().hasChildren()) {
                        nextCellOutput.nextCell = this.m_lastCell.cell.getNeighbourFront();
                    } else {
                        this.m_tmp_point.set((Tuple3d)this.m_lastCell.leavingPoint);
                        this.m_tmp_point.y -= (double)this.m_cellLengthY[this.m_maxDepth + 1];
                        nextCellOutput.nextCell = this.getCellFromPoint(this.m_tmp_point);
                    }
                    this.getLeavingInformation(nextCellOutput);
                    break;
                }
                case 2: {
                    if (this.m_lastCell.cell.getNeighbourBack() == null) {
                        nextCellOutput.nextCell = null;
                        return;
                    }
                    if (!this.m_lastCell.cell.getNeighbourBack().hasChildren()) {
                        nextCellOutput.nextCell = this.m_lastCell.cell.getNeighbourBack();
                    } else {
                        this.m_tmp_point.set((Tuple3d)this.m_lastCell.leavingPoint);
                        this.m_tmp_point.y += (double)this.m_cellLengthY[this.m_maxDepth + 1];
                        nextCellOutput.nextCell = this.getCellFromPoint(this.m_tmp_point);
                    }
                    this.getLeavingInformation(nextCellOutput);
                    break;
                }
                case 3: {
                    if (this.m_lastCell.cell.getNeighbourTop() == null) {
                        nextCellOutput.nextCell = null;
                        return;
                    }
                    if (!this.m_lastCell.cell.getNeighbourTop().hasChildren()) {
                        nextCellOutput.nextCell = this.m_lastCell.cell.getNeighbourTop();
                    } else {
                        this.m_tmp_point.set((Tuple3d)this.m_lastCell.leavingPoint);
                        this.m_tmp_point.z += (double)this.m_cellLengthZ[this.m_maxDepth + 1];
                        nextCellOutput.nextCell = this.getCellFromPoint(this.m_tmp_point);
                    }
                    this.getLeavingInformation(nextCellOutput);
                    break;
                }
                case 4: {
                    if (this.m_lastCell.cell.getNeighbourBottom() == null) {
                        nextCellOutput.nextCell = null;
                        return;
                    }
                    if (!this.m_lastCell.cell.getNeighbourBottom().hasChildren()) {
                        nextCellOutput.nextCell = this.m_lastCell.cell.getNeighbourBottom();
                    } else {
                        this.m_tmp_point.set((Tuple3d)this.m_lastCell.leavingPoint);
                        this.m_tmp_point.z -= (double)this.m_cellLengthZ[this.m_maxDepth + 1];
                        nextCellOutput.nextCell = this.getCellFromPoint(this.m_tmp_point);
                    }
                    this.getLeavingInformation(nextCellOutput);
                    break;
                }
                case 5: {
                    if (this.m_lastCell.cell.getNeighbourLeft() == null) {
                        nextCellOutput.nextCell = null;
                        return;
                    }
                    if (!this.m_lastCell.cell.getNeighbourLeft().hasChildren()) {
                        nextCellOutput.nextCell = this.m_lastCell.cell.getNeighbourLeft();
                    } else {
                        this.m_tmp_point.set((Tuple3d)this.m_lastCell.leavingPoint);
                        this.m_tmp_point.x -= (double)this.m_cellLengthX[this.m_maxDepth + 1];
                        nextCellOutput.nextCell = this.getCellFromPoint(this.m_tmp_point);
                    }
                    this.getLeavingInformation(nextCellOutput);
                    break;
                }
                case 6: {
                    if (this.m_lastCell.cell.getNeighbourRight() == null) {
                        nextCellOutput.nextCell = null;
                        return;
                    }
                    if (!this.m_lastCell.cell.getNeighbourRight().hasChildren()) {
                        nextCellOutput.nextCell = this.m_lastCell.cell.getNeighbourRight();
                    } else {
                        this.m_tmp_point.set((Tuple3d)this.m_lastCell.leavingPoint);
                        this.m_tmp_point.x += (double)this.m_cellLengthX[this.m_maxDepth + 1];
                        nextCellOutput.nextCell = this.getCellFromPoint(this.m_tmp_point);
                    }
                    this.getLeavingInformation(nextCellOutput);
                    break;
                }
                default: {
                    nextCellOutput.nextCell = null;
                    this.m_lastCell.cell = null;
                    return;
                }
            }
            if (nextCellOutput.nextCell == this.m_lastCell.cell) {
                nextCellOutput.errorOccurred = true;
                nextCellOutput.nextCell = null;
                return;
            }
            if (nextCellOutput.nextCell != null && nextCellOutput.nextCell == this.m_nextToLastCell) {
                nextCellOutput.errorOccurred = true;
                nextCellOutput.nextCell = null;
                return;
            }
            this.m_nextToLastCell = this.m_lastCell.cell;
        }
        this.m_lastCell.cell = nextCellOutput.nextCell;
    }

    private void getStartingCell(CellGenerator.NextCellOutput nextCellOutput) {
        if (Intersections.isPointInsideBox(this.m_intersectionInput.origin, this.m_root.getMinValues(), this.m_root.getMaxValues())) {
            nextCellOutput.nextCell = this.getCellFromPoint(this.m_intersectionInput.origin);
        } else {
            this.m_intersectionInput.minValues.set((Tuple3f)this.m_root.getMinValues());
            this.m_intersectionInput.maxValues.set((Tuple3f)this.m_root.getMaxValues());
            EndlCellGenerator.getBoxEnteringIntersection(this.m_intersectionInput, this.m_intersectionLocals, this.m_intersectionOutput);
            if (!this.m_intersectionOutput.hasIntersection) {
                nextCellOutput.nextCell = null;
                return;
            }
            nextCellOutput.nextCell = this.getBorderCellFromPoint(this.m_intersectionOutput.enteringPoint, this.m_intersectionOutput.enteringPart);
        }
        this.getLeavingInformation(nextCellOutput);
    }

    private void getLeavingInformation(CellGenerator.NextCellOutput nextCellOutput) {
        if (nextCellOutput.nextCell == null) {
            nextCellOutput.errorOccurred = true;
            nextCellOutput.nextCell = null;
            return;
        }
        this.m_intersectionInput.minValues.set((Tuple3f)nextCellOutput.nextCell.getMinValues());
        this.m_intersectionInput.maxValues.set((Tuple3f)nextCellOutput.nextCell.getMaxValues());
        this.getBoxLeavingIntersection(this.m_intersectionInput, this.m_intersectionLocals, this.m_intersectionOutput);
        if (this.m_intersectionOutput.errorOccurred) {
            nextCellOutput.errorOccurred = true;
            nextCellOutput.nextCell = null;
            return;
        }
        nextCellOutput.leavingT = this.m_intersectionOutput.leavingT;
        this.m_lastCell.leavingPart = this.m_intersectionOutput.leavingPart;
        this.m_lastCell.leavingPoint.set((Tuple3d)this.m_intersectionOutput.leavingPoint);
    }

    private OctreeCell getCellFromPoint(Point3d point3d) {
        this.m_determiningCellLocals.index_x = (int)Math.floor((point3d.x - (double)this.m_root.getMinValues().x) / (double)this.m_cellLengthX[0] * (double)this.m_maxAxisDivisions);
        this.m_determiningCellLocals.index_y = (int)Math.floor((point3d.y - (double)this.m_root.getMinValues().y) / (double)this.m_cellLengthY[0] * (double)this.m_maxAxisDivisions);
        this.m_determiningCellLocals.index_z = (int)Math.floor((point3d.z - (double)this.m_root.getMinValues().z) / (double)this.m_cellLengthZ[0] * (double)this.m_maxAxisDivisions);
        if (this.m_determiningCellLocals.index_x >= this.m_maxAxisDivisions) {
            System.err.println("x index out of bounds ...");
            this.m_determiningCellLocals.index_x = this.m_maxAxisDivisions - 1;
        }
        if (this.m_determiningCellLocals.index_y >= this.m_maxAxisDivisions) {
            System.err.println("y index out of bounds ...");
            this.m_determiningCellLocals.index_y = this.m_maxAxisDivisions - 1;
        }
        if (this.m_determiningCellLocals.index_z >= this.m_maxAxisDivisions) {
            System.err.println("z index out of bounds ...");
            this.m_determiningCellLocals.index_z = this.m_maxAxisDivisions - 1;
        }
        this.determineCell(this.m_determiningCellLocals);
        return this.m_determiningCellLocals.cell;
    }

    private OctreeCell getBorderCellFromPoint(Point3d point3d, int n) {
        switch (n) {
            case 1: {
                this.m_determiningCellLocals.index_y = 0;
                this.m_determiningCellLocals.index_x = (int)Math.floor((point3d.x - (double)this.m_root.getMinValues().x) / (double)this.m_cellLengthX[0] * (double)this.m_maxAxisDivisions);
                this.m_determiningCellLocals.index_z = (int)Math.floor((point3d.z - (double)this.m_root.getMinValues().z) / (double)this.m_cellLengthZ[0] * (double)this.m_maxAxisDivisions);
                if (this.m_determiningCellLocals.index_x >= this.m_maxAxisDivisions) {
                    this.m_determiningCellLocals.index_x = this.m_maxAxisDivisions - 1;
                }
                if (this.m_determiningCellLocals.index_z < this.m_maxAxisDivisions) break;
                this.m_determiningCellLocals.index_z = this.m_maxAxisDivisions - 1;
                break;
            }
            case 2: {
                this.m_determiningCellLocals.index_y = this.m_maxAxisDivisions - 1;
                this.m_determiningCellLocals.index_x = (int)Math.floor((point3d.x - (double)this.m_root.getMinValues().x) / (double)this.m_cellLengthX[0] * (double)this.m_maxAxisDivisions);
                this.m_determiningCellLocals.index_z = (int)Math.floor((point3d.z - (double)this.m_root.getMinValues().z) / (double)this.m_cellLengthZ[0] * (double)this.m_maxAxisDivisions);
                if (this.m_determiningCellLocals.index_x >= this.m_maxAxisDivisions) {
                    this.m_determiningCellLocals.index_x = this.m_maxAxisDivisions - 1;
                }
                if (this.m_determiningCellLocals.index_z < this.m_maxAxisDivisions) break;
                this.m_determiningCellLocals.index_z = this.m_maxAxisDivisions - 1;
                break;
            }
            case 3: {
                this.m_determiningCellLocals.index_z = this.m_maxAxisDivisions - 1;
                this.m_determiningCellLocals.index_x = (int)Math.floor((point3d.x - (double)this.m_root.getMinValues().x) / (double)this.m_cellLengthX[0] * (double)this.m_maxAxisDivisions);
                this.m_determiningCellLocals.index_y = (int)Math.floor((point3d.y - (double)this.m_root.getMinValues().y) / (double)this.m_cellLengthY[0] * (double)this.m_maxAxisDivisions);
                if (this.m_determiningCellLocals.index_x >= this.m_maxAxisDivisions) {
                    this.m_determiningCellLocals.index_x = this.m_maxAxisDivisions - 1;
                }
                if (this.m_determiningCellLocals.index_y < this.m_maxAxisDivisions) break;
                this.m_determiningCellLocals.index_y = this.m_maxAxisDivisions - 1;
                break;
            }
            case 4: {
                this.m_determiningCellLocals.index_z = 0;
                this.m_determiningCellLocals.index_x = (int)Math.floor((point3d.x - (double)this.m_root.getMinValues().x) / (double)this.m_cellLengthX[0] * (double)this.m_maxAxisDivisions);
                this.m_determiningCellLocals.index_y = (int)Math.floor((point3d.y - (double)this.m_root.getMinValues().y) / (double)this.m_cellLengthY[0] * (double)this.m_maxAxisDivisions);
                if (this.m_determiningCellLocals.index_x >= this.m_maxAxisDivisions) {
                    this.m_determiningCellLocals.index_x = this.m_maxAxisDivisions - 1;
                }
                if (this.m_determiningCellLocals.index_y < this.m_maxAxisDivisions) break;
                this.m_determiningCellLocals.index_y = this.m_maxAxisDivisions - 1;
                break;
            }
            case 5: {
                this.m_determiningCellLocals.index_x = 0;
                this.m_determiningCellLocals.index_y = (int)Math.floor((point3d.y - (double)this.m_root.getMinValues().y) / (double)this.m_cellLengthY[0] * (double)this.m_maxAxisDivisions);
                this.m_determiningCellLocals.index_z = (int)Math.floor((point3d.z - (double)this.m_root.getMinValues().z) / (double)this.m_cellLengthZ[0] * (double)this.m_maxAxisDivisions);
                if (this.m_determiningCellLocals.index_y >= this.m_maxAxisDivisions) {
                    this.m_determiningCellLocals.index_y = this.m_maxAxisDivisions - 1;
                }
                if (this.m_determiningCellLocals.index_z < this.m_maxAxisDivisions) break;
                this.m_determiningCellLocals.index_z = this.m_maxAxisDivisions - 1;
                break;
            }
            case 6: {
                this.m_determiningCellLocals.index_x = this.m_maxAxisDivisions - 1;
                this.m_determiningCellLocals.index_y = (int)Math.floor((point3d.y - (double)this.m_root.getMinValues().y) / (double)this.m_cellLengthY[0] * (double)this.m_maxAxisDivisions);
                this.m_determiningCellLocals.index_z = (int)Math.floor((point3d.z - (double)this.m_root.getMinValues().z) / (double)this.m_cellLengthZ[0] * (double)this.m_maxAxisDivisions);
                if (this.m_determiningCellLocals.index_y >= this.m_maxAxisDivisions) {
                    this.m_determiningCellLocals.index_y = this.m_maxAxisDivisions - 1;
                }
                if (this.m_determiningCellLocals.index_z < this.m_maxAxisDivisions) break;
                this.m_determiningCellLocals.index_z = this.m_maxAxisDivisions - 1;
            }
        }
        this.determineCell(this.m_determiningCellLocals);
        return this.m_determiningCellLocals.cell;
    }

    private void determineCell(DeterminingCellLocals determiningCellLocals) {
        determiningCellLocals.cell = this.m_root;
        for (int i = 0; i < this.m_maxDepth; ++i) {
            if (!determiningCellLocals.cell.hasChildren()) {
                return;
            }
            determiningCellLocals.shift = this.m_maxDepth - 1 - i;
            determiningCellLocals.bit_mask = 1 << determiningCellLocals.shift;
            determiningCellLocals.bit_x = (determiningCellLocals.index_x & determiningCellLocals.bit_mask) >> determiningCellLocals.shift;
            determiningCellLocals.bit_y = (determiningCellLocals.index_y & determiningCellLocals.bit_mask) >> determiningCellLocals.shift;
            determiningCellLocals.bit_z = (determiningCellLocals.index_z & determiningCellLocals.bit_mask) >> determiningCellLocals.shift;
            determiningCellLocals.child_index = (determiningCellLocals.bit_x << 2) + (determiningCellLocals.bit_y << 1) + determiningCellLocals.bit_z;
            determiningCellLocals.cell = determiningCellLocals.cell.getChild(determiningCellLocals.child_index);
        }
    }

    public static void getBoxEnteringIntersection(BoxIntersectionInput boxIntersectionInput, BoxIntersectionLocals boxIntersectionLocals, BoxIntersectionOutput boxIntersectionOutput) {
        boxIntersectionOutput.hasIntersection = false;
        if (boxIntersectionInput.direction.x > 0.0 && boxIntersectionInput.origin.x < (double)boxIntersectionInput.minValues.x) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.minValues.x - boxIntersectionInput.origin.x) / boxIntersectionInput.direction.x;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.enteringPoint.y <= (double)boxIntersectionInput.maxValues.y && boxIntersectionOutput.enteringPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.enteringPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 5;
                return;
            }
        }
        if (boxIntersectionInput.direction.y > 0.0 && boxIntersectionInput.origin.y < (double)boxIntersectionInput.minValues.y) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.minValues.y - boxIntersectionInput.origin.y) / boxIntersectionInput.direction.y;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.enteringPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.enteringPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.enteringPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 1;
                return;
            }
        }
        if (boxIntersectionInput.direction.z > 0.0 && boxIntersectionInput.origin.z < (double)boxIntersectionInput.minValues.z) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.minValues.z - boxIntersectionInput.origin.z) / boxIntersectionInput.direction.z;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.enteringPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.enteringPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.enteringPoint.y <= (double)boxIntersectionInput.maxValues.y) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 4;
                return;
            }
        }
        if (boxIntersectionInput.direction.x < 0.0 && boxIntersectionInput.origin.x > (double)boxIntersectionInput.maxValues.x) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.maxValues.x - boxIntersectionInput.origin.x) / boxIntersectionInput.direction.x;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.enteringPoint.y <= (double)boxIntersectionInput.maxValues.y && boxIntersectionOutput.enteringPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.enteringPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 6;
                return;
            }
        }
        if (boxIntersectionInput.direction.y < 0.0 && boxIntersectionInput.origin.y > (double)boxIntersectionInput.maxValues.y) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.maxValues.y - boxIntersectionInput.origin.y) / boxIntersectionInput.direction.y;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.enteringPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.enteringPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.enteringPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 2;
                return;
            }
        }
        if (boxIntersectionInput.direction.z < 0.0 && boxIntersectionInput.origin.z > (double)boxIntersectionInput.maxValues.z) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.maxValues.z - boxIntersectionInput.origin.z) / boxIntersectionInput.direction.z;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.enteringPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.enteringPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.enteringPoint.y <= (double)boxIntersectionInput.maxValues.y) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 3;
                return;
            }
        }
    }

    public void getBoxLeavingIntersection(BoxIntersectionInput boxIntersectionInput, BoxIntersectionLocals boxIntersectionLocals, BoxIntersectionOutput boxIntersectionOutput) {
        boxIntersectionOutput.errorOccurred = false;
        if (boxIntersectionInput.direction.x > 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.maxValues.x - boxIntersectionInput.origin.x) / boxIntersectionInput.direction.x;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.leavingPoint.y <= (double)boxIntersectionInput.maxValues.y && boxIntersectionOutput.leavingPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.leavingPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.leavingPart = 6;
                return;
            }
        }
        if (boxIntersectionInput.direction.x < 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.minValues.x - boxIntersectionInput.origin.x) / boxIntersectionInput.direction.x;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.leavingPoint.y <= (double)boxIntersectionInput.maxValues.y && boxIntersectionOutput.leavingPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.leavingPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.leavingPart = 5;
                return;
            }
        }
        if (boxIntersectionInput.direction.y > 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.maxValues.y - boxIntersectionInput.origin.y) / boxIntersectionInput.direction.y;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.leavingPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.leavingPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.leavingPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.leavingPart = 2;
                return;
            }
        }
        if (boxIntersectionInput.direction.y < 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.minValues.y - boxIntersectionInput.origin.y) / boxIntersectionInput.direction.y;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.leavingPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.leavingPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.leavingPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.leavingPart = 1;
                return;
            }
        }
        if (boxIntersectionInput.direction.z > 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.maxValues.z - boxIntersectionInput.origin.z) / boxIntersectionInput.direction.z;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.leavingPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.leavingPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.leavingPoint.y <= (double)boxIntersectionInput.maxValues.y) {
                boxIntersectionOutput.leavingPart = 3;
                return;
            }
        }
        if (boxIntersectionInput.direction.z < 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.minValues.z - boxIntersectionInput.origin.z) / boxIntersectionInput.direction.z;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.leavingPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.leavingPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.leavingPoint.y <= (double)boxIntersectionInput.maxValues.y) {
                boxIntersectionOutput.leavingPart = 4;
                return;
            }
        }
        boxIntersectionOutput.leavingPart = 0;
        boxIntersectionOutput.errorOccurred = true;
    }

    public class DeterminingCellLocals {
        public int index_x;
        public int index_y;
        public int index_z;
        public int bit_x;
        public int bit_y;
        public int bit_z;
        public int shift;
        public int bit_mask;
        public int child_index;
        public OctreeCell cell;
    }

    public class LastCell {
        public OctreeCell cell;
        public final Point3d leavingPoint = new Point3d();
        public int leavingPart;
    }

    public class BoxIntersectionLocals {
    }

    public class BoxIntersectionOutput {
        public boolean hasIntersection;
        public double enteringT;
        public final Point3d enteringPoint = new Point3d();
        public int enteringPart;
        public double leavingT;
        public final Point3d leavingPoint = new Point3d();
        public int leavingPart;
        public boolean errorOccurred = false;
    }

    public class BoxIntersectionInput {
        public final Point3d origin = new Point3d();
        public final Vector3d direction = new Vector3d();
        public final Vector3f minValues = new Vector3f();
        public final Vector3f maxValues = new Vector3f();
    }
}

