/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.physics;

import de.grogra.ray.physics.Spectrum;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;

public class Spectrum3d
extends Tuple3d
implements Spectrum {
    public Spectrum3d() {
    }

    public Spectrum3d(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    public void clampMinZero() {
        this.clampMin(0.0);
    }

    public double evaluateDouble(double d) {
        return 0.0;
    }

    public void setZero() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public void setIdentity() {
        this.z = 1.0;
        this.y = 1.0;
        this.x = 1.0;
    }

    public Spectrum3d clone() {
        return new Spectrum3d(this.x, this.y, this.z);
    }

    public Spectrum3d newInstance() {
        return new Spectrum3d();
    }

    public void add(Spectrum spectrum) {
        if (spectrum instanceof Tuple3f) {
            Tuple3f tuple3f = (Tuple3f)spectrum;
            this.x += (double)tuple3f.x;
            this.y += (double)tuple3f.y;
            this.z += (double)tuple3f.z;
        } else {
            this.add((Tuple3d)spectrum);
        }
    }

    public void sub(Spectrum spectrum) {
        if (spectrum instanceof Tuple3f) {
            Tuple3f tuple3f = (Tuple3f)spectrum;
            this.x -= (double)tuple3f.x;
            this.y -= (double)tuple3f.y;
            this.z -= (double)tuple3f.z;
        } else {
            this.sub((Tuple3d)spectrum);
        }
    }

    public void dot(Spectrum spectrum, Tuple3d tuple3d) {
        if (spectrum instanceof Tuple3d) {
            Tuple3d tuple3d2 = (Tuple3d)spectrum;
            tuple3d.x = this.x * tuple3d2.x;
            tuple3d.y = this.y * tuple3d2.y;
            tuple3d.z = this.z * tuple3d2.z;
        } else {
            Tuple3f tuple3f = (Tuple3f)spectrum;
            tuple3d.x = this.x * (double)tuple3f.x;
            tuple3d.y = this.y * (double)tuple3f.y;
            tuple3d.z = this.z * (double)tuple3f.z;
        }
    }

    public void mul(Spectrum spectrum) {
        if (spectrum instanceof Tuple3d) {
            this.mul((Tuple3d)spectrum);
        } else {
            this.mul((Tuple3f)spectrum);
        }
    }

    public void mul(Tuple3d tuple3d) {
        this.x *= tuple3d.x;
        this.y *= tuple3d.y;
        this.z *= tuple3d.z;
    }

    public void mul(Tuple3f tuple3f) {
        this.x *= (double)tuple3f.x;
        this.y *= (double)tuple3f.y;
        this.z *= (double)tuple3f.z;
    }

    public void div(Spectrum spectrum) {
        if (spectrum instanceof Tuple3d) {
            this.div((Tuple3d)spectrum);
        } else {
            this.div((Tuple3f)spectrum);
        }
    }

    public void div(Tuple3d tuple3d) {
        if (this.x != 0.0) {
            this.x /= tuple3d.x;
        }
        if (this.y != 0.0) {
            this.y /= tuple3d.y;
        }
        if (this.z != 0.0) {
            this.z /= tuple3d.z;
        }
    }

    public void div(Tuple3f tuple3f) {
        if (this.x != 0.0) {
            this.x /= (double)tuple3f.x;
        }
        if (this.y != 0.0) {
            this.y /= (double)tuple3f.y;
        }
        if (this.z != 0.0) {
            this.z /= (double)tuple3f.z;
        }
    }

    public void get(Tuple3f tuple3f) {
        tuple3f.set((Tuple3d)this);
    }

    public double integrate() {
        return this.x + this.y + this.z;
    }

    public void set(Spectrum spectrum) {
        spectrum.get(this);
    }

    public double sum() {
        return this.x + this.y + this.z;
    }

    public double getMax() {
        double d = this.x;
        d = Math.max(d, this.y);
        d = Math.max(d, this.z);
        return d;
    }
}

