/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.util;

import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.ray.util.Ray;

public final class RayList {
    public final Spectrum spectrumFactory;
    private int size = 0;
    public Ray[] rays = new Ray[0];

    public RayList() {
        this(10);
    }

    public RayList(int n) {
        this(new Spectrum3f());
        this.setSize(n);
    }

    public RayList(Spectrum spectrum) {
        this.spectrumFactory = spectrum;
    }

    public void setSize(int n) {
        if (n > this.rays.length) {
            int n2;
            this.rays = new Ray[n];
            System.arraycopy(this.rays, 0, this.rays, 0, n2);
            for (n2 = this.rays.length; n2 < n; ++n2) {
                this.rays[n2] = new Ray(this.spectrumFactory);
            }
        }
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public Ray lastRay() {
        return this.rays[this.size - 1];
    }

    public Ray nextRay() {
        this.ensureCapacity(this.size + 1);
        ++this.size;
        return this.rays[this.size - 1];
    }

    public void appendRay(Ray ray) {
        this.setSize(this.size + 1);
        this.rays[this.size - 1] = ray;
    }

    private void ensureCapacity(int n) {
        int n2 = this.rays.length;
        if (n > n2) {
            Ray[] rayArray = this.rays;
            int n3 = n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.rays = new Ray[n3];
            System.arraycopy(rayArray, 0, this.rays, 0, this.size);
            for (int i = this.size; i < n3; ++i) {
                this.rays[i] = new Ray(this.spectrumFactory);
            }
        }
    }
}

