/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.metropolis.strategy;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray2.metropolis.strategy.MutationStrategy;
import de.grogra.ray2.radiosity.Vector3d;
import de.grogra.ray2.tracing.MetropolisProcessor;
import de.grogra.ray2.tracing.modular.CombinedPathValues;
import de.grogra.ray2.tracing.modular.ConditionObject;
import de.grogra.ray2.tracing.modular.LineTracer;
import de.grogra.ray2.tracing.modular.PathValues;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.Line;
import java.util.ArrayList;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CausticPerturbation
extends MutationStrategy {
    static final int NO_DIFFUSE_FOUND = 101;
    static int countOfLensEdgeMutations;
    static int countOfFirstLightRayMutations;
    static int countOfMiddlePathMutations;
    static int countOfLensEdgeMutationsError;
    static int countOfFirstLightRayMutationsError;
    static int countOfMiddlePathMutationsError;
    static int count_NoError;
    static int count_notImplemented;
    static int count_notVisible;
    static int count_ZeroBSDF;
    static int count_noChanges;
    static int count_notValidPath;
    static int count_weakSpec;
    static int count_notCanvasHit;
    static int count_CalculationError;
    static int count_totalError;
    static int count_tracing;
    static int count_no_diffuse;
    static int count_CausticEvent;
    static int count_CausticEventError;
    static int count_CausticEventErrorAtNotVisible;
    static int count_CausticEventErrorAtNoDiffu;
    public int kd;
    public int ka;
    public int l;
    public int m;
    public int l_;
    public int m_;
    public int real_m_;
    public int real_l_;
    public float acceptance;
    float phi1;
    float phi2;
    float r1;
    float r2;
    Vector3d perturbedRay = null;

    public CausticPerturbation(MetropolisProcessor metropolisProcessor) {
        super(metropolisProcessor);
        this.eyePath = new PathValues();
        this.eyePath.initialize(this.eyePathDepth + this.lightPathDepth);
        this.lightPath = new PathValues();
        this.lightPath.initialize(this.eyePathDepth + this.lightPathDepth);
    }

    @Override
    public void initialize(double[] dArray) {
    }

    @Override
    public void resetAll() {
        countOfLensEdgeMutations = 0;
        countOfFirstLightRayMutations = 0;
        countOfMiddlePathMutations = 0;
        count_NoError = 0;
        countOfLensEdgeMutationsError = 0;
        countOfFirstLightRayMutationsError = 0;
        countOfMiddlePathMutationsError = 0;
        count_notImplemented = 0;
        count_notVisible = 0;
        count_ZeroBSDF = 0;
        count_noChanges = 0;
        count_notValidPath = 0;
        count_weakSpec = 0;
        count_notCanvasHit = 0;
        count_CalculationError = 0;
        count_totalError = 0;
        count_tracing = 0;
        count_no_diffuse = 0;
        count_CausticEvent = 0;
        count_CausticEventError = 0;
    }

    @Override
    public float mutatePath(CombinedPathValues combinedPathValues, CombinedPathValues combinedPathValues2) {
        super.mutatePath(combinedPathValues, combinedPathValues2);
        this.real_l_ = -1;
        this.real_m_ = -1;
        this.m_ = -1;
        this.l_ = -1;
        this.m = -1;
        this.l = -1;
        this.ka = -1;
        this.kd = -1;
        int n = this.searchForDoubleDiffuse();
        if (n < 0) {
            return this.registerError(101);
        }
        this.l = n;
        this.m = this.srcPath.pathLength - 1;
        this.l_ = this.m - this.l - 1;
        this.m_ = 0;
        if (this.l_ == 1) {
            return this.registerError(101);
        }
        if (this.l < this.m - 2) {
            ++count_CausticEvent;
        }
        this.srcPath.splitInto2Paths(this.l, this.lightPath, this.eyePath);
        this.eyePath.pathResultList = this.srcPath.pathResultList;
        this.eyePath.creatorID = this.srcPath.sensorID;
        this.lightPath.creatorID = this.srcPath.lightID;
        this.eyePath.pathLength = 1;
        this.eyePath.pathResultList = 1.0E-5f;
        this.tracer.condition = this.condition = new CausticPerturbationCondition(this.lightPath, this.tracer, this.srcPath);
        int n2 = this.lightPath.pathLength;
        this.perturbedRay = this.perturbRay();
        this.traceLightSubPath(this.l, this.l_);
        this.real_m_ = 0;
        this.real_l_ = this.lightPath.pathLength - n2;
        if (this.l_ != this.real_l_) {
            return this.registerError(7);
        }
        boolean bl = false;
        for (int i = this.l; i < this.srcPath.pathLength - 1; ++i) {
            if (this.srcPath.isSpecular(i) == this.lightPath.isSpecular(i)) continue;
            return this.registerError(7);
        }
        Environment environment = this.lightPath.envList.get(this.lightPath.pathLength - 1);
        Environment environment2 = this.eyePath.envList.get(this.eyePath.pathLength - 1);
        Intersection intersection = this.lightPath.intersecList.get(this.lightPath.pathLength - 1);
        if (this.eyePath.pathLength == 1 ? !this.isVisble(environment2, environment, null) : !this.isVisble(environment, environment2, intersection)) {
            return this.registerError(1);
        }
        this.complTracer.complement2Paths(this.lightPath, this.lightPath.pathLength - 1, this.eyePath, this.eyePath.pathLength - 1, false, this.mutatedPath);
        this.mutatedPath.pathResultList = this.eyePath.pathResultList;
        if (!this.hitsCanvas(combinedPathValues2)) {
            this.abbortCode = 6;
            return -1.0f;
        }
        if (!combinedPathValues2.isValid()) {
            return this.registerError(2);
        }
        this.acceptance = this.calculateAcceptanceProbality(this.l, this.m, this.real_l_, this.real_m_);
        if (this.abbortCode == 0) {
            ++count_NoError;
            if (this.m == combinedPathValues.pathLength - 1) {
                ++countOfLensEdgeMutations;
            }
            if (this.l == 0) {
                ++countOfFirstLightRayMutations;
            }
            if (this.m != combinedPathValues.pathLength - 1 && this.l != 0) {
                ++countOfMiddlePathMutations;
            }
        }
        return this.acceptance;
    }

    private Vector3d perturbRay() {
        int n = ((MetropolisProcessor)this.tracingMediator.getProcessor()).imageWidth;
        int n2 = ((MetropolisProcessor)this.tracingMediator.getProcessor()).imageHeight;
        float f = 2.0f / (float)n;
        this.r1 = 0.1f * f;
        this.r2 = (float)Math.sqrt((double)(0.05f * (float)n * (float)n2) / Math.PI);
        float f2 = ((Environment)this.srcPath.envList.get((int)(this.srcPath.pathLength - 1))).point.distance(((Environment)this.srcPath.envList.get((int)(this.srcPath.pathLength - 2))).point);
        this.phi1 = (float)Math.atan(this.r1 / f2);
        this.phi2 = (float)Math.atan(this.r2 / f2);
        float f3 = 0.0f;
        for (int i = this.l + 1; i < this.srcPath.pathLength - 1; ++i) {
            f3 += ((Environment)this.srcPath.envList.get((int)i)).point.distance(((Environment)this.srcPath.envList.get((int)(i - 1))).point);
        }
        this.phi1 = this.phi1 * f2 / f3;
        this.phi2 = this.phi2 * f2 / f3;
        float f4 = this.rnd.nextFloat();
        float f5 = this.phi2 * (float)Math.exp(-Math.log(this.phi2 / this.phi1) * (double)f4);
        float f6 = this.rnd.nextFloat() * (float)Math.PI * 2.0f;
        Vector3d vector3d = new Vector3d((Tuple3d)((Line)this.srcPath.rayListBE.get((int)this.l)).direction);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.m00 = Math.cos(f5);
        matrix3d.m10 = -Math.sin(f5);
        matrix3d.m20 = 0.0;
        matrix3d.m01 = Math.sin(f5);
        matrix3d.m11 = Math.cos(f5);
        matrix3d.m21 = 0.0;
        matrix3d.m02 = 0.0;
        matrix3d.m12 = 0.0;
        matrix3d.m22 = 1.0;
        Vector3d vector3d2 = new Vector3d();
        matrix3d.transform((Tuple3d)vector3d, (Tuple3d)vector3d2);
        vector3d.normalize();
        double d = vector3d.x;
        double d2 = vector3d.y;
        double d3 = vector3d.z;
        Matrix3d matrix3d2 = new Matrix3d();
        matrix3d2.m00 = Math.cos(f6) + d * d * (1.0 - Math.cos(f6));
        matrix3d2.m10 = d * d2 * (1.0 - Math.cos(f6)) - d3 * Math.sin(f6);
        matrix3d2.m20 = d * d3 * (1.0 - Math.cos(f6)) + d2 * Math.sin(f6);
        matrix3d2.m01 = d * d2 * (1.0 - Math.cos(f6)) + d3 * Math.sin(f6);
        matrix3d2.m11 = Math.cos(f6) + d2 * d2 * (1.0 - Math.cos(f6));
        matrix3d2.m21 = d3 * d2 * (1.0 - Math.cos(f6)) - d * Math.sin(f6);
        matrix3d2.m02 = d * d3 * (1.0 - Math.cos(f6)) - d2 * Math.sin(f6);
        matrix3d2.m12 = d3 * d2 * (1.0 - Math.cos(f6)) + d * Math.sin(f6);
        matrix3d2.m22 = Math.cos(f6) + d3 * d3 * (1.0 - Math.cos(f6));
        matrix3d2.transform((Tuple3d)vector3d2);
        if (Double.isNaN(vector3d2.x)) {
            System.err.println("  Caustic Perturbation:  perturbRay:   r1=" + this.r1 + "  r2=" + this.r2 + "  le=" + f2 + " sum=" + f3);
            System.err.println("  Caustic Perturbation:  perturbRay:   phi1=" + this.phi1 + "  phi2=" + this.phi2 + "  resPhi=" + f5 + " angle=" + f6);
            System.err.println("  Caustic Perturbation:  perturbRay:   oldDirection= \n" + ((Line)this.srcPath.rayListBE.get((int)this.l)).direction);
            System.err.println(" \t newDirection= \n" + (Object)((Object)vector3d2));
        }
        return vector3d2;
    }

    @Override
    public void traceLightSubPath(int n, int n2) {
        if (n <= 0) {
            Line line = this.generateNewStartLine(true);
            line.direction.set((Tuple3d)this.perturbedRay);
            Spectrum3d spectrum3d = new Spectrum3d();
            spectrum3d.set((Tuple3f)line.spectrum);
            this.tracer.traceLine(n2 + 1, this.lightPath, line, spectrum3d, this.lightPath.creatorID, true, this.rnd);
        } else if (n2 > 0) {
            this.tracer.traceSubPath(this.lightPath, n, n2, true, this.perturbedRay);
        }
        this.tracer.condition = null;
    }

    @Override
    public int registerError(int n) {
        switch (n) {
            case -1: {
                ++count_notImplemented;
                break;
            }
            case 1: {
                ++count_notVisible;
                break;
            }
            case 0: {
                ++count_NoError;
                break;
            }
            case 3: {
                ++count_ZeroBSDF;
                break;
            }
            case 4: {
                ++count_noChanges;
                break;
            }
            case 2: {
                ++count_notValidPath;
                break;
            }
            case 5: {
                ++count_weakSpec;
                break;
            }
            case 6: {
                ++count_notCanvasHit;
                break;
            }
            case 7: {
                ++count_tracing;
                break;
            }
            case 101: {
                ++count_no_diffuse;
                break;
            }
            default: {
                ++count_CalculationError;
            }
        }
        if (n != 0) {
            ++count_totalError;
            if (this.l < this.m - 2) {
                ++count_CausticEventError;
            }
            if (this.m >= this.srcPath.pathLength - 1) {
                ++countOfLensEdgeMutationsError;
            }
            if (this.l <= 0) {
                ++countOfFirstLightRayMutationsError;
            }
            if (this.m < this.srcPath.pathLength - 1 && this.l > 0) {
                ++countOfMiddlePathMutationsError;
            }
        }
        return super.registerError(n);
    }

    @Override
    public ArrayList<String> getStatistics() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("total Count of successfull strategy runs: " + count_NoError + "\n");
        arrayList.add(" * successfull lens edge mutation runs:" + countOfLensEdgeMutations + "(" + (float)countOfLensEdgeMutations / (float)count_NoError + ")\n");
        arrayList.add(" * successfull first light ray mutation runs:" + countOfFirstLightRayMutations + "(" + (float)countOfFirstLightRayMutations / (float)count_NoError + ")\n");
        arrayList.add(" * successfull path centered mutation runs:" + countOfMiddlePathMutations + "(" + (float)countOfMiddlePathMutations / (float)count_NoError + ")\n");
        arrayList.add(" * successfull caustic event mutation runs:" + (count_CausticEvent - count_CausticEventError) + "(" + (float)(count_CausticEvent - count_CausticEventError) / (float)count_CausticEvent + ")\n\n");
        arrayList.add("total count of failure: " + count_totalError + "\n");
        arrayList.add(" * error on lens edge mutation:" + countOfLensEdgeMutationsError + "(" + (float)countOfLensEdgeMutationsError / (float)count_totalError + ")\n");
        arrayList.add(" * error on first light ray mutation:" + countOfFirstLightRayMutationsError + "(" + (float)countOfFirstLightRayMutationsError / (float)count_totalError + ")\n");
        arrayList.add(" * error on path centered mutation:" + countOfMiddlePathMutationsError + "(" + (float)countOfMiddlePathMutationsError / (float)count_totalError + ")\n\n");
        arrayList.add(" * count_no_diffuse: " + count_no_diffuse + " (" + (float)count_no_diffuse / (float)count_totalError + ")\n");
        arrayList.add(" * count_notImplemented: " + count_notImplemented + " (" + (float)count_notImplemented / (float)count_totalError + ")\n");
        arrayList.add(" * count_notVisible: " + count_notVisible + " (" + (float)count_notVisible / (float)count_totalError + ")\n");
        arrayList.add(" * count_ZeroBSDF: " + count_ZeroBSDF + " (" + (float)count_ZeroBSDF / (float)count_totalError + ")\n");
        arrayList.add(" * count_noChanges: " + count_noChanges + " (" + (float)count_noChanges / (float)count_totalError + ")\n");
        arrayList.add(" * count_notValidPath: " + count_notValidPath + " (" + (float)count_notValidPath / (float)count_totalError + ")\n");
        arrayList.add(" * count_weakSpec: " + count_weakSpec + " (" + (float)count_weakSpec / (float)count_totalError + "\n");
        arrayList.add(" * count_notCanvasHit: " + count_notCanvasHit + " (" + (float)count_notCanvasHit / (float)count_totalError + ")\n");
        arrayList.add(" * count_CalculationError: " + count_CalculationError + " (" + (float)count_CalculationError / (float)count_totalError + ")\n");
        arrayList.add(" * count_tracingError: " + count_tracing + " (" + (float)count_tracing / (float)count_totalError + ")\n");
        arrayList.add(" * count_CausticEventError: " + count_CausticEventError + " (" + (float)count_CausticEventError / (float)count_CausticEvent + ")\n\n");
        return arrayList;
    }

    int searchForDoubleDiffuse() {
        if (this.srcPath.pathLength < 2) {
            return -1;
        }
        if (!this.srcPath.isSpecular(this.srcPath.pathLength - 2)) {
            for (int i = this.srcPath.pathLength - 3; i >= 0; --i) {
                if (this.srcPath.isSpecular(i)) continue;
                return i;
            }
        }
        return -1;
    }

    static {
        countOfLensEdgeMutationsError = 0;
        countOfFirstLightRayMutationsError = 0;
        countOfMiddlePathMutationsError = 0;
        count_notImplemented = 0;
        count_notVisible = 0;
        count_ZeroBSDF = 0;
        count_noChanges = 0;
        count_notValidPath = 0;
        count_weakSpec = 0;
        count_notCanvasHit = 0;
        count_CalculationError = 0;
        count_totalError = 0;
        count_tracing = 0;
        count_no_diffuse = 0;
        count_CausticEvent = 0;
        count_CausticEventError = 0;
        count_CausticEventErrorAtNotVisible = 0;
        count_CausticEventErrorAtNoDiffu = 0;
    }

    class CausticPerturbationCondition
    extends ConditionObject {
        CombinedPathValues srcPath;

        public CausticPerturbationCondition(PathValues pathValues, LineTracer lineTracer, CombinedPathValues combinedPathValues) {
            super(pathValues, lineTracer);
            this.srcPath = combinedPathValues;
        }

        public boolean stopOnCondition() {
            int n = this.path.pathLength - 1;
            if (n == 0) {
                return false;
            }
            return !this.path.isSpecular(n);
        }
    }
}

