/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.photonmap;

import de.grogra.vecmath.geom.Intersection;
import edu.wlu.cs.levy.CG.KDTree;
import edu.wlu.cs.levy.CG.KeyDuplicateException;
import edu.wlu.cs.levy.CG.KeySizeException;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PhotonMap {
    private static double epsilon = 0.005;
    private KDTree photonMap = new KDTree(3);
    private double photonArea;
    private int entryCount = 0;

    public PhotonMap(double d) {
        this.photonArea = d;
    }

    public void insertPhoton(Color3f color3f, Point3d point3d, Vector3f vector3f) {
        ++this.entryCount;
        double[] dArray = new double[]{point3d.x, point3d.y, point3d.z};
        Photon photon = new Photon(new Point3d((Tuple3f)color3f), new Vector3f(vector3f));
        try {
            this.photonMap.insert(dArray, (Object)photon);
        }
        catch (KeySizeException keySizeException) {
            keySizeException.printStackTrace();
        }
        catch (KeyDuplicateException keyDuplicateException) {
            try {
                Photon photon2 = (Photon)this.photonMap.search(dArray);
                this.photonMap.delete(dArray);
                photon2.col.add((Tuple3d)new Point3d((Tuple3f)color3f));
                this.photonMap.insert(dArray, (Object)photon2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void sumPhotons(Point3d point3d, Vector3f vector3f, Tuple3d tuple3d) {
        Photon photon = null;
        Point3d point3d2 = new Point3d();
        Object[] objectArray = this.getNearestPhotons(point3d);
        for (int i = 0; i < objectArray.length; ++i) {
            photon = (Photon)objectArray[i];
            float f = photon.dir.dot(vector3f);
            if (!(f > 0.0f)) continue;
            point3d2.set(point3d2.x + photon.col.x * (double)f, point3d2.y + photon.col.y * (double)f, point3d2.z + photon.col.z * (double)f);
        }
        point3d2.scale(1.0 / (this.photonArea * this.photonArea));
        tuple3d.add((Tuple3d)point3d2);
    }

    private Object[] getNearestPhotons(Point3d point3d) {
        Object[] objectArray;
        double d = this.photonArea;
        double[] dArray = new double[]{point3d.x - d, point3d.y - d, point3d.z - d};
        double[] dArray2 = new double[]{point3d.x + d, point3d.y + d, point3d.z + d};
        try {
            objectArray = this.photonMap.range(dArray, dArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return null;
        }
        catch (KeySizeException keySizeException) {
            keySizeException.printStackTrace();
            return null;
        }
        return objectArray;
    }

    public float traceRay(Intersection intersection, Tuple3d tuple3d) {
        Point3d point3d = intersection.getPoint();
        try {
            Object[] objectArray = this.photonMap.range(new double[]{point3d.x - epsilon, point3d.y - epsilon, point3d.z - epsilon}, new double[]{point3d.x + epsilon, point3d.y + epsilon, point3d.z + epsilon});
            if (objectArray != null && objectArray.length > 0) {
                tuple3d.set(0.0, 0.0, 0.0);
                for (Object object : objectArray) {
                    tuple3d.add((Tuple3d)((Photon)object).col);
                }
                tuple3d.scale(2000.0);
            } else {
                tuple3d.set(0.0, 0.0, 0.0);
            }
        }
        catch (KeySizeException keySizeException) {
            keySizeException.printStackTrace();
        }
        return 0.0f;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    private class Photon {
        public Point3d col;
        public Vector3f dir;

        public Photon(Point3d point3d, Vector3f vector3f) {
            this.col = point3d;
            this.dir = vector3f;
        }
    }
}

