/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Sensor;
import de.grogra.ray2.Options;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.ray2.Renderer;
import de.grogra.ray2.Resources;
import de.grogra.ray2.Scene;
import de.grogra.ray2.antialiasing.Antialiasing;
import de.grogra.ray2.antialiasing.NoAntialiasing;
import de.grogra.task.PartialTask;
import de.grogra.task.Solver;
import de.grogra.task.SolverInOwnThread;
import de.grogra.task.Task;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix4d;
import net.goui.util.MTRandom;

public class PixelwiseRenderer
extends Task
implements Renderer {
    public static final String ANTIALIASING = "antialiasing";
    public static final String RAYPROCESSOR = "rayprocessor";
    public static final String BRIGHTNESS = "brightness";
    public static final String THREAD_COUNT = "threadcount";
    public static final String AUTO_ADJUST = "autoadjust";
    public static final String AUTO_ADJUST_MAX_VALUE = "autoadjustmaxvalue";
    public static final String REMOVE_OUTLIERS = "removeoutliers";
    public static final String HDR = "hdr";
    public static final String SEED = "seed";
    private Options opts;
    protected ProgressMonitor monitor;
    protected Sensor camera;
    protected Matrix4d cameraTransformation;
    public int threadCount;
    protected int width;
    protected int height;
    protected BufferedImage image;
    protected int[] rgbaPixels;
    protected float[][] hdrPixels;
    protected ImageObserver observer;
    protected Scene originalScene;
    protected Antialiasing antialiasing;
    protected int imageUpdateDistance = 50;
    protected int imageUpdateRate = 3000;
    protected float brightness;
    protected boolean hdr;
    protected boolean autoAdjust;
    protected boolean removeOutliers;
    protected float autoAdjustMaxValue;
    protected float maxValue;
    protected long seed;
    Color4f maxColor = null;
    Color4f minColor = null;
    static int changedPixels;
    private static final int AVG_SIZE = 5;
    private static final int MAX_SIZE = 1;
    static final int RENDERING = 1;
    static final int RENDERED = 2;
    protected int renderedLines;
    protected int[] lineState;
    public static int DEBUG_X;
    public static int DEBUG_Y;
    public static float DEBUG_LINE;
    public static boolean DEBUG_PIXEL;
    public static boolean DEBUG_SUBPIXEL;

    public Number getNumericOption(String string, Number number) {
        return this.opts != null ? (Number)((Number)this.opts.get(string, number)) : (Number)number;
    }

    public boolean getBooleanOption(String string, boolean bl) {
        return this.opts != null ? (Boolean)this.opts.get(string, bl) : bl;
    }

    public Object getClassOption(String string, Object object) {
        Object object2;
        if (this.opts != null && (object2 = this.opts.get(string, null)) instanceof Class) {
            try {
                return ((Class)object2).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return object;
    }

    public void initialize(Options options, ProgressMonitor progressMonitor) {
        this.opts = options;
        this.monitor = progressMonitor;
        if (progressMonitor != null) {
            progressMonitor.setProgress(Resources.msg("initializing"), -1.0f);
        }
        this.antialiasing = (Antialiasing)this.getClassOption(ANTIALIASING, new NoAntialiasing());
        this.brightness = this.getNumericOption(BRIGHTNESS, Float.valueOf(0.1f)).floatValue();
        this.threadCount = this.getNumericOption(THREAD_COUNT, 0).intValue();
        this.autoAdjust = this.getBooleanOption(AUTO_ADJUST, Boolean.TRUE);
        this.autoAdjustMaxValue = this.getNumericOption(AUTO_ADJUST_MAX_VALUE, 1).floatValue();
        this.removeOutliers = this.getBooleanOption(REMOVE_OUTLIERS, Boolean.TRUE);
        this.hdr = this.getBooleanOption(HDR, Boolean.TRUE);
        this.seed = this.getNumericOption(SEED, 0).longValue();
        this.maxValue = 0.0f;
        if (this.threadCount <= 0) {
            this.threadCount = Runtime.getRuntime().availableProcessors();
        }
    }

    public Sensor getCamera() {
        return this.camera;
    }

    public Matrix4d getCameraTransformation() {
        return this.cameraTransformation;
    }

    public void setAntialiasing(Antialiasing antialiasing) {
        this.antialiasing = antialiasing;
    }

    public void setHDR(boolean bl) {
        this.hdr = bl;
    }

    public void setAutoAdjust(boolean bl) {
        this.autoAdjust = bl;
    }

    public boolean getAutoAdjust() {
        return this.autoAdjust;
    }

    public void setAutoAdjustMaxValue(float f) {
        this.autoAdjustMaxValue = f;
    }

    public void setBrightness(float f) {
        this.brightness = f;
    }

    public void setThreadCount(int n) {
        this.threadCount = n;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public long getSeed() {
        return this.seed;
    }

    public void render(Scene scene, Sensor sensor, Matrix4d matrix4d, int n, int n2, ImageObserver imageObserver) {
        Object object;
        long l = System.currentTimeMillis();
        this.originalScene = scene;
        this.camera = sensor;
        this.cameraTransformation = matrix4d;
        this.antialiasing.initialize(this, scene);
        this.width = n;
        this.height = n2;
        changedPixels = 0;
        this.maxColor = new Color4f();
        this.minColor = new Color4f(10.0f, 10.0f, 10.0f, 10.0f);
        this.lineState = new int[n2];
        if (this.hdr) {
            this.hdrPixels = new float[4][n * n2];
            DataBufferFloat dataBufferFloat = new DataBufferFloat(this.hdrPixels, this.hdrPixels[0].length);
            BandedSampleModel bandedSampleModel = new BandedSampleModel(dataBufferFloat.getDataType(), n, n2, 4);
            object = Raster.createWritableRaster(bandedSampleModel, dataBufferFloat, null);
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, true, false, 3, dataBufferFloat.getDataType());
            this.image = new BufferedImage(componentColorModel, (WritableRaster)object, false, null);
        } else {
            this.image = new BufferedImage(n, n2, 2);
            this.rgbaPixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        }
        this.observer = imageObserver;
        if (this.threadCount < 2) {
            this.addSolver(this.createLocalSolver(true));
        } else {
            for (int i = Math.min(32, this.threadCount); i > 0; --i) {
                this.addSolver(this.createLocalSolver(false));
            }
        }
        if (this.monitor != null) {
            this.monitor.setProgress(Resources.msg("renderer.rendering", new Float(0.0f)), 0.0f);
        }
        this.solve();
        this.removeSolvers();
        if (this.isStopped()) {
            this.observer.imageUpdate(this.image, 192, 0, 0, n, n2);
            if (this.monitor != null) {
                this.monitor.setProgress(Resources.msg("renderer.stopped"), 2.0f);
            }
        } else {
            if (this.hdr) {
                if (this.removeOutliers) {
                    this.removeOutliers();
                }
                if (this.autoAdjust && this.maxValue > 0.0f) {
                    float f = this.autoAdjustMaxValue / this.maxValue;
                    for (int i = 0; i < 3; ++i) {
                        object = this.hdrPixels[i];
                        int n3 = ((Object)object).length - 1;
                        while (n3 >= 0) {
                            Object object2 = object;
                            int n4 = n3--;
                            object2[n4] = object2[n4] * f;
                        }
                    }
                }
            }
            long l2 = System.currentTimeMillis() - l;
            this.observer.imageUpdate(this.image, 32, 0, 0, n, n2);
            if (this.monitor != null) {
                this.monitor.setProgress(Resources.msg("renderer.done"), 2.0f);
                object = new StringBuffer("<html><pre>");
                ((StringBuffer)object).append(Resources.msg("raytracer.statistics", n, n2, this.threadCount, (int)(l2 / 60000L), Float.valueOf((float)(l2 % 60000L) * 0.001f)));
                ((StringBuffer)object).append("    Count of changed Pixels: " + changedPixels + "\n");
                ((StringBuffer)object).append("    maxColor " + this.maxColor + "\n");
                ((StringBuffer)object).append("    minColor " + this.minColor + "\n");
                this.originalScene.appendStatistics((StringBuffer)object);
                this.antialiasing.appendStatistics((StringBuffer)object);
                this.monitor.showMessage(((StringBuffer)object).append("</pre></html>").toString());
            }
        }
    }

    protected void removeOutliers() {
        int n;
        int n2;
        if (this.width <= 5 || this.height <= 5) {
            return;
        }
        IntList intList = new IntList();
        FloatList floatList = new FloatList();
        for (n2 = 0; n2 < this.height; ++n2) {
            int n3;
            int n4;
            int n5;
            n = Math.max(n2 - 5, 0);
            int n6 = Math.min(n2 + 5, this.height - 1);
            int n7 = 0;
            double[] dArray = new double[3];
            double[] dArray2 = new double[3];
            for (n5 = 0; n5 < 5; ++n5) {
                for (n4 = n; n4 <= n6; ++n4) {
                    ++n7;
                    n3 = n4 * this.width + n5;
                    for (int i = 0; i < 3; ++i) {
                        int n8 = i;
                        dArray[n8] = dArray[n8] + (double)this.hdrPixels[i][n3];
                    }
                }
            }
            block4: for (n5 = 0; n5 < this.width; ++n5) {
                int n9;
                int n10;
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 0.0;
                n4 = n5 + 5;
                if (n4 < this.width) {
                    for (n3 = n; n3 <= n6; ++n3) {
                        ++n7;
                        int n11 = n3 * this.width + n4;
                        for (n10 = 0; n10 < 3; ++n10) {
                            int n12 = n10;
                            dArray2[n12] = dArray2[n12] + (double)this.hdrPixels[n10][n11];
                        }
                    }
                }
                if ((n4 = n5 - 5 - 1) >= 0) {
                    for (n3 = n; n3 <= n6; ++n3) {
                        --n7;
                        int n13 = n3 * this.width + n4;
                        for (n10 = 0; n10 < 3; ++n10) {
                            int n14 = n10;
                            dArray2[n14] = dArray2[n14] - (double)this.hdrPixels[n10][n13];
                        }
                    }
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    int n15 = n3;
                    dArray[n15] = dArray[n15] + dArray2[n3];
                }
                n3 = n2 * this.width + n5;
                float f = this.hdrPixels[0][n3] + this.hdrPixels[1][n3] + this.hdrPixels[2][n3];
                if (!((double)((float)(n7 - 1) * f) > 3.0 * (dArray[0] + dArray[1] + dArray[2] - (double)f))) continue;
                for (n10 = Math.max(n2 - 1, 0); n10 <= Math.min(n2 + 1, this.height - 1); ++n10) {
                    for (n4 = Math.max(n5 - 1, 0); n4 <= Math.min(n5 + 1, this.width - 1); ++n4) {
                        n9 = n10 * this.width + n4;
                        if (n9 != n3 && f < 3.0f * (this.hdrPixels[0][n9] + this.hdrPixels[1][n9] + this.hdrPixels[2][n9])) continue block4;
                    }
                }
                intList.add(n3);
                float f2 = 1.0f / (float)(n7 - 1);
                for (n9 = 0; n9 < 3; ++n9) {
                    floatList.add(f2 * ((float)dArray[n9] - this.hdrPixels[n9][n3]));
                }
            }
        }
        if (intList.isEmpty()) {
            return;
        }
        while (!intList.isEmpty()) {
            n2 = intList.pop();
            for (n = 2; n >= 0; --n) {
                this.hdrPixels[n][n2] = floatList.pop();
            }
        }
        if (!this.autoAdjust) {
            return;
        }
        this.maxValue = 0.0f;
        for (n2 = 0; n2 < this.width * this.height; ++n2) {
            float f = this.hdrPixels[3][n2];
            if (f * this.hdrPixels[0][n2] > this.maxValue) {
                this.maxValue = f * this.hdrPixels[0][n2];
            }
            if (f * this.hdrPixels[1][n2] > this.maxValue) {
                this.maxValue = f * this.hdrPixels[1][n2];
            }
            if (!(f * this.hdrPixels[2][n2] > this.maxValue)) continue;
            this.maxValue = f * this.hdrPixels[2][n2];
        }
    }

    public float getAdjustFactor() {
        return this.autoAdjustMaxValue / this.maxValue;
    }

    public Solver createLocalSolver(final boolean bl) {
        final Antialiasing antialiasing = this.antialiasing.dup(this.originalScene.dup());
        return new SolverInOwnThread(){
            private final Result result = new Result();

            protected void solveImpl(PartialTask partialTask) {
                PixelwiseRenderer.this.renderLines(antialiasing, ((RenderTask)partialTask).lines, this.result);
            }

            protected Thread createThread() {
                if (bl) {
                    return null;
                }
                Thread thread = new Thread((Runnable)this, this.toString());
                thread.setPriority(1);
                return thread;
            }
        };
    }

    public synchronized void merge(Result result) {
        int n = -1;
        int n2 = -1;
        float[] fArray = result.data.elements;
        float f = this.maxValue;
        for (int i = 0; i <= result.lines.size; ++i) {
            int n3;
            int n4;
            if (i < result.lines.size) {
                n4 = result.lines.elements[i];
                if (this.lineState[n4] != 2) {
                    ++this.renderedLines;
                    this.lineState[n4] = 2;
                    n3 = i * this.width * 4;
                    int n5 = n4 * this.width;
                    for (int j = 0; j < this.width; ++j) {
                        if (this.autoAdjust) {
                            float f2 = fArray[n3 + 3];
                            if (f2 * fArray[n3] > f) {
                                f = f2 * fArray[n3];
                            }
                            if (f2 * fArray[n3 + 1] > f) {
                                f = f2 * fArray[n3 + 1];
                            }
                            if (f2 * fArray[n3 + 2] > f) {
                                f = f2 * fArray[n3 + 2];
                            }
                        }
                        if (this.hdr) {
                            this.hdrPixels[0][n5] = fArray[n3];
                            this.hdrPixels[1][n5] = fArray[n3 + 1];
                            this.hdrPixels[2][n5] = fArray[n3 + 2];
                            this.hdrPixels[3][n5] = fArray[n3 + 3];
                            if (this.luminance(this.hdrPixels[0][n5], this.hdrPixels[1][n5], this.hdrPixels[2][n5]) > this.luminance(this.maxColor.x, this.maxColor.y, this.maxColor.z)) {
                                this.maxColor.x = this.hdrPixels[0][n5];
                                this.maxColor.y = this.hdrPixels[1][n5];
                                this.maxColor.z = this.hdrPixels[2][n5];
                                this.maxColor.w = this.hdrPixels[3][n5];
                            }
                            if (this.luminance(this.hdrPixels[0][n5], this.hdrPixels[1][n5], this.hdrPixels[2][n5]) < this.luminance(this.minColor.x, this.minColor.y, this.minColor.z)) {
                                this.minColor.x = this.hdrPixels[0][n5];
                                this.minColor.y = this.hdrPixels[1][n5];
                                this.minColor.z = this.hdrPixels[2][n5];
                                this.minColor.w = this.hdrPixels[3][n5];
                            }
                        } else {
                            this.rgbaPixels[n5] = PixelwiseRenderer.toIntColor(fArray[n3], fArray[n3 + 1], fArray[n3 + 2], fArray[n3 + 3]);
                        }
                        n3 += 4;
                        ++n5;
                        ++changedPixels;
                    }
                }
            } else {
                n4 = -1;
            }
            if (n < 0) {
                n = n4;
            } else if (n2 != n4) {
                if (n2 < this.height && this.lineState[n2] != 2) {
                    for (n3 = 0; n3 < this.width; ++n3) {
                        this.image.setRGB(n3, n2, -1);
                    }
                    ++n2;
                }
                this.observer.imageUpdate(this.image, 8, 0, n, this.width, n2 - n);
                n = n4;
            }
            n2 = n4 + 1;
        }
        this.maxValue = f;
        if (this.monitor != null) {
            float f3 = (float)this.renderedLines / (float)this.height;
            this.monitor.setProgress(Resources.msg("renderer.rendering", new Float(f3)), f3);
        }
    }

    protected synchronized boolean done() {
        return this.renderedLines == this.height;
    }

    protected PartialTask nextPartialTask(int n) {
        int n2;
        int n3;
        int n4 = this.getSolverCount();
        RenderTask renderTask = new RenderTask();
        int n5 = n3 = this.height * n / n4;
        int n6 = n2 = n4 == 1 ? this.height : Math.max(Math.min((this.height - this.renderedLines) / (2 * n4), this.height / (8 * n4)), 1);
        do {
            if (this.lineState[n5] != 0) continue;
            renderTask.lines.push(n5);
            this.lineState[n5] = 1;
            if (--n2 == 0) break;
        } while ((n5 = (n5 + 1) % this.height) != n3);
        return renderTask.lines.size == 0 ? null : renderTask;
    }

    protected void dispose(PartialTask partialTask) {
        IntList intList = ((RenderTask)partialTask).lines;
        for (int i = 0; i < intList.size; ++i) {
            int n = intList.elements[i];
            this.lineState[n] = this.lineState[n] & 0xFFFFFFFE;
        }
    }

    protected void renderLines(Antialiasing antialiasing, IntList intList, Result result) {
        double d = 2.0 / (double)this.width;
        Color4f color4f = new Color4f();
        int n = Math.min(this.imageUpdateDistance, intList.size - 1);
        long l = System.currentTimeMillis() + (long)this.imageUpdateRate;
        result.lines.setSize(0);
        result.data.setSize(0);
        MTRandom mTRandom = new MTRandom();
        for (int i = 0; i < intList.size; ++i) {
            int n2 = intList.elements[i];
            mTRandom.setSeed(this.seed + 25214903917L * (long)n2);
            for (int j = 0; j < this.width; ++j) {
                if (this.isStopped()) {
                    return;
                }
                ((NoAntialiasing)antialiasing).setPixelXY(j, n2);
                antialiasing.getColorOfRectangle((double)j * d - 1.0, (0.5 * (double)this.height - (double)(n2 + 1)) * d, d, d, color4f, mTRandom);
                float f = this.brightness / Math.max(color4f.w, 0.001f);
                result.data.push(color4f.x * f).push(color4f.y * f).push(color4f.z * f).push(color4f.w);
            }
            result.lines.push(n2);
            if (i != n && System.currentTimeMillis() < l) continue;
            this.merge(result);
            result.lines.setSize(0);
            result.data.setSize(0);
            n = Math.min(i + this.imageUpdateDistance, intList.size - 1);
            l = System.currentTimeMillis() + (long)this.imageUpdateRate;
        }
    }

    private static int toByte(float f) {
        int n = (int)(f * 256.0f);
        return n < 0 ? 0 : (n > 255 ? 255 : n);
    }

    protected static int toIntColor(float f, float f2, float f3, float f4) {
        return (PixelwiseRenderer.toByte(f4) << 24) + (PixelwiseRenderer.toByte(f) << 16) + (PixelwiseRenderer.toByte(f2) << 8) + PixelwiseRenderer.toByte(f3);
    }

    protected static float[] toRGBA(int n) {
        float f = (float)(n >> 24 & 0xFF) / 256.0f;
        float f2 = (float)(n >> 16 & 0xFF) / 256.0f;
        float f3 = (float)(n >> 8 & 0xFF) / 256.0f;
        float f4 = (float)(n & 0xFF) / 255.0f;
        float[] fArray = new float[]{f2, f3, f4, f};
        return fArray;
    }

    public void setMessage(String string, float f) {
        if (this.monitor != null) {
            this.monitor.setProgress(string, f);
        }
    }

    public Scene getScene() {
        return this.originalScene;
    }

    public float luminance(double d, double d2, double d3) {
        return (float)((double)0.299f * d + (double)0.587f * d2 + (double)0.114f * d3);
    }

    static {
        DEBUG_X = -1;
        DEBUG_Y = -1;
        DEBUG_LINE = -1.0f;
    }

    public static class RenderTask
    implements PartialTask {
        public IntList lines = new IntList(500);
    }

    public static class Result {
        public IntList lines = new IntList(500);
        public FloatList data = new FloatList(10000);
    }
}

