/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing.modular;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Scattering;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray2.tracing.modular.PathValues;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.Line;
import java.util.ArrayList;

public class CombinedPathValues
extends PathValues {
    public ArrayList<Line> rayListEB;
    public ArrayList<Spectrum> weightListEB;
    public ArrayList<Float> geometryFactorsEB;
    public Spectrum3d initialSpectrumEnd = new Spectrum3d();
    public int dividerIndex;
    boolean validFlag = true;
    Line dummyLine;
    Spectrum dummySpec;
    float dummyGeomFac;
    public int lightID;
    public int sensorID;

    public void initialize(int n) {
        super.initialize(n);
        this.validFlag = true;
        this.rayListEB = new ArrayList(n - 1);
        this.weightListEB = new ArrayList(n);
        this.geometryFactorsEB = new ArrayList(n);
        this.dividerIndex = -1;
        this.dummyLine = new Line();
        this.dummyLine.directionDensity = 0.12345f;
        this.dummySpec = new Spectrum3d();
        this.dummyGeomFac = 0.98765f;
    }

    public void merge2Paths(PathValues pathValues, int n, PathValues pathValues2, int n2) {
        this.pathLength = n + n2 + 2;
        this.initialSpectrum.set(pathValues.initialSpectrum);
        this.initialSpectrumEnd.set(pathValues2.initialSpectrum);
        this.dividerIndex = n;
        for (int i = 0; i < n + n2 + 2; ++i) {
            if (i <= n) {
                if (this.envList.size() > i) {
                    this.envList.set(i, pathValues.envList.get(i));
                } else {
                    this.envList.add(i, pathValues.envList.get(i));
                }
                if (this.shaderList.size() > i) {
                    this.shaderList.set(i, pathValues.shaderList.get(i));
                } else {
                    this.shaderList.add(i, pathValues.shaderList.get(i));
                }
                if (this.intersecList.size() > i) {
                    this.intersecList.set(i, pathValues.intersecList.get(i));
                } else {
                    this.intersecList.add(i, pathValues.intersecList.get(i));
                }
                if (i > 0) {
                    if (this.rayListBE.size() > i - 1) {
                        this.rayListBE.set(i - 1, pathValues.rayListBE.get(i - 1));
                    } else {
                        this.rayListBE.add(i - 1, pathValues.rayListBE.get(i - 1));
                    }
                    if (this.weightListBE.size() > i - 1) {
                        this.weightListBE.set(i - 1, pathValues.weightListBE.get(i - 1));
                    } else {
                        this.weightListBE.add(i - 1, pathValues.weightListBE.get(i - 1));
                    }
                    if (this.geometryFactorsBE.size() > i - 1) {
                        this.geometryFactorsBE.set(i - 1, pathValues.geometryFactorsBE.get(i - 1));
                    } else {
                        this.geometryFactorsBE.add(i - 1, pathValues.geometryFactorsBE.get(i - 1));
                    }
                }
                if (i < pathValues.specReflectionList.length) {
                    this.specReflectionList[i] = pathValues.specReflectionList[i];
                }
                if (i < pathValues.specRefractionList.length) {
                    this.specRefractionList[i] = pathValues.specRefractionList[i];
                }
                if (i < pathValues.hitLights.length) {
                    this.hitLights[i] = pathValues.hitLights[i];
                }
                if (this.rayListEB.size() > i) {
                    this.rayListEB.set(i, this.dummyLine);
                } else {
                    this.rayListEB.add(i, this.dummyLine);
                }
                if (this.weightListEB.size() > i) {
                    this.weightListEB.set(i, this.dummySpec);
                } else {
                    this.weightListEB.add(i, this.dummySpec);
                }
                if (this.geometryFactorsEB.size() > i) {
                    this.geometryFactorsEB.set(i, Float.valueOf(this.dummyGeomFac));
                    continue;
                }
                this.geometryFactorsEB.add(i, Float.valueOf(this.dummyGeomFac));
                continue;
            }
            int n3 = n2 - (i - n - 1);
            if (this.envList.size() > i) {
                this.envList.set(i, pathValues2.envList.get(n3));
            } else {
                this.envList.add(i, pathValues2.envList.get(n3));
            }
            if (this.shaderList.size() > i) {
                this.shaderList.set(i, pathValues2.shaderList.get(n3));
            } else {
                this.shaderList.add(i, pathValues2.shaderList.get(n3));
            }
            if (this.intersecList.size() > i) {
                this.intersecList.set(i, pathValues2.intersecList.get(n3));
            } else {
                this.intersecList.add(i, pathValues2.intersecList.get(n3));
            }
            if (n3 < n2) {
                if (this.rayListEB.size() > i - 1) {
                    this.rayListEB.set(i - 1, pathValues2.rayListBE.get(n3));
                } else {
                    this.rayListEB.add(i - 1, pathValues2.rayListBE.get(n3));
                }
                if (this.weightListEB.size() > i - 1) {
                    this.weightListEB.set(i - 1, pathValues2.weightListBE.get(n3));
                } else {
                    this.weightListEB.add(i - 1, pathValues2.weightListBE.get(n3));
                }
                if (this.geometryFactorsEB.size() > i - 1) {
                    this.geometryFactorsEB.set(i - 1, pathValues2.geometryFactorsBE.get(n3));
                } else {
                    this.geometryFactorsEB.add(i - 1, pathValues2.geometryFactorsBE.get(n3));
                }
            }
            if (n3 < pathValues2.specReflectionList.length) {
                this.specReflectionList[i] = pathValues2.specReflectionList[n3];
                this.specRefractionList[i] = pathValues2.specRefractionList[n3];
            }
            if (n3 >= pathValues2.hitLights.length) continue;
            this.hitLights[i] = pathValues2.hitLights[n3];
        }
        this.validFlag = true;
    }

    public void splitInto2Paths(int n, PathValues pathValues, PathValues pathValues2) {
        int n2;
        pathValues.pathLength = n + 1;
        pathValues2.pathLength = this.pathLength - pathValues.pathLength;
        pathValues.initialSpectrum.set(this.initialSpectrum);
        pathValues2.initialSpectrum.set(this.initialSpectrumEnd);
        if (this.pathLength - 1 < n) {
            n = this.pathLength - 1;
        }
        for (n2 = 0; n2 <= n; ++n2) {
            if (pathValues.envList.size() > n2) {
                pathValues.envList.set(n2, (Environment)this.envList.get(n2));
            } else {
                pathValues.envList.add(n2, (Environment)this.envList.get(n2));
            }
            if (pathValues.intersecList.size() > n2) {
                pathValues.intersecList.set(n2, (Intersection)this.intersecList.get(n2));
            } else {
                pathValues.intersecList.add(n2, (Intersection)this.intersecList.get(n2));
            }
            if (pathValues.shaderList.size() > n2) {
                pathValues.shaderList.set(n2, (Scattering)this.shaderList.get(n2));
            } else {
                pathValues.shaderList.add(n2, (Scattering)this.shaderList.get(n2));
            }
            pathValues.hitLights[n2] = this.hitLights[n2];
            pathValues.specReflectionList[n2] = this.specReflectionList[n2];
            pathValues.specRefractionList[n2] = this.specRefractionList[n2];
            if (n2 == 0) {
                if (pathValues.weightListBE.size() > n2) {
                    pathValues.weightListBE.set(n2, (Spectrum)this.weightListBE.get(n2));
                } else {
                    pathValues.weightListBE.add(n2, (Spectrum)this.weightListBE.get(n2));
                }
            }
            if (n2 <= 0) continue;
            if (pathValues.weightListBE.size() > n2 - 1) {
                pathValues.weightListBE.set(n2 - 1, (Spectrum)this.weightListBE.get(n2 - 1));
            } else {
                pathValues.weightListBE.add(n2 - 1, (Spectrum)this.weightListBE.get(n2 - 1));
            }
            if (pathValues.rayListBE.size() > n2 - 1) {
                pathValues.rayListBE.set(n2 - 1, (Line)this.rayListBE.get(n2 - 1));
            } else {
                pathValues.rayListBE.add(n2 - 1, (Line)this.rayListBE.get(n2 - 1));
            }
            if (pathValues.geometryFactorsBE.size() > n2 - 1) {
                pathValues.geometryFactorsBE.set(n2 - 1, (Float)this.geometryFactorsBE.get(n2 - 1));
                continue;
            }
            pathValues.geometryFactorsBE.add(n2 - 1, (Float)this.geometryFactorsBE.get(n2 - 1));
        }
        for (n2 = this.pathLength - 1; n2 > n; --n2) {
            int n3 = this.pathLength - 1 - n2;
            if (pathValues2.envList.size() > n3) {
                pathValues2.envList.set(n3, (Environment)this.envList.get(n2));
            } else {
                pathValues2.envList.add(n3, (Environment)this.envList.get(n2));
            }
            if (pathValues2.intersecList.size() > n3) {
                pathValues2.intersecList.set(n3, (Intersection)this.intersecList.get(n2));
            } else {
                pathValues2.intersecList.add(n3, (Intersection)this.intersecList.get(n2));
            }
            if (pathValues2.shaderList.size() > n3) {
                pathValues2.shaderList.set(n3, (Scattering)this.shaderList.get(n2));
            } else {
                pathValues2.shaderList.add(n3, (Scattering)this.shaderList.get(n2));
            }
            pathValues2.hitLights[n3] = this.hitLights[n2];
            pathValues2.specRefractionList[n3] = this.specRefractionList[n2];
            pathValues2.specReflectionList[n3] = this.specReflectionList[n2];
            if (n3 <= 0) continue;
            if (pathValues2.weightListBE.size() > n3 - 1) {
                pathValues2.weightListBE.set(n3 - 1, this.weightListEB.get(n2));
            } else {
                pathValues2.weightListBE.add(n3 - 1, this.weightListEB.get(n2));
            }
            if (pathValues2.rayListBE.size() > n3 - 1) {
                pathValues2.rayListBE.set(n3 - 1, this.rayListEB.get(n2));
            } else {
                pathValues2.rayListBE.add(n3 - 1, this.rayListEB.get(n2));
            }
            if (pathValues2.geometryFactorsBE.size() > n3 - 1) {
                pathValues2.geometryFactorsBE.set(n3 - 1, this.geometryFactorsEB.get(n2));
                continue;
            }
            pathValues2.geometryFactorsBE.add(n3 - 1, this.geometryFactorsEB.get(n2));
        }
    }

    public void setValidFlag(boolean bl) {
        this.validFlag = bl;
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public String toString() {
        String string = "CombinedPathValues \n   lightSourceId=" + this.lightID + " sensorSourceId=" + this.sensorID + "  dividerIndex=" + this.dividerIndex + "\n";
        string = string + "   " + super.toString();
        string = string + "   Valid=" + this.validFlag + "\n";
        string = string + "   initalSpectrumEnd=" + this.initialSpectrumEnd + "\n";
        for (int i = 0; i < this.pathLength; ++i) {
            string = i < this.pathLength - 1 && i < this.rayListEB.size() - 1 ? string + "   rayListEB[" + i + "].direction=" + this.rayListEB.get((int)i).direction + "   DirDens[" + i + "]=" + this.rayListEB.get((int)i).directionDensity + "  ---  weightEB[" + i + "]=" + this.weightListEB.get(i) : string + "   rayListEB[" + i + "].direction=not set" + "  ---  weightEB[" + i + "]=not set";
            string = string + "\n";
        }
        if (this.pathLength > 2) {
            string = string + "    Crossing Canvas in Pixel(" + this.rayListEB.get((int)(this.pathLength - 2)).x + "," + this.rayListEB.get((int)(this.pathLength - 2)).y + ")";
        }
        return string;
    }
}

