/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image;

import org.sunflow.image.RGBSpace;
import org.sunflow.math.MathUtils;

public final class Color {
    private float r;
    private float g;
    private float b;
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f);
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f);
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f);
    public static final Color GREEN = new Color(0.0f, 1.0f, 0.0f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f);
    public static final Color YELLOW = new Color(1.0f, 1.0f, 0.0f);
    public static final Color CYAN = new Color(0.0f, 1.0f, 1.0f);
    public static final Color MAGENTA = new Color(1.0f, 0.0f, 1.0f);
    public static final Color GRAY = new Color(0.5f, 0.5f, 0.5f);
    private static final float[] EXPONENT = new float[256];

    public static Color black() {
        return new Color();
    }

    public static Color white() {
        return new Color(1.0f, 1.0f, 1.0f);
    }

    public Color() {
    }

    public Color(float f) {
        this.g = this.b = f;
        this.r = this.b;
    }

    public Color(float f, float f2, float f3) {
        this.r = f;
        this.g = f2;
        this.b = f3;
    }

    public Color toNonLinear() {
        this.r = RGBSpace.SRGB.gammaCorrect(this.r);
        this.g = RGBSpace.SRGB.gammaCorrect(this.g);
        this.b = RGBSpace.SRGB.gammaCorrect(this.b);
        return this;
    }

    public Color toLinear() {
        this.r = RGBSpace.SRGB.ungammaCorrect(this.r);
        this.g = RGBSpace.SRGB.ungammaCorrect(this.g);
        this.b = RGBSpace.SRGB.ungammaCorrect(this.b);
        return this;
    }

    public Color(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
    }

    public Color(int n) {
        this.r = (float)(n >> 16 & 0xFF) / 255.0f;
        this.g = (float)(n >> 8 & 0xFF) / 255.0f;
        this.b = (float)(n & 0xFF) / 255.0f;
    }

    public Color copy() {
        return new Color(this);
    }

    public final Color set(float f, float f2, float f3) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        return this;
    }

    public final Color set(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        return this;
    }

    public final Color setRGB(int n) {
        this.r = (float)(n >> 16 & 0xFF) / 255.0f;
        this.g = (float)(n >> 8 & 0xFF) / 255.0f;
        this.b = (float)(n & 0xFF) / 255.0f;
        return this;
    }

    public final Color setRGBE(int n) {
        float f = EXPONENT[n & 0xFF];
        this.r = f * ((float)(n >>> 24) + 0.5f);
        this.g = f * ((float)(n >> 16 & 0xFF) + 0.5f);
        this.b = f * ((float)(n >> 8 & 0xFF) + 0.5f);
        return this;
    }

    public final boolean isBlack() {
        return this.r <= 0.0f && this.g <= 0.0f && this.b <= 0.0f;
    }

    public final float getLuminance() {
        return 0.2989f * this.r + 0.5866f * this.g + 0.1145f * this.b;
    }

    public final float getMin() {
        return MathUtils.min(this.r, this.g, this.b);
    }

    public final float getMax() {
        return MathUtils.max(this.r, this.g, this.b);
    }

    public final float getAverage() {
        return (this.r + this.g + this.b) / 3.0f;
    }

    public final float[] getRGB() {
        return new float[]{this.r, this.g, this.b};
    }

    public final int toRGB() {
        int n = (int)((double)(this.r * 255.0f) + 0.5);
        int n2 = (int)((double)(this.g * 255.0f) + 0.5);
        int n3 = (int)((double)(this.b * 255.0f) + 0.5);
        n = MathUtils.clamp(n, 0, 255);
        n2 = MathUtils.clamp(n2, 0, 255);
        n3 = MathUtils.clamp(n3, 0, 255);
        return n << 16 | n2 << 8 | n3;
    }

    public final int toRGBE() {
        float f = MathUtils.max(this.r, this.g, this.b);
        if (f < 1.0E-32f) {
            return 0;
        }
        float f2 = f;
        int n = 0;
        if (f > 1.0f) {
            while (f2 > 1.0f) {
                f2 *= 0.5f;
                ++n;
            }
        } else if (f <= 0.5f) {
            while (f2 <= 0.5f) {
                f2 *= 2.0f;
                --n;
            }
        }
        f = f2 * 255.0f / f;
        int n2 = n + 128;
        n2 |= (int)(this.r * f) << 24;
        n2 |= (int)(this.g * f) << 16;
        return n2 |= (int)(this.b * f) << 8;
    }

    public final Color constrainRGB() {
        float f = -MathUtils.min(0.0f, this.r, this.g, this.b);
        if (f > 0.0f) {
            this.r += f;
            this.g += f;
            this.b += f;
        }
        return this;
    }

    public final boolean isNan() {
        return Float.isNaN(this.r) || Float.isNaN(this.g) || Float.isNaN(this.b);
    }

    public final boolean isInf() {
        return Float.isInfinite(this.r) || Float.isInfinite(this.g) || Float.isInfinite(this.b);
    }

    public final Color add(Color color) {
        this.r += color.r;
        this.g += color.g;
        this.b += color.b;
        return this;
    }

    public static final Color add(Color color, Color color2) {
        return Color.add(color, color2, new Color());
    }

    public static final Color add(Color color, Color color2, Color color3) {
        color3.r = color.r + color2.r;
        color3.g = color.g + color2.g;
        color3.b = color.b + color2.b;
        return color3;
    }

    public final Color madd(float f, Color color) {
        this.r += f * color.r;
        this.g += f * color.g;
        this.b += f * color.b;
        return this;
    }

    public final Color madd(Color color, Color color2) {
        this.r += color.r * color2.r;
        this.g += color.g * color2.g;
        this.b += color.b * color2.b;
        return this;
    }

    public final Color sub(Color color) {
        this.r -= color.r;
        this.g -= color.g;
        this.b -= color.b;
        return this;
    }

    public static final Color sub(Color color, Color color2) {
        return Color.sub(color, color2, new Color());
    }

    public static final Color sub(Color color, Color color2, Color color3) {
        color3.r = color.r - color2.r;
        color3.g = color.g - color2.g;
        color3.b = color.b - color2.b;
        return color3;
    }

    public final Color mul(Color color) {
        this.r *= color.r;
        this.g *= color.g;
        this.b *= color.b;
        return this;
    }

    public static final Color mul(Color color, Color color2) {
        return Color.mul(color, color2, new Color());
    }

    public static final Color mul(Color color, Color color2, Color color3) {
        color3.r = color.r * color2.r;
        color3.g = color.g * color2.g;
        color3.b = color.b * color2.b;
        return color3;
    }

    public final Color mul(float f) {
        this.r *= f;
        this.g *= f;
        this.b *= f;
        return this;
    }

    public static final Color mul(float f, Color color) {
        return Color.mul(f, color, new Color());
    }

    public static final Color mul(float f, Color color, Color color2) {
        color2.r = f * color.r;
        color2.g = f * color.g;
        color2.b = f * color.b;
        return color2;
    }

    public final Color div(Color color) {
        this.r /= color.r;
        this.g /= color.g;
        this.b /= color.b;
        return this;
    }

    public static final Color div(Color color, Color color2) {
        return Color.div(color, color2, new Color());
    }

    public static final Color div(Color color, Color color2, Color color3) {
        color3.r = color.r / color2.r;
        color3.g = color.g / color2.g;
        color3.b = color.b / color2.b;
        return color3;
    }

    public final Color exp() {
        this.r = (float)Math.exp(this.r);
        this.g = (float)Math.exp(this.g);
        this.b = (float)Math.exp(this.b);
        return this;
    }

    public final Color opposite() {
        this.r = 1.0f - this.r;
        this.g = 1.0f - this.g;
        this.b = 1.0f - this.b;
        return this;
    }

    public final Color clamp(float f, float f2) {
        this.r = MathUtils.clamp(this.r, f, f2);
        this.g = MathUtils.clamp(this.r, f, f2);
        this.b = MathUtils.clamp(this.r, f, f2);
        return this;
    }

    public static final Color blend(Color color, Color color2, float f) {
        return Color.blend(color, color2, f, new Color());
    }

    public static final Color blend(Color color, Color color2, float f, Color color3) {
        color3.r = (1.0f - f) * color.r + f * color2.r;
        color3.g = (1.0f - f) * color.g + f * color2.g;
        color3.b = (1.0f - f) * color.b + f * color2.b;
        return color3;
    }

    public static final Color blend(Color color, Color color2, Color color3) {
        return Color.blend(color, color2, color3, new Color());
    }

    public static final Color blend(Color color, Color color2, Color color3, Color color4) {
        color4.r = (1.0f - color3.r) * color.r + color3.r * color2.r;
        color4.g = (1.0f - color3.g) * color.g + color3.g * color2.g;
        color4.b = (1.0f - color3.b) * color.b + color3.b * color2.b;
        return color4;
    }

    public static final boolean hasContrast(Color color, Color color2, float f) {
        if (Math.abs(color.r - color2.r) / (color.r + color2.r) > f) {
            return true;
        }
        if (Math.abs(color.g - color2.g) / (color.g + color2.g) > f) {
            return true;
        }
        return Math.abs(color.b - color2.b) / (color.b + color2.b) > f;
    }

    public String toString() {
        return String.format("(%.3f, %.3f, %.3f)", Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
    }

    static {
        Color.EXPONENT[0] = 0.0f;
        for (int i = 1; i < 256; ++i) {
            int n;
            float f = 1.0f;
            int n2 = i - 136;
            if (n2 > 0) {
                for (n = 0; n < n2; ++n) {
                    f *= 2.0f;
                }
            } else {
                for (n = 0; n < -n2; ++n) {
                    f *= 0.5f;
                }
            }
            Color.EXPONENT[i] = f;
        }
    }
}

