/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.pdb;

import de.grogra.ext.pdb.HierarchicalStructureFactory;
import de.grogra.ext.pdb.PDBAtomReader;
import de.grogra.ext.pdb.PDBStartNode;
import de.grogra.ext.pdb.model.IProtein;
import de.grogra.ext.pdb.view.BackboneVisualizer;
import de.grogra.ext.pdb.view.BallStickVisualizer;
import de.grogra.ext.pdb.view.SpaceFilledVisualizer;
import de.grogra.graph.impl.Node;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ReaderSource;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Option;
import de.grogra.reflect.Type;
import de.grogra.util.Configurable;
import de.grogra.util.Configuration;
import de.grogra.util.ConfigurationSet;
import de.grogra.util.EnumerationType;
import de.grogra.util.I18NBundle;
import de.grogra.util.KeyDescription;
import de.grogra.util.Map;
import java.io.IOException;
import java.io.Reader;

public class PDBImport
extends FilterBase
implements ObjectSource,
Configurable {
    public static final String OPTION_NAME_VISUALISATION_STYLE = "visualisation_style";
    public static final I18NBundle I18N = I18NBundle.getInstance(PDBImport.class);
    public static final Type VISUALISATION_STYLE = new EnumerationType("pdb.visualisation_style", I18N, 3);
    public static final int BOND_EDGE = 32768;
    Configuration conf;

    public PDBImport(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(IOFlavor.NODE);
    }

    public void addConfigurations(ConfigurationSet configurationSet) {
        Option[] optionArray = Option.getEditableOptions((Item)this.item, (boolean)true);
        this.conf = new Configuration((KeyDescription[])optionArray, (Map)this.item);
        configurationSet.add(this.conf);
    }

    public Object getObject() throws IOException {
        HierarchicalStructureFactory hierarchicalStructureFactory = new HierarchicalStructureFactory("SomeProteinName");
        Reader reader = ((ReaderSource)this.source).getReader();
        PDBAtomReader pDBAtomReader = new PDBAtomReader(reader);
        pDBAtomReader.read(hierarchicalStructureFactory);
        IProtein iProtein = hierarchicalStructureFactory.getProtein();
        PDBStartNode pDBStartNode = new PDBStartNode(iProtein);
        Object object = this.conf.get((Object)OPTION_NAME_VISUALISATION_STYLE, (Object)new Integer(0));
        int n = (Integer)object;
        Node node = null;
        switch (n) {
            default: {
                node = new SpaceFilledVisualizer(iProtein).createGraph();
                break;
            }
            case 1: {
                node = new BackboneVisualizer(iProtein).createGraph();
                break;
            }
            case 2: {
                node = new BallStickVisualizer(iProtein).createGraph();
            }
        }
        return node;
    }
}

