/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.jocl;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.jocl.JOCLBuffer;
import de.grogra.gpuflux.jocl.JOCLDevice;
import de.grogra.gpuflux.jocl.JOCLProgram;
import de.grogra.gpuflux.jocl.JOCLSource;
import de.grogra.gpuflux.utils.ByteArray;
import de.grogra.pf.boot.Main;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.jocl.CL;
import org.jocl.CLException;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_context;
import org.jocl.cl_device_id;
import org.jocl.cl_program;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOCLContext {
    public final int KERNEL_VERSION = 12;
    public static final boolean logResourceManagement = false;
    private String log = "";
    private AbstractList<JOCLDevice> devices;
    private cl_device_id[] device_id_array;
    private cl_context context;
    private boolean hasLittleEndian = false;
    private boolean hasBigEndian = false;
    private Vector<String> extensions = new Vector();
    private String extensionOptions = " ";
    private HashMap<String, JOCLProgram> programCache = new HashMap();

    public JOCLContext(cl_context cl_context2, AbstractList<cl_device_id> abstractList) {
        this.context = cl_context2;
        this.devices = new ArrayList<JOCLDevice>(abstractList.size());
        if (abstractList != null) {
            String[] stringArray;
            for (cl_device_id stringArray2 : abstractList) {
                JOCLDevice jOCLDevice = new JOCLDevice(this, stringArray2);
                this.log = this.log + jOCLDevice + "\n";
                this.devices.add(jOCLDevice);
                this.hasLittleEndian |= jOCLDevice.isLittleEndian();
                this.hasBigEndian |= !jOCLDevice.isLittleEndian();
            }
            this.device_id_array = new cl_device_id[this.devices.size()];
            for (int i = 0; i < this.devices.size(); ++i) {
                this.device_id_array[i] = this.devices.get(i).getClDevice();
            }
            for (String string : stringArray = this.devices.get(0).getExtensionList()) {
                if (string.length() == 0) continue;
                boolean bl = true;
                for (JOCLDevice jOCLDevice : this.devices) {
                    boolean bl2 = false;
                    for (String string2 : jOCLDevice.getExtensionList()) {
                        if (string2.equals(string)) continue;
                        bl2 = true;
                    }
                    bl &= bl2;
                }
                if (!bl) continue;
                this.extensions.add(string);
                this.extensionOptions = this.extensionOptions + " -D " + string;
            }
            this.log = this.log + "    Shared Extensions: " + this.extensions + "\n\n";
        }
    }

    public void finalize() throws Throwable {
        CL.clReleaseContext((cl_context)this.context);
        super.finalize();
    }

    public static cl_device_id[] getDevices(cl_context cl_context2) {
        long[] lArray = new long[1];
        CL.clGetContextInfo((cl_context)cl_context2, (int)4225, (long)0L, null, (long[])lArray);
        int n = (int)lArray[0] / Sizeof.cl_device_id;
        cl_device_id[] cl_device_idArray = new cl_device_id[n];
        CL.clGetContextInfo((cl_context)cl_context2, (int)4225, (long)lArray[0], (Pointer)Pointer.to((NativePointerObject[])cl_device_idArray), null);
        return cl_device_idArray;
    }

    public AbstractList<JOCLDevice> getDevices() {
        return this.devices;
    }

    public String getIdentifier() {
        String string = "";
        for (int i = 0; i < this.devices.size(); ++i) {
            string = string + this.devices.get(i).getIdentifier() + "__";
        }
        return string;
    }

    public String getLog() {
        return this.log;
    }

    public synchronized JOCLProgram getProgram(String string) {
        JOCLProgram jOCLProgram = this.programCache.get(string);
        return jOCLProgram;
    }

    public synchronized JOCLProgram loadProgram(String string, JOCLSource jOCLSource, String string2) throws IOException {
        JOCLProgram jOCLProgram = this.programCache.get(string);
        if (jOCLProgram == null && FluxSettings.getOCLPrecompile()) {
            jOCLProgram = this.loadProgramFromDisk(string, string2);
        }
        if (jOCLProgram == null) {
            cl_program cl_program2 = CL.clCreateProgramWithSource((cl_context)this.context, (int)1, (String[])new String[]{jOCLSource.getSource()}, null, null);
            try {
                String string3 = string2 + this.extensionOptions + " -Werror";
                CL.clBuildProgram((cl_program)cl_program2, (int)this.device_id_array.length, (cl_device_id[])this.device_id_array, (String)string3, null, null);
            }
            catch (CLException cLException) {
                throw new IOException(this.getBuildLog(cl_program2));
            }
            jOCLProgram = new JOCLProgram(cl_program2, string, "    " + string + this.extensionOptions + this.getBuildLog(cl_program2));
            this.cacheBinariesOnDisk(jOCLProgram);
        }
        if (jOCLProgram != null) {
            this.programCache.put(string, jOCLProgram);
        }
        return jOCLProgram;
    }

    public String getCachedProgramKey(cl_device_id cl_device_id2, String string) {
        String string2 = JOCLProgram.getIdenifier(string);
        String string3 = JOCLDevice.getIdentifier(cl_device_id2);
        return string2 + "___" + string3;
    }

    public String getCachedProgramPath(String string) {
        String string2 = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "GroIMP" + System.getProperty("file.separator");
        String string3 = this.hashString(string);
        String string4 = string2 + string3 + ".tmp";
        new File(string2).mkdir();
        return string4;
    }

    private String hashString(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            BigInteger bigInteger = new BigInteger(1, byArray);
            return String.format("%0" + (byArray.length << 1) + "X", bigInteger) + 12;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return "" + string.hashCode();
        }
    }

    public JOCLProgram loadProgramFromDisk(String string, String string2) throws IOException {
        cl_program cl_program2;
        Object object;
        int[] nArray = new int[this.devices.size()];
        long[] lArray = new long[this.devices.size()];
        byte[][] byArrayArray = new byte[this.devices.size()][];
        for (int i = 0; i < this.devices.size(); ++i) {
            object = this.getCachedProgramKey(this.devices.get(i).getClDevice(), string);
            String string3 = this.getCachedProgramPath((String)object);
            try {
                byArrayArray[i] = this.readFile(string3, (String)object);
                lArray[i] = byArrayArray[i].length;
                continue;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        try {
            cl_program2 = CL.clCreateProgramWithBinary((cl_context)this.context, (int)this.device_id_array.length, (cl_device_id[])this.device_id_array, (long[])lArray, (byte[][])byArrayArray, (int[])nArray, null);
            for (Object object2 : (Object)nArray) {
                if (object2 == false) continue;
                return null;
            }
        }
        catch (CLException cLException) {
            return null;
        }
        try {
            object = string2 + this.extensionOptions + " -Werror";
            CL.clBuildProgram((cl_program)cl_program2, (int)this.device_id_array.length, (cl_device_id[])this.device_id_array, (String)object, null, null);
        }
        catch (CLException cLException) {
            System.out.println(this.getBuildLog(cl_program2));
            return null;
        }
        object = new JOCLProgram(cl_program2, string, "    " + string + this.extensionOptions + this.getBuildLog(cl_program2));
        return object;
    }

    private byte[] readFile(String string, String string2) throws IOException {
        File file = new File(string);
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        if (!new String(byArray).equals(string2)) {
            Main.getLogger().warning("GPUFlux: cached kernel collision.\nCACHED KEY:\n" + byArray + "\nREQUESTED KEY:\n" + string2);
            return null;
        }
        int n2 = dataInputStream.readInt();
        byte[] byArray2 = new byte[n2];
        dataInputStream.read(byArray2);
        dataInputStream.close();
        return byArray2;
    }

    public void cacheBinariesOnDisk(JOCLProgram jOCLProgram) {
        byte[][] byArray = jOCLProgram.getBinarieDatas();
        cl_device_id[] cl_device_idArray = jOCLProgram.getDevices();
        for (int i = 0; i < cl_device_idArray.length; ++i) {
            if (cl_device_idArray[i] == null || byArray[i].length <= 0) continue;
            String string = this.getCachedProgramKey(cl_device_idArray[i], jOCLProgram.getName());
            String string2 = this.getCachedProgramPath(string);
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string2));
                int n = string.getBytes().length;
                dataOutputStream.writeInt(n);
                dataOutputStream.write(string.getBytes());
                int n2 = byArray[i].length;
                dataOutputStream.writeInt(n2);
                dataOutputStream.write(byArray[i]);
                dataOutputStream.close();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private String getBuildLog(cl_program cl_program2) {
        String string = "";
        for (JOCLDevice jOCLDevice : this.devices) {
            string = string + JOCLContext.getBuildLog(cl_program2, jOCLDevice.getClDevice());
        }
        return string;
    }

    public JOCLBuffer createBuffer(int n, long l) {
        return new JOCLBuffer(CL.clCreateBuffer((cl_context)this.context, (long)l, (long)Math.max(n + 3, 4), null, null), n);
    }

    public JOCLBuffer createBufferFromByteArray(ByteArray byteArray, long l) {
        if (byteArray.size() == 0) {
            return this.createBuffer(0, l & 0xFFFFFFFFFFFFFFDFL & 0xFFFFFFFFFFFFFFF7L);
        }
        return new JOCLBuffer(CL.clCreateBuffer((cl_context)this.context, (long)l, (long)(byteArray.size() + 3), (Pointer)Pointer.to((byte[])byteArray.getBuffer()), null), byteArray.size());
    }

    public boolean hasDevices() {
        return this.devices != null && this.devices.size() != 0;
    }

    public cl_context getClContext() {
        return this.context;
    }

    private static String getBuildLog(cl_program cl_program2, cl_device_id cl_device_id2) {
        long[] lArray = new long[1];
        CL.clGetProgramBuildInfo((cl_program)cl_program2, (cl_device_id)cl_device_id2, (int)4483, (long)0L, null, (long[])lArray);
        byte[] byArray = new byte[(int)lArray[0]];
        CL.clGetProgramBuildInfo((cl_program)cl_program2, (cl_device_id)cl_device_id2, (int)4483, (long)byArray.length, (Pointer)Pointer.to((byte[])byArray), null);
        return new String(byArray, 0, byArray.length - 1);
    }

    public boolean hasLittleEndian() {
        return this.hasLittleEndian;
    }

    public boolean hasBigEndian() {
        return this.hasBigEndian;
    }

    public String getExtensions() {
        String string = "";
        for (String string2 : this.extensions) {
            string = string + string2 + " ";
        }
        return string;
    }

    public String getDeviceNames() {
        String string = "";
        for (JOCLDevice jOCLDevice : this.devices) {
            string = string + jOCLDevice.getName() + "\n";
        }
        return string;
    }
}

