/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.jocl;

import de.grogra.gpuflux.jocl.JOCLContext;
import de.grogra.gpuflux.jocl.JOCLDevice;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.jocl.CL;
import org.jocl.CLException;
import org.jocl.Pointer;
import org.jocl.cl_context;
import org.jocl.cl_context_properties;
import org.jocl.cl_device_id;
import org.jocl.cl_platform_id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOCLPlatform {
    private cl_platform_id platform_id;

    public JOCLPlatform(cl_platform_id cl_platform_id2) {
        this.platform_id = cl_platform_id2;
    }

    public String getProfile() {
        return JOCLPlatform.getString(this.platform_id, 2304);
    }

    public JOCLPlatformVersion getVersion() {
        String string = JOCLPlatform.getString(this.platform_id, 2305);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " .");
        stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        return new JOCLPlatformVersion(n, n2, string2);
    }

    public String getName() {
        return JOCLPlatform.getString(this.platform_id, 2306);
    }

    public String getVendor() {
        return JOCLPlatform.getString(this.platform_id, 2307);
    }

    public String get_EXTENSIONS() {
        return JOCLPlatform.getString(this.platform_id, 2308);
    }

    public String toString() {
        String string = "";
        string = string + "    Platform: " + this.getName() + "\n";
        string = string + "    Vendor: " + this.getVendor() + "\n";
        string = string + "    Version: " + this.getVersion() + "\n";
        return string;
    }

    public JOCLContext createContext(AbstractList<cl_device_id> abstractList) {
        cl_context_properties cl_context_properties2 = new cl_context_properties();
        cl_context_properties2.addProperty(4228L, this.platform_id);
        try {
            cl_context cl_context2 = CL.clCreateContextFromType((cl_context_properties)cl_context_properties2, (long)-1L, null, null, null);
            return new JOCLContext(cl_context2, abstractList);
        }
        catch (CLException cLException) {
            return null;
        }
    }

    private static String getString(cl_platform_id cl_platform_id2, int n) {
        long[] lArray = new long[1];
        CL.clGetPlatformInfo((cl_platform_id)cl_platform_id2, (int)n, (long)0L, null, (long[])lArray);
        byte[] byArray = new byte[(int)lArray[0]];
        CL.clGetPlatformInfo((cl_platform_id)cl_platform_id2, (int)n, (long)byArray.length, (Pointer)Pointer.to((byte[])byArray), null);
        return new String(byArray, 0, byArray.length - 1);
    }

    public cl_device_id[] getDevices() {
        return JOCLDevice.getDevices(this.platform_id);
    }

    public static cl_platform_id[] getPlatforms() {
        int[] nArray = new int[1];
        CL.clGetPlatformIDs((int)0, null, (int[])nArray);
        cl_platform_id[] cl_platform_idArray = new cl_platform_id[nArray[0]];
        CL.clGetPlatformIDs((int)cl_platform_idArray.length, (cl_platform_id[])cl_platform_idArray, null);
        return cl_platform_idArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JOCLPlatformVersion
    implements Comparator<JOCLPlatformVersion> {
        private String info;
        private int major;
        private int minor;

        public JOCLPlatformVersion(int n, int n2, String string) {
            this.setMajor(n);
            this.setMinor(n2);
            this.setInfo(string);
        }

        private void setInfo(String string) {
            this.info = string;
        }

        public String getInfo() {
            return this.info;
        }

        private void setMajor(int n) {
            this.major = n;
        }

        public int getMajor() {
            return this.major;
        }

        private void setMinor(int n) {
            this.minor = n;
        }

        public int getMinor() {
            return this.minor;
        }

        @Override
        public int compare(JOCLPlatformVersion jOCLPlatformVersion, JOCLPlatformVersion jOCLPlatformVersion2) {
            if (jOCLPlatformVersion.major < jOCLPlatformVersion2.major) {
                return -1;
            }
            if (jOCLPlatformVersion.major > jOCLPlatformVersion2.major) {
                return 1;
            }
            if (jOCLPlatformVersion.minor < jOCLPlatformVersion2.minor) {
                return -1;
            }
            if (jOCLPlatformVersion.minor > jOCLPlatformVersion2.minor) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            String string = "";
            string = string + this.major + "." + this.minor + " " + this.info;
            return string;
        }
    }
}

