/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.BVH;

import de.grogra.gpuflux.scene.BVH.BVHBuilder;
import de.grogra.gpuflux.scene.BVH.BVHNode;
import de.grogra.gpuflux.scene.BVH.BVHTree;
import de.grogra.gpuflux.scene.volume.FluxVolume;
import de.grogra.gpuflux.utils.TaskMonitor;
import de.grogra.vecmath.BoundingBox3d;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedBVHBuilderMiddle
implements BVHBuilder {
    private static final int WORK_PER_THREAD = 10000;
    private static final int TREE_WORK_PER_THREAD = 3000;
    private static final int MAX_DEPTH = 63;
    private static final int MIN_PRIMS = 1;
    private TaskMonitor jobs;
    String log = "";
    private Integer[] primIdx;
    private BVHPrimitive[] prims;

    @Override
    public BVHTree construct(Vector<? extends FluxVolume> vector) {
        int n = vector.size();
        this.log = "";
        BoundingBox3d boundingBox3d = new BoundingBox3d();
        this.prims = new BVHPrimitive[n];
        this.primIdx = new Integer[n];
        Point3d point3d = new Point3d();
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            this.prims[i] = new BVHPrimitive();
            this.prims[i].bb = vector.get(i).getBoundingBox();
            this.prims[i].bb.getCenter((Tuple3d)point3d);
            this.prims[i].center[0] = point3d.x;
            this.prims[i].center[1] = point3d.y;
            this.prims[i].center[2] = point3d.z;
            this.prims[i].idx = i;
            boundingBox3d.extent(this.prims[i].bb);
            this.primIdx[i] = new Integer(i);
        }
        l = System.currentTimeMillis() - l;
        long l2 = System.currentTimeMillis();
        ExecutorService executorService = Executors.newCachedThreadPool();
        BVHNode bVHNode = new BVHNode(-1, 0, n, boundingBox3d, null, null);
        MedianSplitJob medianSplitJob = new MedianSplitJob(0, n, boundingBox3d, boundingBox3d.clone(), 0, this.primIdx, this.prims, bVHNode, executorService);
        this.jobs = new TaskMonitor();
        this.jobs.startTask();
        executorService.execute(medianSplitJob);
        this.jobs.awaitTasks();
        executorService.shutdown();
        l2 = System.currentTimeMillis() - l2;
        this.log = this.log + "        Compute BB time:       " + l + " ms\n";
        this.log = this.log + "        Subdivide tree time:   " + l2 + " ms\n";
        BVHTree bVHTree = new BVHTree(bVHNode, boundingBox3d, this.primIdx);
        for (int i = 0; i < n; ++i) {
            this.primIdx[i] = this.prims[i].idx;
        }
        return bVHTree;
    }

    public int getMaxAxis(BoundingBox3d boundingBox3d) {
        Tuple3d tuple3d = boundingBox3d.getMax();
        Tuple3d tuple3d2 = boundingBox3d.getMin();
        double d = tuple3d.x - tuple3d2.x;
        double d2 = tuple3d.y - tuple3d2.y;
        double d3 = tuple3d.z - tuple3d2.z;
        if (d > d2) {
            if (d > d3) {
                return 0;
            }
            return 2;
        }
        if (d2 > d3) {
            return 1;
        }
        return 2;
    }

    private double getAxis(Tuple3d tuple3d, int n) {
        if (n == 0) {
            return tuple3d.x;
        }
        if (n == 1) {
            return tuple3d.y;
        }
        if (n == 2) {
            return tuple3d.z;
        }
        return 0.0;
    }

    @Override
    public String getLog() {
        return this.log;
    }

    class MedianSplitJob
    implements Runnable {
        private int work = 0;
        private int from;
        private int to;
        private BoundingBox3d bbox;
        private BoundingBox3d nodebox;
        private int depth;
        private Integer[] primIdx;
        private BVHPrimitive[] prims;
        private BVHNode leaf;
        Executor executor;
        Point3d centerTmp = new Point3d();

        public MedianSplitJob(int n, int n2, BoundingBox3d boundingBox3d, BoundingBox3d boundingBox3d2, int n3, Integer[] integerArray, BVHPrimitive[] bVHPrimitiveArray, BVHNode bVHNode, Executor executor) {
            this.from = n;
            this.to = n2;
            this.bbox = boundingBox3d;
            this.nodebox = boundingBox3d2;
            this.depth = n3;
            this.primIdx = integerArray;
            this.prims = bVHPrimitiveArray;
            this.leaf = bVHNode;
            this.executor = executor;
        }

        public void run() {
            BVHNode bVHNode = this.subdivide(this.from, this.to, this.bbox, this.nodebox, this.depth, true);
            this.leaf.set(bVHNode);
            ThreadedBVHBuilderMiddle.this.jobs.finishTask();
        }

        private BVHNode subdivide(int n, int n2, BoundingBox3d boundingBox3d, BoundingBox3d boundingBox3d2, int n3, boolean bl) {
            if (this.work > 10000 && n2 - n > 3000) {
                BVHNode bVHNode = new BVHNode(-1, n, n2 - n, boundingBox3d, null, null);
                MedianSplitJob medianSplitJob = new MedianSplitJob(n, n2, boundingBox3d, boundingBox3d2, n3, this.primIdx, this.prims, bVHNode, this.executor);
                ThreadedBVHBuilderMiddle.this.jobs.startTask();
                this.executor.execute(medianSplitJob);
                return bVHNode;
            }
            if (n3 < 63 && n2 - n > 1) {
                BVHPrimitive bVHPrimitive;
                int n4 = ThreadedBVHBuilderMiddle.this.getMaxAxis(boundingBox3d2);
                boundingBox3d2.getCenter((Tuple3d)this.centerTmp);
                double d = ThreadedBVHBuilderMiddle.this.getAxis((Tuple3d)this.centerTmp, n4);
                BoundingBox3d boundingBox3d3 = new BoundingBox3d();
                BoundingBox3d boundingBox3d4 = new BoundingBox3d();
                this.work += n2 - n;
                int n5 = n;
                int n6 = n2 - 1;
                while (true) {
                    if (d <= this.prims[n6].center[n4] && n6 != n5) {
                        boundingBox3d4.extent(this.prims[n6].bb);
                        --n6;
                        continue;
                    }
                    while (d > this.prims[n5].center[n4] && n6 != n5) {
                        boundingBox3d3.extent(this.prims[n5].bb);
                        ++n5;
                    }
                    if (n6 == n5) break;
                    bVHPrimitive = this.prims[n6];
                    this.prims[n6] = this.prims[n5];
                    this.prims[n5] = bVHPrimitive;
                }
                boundingBox3d4.extent(this.prims[n6].bb);
                bVHPrimitive = boundingBox3d2.clone();
                BoundingBox3d boundingBox3d5 = boundingBox3d2.clone();
                if (n4 == 0) {
                    bVHPrimitive.getMax().x = Math.min(d, bVHPrimitive.getMax().x);
                    boundingBox3d5.getMin().x = Math.max(d, boundingBox3d5.getMin().x);
                } else if (n4 == 1) {
                    bVHPrimitive.getMax().y = Math.min(d, bVHPrimitive.getMax().y);
                    boundingBox3d5.getMin().y = Math.max(d, boundingBox3d5.getMin().y);
                } else {
                    bVHPrimitive.getMax().z = Math.min(d, bVHPrimitive.getMax().z);
                    boundingBox3d5.getMin().z = Math.max(d, boundingBox3d5.getMin().z);
                }
                BVHNode bVHNode = this.subdivide(n, n5, boundingBox3d3, (BoundingBox3d)bVHPrimitive, n3 + 1, false);
                BVHNode bVHNode2 = this.subdivide(n6, n2, boundingBox3d4, boundingBox3d5, n3 + 1, false);
                if (!bl) {
                    if (n5 - n == 0) {
                        return bVHNode2;
                    }
                    if (n2 - n6 == 0) {
                        return bVHNode;
                    }
                }
                return new BVHNode(n4, n, n2 - n, boundingBox3d, bVHNode, bVHNode2);
            }
            return new BVHNode(-1, n, n2 - n, boundingBox3d, null, null);
        }
    }

    private class BVHPrimitive {
        public BoundingBox3d bb = new BoundingBox3d();
        public double[] center = new double[3];
        public int idx;

        private BVHPrimitive() {
        }
    }
}

