/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.jocl.compute.ComputeContext;
import de.grogra.gpuflux.jocl.compute.Device;
import de.grogra.gpuflux.jocl.compute.Kernel;
import de.grogra.gpuflux.jocl.compute.SharedBuffer;
import de.grogra.gpuflux.scene.FluxSceneSerializer;
import java.io.IOException;

public class FluxJOCLScene {
    private FluxSceneSerializer serializer;
    private ComputeContext computeContext;
    private SharedBuffer primBuffer;
    private SharedBuffer offsetBuffer;
    private SharedBuffer bvhBuffer;
    private SharedBuffer shaderBuffer;
    private SharedBuffer channelBuffer;
    private SharedBuffer sensorBuffer;
    private SharedBuffer sensorBVHBuffer;
    private SharedBuffer lightPowerBuffer;
    private SharedBuffer lightBuffer;
    private SharedBuffer lightOffsetBuffer;
    private SharedBuffer cameraBuffer;
    private SharedBuffer detectorBuffer;
    private ComputeByteBuffer boundsBuffer;
    private ComputeByteBuffer computeByteBuffer;

    public FluxJOCLScene(FluxSceneSerializer fluxSceneSerializer, ComputeContext computeContext) {
        this.serializer = fluxSceneSerializer;
        this.computeContext = computeContext;
        this.computeByteBuffer = computeContext.createByteBuffer();
    }

    public void setupOCLBounds() throws IOException {
        this.boundsBuffer = this.computeContext.createByteBuffer();
        this.serializer.serializeBoundingSphere(this.boundsBuffer);
    }

    public void setupOCLDetectors() throws IOException {
        this.computeByteBuffer.reset();
        this.serializer.serializeDetectors(this.computeByteBuffer);
        this.detectorBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
    }

    public void setupOCLCamera(int n, int n2) throws IOException {
        this.computeByteBuffer.reset();
        this.serializer.serializeCamera(this.computeByteBuffer, n, n2);
        this.cameraBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
    }

    public void setupOCLSensors() throws IOException {
        this.computeByteBuffer.reset();
        this.serializer.serializeSensors(this.computeByteBuffer);
        this.sensorBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
        this.computeByteBuffer.reset();
        this.serializer.serializeSensorBVH(this.computeByteBuffer, false);
        this.sensorBVHBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
    }

    public void setupOCLScene(boolean bl) throws IOException {
        this.computeByteBuffer.reset();
        this.serializer.serializeChannels(this.computeByteBuffer);
        this.channelBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
        this.computeByteBuffer.reset();
        this.serializer.serializeShaders(this.computeByteBuffer);
        this.shaderBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
        this.computeByteBuffer.reset();
        this.serializer.serializePrimitives(this.computeByteBuffer);
        this.primBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
        this.computeByteBuffer.reset();
        this.serializer.serializePrimitiveOffsets(this.computeByteBuffer);
        this.offsetBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
        this.computeByteBuffer.reset();
        this.serializer.serializeBVH(this.computeByteBuffer, bl);
        this.bvhBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
    }

    public void setupOCLLights() throws IOException {
        this.computeByteBuffer.reset();
        this.serializer.serializeLights(this.computeByteBuffer);
        this.lightBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
        this.computeByteBuffer.reset();
        this.serializer.serializeLightOffsets(this.computeByteBuffer);
        this.lightOffsetBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
        this.computeByteBuffer.reset();
        this.serializer.serializeCumulativeLightPowerDistribution(this.computeByteBuffer);
        this.lightPowerBuffer = this.computeContext.createSharedBuffer(this.computeByteBuffer, 36L);
    }

    public void setKernelArgDetectors(Device device, Kernel kernel, int n) {
        device.setKernelArgMemBuffer(kernel, n, this.detectorBuffer);
    }

    public void setKernelArgCamera(Device device, Kernel kernel, int n) {
        device.setKernelArgMemBuffer(kernel, n, this.cameraBuffer);
    }

    public void setKernelArgBounds(Device device, Kernel kernel, int n) {
        device.setKernelArgBuffer(kernel, n, this.boundsBuffer.getBuffer(device.isLittleEndian()));
    }

    public void setKernelArgSensors(Device device, Kernel kernel, int n) {
        device.setKernelArgInt(kernel, n + 0, this.serializer.getScene().getSensorCount());
        device.setKernelArgMemBuffer(kernel, n + 1, this.sensorBuffer);
        device.setKernelArgInt(kernel, n + 2, this.serializer.getScene().getSensorBVHRoot());
        device.setKernelArgMemBuffer(kernel, n + 3, this.sensorBVHBuffer);
    }

    public void setKernelArgScene(Device device, Kernel kernel, int n) {
        device.setKernelArgInt(kernel, n + 0, this.serializer.getScene().getPrimitiveCount());
        device.setKernelArgInt(kernel, n + 1, this.serializer.getScene().getInfPrimitiveCount());
        device.setKernelArgMemBuffer(kernel, n + 2, this.primBuffer);
        device.setKernelArgMemBuffer(kernel, n + 3, this.offsetBuffer);
        device.setKernelArgInt(kernel, n + 4, this.serializer.getScene().getBVHRoot());
        device.setKernelArgMemBuffer(kernel, n + 5, this.bvhBuffer);
        device.setKernelArgMemBuffer(kernel, n + 6, this.shaderBuffer);
        device.setKernelArgMemBuffer(kernel, n + 7, this.channelBuffer);
        device.setKernelArgInt(kernel, n + 8, this.serializer.getScene().getLightCount());
        device.setKernelArgMemBuffer(kernel, n + 9, this.lightBuffer);
        device.setKernelArgMemBuffer(kernel, n + 10, this.lightOffsetBuffer);
        device.setKernelArgMemBuffer(kernel, n + 11, this.lightPowerBuffer);
        device.setKernelArgInt(kernel, n + 12, this.serializer.getSkyOffset());
    }
}

