/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.experiment;

import de.grogra.gpuflux.scene.experiment.Measurement;
import de.grogra.graph.impl.Node;
import de.grogra.xl.util.LongToIntHashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Experiment {
    private transient LongToIntHashMap nodeToGroup;
    private transient Vector<? extends Measurement> measurements;
    private transient Measurement zero = new Measurement();

    public Experiment(LongToIntHashMap longToIntHashMap, Vector<? extends Measurement> vector, Measurement measurement) {
        this.nodeToGroup = longToIntHashMap;
        this.measurements = vector;
        this.zero = measurement;
    }

    public Measurement getMeasurement(Node node) {
        int n = this.checkGroupId(node);
        return n >= 0 ? this.measurements.get(n) : (Measurement)this.zero.clone();
    }

    public Measurement getZero() {
        return (Measurement)this.zero.clone();
    }

    public int checkGroupId(Node node) {
        if (this.nodeToGroup == null) {
            return -1;
        }
        int n = this.nodeToGroup.get(node.getId(), -1);
        return n;
    }

    public void mul(float f) {
        for (Measurement measurement : this.measurements) {
            measurement.mul(f);
        }
    }

    public void aggregate(Experiment experiment, float f) {
        if (experiment.nodeToGroup != this.nodeToGroup) {
            throw new IllegalArgumentException("Node to group mappings don't match");
        }
        for (int i = 0; i < this.measurements.size(); ++i) {
            this.measurements.elementAt(i).mad(experiment.measurements.elementAt(i), f);
        }
    }
}

