/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.volume;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.shading.FluxShader;
import de.grogra.gpuflux.scene.volume.FluxVolume;
import de.grogra.imp3d.Renderable;
import de.grogra.vecmath.BoundingBox3d;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import java.io.IOException;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public abstract class FluxPrimitive
extends FluxVolume {
    public final int PRIM_TRANSFORMABLE = 128;
    public final int PRIM_PLANE = 129;
    public final int PRIM_SPHERE = 130;
    public final int PRIM_FRUSTUM = 131;
    public final int PRIM_BOX = 132;
    public final int PRIM_TRIANGLE = 5;
    public final int PRIM_PARALLEL = 6;
    protected Renderable owner;
    private FluxShader shader;
    private float currentIOR;
    private int groupIndex = -1;

    public abstract void getExtent(BoundingBox3d var1, Variables var2);

    public void setOwner(Renderable renderable) {
        this.owner = renderable;
    }

    protected void serialize(ComputeByteBuffer computeByteBuffer, int n, Matrix4f matrix4f) throws IOException {
        this.serialize(computeByteBuffer, n);
        Matrix3f matrix3f = new Matrix3f();
        Vector3f vector3f = new Vector3f();
        matrix4f.getRotationScale(matrix3f);
        matrix4f.get(vector3f);
        computeByteBuffer.write(matrix4f);
    }

    public void serialize(ComputeByteBuffer computeByteBuffer, int n, TransformableVolume transformableVolume) throws IOException {
        this.serialize(computeByteBuffer, n);
        Matrix3d matrix3d = new Matrix3d();
        Vector3d vector3d = new Vector3d();
        transformableVolume.getTransformation(matrix3d, (Tuple3d)vector3d);
        Matrix3f matrix3f = new Matrix3f(matrix3d);
        Vector3f vector3f = new Vector3f(vector3d);
        computeByteBuffer.write(matrix3f);
        computeByteBuffer.write((Tuple3f)vector3f);
    }

    public void setFluxShader(FluxShader fluxShader) {
        this.shader = fluxShader;
    }

    private void serialize(ComputeByteBuffer computeByteBuffer, int n) throws IOException {
        computeByteBuffer.writeInt(n);
        computeByteBuffer.writeInt(this.groupIndex);
        if (this.shader == null) {
            computeByteBuffer.writeInt(0);
        } else {
            computeByteBuffer.writeInt(this.shader.getOffset());
        }
        computeByteBuffer.writeFloat(this.currentIOR);
        super.serialize(computeByteBuffer);
    }

    public void setIOR(float f) {
        this.currentIOR = f;
    }

    public void setGroupIndex(int n) {
        this.groupIndex = n;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }
}

