/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.tracer;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.GPUFluxInit;
import de.grogra.gpuflux.jocl.JOCLBuffer;
import de.grogra.gpuflux.jocl.JOCLEvent;
import de.grogra.gpuflux.jocl.compute.Buffer;
import de.grogra.gpuflux.jocl.compute.ComputeContext;
import de.grogra.gpuflux.jocl.compute.Device;
import de.grogra.gpuflux.jocl.compute.Kernel;
import de.grogra.gpuflux.scene.FluxJOCLScene;
import de.grogra.gpuflux.scene.FluxScene;
import de.grogra.gpuflux.scene.FluxSceneSerializer;
import de.grogra.gpuflux.scene.filter.NoneFilter;
import de.grogra.gpuflux.tracer.FluxTracer;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.ViewConfig3D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.AbstractList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.jocl.CL;
import org.jocl.cl_event;

public class FluxWhittedTracer
extends FluxTracer {
    private ConcurrentLinkedQueue<DeviceMonitor> openDeviceList;
    private Semaphore available;
    private volatile boolean finnished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void trace() throws IOException {
        DeviceMonitor[] deviceMonitorArray;
        long l;
        long l2;
        long l3;
        StringBuffer stringBuffer;
        block27: {
            block26: {
                stringBuffer = new StringBuffer("<html><pre>");
                stringBuffer.append("<B>GPUFlux Whitted Tracer</B>\n\n");
                l3 = 0L;
                l2 = 0L;
                l = 0L;
                long l4 = 0L;
                deviceMonitorArray = null;
                try {
                    int n;
                    long l5;
                    this.setProgress("Build scene", -1.0f);
                    l3 = System.currentTimeMillis();
                    FluxScene fluxScene = new FluxScene();
                    fluxScene.buildSceneFromGraph(this.view.getGraph(), (ViewConfig3D)((View3D)this.view), new NoneFilter(), false, this, true, FluxSettings.getModelFlatness());
                    l3 = System.currentTimeMillis() - l3;
                    stringBuffer.append(fluxScene.getLog());
                    stringBuffer.append(fluxScene.getSceneStats());
                    this.setProgress("Init compute context", -1.0f);
                    ComputeContext computeContext = GPUFluxInit.initComputeContext(true, null);
                    stringBuffer.append(computeContext.aquireLog());
                    if (!computeContext.valid()) {
                        Object var39_9 = null;
                        stringBuffer.append("\n<B>Profile Summary</B>\n");
                        break block26;
                    }
                    AbstractList<Device> abstractList = computeContext.getDeviceList();
                    this.setProgress("Serialize scene", -1.0f);
                    l2 = System.currentTimeMillis();
                    FluxSceneSerializer fluxSceneSerializer = new FluxSceneSerializer();
                    FluxJOCLScene fluxJOCLScene = new FluxJOCLScene(fluxSceneSerializer, computeContext);
                    fluxSceneSerializer.serializeScene(fluxScene);
                    fluxJOCLScene.setupOCLScene(this.useBih);
                    fluxJOCLScene.setupOCLCamera(this.width, this.height);
                    fluxJOCLScene.setupOCLLights();
                    l2 = System.currentTimeMillis() - l2;
                    this.setProgress("Load kernel", -1.0f);
                    Kernel kernel = computeContext.createKernel("kernel/whitted_kernel.cl", "computeImage", this.getKernelCompilationArguments(false, false));
                    stringBuffer.append(computeContext.getLog());
                    stringBuffer.append("<B>Settings</B>\n");
                    stringBuffer.append(FluxSettings.getTracerLog());
                    stringBuffer.append("        Image size:   " + this.width + " x " + this.height + "\n");
                    stringBuffer.append("        Total pixels: " + this.width * this.height + "\n");
                    stringBuffer.append("\n");
                    int n2 = FluxSettings.getRenderDepth();
                    double d = FluxSettings.getOCLPreferredDuration();
                    float f = FluxSettings.getRenderMinPower();
                    int n3 = FluxSettings.getOCLInitialSampleCount();
                    int n4 = n3 / fluxScene.getSampleCount();
                    int n5 = Math.min(n4, this.width * this.height);
                    int n6 = this.width * this.height * 1;
                    int n7 = 0;
                    deviceMonitorArray = new DeviceMonitor[abstractList.size()];
                    this.openDeviceList = new ConcurrentLinkedQueue();
                    this.available = new Semaphore(abstractList.size());
                    for (int i = 0; i < abstractList.size(); ++i) {
                        Device device = abstractList.get(i);
                        DeviceMonitor deviceMonitor = new DeviceMonitor();
                        deviceMonitor.smlprun = n5;
                        deviceMonitor.totalsml = 0;
                        deviceMonitor.device = device;
                        deviceMonitor.total_time = 0.0;
                        deviceMonitor.image = device.createBuffer(16 * this.width * this.height, 1L);
                        deviceMonitor.image.clear();
                        deviceMonitorArray[i] = deviceMonitor;
                        this.openDeviceList.add(deviceMonitor);
                        deviceMonitor.start();
                    }
                    stringBuffer.append("<B>Render Profile</B>\n");
                    long l6 = l5 = System.currentTimeMillis();
                    int n8 = n6;
                    this.finnished = false;
                    for (int i = 0; i < n8; i += n, n7 += n, l4 += (long)n) {
                        this.setProgress("Execute", (float)i / (float)n8);
                        try {
                            this.available.acquire();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            Object var39_10 = null;
                            stringBuffer.append("\n<B>Profile Summary</B>\n");
                            stringBuffer.append("    Construction time: " + l3 + " ms\n");
                            stringBuffer.append("    Serialize time:    " + l2 + " ms\n");
                            stringBuffer.append("    Render time:       " + l + " ms\n");
                            if (deviceMonitorArray != null) {
                                DeviceMonitor deviceMonitor;
                                int n9 = 0;
                                DeviceMonitor[] deviceMonitorArray2 = deviceMonitorArray;
                                int n10 = deviceMonitorArray2.length;
                                for (int j = 0; j < n10; n9 += deviceMonitor.totalsml, ++j) {
                                    deviceMonitor = deviceMonitorArray2[j];
                                }
                                if (n9 > 0) {
                                    for (DeviceMonitor deviceMonitor2 : deviceMonitorArray) {
                                        stringBuffer.append("        " + deviceMonitor2.totalsml * 100 / n9 + "%: \t" + deviceMonitor2.device.getName() + "\n");
                                    }
                                }
                            }
                            stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
                            this.setProgress("Done", 2.0f);
                            this.view.getWorkbench().logGUIInfo(stringBuffer.append("</pre></html>").toString());
                            this.available = null;
                            this.openDeviceList = null;
                            return;
                        }
                        DeviceMonitor deviceMonitor = (DeviceMonitor)this.openDeviceList.remove();
                        deviceMonitor.smlprun = n = Math.min(deviceMonitor.smlprun, n8 - i);
                        deviceMonitor.device.setKernelArgMemBuffer(kernel, 1, deviceMonitor.image);
                        deviceMonitor.device.setKernelArgInt(kernel, 2, this.width);
                        deviceMonitor.device.setKernelArgInt(kernel, 3, this.height);
                        deviceMonitor.device.setKernelArgInt(kernel, 4, n);
                        deviceMonitor.device.setKernelArgInt(kernel, 5, n7);
                        fluxJOCLScene.setKernelArgScene(deviceMonitor.device, kernel, 6);
                        fluxJOCLScene.setKernelArgCamera(deviceMonitor.device, kernel, 19);
                        deviceMonitor.device.setKernelArgInt(kernel, 20, n2);
                        deviceMonitor.device.setKernelArgFloat(kernel, 21, f);
                        deviceMonitor.device.executeKernel(kernel, n, deviceMonitor.event);
                        deviceMonitor.resume.release();
                        long l7 = System.currentTimeMillis() - l5;
                        if (!((double)l7 / 1000.0 > d)) continue;
                        this.displayImage(deviceMonitorArray);
                        l5 = System.currentTimeMillis();
                    }
                    computeContext.finish();
                    this.finnished = true;
                    for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
                        deviceMonitor.resume.release();
                    }
                    long l8 = System.currentTimeMillis() - l6;
                    l += l8;
                    this.displayImage(deviceMonitorArray);
                    stringBuffer.append("\n");
                    for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
                        stringBuffer.append("Device: " + deviceMonitor.device.getName() + "\n");
                        stringBuffer.append("\tTotal samples:     " + deviceMonitor.totalsml + "\n");
                        stringBuffer.append("\tSamples per batch: " + deviceMonitor.smlprun + "\n");
                        stringBuffer.append("\tTotal trace time:  " + (int)(deviceMonitor.total_time * 1000.0) + " ms\n");
                        stringBuffer.append("\tSamples per second: " + (double)deviceMonitor.totalsml / 1000000.0 / deviceMonitor.total_time + " MSmpl/s\n");
                    }
                    stringBuffer.append("\n");
                    for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
                        stringBuffer.append(deviceMonitor.log + "\n");
                    }
                    break block27;
                }
                catch (Throwable throwable) {
                    Object var39_12 = null;
                    stringBuffer.append("\n<B>Profile Summary</B>\n");
                    stringBuffer.append("    Construction time: " + l3 + " ms\n");
                    stringBuffer.append("    Serialize time:    " + l2 + " ms\n");
                    stringBuffer.append("    Render time:       " + l + " ms\n");
                    if (deviceMonitorArray != null) {
                        void var44_38;
                        int n = 0;
                        DeviceMonitor[] deviceMonitorArray3 = deviceMonitorArray;
                        int n11 = deviceMonitorArray3.length;
                        for (int i = 0; i < n11; n += var44_38.totalsml, ++i) {
                            var44_38 = deviceMonitorArray3[i];
                        }
                        if (n > 0) {
                            for (void var44_40 : deviceMonitorArray) {
                                stringBuffer.append("        " + var44_40.totalsml * 100 / n + "%: \t" + var44_40.device.getName() + "\n");
                            }
                        }
                    }
                    stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
                    this.setProgress("Done", 2.0f);
                    this.view.getWorkbench().logGUIInfo(stringBuffer.append("</pre></html>").toString());
                    this.available = null;
                    this.openDeviceList = null;
                    throw throwable;
                }
            }
            stringBuffer.append("    Construction time: " + l3 + " ms\n");
            stringBuffer.append("    Serialize time:    " + l2 + " ms\n");
            stringBuffer.append("    Render time:       " + l + " ms\n");
            if (deviceMonitorArray != null) {
                void var44_29;
                int n = 0;
                DeviceMonitor[] deviceMonitorArray4 = deviceMonitorArray;
                int n12 = deviceMonitorArray4.length;
                for (int i = 0; i < n12; n += var44_29.totalsml, ++i) {
                    var44_29 = deviceMonitorArray4[i];
                }
                if (n > 0) {
                    for (void var44_31 : deviceMonitorArray) {
                        stringBuffer.append("        " + var44_31.totalsml * 100 / n + "%: \t" + var44_31.device.getName() + "\n");
                    }
                }
            }
            stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
            this.setProgress("Done", 2.0f);
            this.view.getWorkbench().logGUIInfo(stringBuffer.append("</pre></html>").toString());
            this.available = null;
            this.openDeviceList = null;
            return;
        }
        Object var39_11 = null;
        stringBuffer.append("\n<B>Profile Summary</B>\n");
        stringBuffer.append("    Construction time: " + l3 + " ms\n");
        stringBuffer.append("    Serialize time:    " + l2 + " ms\n");
        stringBuffer.append("    Render time:       " + l + " ms\n");
        if (deviceMonitorArray != null) {
            DeviceMonitor deviceMonitor;
            int n = 0;
            DeviceMonitor[] deviceMonitorArray5 = deviceMonitorArray;
            int n13 = deviceMonitorArray5.length;
            for (int i = 0; i < n13; n += deviceMonitor.totalsml, ++i) {
                deviceMonitor = deviceMonitorArray5[i];
            }
            if (n > 0) {
                for (DeviceMonitor deviceMonitor3 : deviceMonitorArray) {
                    stringBuffer.append("        " + deviceMonitor3.totalsml * 100 / n + "%: \t" + deviceMonitor3.device.getName() + "\n");
                }
            }
        }
        stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
        this.setProgress("Done", 2.0f);
        this.view.getWorkbench().logGUIInfo(stringBuffer.append("</pre></html>").toString());
        this.available = null;
        this.openDeviceList = null;
    }

    protected void displayImage(DeviceMonitor[] deviceMonitorArray) {
        this.setProgress("Display image", -1.0f);
        byte[] byArray = new byte[this.width * this.height * 16];
        FloatBuffer floatBuffer = ByteBuffer.wrap(byArray).asFloatBuffer();
        for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
            byte[] byArray2 = new byte[this.width * this.height * 16];
            deviceMonitor.image.readBuffer(byArray2);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            byteBuffer.order(deviceMonitor.device.getByteOrder());
            FloatBuffer floatBuffer2 = byteBuffer.asFloatBuffer();
            for (int i = 0; i < this.width * this.height * 4; ++i) {
                floatBuffer.put(i, floatBuffer.get(i) + floatBuffer2.get(i));
            }
        }
        this.displayImage(floatBuffer);
    }

    class DeviceMonitor
    extends Thread {
        Semaphore resume = new Semaphore(0);
        Buffer image;
        cl_event event = new cl_event();
        public Device device;
        double passed_time;
        double samplesPerSecond;
        double total_time;
        int smlprun;
        int totalsml;
        String log = "";

        DeviceMonitor() {
        }

        public void run() {
            while (true) {
                try {
                    this.resume.acquire();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (FluxWhittedTracer.this.finnished) break;
                CL.clWaitForEvents((int)1, (cl_event[])new cl_event[]{this.event});
                this.passed_time = JOCLEvent.getEndTime(this.event) - JOCLEvent.getStartTime(this.event);
                this.samplesPerSecond = (double)this.smlprun / this.passed_time;
                this.total_time += this.passed_time;
                if (FluxTracer.BATCH_LOGGING_ENABLED) {
                    this.log = this.log + "<i>";
                    this.log = this.log + "Sample batch\n";
                    this.log = this.log + "    Device:      " + this.device.getName() + "\n";
                    this.log = this.log + "    Batch size: " + this.smlprun + "\n";
                    this.log = this.log + "    Render time: " + this.passed_time * 1000.0 + "ms\n";
                    this.log = this.log + "    Performance: " + this.samplesPerSecond / 1000000.0 + " MSmpl\n";
                    this.log = this.log + "\n</i>";
                }
                this.totalsml += this.smlprun;
                FluxWhittedTracer.this.openDeviceList.add(this);
                FluxWhittedTracer.this.available.release();
            }
        }
    }
}

