/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d;

import de.grogra.graph.EdgePattern;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.imp2d.objects.Attributes;
import de.grogra.imp2d.objects.Transformation;
import de.grogra.xl.util.ObjectList;
import javax.vecmath.Matrix3d;

public abstract class Visitor2D
extends ObjectList
implements Visitor {
    private EdgePattern pattern;
    protected GraphState state;
    protected Matrix3d transformation = new Matrix3d();
    protected int layer;
    private Matrix3d pre = new Matrix3d();
    private boolean hasXf;

    protected void init(GraphState graphState, EdgePattern edgePattern, Matrix3d matrix3d) {
        this.size = 0;
        this.transformation.set(matrix3d);
        this.pre.setIdentity();
        this.state = graphState;
        this.pattern = edgePattern;
    }

    public GraphState getGraphState() {
        return this.state;
    }

    protected final void pushTransformation(Matrix3d matrix3d) {
        Object object;
        if (this.elements.length == this.size || (object = this.elements[this.size]) == null) {
            this.push(new Matrix3d(matrix3d));
        } else {
            ((Matrix3d)object).set(matrix3d);
            ++this.size;
        }
    }

    protected final Matrix3d popTransformation(Matrix3d matrix3d) {
        Matrix3d matrix3d2 = (Matrix3d)this.elements[--this.size];
        this.elements[this.size] = matrix3d;
        return matrix3d2;
    }

    public Object visitEnter(Path path, boolean bl) {
        if (bl) {
            return this.visitEnter(path.getObject(-1), true, path);
        }
        if (!GraphUtils.matchesTerminalEdge((EdgePattern)this.pattern, (Path)path)) {
            return STOP;
        }
        return this.visitEnter(path.getObject(-2), false, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object visitEnter(Object object, boolean bl, Path path) {
        Object var4_4 = null;
        this.pushTransformation(this.transformation);
        Transformation transformation = object == null ? null : (Transformation)this.state.getObjectDefault(object, bl, Attributes.TRANSFORMATION, null);
        int n = this.layer;
        if (object != null) {
            this.layer = this.state.getIntDefault(object, bl, Attributes.LAYER, n);
        }
        Matrix3d matrix3d = this.transformation;
        this.hasXf = transformation != null;
        if (this.hasXf) {
            transformation.preTransform(object, bl, matrix3d, this.pre, this.state);
            this.transformation = this.pre;
        }
        try {
            this.visitImpl(object, bl, path);
        }
        finally {
            this.transformation = matrix3d;
            this.layer = n;
        }
        if (transformation != null) {
            transformation.postTransform(object, bl, this.pre, matrix3d, matrix3d, this.state);
        }
        return var4_4;
    }

    protected abstract void visitImpl(Object var1, boolean var2, Path var3);

    public boolean visitLeave(Object object, Path path, boolean bl) {
        if (bl) {
            this.transformation = this.popTransformation(this.transformation);
            return true;
        }
        if (object != STOP) {
            this.transformation = this.popTransformation(this.transformation);
        }
        return true;
    }

    public Object visitInstanceEnter() {
        this.pushTransformation(this.transformation);
        if (this.hasXf) {
            this.transformation.set(this.pre);
        }
        return null;
    }

    public boolean visitInstanceLeave(Object object) {
        this.transformation = this.popTransformation(this.transformation);
        return true;
    }
}

