/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.graph.Graph;
import de.grogra.imp2d.layout.DrawingEdgeTypeProperties;
import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.GraphUtilities;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.SCOType;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2d;

public abstract class EdgeBasedLayout
extends Layout {
    double degreeDeviationAgainstOverlapping = 5.0;
    boolean mirrorLayout = false;
    DrawingEdgeTypeProperties detp;
    Graph sourceGraph;
    Node nodesFromGraph;
    public static final Type $TYPE = new Type(EdgeBasedLayout.class);
    public static final SCOType.Field degreeDeviationAgainstOverlapping$FIELD = Type._addManagedField($TYPE, "degreeDeviationAgainstOverlapping", 0x200000, de.grogra.reflect.Type.DOUBLE, null, 2);
    public static final SCOType.Field mirrorLayout$FIELD = Type._addManagedField($TYPE, "mirrorLayout", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 3);

    protected Layout.Algorithm createAlgorithm() {
        return new Layout.Algorithm(){

            protected void layout(Node node) {
                EdgeBasedLayout.this.sourceGraph = this.graph;
                EdgeBasedLayout.this.nodesFromGraph = node;
                EdgeBasedLayout.this.detp = EdgeBasedLayout.this.getEdgeTypeProperties(node);
                GraphUtilities graphUtilities = new GraphUtilities();
                graphUtilities.setAllNodesEdgesAccessed(node, false);
                LinkedList linkedList = graphUtilities.getRoots(node);
                for (int i = 0; i < linkedList.size(); ++i) {
                    this.setNewCoordinatesForNeighbour((Node)((Object)linkedList.get(i)));
                }
                if (EdgeBasedLayout.this.mirrorLayout) {
                    Node node2 = node;
                    while (node2 != null) {
                        float f = node2.x;
                        node2.x = -node2.y;
                        node2.y = -f;
                        node2 = node2.next;
                    }
                }
            }

            private void setNewCoordinatesForNeighbour(Node node) {
                Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
                for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                    int n = ((de.grogra.graph.impl.Edge)edge.object).getEdgeBits();
                    if (edge.isAccessed || edge.target.equals((Tuple2f)node) || edge.target.isAccessed) continue;
                    edge.isAccessed = true;
                    if (!hashtable.containsKey(n)) {
                        hashtable.put(n, 0);
                    } else {
                        int n2 = (Integer)hashtable.get(n);
                        hashtable.put(n, ++n2);
                    }
                    double d = EdgeBasedLayout.this.detp.getDirection(n);
                    d = (Integer)hashtable.get(n) % 2 == 0 ? (d += (double)((Integer)hashtable.get(n) / 2) * (Math.PI / 180 * EdgeBasedLayout.this.degreeDeviationAgainstOverlapping)) : (d += (double)((Integer)hashtable.get(n) / 2) * (Math.PI / 180 * EdgeBasedLayout.this.degreeDeviationAgainstOverlapping) + Math.PI);
                    edge.target.x = (float)((double)edge.source.x + EdgeBasedLayout.this.detp.getLength(n) * Math.cos(d));
                    edge.target.y = (float)((double)edge.source.y + EdgeBasedLayout.this.detp.getLength(n) * Math.sin(d));
                    for (int i = 0; this.checkHidingAnotherNodes(edge.target, EdgeBasedLayout.this.nodesFromGraph) && i < 100; ++i) {
                        edge.target.x = (float)((double)edge.source.x + EdgeBasedLayout.this.detp.getLength(n) * Math.cos(d += Math.PI / 180 * EdgeBasedLayout.this.degreeDeviationAgainstOverlapping));
                        edge.target.y = (float)((double)edge.source.y + EdgeBasedLayout.this.detp.getLength(n) * Math.sin(d));
                    }
                    edge.target.isAccessed = true;
                    this.setNewCoordinatesForNeighbour(edge.target);
                }
            }

            private boolean checkHidingAnotherNodes(Node node, Node node2) {
                Node node3 = node2;
                while (node3 != null) {
                    if (node3.isAccessed) {
                        Vector2d vector2d = new Vector2d((double)(node.x - node.width), (double)(node.x + node.width));
                        Vector2d vector2d2 = new Vector2d((double)(node.y - node.height), (double)(node.y + node.height));
                        if ((double)node3.x > vector2d.x && (double)node3.x < vector2d.y && (double)node3.y > vector2d2.x && (double)node3.y < vector2d2.y) {
                            return true;
                        }
                    }
                    node3 = node3.next;
                }
                return false;
            }
        };
    }

    public abstract DrawingEdgeTypeProperties getEdgeTypeProperties(Node var1);

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Layout.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 4;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(EdgeBasedLayout edgeBasedLayout, SCOType sCOType) {
            super(edgeBasedLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Layout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 3: {
                    ((EdgeBasedLayout)((Object)object)).mirrorLayout = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((EdgeBasedLayout)((Object)object)).mirrorLayout;
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 2: {
                    ((EdgeBasedLayout)((Object)object)).degreeDeviationAgainstOverlapping = d;
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((EdgeBasedLayout)((Object)object)).degreeDeviationAgainstOverlapping;
                }
            }
            return super.getDouble(object, n);
        }
    }
}

