/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.GraphUtilities;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.MinimizerPolyLogBarnesHut;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.util.LinkedList;
import javax.vecmath.Point2d;

public class EnergyModelLayout
extends Layout {
    private MinimizerPolyLogBarnesHut fMiniPolyLog;
    private float[][] fPos = null;
    private float[][] fattr = null;
    private float gravitationFactor = 0.15f;
    private float attractionExponent = 3.0f;
    private float minDistanceX = 3.0f;
    private float minDistanceY = 3.0f;
    private float unconnectedNodeX = 0.5f;
    private int count = 100;
    public static final Type $TYPE = new Type(EnergyModelLayout.class);
    public static final SCOType.Field gravitationFactor$FIELD = Type._addManagedField($TYPE, "gravitationFactor", 0x200002, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field attractionExponent$FIELD = Type._addManagedField($TYPE, "attractionExponent", 0x200002, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field minDistanceX$FIELD = Type._addManagedField($TYPE, "minDistanceX", 0x200002, de.grogra.reflect.Type.FLOAT, null, 4);
    public static final SCOType.Field minDistanceY$FIELD = Type._addManagedField($TYPE, "minDistanceY", 0x200002, de.grogra.reflect.Type.FLOAT, null, 5);
    public static final SCOType.Field unconnectedNodeX$FIELD = Type._addManagedField($TYPE, "unconnectedNodeX", 0x200002, de.grogra.reflect.Type.FLOAT, null, 6);
    public static final SCOType.Field count$FIELD = Type._addManagedField($TYPE, "count", 0x200002, de.grogra.reflect.Type.INT, null, 7);

    protected Layout.Algorithm createAlgorithm() {
        return new Layout.Algorithm(){

            protected void layout(Node node) {
                int n;
                GraphUtilities graphUtilities = new GraphUtilities();
                int n2 = graphUtilities.getConnectedNodesSize(node);
                LinkedList linkedList = graphUtilities.getUnconnectedNodes(node);
                float f = (float)this.getMaxBounds((LinkedList)linkedList).y;
                int n3 = 0;
                int n4 = 0;
                if (n2 > 0) {
                    EnergyModelLayout.access$002(EnergyModelLayout.this, new float[n2][3]);
                    EnergyModelLayout.access$102(EnergyModelLayout.this, new float[n2][n2]);
                }
                Node node2 = node;
                while (node2 != null) {
                    if (node2.getFirstEdge() == null) {
                        node2.x = EnergyModelLayout.this.unconnectedNodeX;
                        node2.y = (float)n4 * f;
                        ++n4;
                    } else {
                        ((EnergyModelLayout)EnergyModelLayout.this).fPos[n3][0] = node2.x;
                        ((EnergyModelLayout)EnergyModelLayout.this).fPos[n3][1] = node2.y;
                        ((EnergyModelLayout)EnergyModelLayout.this).fPos[n3][2] = 0.0f;
                        node2.index = n3++;
                    }
                    node2 = node2.next;
                }
                for (n = 0; n < n2; ++n) {
                    for (int i = 0; i < n2; ++i) {
                        ((EnergyModelLayout)EnergyModelLayout.this).fattr[n][i] = 0.0f;
                    }
                }
                n = 0;
                double d = 0.0;
                Node node3 = node;
                while (node3 != null) {
                    for (Edge edge = node3.getFirstEdge(); edge != null; edge = edge.getNext(node3)) {
                        Node node4 = edge.source;
                        Node node5 = edge.target;
                        ((EnergyModelLayout)EnergyModelLayout.this).fattr[node4.index][node5.index] = edge.weight;
                        ((EnergyModelLayout)EnergyModelLayout.this).fattr[node5.index][node4.index] = edge.weight;
                        d += (double)node4.distance(node5);
                        ++n;
                    }
                    node3 = node3.next;
                }
                d /= (double)n;
                for (int i = 0; i < n2; ++i) {
                    ((EnergyModelLayout)EnergyModelLayout.this).fPos[i][0] = (float)((double)EnergyModelLayout.this.fPos[i][0] / d);
                    ((EnergyModelLayout)EnergyModelLayout.this).fPos[i][1] = (float)((double)EnergyModelLayout.this.fPos[i][1] / d);
                }
                EnergyModelLayout.this.fMiniPolyLog = new MinimizerPolyLogBarnesHut(n2, EnergyModelLayout.this.fattr, EnergyModelLayout.this.fPos);
                EnergyModelLayout.this.fMiniPolyLog.setAttractionExponent(EnergyModelLayout.this.attractionExponent);
                EnergyModelLayout.this.fMiniPolyLog.setGravitationFactor(EnergyModelLayout.this.gravitationFactor);
                EnergyModelLayout.this.fMiniPolyLog.minimizeEnergy(EnergyModelLayout.this.count);
                Node node6 = node;
                while (node6 != null) {
                    node6.layoutVarX = EnergyModelLayout.this.fPos[node6.index][0];
                    node6.layoutVarY = EnergyModelLayout.this.fPos[node6.index][1];
                    node6 = node6.next;
                }
                node6 = node;
                while (node6 != null) {
                    node6.x = node6.layoutVarX * Math.max(0.0f, EnergyModelLayout.this.minDistanceX);
                    node6.y = node6.layoutVarY * Math.max(0.0f, EnergyModelLayout.this.minDistanceY);
                    node6 = node6.next;
                }
            }

            protected Point2d getMaxBounds(LinkedList linkedList) {
                if (linkedList == null) {
                    return new Point2d(0.0, 0.0);
                }
                Point2d point2d = new Point2d();
                for (int i = 0; i < linkedList.size(); ++i) {
                    point2d.set(Math.max((double)((Node)((Object)linkedList.get((int)i))).height, point2d.x), Math.max((double)((Node)((Object)linkedList.get((int)i))).width, point2d.y));
                }
                return point2d;
            }
        };
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static /* synthetic */ float[][] access$002(EnergyModelLayout energyModelLayout, float[][] fArray) {
        energyModelLayout.fPos = fArray;
        return fArray;
    }

    static /* synthetic */ float[][] access$102(EnergyModelLayout energyModelLayout, float[][] fArray) {
        energyModelLayout.fattr = fArray;
        return fArray;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Layout.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 8;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(EnergyModelLayout energyModelLayout, SCOType sCOType) {
            super(energyModelLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Layout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 7: {
                    ((EnergyModelLayout)((Object)object)).count = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 7: {
                    return ((EnergyModelLayout)((Object)object)).count;
                }
            }
            return super.getInt(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((EnergyModelLayout)((Object)object)).gravitationFactor = f;
                    return;
                }
                case 3: {
                    ((EnergyModelLayout)((Object)object)).attractionExponent = f;
                    return;
                }
                case 4: {
                    ((EnergyModelLayout)((Object)object)).minDistanceX = f;
                    return;
                }
                case 5: {
                    ((EnergyModelLayout)((Object)object)).minDistanceY = f;
                    return;
                }
                case 6: {
                    ((EnergyModelLayout)((Object)object)).unconnectedNodeX = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((EnergyModelLayout)((Object)object)).gravitationFactor;
                }
                case 3: {
                    return ((EnergyModelLayout)((Object)object)).attractionExponent;
                }
                case 4: {
                    return ((EnergyModelLayout)((Object)object)).minDistanceX;
                }
                case 5: {
                    return ((EnergyModelLayout)((Object)object)).minDistanceY;
                }
                case 6: {
                    return ((EnergyModelLayout)((Object)object)).unconnectedNodeX;
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new EnergyModelLayout();
        }
    }
}

