/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.graph.impl.GraphManager;
import de.grogra.imp.IMPWorkbench;
import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.pf.ui.Workbench;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class GeneralPurposeLayout
extends Layout {
    private float idealDistance = 1.5f;
    private float yIdealDistance = 1.5f;
    private int maxNbOfSteps = 25000;
    private boolean fast = false;
    private boolean startAgain = false;
    private final WeakHashMap<Object, Integer> oldNodes = new WeakHashMap();
    public static final Type $TYPE = new Type(GeneralPurposeLayout.class);
    public static final SCOType.Field idealDistance$FIELD = Type._addManagedField($TYPE, "idealDistance", 0x200002, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field yIdealDistance$FIELD = Type._addManagedField($TYPE, "yIdealDistance", 0x200002, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field maxNbOfSteps$FIELD = Type._addManagedField($TYPE, "maxNbOfSteps", 0x200002, de.grogra.reflect.Type.INT, null, 4);
    public static final SCOType.Field fast$FIELD = Type._addManagedField($TYPE, "fast", 0x200002, de.grogra.reflect.Type.BOOLEAN, null, 5);
    public static final SCOType.Field startAgain$FIELD = Type._addManagedField($TYPE, "startAgain", 0x200002, de.grogra.reflect.Type.BOOLEAN, null, 6);

    public GeneralPurposeLayout() {
        maxNbOfSteps$FIELD.setInt((Object)this, 25000);
        idealDistance$FIELD.setFloat((Object)this, 1.5f);
        idealDistance$FIELD.setFloat((Object)this, 1.5f);
        startAgain$FIELD.setBoolean((Object)this, false);
        fast$FIELD.setBoolean((Object)this, false);
    }

    protected Layout.Algorithm createAlgorithm() {
        return new Layout.Algorithm(){
            float springLength;
            float forceConst;
            final float criticalDistance;
            boolean edgeVisitedValue;
            {
                this.springLength = 3.0f * GeneralPurposeLayout.this.idealDistance / 4.0f;
                this.forceConst = 0.5f * GeneralPurposeLayout.this.idealDistance * GeneralPurposeLayout.this.idealDistance * (GeneralPurposeLayout.this.idealDistance - this.springLength);
                this.criticalDistance = 0.01f * GeneralPurposeLayout.this.idealDistance;
                this.edgeVisitedValue = false;
            }

            @Override
            protected void layout(Node node) {
                boolean bl = false;
                Node node2 = this.initialisation(node, !bl, !this.edgeVisitedValue);
                ArrayList<HashMap<Integer, Node>> arrayList = new ArrayList<HashMap<Integer, Node>>();
                HashMap<Integer, Node> hashMap = new HashMap<Integer, Node>();
                this.goThroughLinkedNodes(node2, null, arrayList, hashMap, bl);
                this.edgeVisitedValue = !this.edgeVisitedValue;
                boolean bl2 = bl = !bl;
                if (arrayList.isEmpty()) {
                    this.tree(node2, 0.0f, 0.0f, bl);
                } else {
                    if (GeneralPurposeLayout.this.startAgain) {
                        GeneralPurposeLayout.this.oldNodes.clear();
                    }
                    this.treeLikeLayout(hashMap, arrayList, node2, GeneralPurposeLayout.this.maxNbOfSteps, bl);
                }
            }

            private void energyAlgorithm(Node node, Node node2, boolean bl, boolean bl2) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                ArrayList<Node> arrayList2 = new ArrayList<Node>();
                ArrayList<Node> arrayList3 = new ArrayList<Node>();
                Node node3 = node.getFirstEdge().target;
                arrayList3.add(node);
                arrayList3.add(node3);
                if (!GeneralPurposeLayout.this.oldNodes.containsKey(node.object)) {
                    GeneralPurposeLayout.this.oldNodes.put(node.object, 0);
                    node.x = 0.0f;
                    node.y = 0.0f;
                }
                if (!GeneralPurposeLayout.this.oldNodes.containsKey(node3.object)) {
                    GeneralPurposeLayout.this.oldNodes.put(node3.object, 0);
                    node3.x = 0.0f;
                    node3.y = -GeneralPurposeLayout.this.idealDistance;
                }
                Object object = node2;
                while (object != null) {
                    if (GeneralPurposeLayout.this.oldNodes.containsKey(((Node)((Object)object)).object)) {
                        if (object != node && object != node3) {
                            arrayList3.add((Node)((Object)object));
                        }
                    } else if (object != node && object != node3) {
                        arrayList2.add((Node)((Object)object));
                    }
                    object = ((Node)((Object)object)).next;
                }
                arrayList.addAll(arrayList3);
                arrayList.addAll(arrayList2);
                if (arrayList2.size() > 0) {
                    int n = 2;
                    this.placingNewNodes(arrayList2, arrayList3, bl2, bl, n);
                    boolean bl3 = bl2 = !bl2;
                }
                if (!bl) {
                    this.optimizationMethods(arrayList, arrayList, GeneralPurposeLayout.this.maxNbOfSteps, bl2);
                } else {
                    this.optimizationMethods(arrayList2, arrayList, GeneralPurposeLayout.this.maxNbOfSteps, bl2);
                }
                this.centringAndRotating(node, node3, arrayList);
                for (Node node4 : arrayList2) {
                    GeneralPurposeLayout.this.oldNodes.put(node4.object, 0);
                }
            }

            private void placingNewNodes(ArrayList<Node> arrayList, ArrayList<Node> arrayList2, boolean bl, boolean bl2, int n) {
                ArrayList<Node> arrayList3 = new ArrayList<Node>();
                arrayList3.addAll(arrayList2);
                ArrayList<Node> arrayList4 = new ArrayList<Node>();
                for (Node object3 : arrayList3) {
                    object3.isAccessed = bl;
                }
                ArrayList<Node> object = this.linksNewOld(arrayList);
                while (object.size() > 0) {
                    Object object22;
                    for (Object object22 : object) {
                        this.placeNode((Node)((Object)object22), bl);
                    }
                    ArrayList<Node> arrayList5 = new ArrayList<Node>();
                    object22 = new ArrayList();
                    for (Node node : object) {
                        this.recursivelyDepthLimitedPlacingNode(node, (ArrayList<Node>)object22, arrayList5, bl, 0, n);
                    }
                    ((ArrayList)object22).addAll(object);
                    arrayList3.addAll((Collection<Node>)object22);
                    if (bl2) {
                        arrayList4.addAll((Collection<Node>)object22);
                        this.optimizationNewNodes((ArrayList<Node>)object22, arrayList4, arrayList3, !bl);
                    } else {
                        this.optimizationNewNodes((ArrayList<Node>)object22, arrayList3, arrayList3, !bl);
                    }
                    object = arrayList5;
                }
            }

            private void optimizationMethods(ArrayList<Node> arrayList, ArrayList<Node> arrayList2, int n, boolean bl) {
                int n2 = (int)Math.floor(0.2 * (double)n);
                int n3 = (int)Math.floor(0.5 * (double)n);
                int n4 = (int)Math.floor(0.3 * (double)n);
                float f = GeneralPurposeLayout.this.idealDistance * GeneralPurposeLayout.this.idealDistance / 16.0f;
                int n5 = this.newtonPlacement(arrayList, arrayList2, n2, f, bl);
                if ((n3 += n2 - n5) >= 2 * arrayList.size()) {
                    float f2;
                    int n6;
                    int n7;
                    if (n3 / (10 * arrayList.size()) < 20) {
                        n7 = (int)Math.floor(Math.sqrt(n3 / (2 * arrayList.size())));
                        n6 = 2 * n7;
                    } else {
                        n7 = 10;
                        n6 = n3 / n7;
                    }
                    float f3 = 0.95f;
                    float f4 = f2 = (float)Math.exp(-3.0 * Math.log(10.0) / (double)n6);
                    this.simulatedAnnealing(arrayList2, arrayList, n6, n7, f3, f4, f2, bl);
                }
                float f5 = GeneralPurposeLayout.this.idealDistance * GeneralPurposeLayout.this.idealDistance / 100.0f;
                this.newtonPlacement(arrayList, arrayList2, n4, f5, bl);
            }

            private void fastLoopLayout(HashMap<Integer, Node> hashMap, boolean bl) {
                Node[] nodeArray = new Node[hashMap.size()];
                hashMap.values().toArray(nodeArray);
                int n = hashMap.size();
                if (n >= 3) {
                    float f = (float)Math.PI * 2 / (float)n;
                    float f2 = GeneralPurposeLayout.this.idealDistance / (2.0f * (float)Math.sin(f));
                    this.placeNodesCircle(f, f2, 0, hashMap, nodeArray[0], bl);
                } else if (n == 2) {
                    nodeArray[0].x = 0.0f;
                    nodeArray[0].y = 0.0f;
                    nodeArray[1].x = 0.0f;
                    nodeArray[1].y = -GeneralPurposeLayout.this.idealDistance;
                } else if (n == 1) {
                    nodeArray[0].x = 0.0f;
                    nodeArray[0].y = 0.0f;
                }
            }

            private int placeNodesCircle(float f, float f2, int n, HashMap<Integer, Node> hashMap, Node node, boolean bl) {
                node.isAccessed = bl;
                node.x = f2 * (float)Math.cos((float)n * f);
                node.y = f2 * (float)Math.sin((float)n * f);
                ++n;
                for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                    Node node2;
                    Node node3 = node2 = edge.target == node ? edge.source : edge.target;
                    if (!hashMap.containsKey(node2.object.hashCode())) continue;
                    if (edge.isAccessed == this.edgeVisitedValue) {
                        edge.isAccessed = !this.edgeVisitedValue;
                        continue;
                    }
                    edge.isAccessed = this.edgeVisitedValue;
                    if (node2.isAccessed == bl) continue;
                    n = this.placeNodesCircle(f, f2, n, hashMap, node2, bl);
                }
                node.isAccessed = !bl;
                return n;
            }

            private void loopLayout(HashMap<Integer, Node> hashMap, int n, boolean bl, boolean bl2) {
                Node[] nodeArray = new Node[hashMap.size()];
                hashMap.values().toArray(nodeArray);
                int n2 = hashMap.size();
                if (bl2) {
                    this.placeNewNodesLoop(hashMap, nodeArray, bl);
                }
                int n3 = (int)Math.floor(0.2 * (double)n);
                int n4 = (int)Math.floor(0.5 * (double)n);
                int n5 = (int)Math.floor(0.3 * (double)n);
                float f = GeneralPurposeLayout.this.idealDistance * GeneralPurposeLayout.this.idealDistance / 16.0f;
                int n6 = this.newtonOptimisationHM(hashMap, nodeArray, n3, f, bl);
                if ((n4 += n3 - n6) >= 2 * n2) {
                    float f2;
                    int n7;
                    int n8;
                    if (n4 / (10 * n2) < 20) {
                        n8 = (int)Math.floor(Math.sqrt(n4 / (2 * n2)));
                        n7 = n4 / (n2 * n8);
                    } else {
                        n8 = 10;
                        n7 = n4 / n8;
                    }
                    float f3 = 0.95f;
                    float f4 = f2 = (float)Math.exp(-3.0 * Math.log(10.0) / (double)n7);
                    this.simulatedAnnealingHM(hashMap, nodeArray, n7, n8, f3, f4, f2, bl);
                }
                float f5 = GeneralPurposeLayout.this.idealDistance * GeneralPurposeLayout.this.idealDistance / 100.0f;
                this.newtonOptimisationHM(hashMap, nodeArray, n5, f5, bl);
            }

            private void placeNewNodesLoop(HashMap<Integer, Node> hashMap, Node[] nodeArray, boolean bl) {
                HashMap<Integer, Node> hashMap2 = new HashMap<Integer, Node>();
                for (Node node : nodeArray) {
                    if (GeneralPurposeLayout.this.oldNodes.containsKey(node.object.hashCode())) continue;
                    hashMap2.put(node.object.hashCode(), node);
                }
                if (hashMap2.size() == hashMap.size()) {
                    this.fastLoopLayout(hashMap, bl);
                } else {
                    boolean bl2 = false;
                    while (!bl2) {
                        bl2 = this.placeLinkNodesLoop(hashMap2, hashMap);
                    }
                }
            }

            private boolean placeLinkNodesLoop(HashMap<Integer, Node> hashMap, HashMap<Integer, Node> hashMap2) {
                Collection<Node> collection = hashMap.values();
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (Node node : collection) {
                    boolean bl = false;
                    for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                        Node node2;
                        Node node3 = node2 = edge.target == node ? edge.source : edge.target;
                        if (!hashMap2.containsKey(node2.object.hashCode()) || hashMap.containsKey(node2.object.hashCode())) continue;
                        this.placeNodeLoop(node, hashMap, hashMap2);
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    arrayList.add(node);
                }
                for (Node node : arrayList) {
                    hashMap.remove(node.object.hashCode());
                }
                return hashMap.isEmpty();
            }

            private void placeNodeLoop(Node node, HashMap<Integer, Node> hashMap, HashMap<Integer, Node> hashMap2) {
                int n = 0;
                float f = 0.0f;
                float f2 = 0.0f;
                for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                    Node node2;
                    Node node3 = node2 = edge.target == node ? edge.source : edge.target;
                    if (!hashMap.containsKey(node2.object.hashCode()) || hashMap2.containsKey(node2.object.hashCode())) continue;
                    float[] fArray = this.directionLoop(node2, hashMap, hashMap2);
                    int n2 = edge.target == node ? 1 : -1;
                    f += node2.x + (float)n2 * fArray[0];
                    f2 += node2.x + (float)n2 * fArray[1];
                    ++n;
                }
                if (n > 1) {
                    float f3 = (float)Math.sqrt(f * f + f2 * f2);
                    f = f / f3 * GeneralPurposeLayout.this.idealDistance + (2.0f * (float)Math.random() - 1.0f) * 0.25f * GeneralPurposeLayout.this.idealDistance;
                    f2 = f2 / f3 * GeneralPurposeLayout.this.idealDistance + (2.0f * (float)Math.random() - 1.0f) * 0.25f * GeneralPurposeLayout.this.idealDistance;
                }
                node.x = f;
                node.y = f2;
            }

            private float[] directionLoop(Node node, HashMap<Integer, Node> hashMap, HashMap<Integer, Node> hashMap2) {
                Object object;
                float f = 0.0f;
                float f2 = 0.0f;
                for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                    Node node2 = object = edge.target == node ? edge.source : edge.target;
                    if (!hashMap.containsKey(object.object.hashCode()) || hashMap2.containsKey(object.object.hashCode())) continue;
                    int n = edge.target == node ? 1 : -1;
                    f += (float)n * (node.x - object.x);
                    f2 += (float)n * (node.y - object.y);
                }
                float f3 = (float)Math.sqrt(f * f + f2 * f2);
                if ((double)f3 > 0.1) {
                    float f4 = (float)Math.sqrt(GeneralPurposeLayout.this.idealDistance / 2.0f);
                    f = f / f3 * f4;
                    f2 = f2 / f3 * f4;
                    float[] fArray = new float[]{f, f2};
                    return fArray;
                }
                f = 0.0f;
                f2 = -GeneralPurposeLayout.this.idealDistance;
                object = new float[]{f, f2};
                return object;
            }

            private void hierarchicalRank(Node node, boolean bl) {
                LinkedList<Node> linkedList = new LinkedList<Node>();
                linkedList.addLast(node);
                node.index = 0;
                node.isAccessed = bl;
                while (linkedList.size() > 0) {
                    Node node2 = (Node)((Object)linkedList.getFirst());
                    int n = node2.index;
                    for (Edge edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                        Node node3;
                        Node node4 = node3 = edge.target == node2 ? edge.source : edge.target;
                        if (node3.isAccessed == bl) continue;
                        node3.isAccessed = bl;
                        node3.index = n + 1;
                        linkedList.addLast(node3);
                    }
                    linkedList.remove();
                }
            }

            private void optimizationNewNodes(ArrayList<Node> arrayList, ArrayList<Node> arrayList2, ArrayList<Node> arrayList3, boolean bl) {
                float f;
                int n = arrayList.size();
                int n2 = arrayList3.size();
                float f2 = (GeneralPurposeLayout.this.idealDistance - this.springLength) * (GeneralPurposeLayout.this.idealDistance - this.springLength) / 16.0f;
                this.newtonPlacement(arrayList, arrayList3, 3 * n, f2, bl);
                this.newtonPlacement(arrayList2, arrayList3, 5 * (n2 - 2), f2, bl);
                int n3 = 5;
                int n4 = 10;
                float f3 = 0.95f;
                float f4 = f = (float)Math.exp(-3.0 * Math.log(10.0) / (double)n4);
                this.simulatedAnnealing(arrayList3, arrayList2, n4, n3, f3, f4, f, bl);
                this.newtonPlacement(arrayList2, arrayList3, 5 * (n2 - 2), f2, bl);
            }

            private void recursivelyDepthLimitedPlacingNode(Node node, ArrayList<Node> arrayList, ArrayList<Node> arrayList2, boolean bl, int n, int n2) {
                if (n <= n2) {
                    if (node.isAccessed == !bl) {
                        this.placeNode(node, bl);
                        arrayList.add(node);
                    }
                    for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                        Node node2;
                        Node node3 = node2 = edge.source == node ? edge.target : edge.source;
                        if (node2.isAccessed == bl || GeneralPurposeLayout.this.oldNodes.containsKey(node2.object)) continue;
                        this.recursivelyDepthLimitedPlacingNode(node2, arrayList, arrayList2, bl, n + 1, n2);
                    }
                } else if (node.isAccessed == !bl) {
                    arrayList2.add(node);
                    node.isAccessed = bl;
                }
            }

            private float[] directionPlacement(Node node, boolean bl) {
                Object object;
                float f = 0.0f;
                float f2 = 0.0f;
                for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                    Node node2 = object = edge.source == node ? edge.target : edge.source;
                    if (object.isAccessed != bl && !GeneralPurposeLayout.this.oldNodes.containsKey(object.object)) continue;
                    int n = edge.source == node ? -1 : 1;
                    f += (float)n * (node.x - object.x);
                    f2 += (float)n * (node.y - object.y);
                }
                float f3 = (float)Math.sqrt(f * f + f2 * f2);
                f = f / f3 * GeneralPurposeLayout.this.idealDistance * 0.5f;
                f2 = f2 / f3 * GeneralPurposeLayout.this.idealDistance * 0.5f;
                object = new float[]{f, f2};
                return object;
            }

            private void placeNode(Node node, boolean bl) {
                int n = 0;
                for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                    int n2;
                    Node node2 = edge.source == node ? edge.target : edge.source;
                    int n3 = n2 = edge.source == node ? -1 : 1;
                    if (node2.isAccessed != bl && !GeneralPurposeLayout.this.oldNodes.containsKey(node2.object)) continue;
                    float[] fArray = this.directionPlacement(node2, bl);
                    node.x = node2.x + (float)n2 * fArray[0];
                    node.y = node2.y + (float)n2 * fArray[1];
                    ++n;
                }
                if (n > 1) {
                    node.x /= (float)n;
                    node.y /= (float)n;
                }
                node.x += (2.0f * (float)Math.random() - 1.0f) * GeneralPurposeLayout.this.idealDistance * 0.25f;
                node.y += (2.0f * (float)Math.random() - 1.0f) * GeneralPurposeLayout.this.idealDistance * 0.25f;
                node.isAccessed = bl;
            }

            private ArrayList<Node> linksNewOld(ArrayList<Node> arrayList) {
                ArrayList<Node> arrayList2 = new ArrayList<Node>();
                for (Node node : arrayList) {
                    for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                        Node node2;
                        Node node3 = node2 = edge.source == node ? edge.target : edge.source;
                        if (!GeneralPurposeLayout.this.oldNodes.containsKey(node2.object)) continue;
                        arrayList2.add(node);
                    }
                }
                return arrayList2;
            }

            private void translationXY(ArrayList<Node> arrayList, float f, float f2) {
                for (Node node : arrayList) {
                    node.x += f;
                    node.y += f2;
                }
            }

            private void translationXY(Collection<Node> collection, float f, float f2) {
                for (Node node : collection) {
                    node.x += f;
                    node.y += f2;
                }
            }

            private void rotation(ArrayList<Node> arrayList, float f, float f2) {
                for (Node node : arrayList) {
                    float f3 = (float)Math.sqrt(node.x * node.x + node.y * node.y);
                    if (!(f3 >= 0.01f)) continue;
                    float f4 = node.x / f3;
                    float f5 = node.y / f3;
                    node.x = f3 * (f4 * f - f5 * f2);
                    node.y = f3 * (f5 * f + f2 * f4);
                }
            }

            private void rotation(Collection<Node> collection, float f, float f2, float f3, float f4) {
                for (Node node : collection) {
                    float f5 = (float)Math.sqrt((node.x - f) * (node.x - f) + (node.y - f2) * (node.y - f2));
                    if (!(f5 >= 0.01f)) continue;
                    float f6 = (node.x - f) / f5;
                    float f7 = (node.y - f2) / f5;
                    node.x = f5 * (f6 * f3 - f7 * f4) + f;
                    node.y = f5 * (f7 * f3 + f4 * f6) + f2;
                }
            }

            private void centringAndRotating(Node node, Node node2, ArrayList<Node> arrayList) {
                if (node.x != 0.0f || node.y != 0.0f) {
                    this.translationXY(arrayList, -node.x, -node.y);
                }
                if ((double)Math.abs(node2.x) > 0.001 && (double)Math.abs(node2.y) > 0.001) {
                    float f = (float)Math.sqrt(node2.x * node2.x + node2.y * node2.y);
                    float f2 = -node2.y / f;
                    float f3 = -node2.x / f;
                    this.rotation(arrayList, f2, f3);
                }
            }

            private Node initialisation(Node node, boolean bl, boolean bl2) {
                Node node2 = node;
                boolean bl3 = false;
                IMPWorkbench iMPWorkbench = (IMPWorkbench)Workbench.current();
                GraphManager graphManager = iMPWorkbench != null ? iMPWorkbench.getRegistry().getProjectGraph() : null;
                Node node3 = node;
                while (node3 != null) {
                    node3.index = 0;
                    node3.finalX = 0.0f;
                    node3.finalY = 0.0f;
                    node3.initialX = 0.0f;
                    node3.initialY = 0.0f;
                    node3.layoutVarX = 0.0f;
                    node3.layoutVarY = 0.0f;
                    node3.isAccessed = bl;
                    for (Edge edge = node3.getFirstEdge(); edge != null; edge = edge.getNext(node3)) {
                        edge.isAccessed = bl2;
                    }
                    if (!bl3 && node3.object == graphManager.getRoot()) {
                        bl3 = true;
                        node2 = node3;
                    }
                    node3 = node3.next;
                }
                return node2;
            }

            private float[] tree(Node node, float f, float f2, boolean bl) {
                Object object;
                node.isAccessed = bl;
                node.y = f2;
                float f3 = 0.0f;
                float f4 = f;
                int n = 0;
                for (object = node.getFirstEdge(); object != null; object = ((Edge)object).getNext(node)) {
                    Node node2;
                    if (((Edge)object).isAccessed == this.edgeVisitedValue) continue;
                    ((Edge)object).isAccessed = this.edgeVisitedValue;
                    Node node3 = node2 = ((Edge)object).source == node ? ((Edge)object).target : ((Edge)object).source;
                    if (node2.isAccessed == bl) continue;
                    ++n;
                    float[] fArray = this.tree(node2, f4, f2 - GeneralPurposeLayout.this.yIdealDistance, bl);
                    f3 += fArray[1];
                    f4 = fArray[0];
                }
                if (n == 0) {
                    node.x = f;
                    object = new float[]{f + GeneralPurposeLayout.this.idealDistance, f};
                    return object;
                }
                node.x = f3 / (float)n;
                object = new float[]{f4, node.x};
                return object;
            }

            private float[] subTree(Node node, float f, float f2, HashMap<Integer, Node> hashMap, boolean bl) {
                Object object;
                node.isAccessed = bl;
                node.y = f2;
                float f3 = 0.0f;
                float f4 = f;
                int n = 0;
                for (object = node.getFirstEdge(); object != null; object = ((Edge)object).getNext(node)) {
                    Node node2;
                    Node node3 = node2 = ((Edge)object).source == node ? ((Edge)object).target : ((Edge)object).source;
                    if (!hashMap.containsKey(node2.object.hashCode())) continue;
                    if (((Edge)object).isAccessed == this.edgeVisitedValue) {
                        ((Edge)object).isAccessed = !this.edgeVisitedValue;
                        continue;
                    }
                    ((Edge)object).isAccessed = this.edgeVisitedValue;
                    if (node2.isAccessed == bl) continue;
                    ++n;
                    float[] fArray = this.subTree(node2, f4, f2 - GeneralPurposeLayout.this.yIdealDistance, hashMap, bl);
                    f3 += fArray[1];
                    f4 = fArray[0];
                }
                if (n == 0) {
                    node.x = f;
                    object = new float[]{f + GeneralPurposeLayout.this.idealDistance, f};
                    node.isAccessed = !bl;
                    return object;
                }
                node.x = f3 / (float)n;
                object = new float[]{f4, node.x};
                node.isAccessed = !bl;
                return object;
            }

            private float[] treeForStructure(Node node, ArrayList<HashMap<Integer, Node>> arrayList, ArrayList<HashMap<Integer, Node>> arrayList2, float f, float f2, HashMap<Integer, Node> hashMap, boolean bl) {
                float f3;
                HashMap<Integer, Node> hashMap2;
                boolean bl2 = false;
                int n = node.index;
                if (hashMap.get(node.object.hashCode()) != null) {
                    hashMap2 = arrayList.get(n);
                } else {
                    hashMap2 = arrayList2.get(n);
                    bl2 = true;
                }
                float f4 = 0.0f;
                float f5 = f;
                float f6 = node.x;
                float f7 = node.x;
                float f8 = node.y;
                float f9 = node.y;
                float f10 = 0.0f;
                float f11 = 0.0f;
                Collection<Node> collection = hashMap2.values();
                if (bl2) {
                    for (Node node2 : collection) {
                        f10 += node2.x;
                        f11 += node2.y;
                    }
                    float f12 = node.x - (f10 /= (float)collection.size());
                    float f13 = node.y - (f11 /= (float)collection.size());
                    if ((double)Math.abs(f12) > 0.1 || (double)Math.abs(f13) > 0.1) {
                        float f14 = (float)Math.sqrt(f12 * f12 + f13 * f13);
                        f3 = f13 / f14;
                        float f15 = f12 / f14;
                        this.rotation(collection, node.x, node.y, f3, f15);
                    }
                }
                for (Node node3 : collection) {
                    if (node3.x > f7) {
                        f7 = node3.x;
                    } else if (node3.x < f6) {
                        f6 = node3.x;
                    }
                    if (node3.y > f9) {
                        f9 = node3.y;
                    } else if (node3.y < f8) {
                        f8 = node3.y;
                    }
                    node3.isAccessed = bl;
                }
                HashMap hashMap3 = new HashMap();
                int n2 = 0;
                for (Node node4 : collection) {
                    ArrayList<Node> arrayList3 = new ArrayList<Node>();
                    for (Edge edge = node4.getFirstEdge(); edge != null; edge = edge.getNext(node4)) {
                        Node node5;
                        if (edge.isAccessed == this.edgeVisitedValue) continue;
                        edge.isAccessed = this.edgeVisitedValue;
                        Node node6 = node5 = edge.target == node4 ? edge.source : edge.target;
                        if (hashMap2.containsKey(node5.object.hashCode()) || node5.isAccessed == bl) continue;
                        node5.isAccessed = bl;
                        arrayList3.add(node5);
                        ++n2;
                    }
                    if (arrayList3.isEmpty()) continue;
                    hashMap3.put((int)Math.floor(node4.x * 10000.0f), arrayList3);
                }
                if (n2 > 0) {
                    Object object = new int[hashMap3.size()];
                    int n3 = 0;
                    Iterator iterator = hashMap3.keySet().iterator();
                    while (iterator.hasNext()) {
                        int n4 = (Integer)iterator.next();
                        object[n3] = n4;
                        ++n3;
                    }
                    Arrays.sort((int[])object);
                    for (Object object2 : object) {
                        ArrayList arrayList4 = (ArrayList)hashMap3.get((int)object2);
                        for (Node node7 : arrayList4) {
                            float[] fArray = this.treeForStructure(node7, arrayList, arrayList2, f5, f2 + f8 - f9 - GeneralPurposeLayout.this.yIdealDistance, hashMap, bl);
                            f4 += fArray[1];
                            f5 = fArray[0];
                        }
                    }
                }
                if (n2 == 0) {
                    float f16 = f7 - node.x;
                    this.translationXY(collection, f - f6, f2 - f9);
                    f16 = node.x + f16 + GeneralPurposeLayout.this.idealDistance;
                    float[] fArray = new float[]{f16, node.x};
                    return fArray;
                }
                float f17 = f7 - node.x;
                f3 = Math.max(f4 / (float)n2, f + node.x - f6);
                this.translationXY(collection, f3 - node.x, f2 - f9);
                f17 = node.x + f17 + GeneralPurposeLayout.this.idealDistance;
                f5 = Math.max(f17, f5);
                float[] fArray = new float[]{f5, node.x};
                return fArray;
            }

            private ArrayList<HashMap<Integer, Node>> goThroughLinkedNodes(Node node, Node node2, ArrayList<HashMap<Integer, Node>> arrayList, HashMap<Integer, Node> hashMap, boolean bl) {
                ArrayList<HashMap<Integer, Node>> arrayList2;
                if (node.isAccessed == bl) {
                    HashMap<Integer, Node> hashMap2 = new HashMap<Integer, Node>();
                    hashMap2.put(node.object.hashCode(), node);
                    ArrayList<HashMap<Integer, Node>> arrayList3 = new ArrayList<HashMap<Integer, Node>>();
                    arrayList3.add(hashMap2);
                    return arrayList3;
                }
                node.isAccessed = bl;
                boolean bl2 = false;
                HashMap<Integer, Node> hashMap3 = new HashMap<Integer, Node>();
                HashMap hashMap4 = new HashMap();
                HashMap hashMap5 = new HashMap();
                for (arrayList2 = node.getFirstEdge(); arrayList2 != null; arrayList2 = ((Edge)((Object)arrayList2)).getNext(node)) {
                    ArrayList<HashMap<Integer, Node>> arrayList4;
                    Node node3;
                    if (((Edge)((Object)arrayList2)).isAccessed == this.edgeVisitedValue) continue;
                    ((Edge)((Object)arrayList2)).isAccessed = this.edgeVisitedValue;
                    Node node4 = node3 = ((Edge)((Object)arrayList2)).source == node ? ((Edge)((Object)arrayList2)).target : ((Edge)((Object)arrayList2)).source;
                    if (node3 == node2 || (arrayList4 = this.goThroughLinkedNodes(node3, node, arrayList, hashMap, bl)).isEmpty()) continue;
                    if (arrayList4.size() >= 1) {
                        hashMap4.putAll(arrayList4.get(0));
                        bl2 = true;
                    }
                    if (arrayList4.size() < 2) continue;
                    hashMap3.putAll((Map)arrayList4.get(1));
                }
                if (!bl2) {
                    hashMap.put(node.object.hashCode(), node);
                    arrayList2 = new ArrayList();
                    return arrayList2;
                }
                hashMap3.put(node.object.hashCode(), node);
                if (hashMap4.containsKey(node.object.hashCode())) {
                    hashMap4.remove(node.object.hashCode());
                }
                if (hashMap4.isEmpty()) {
                    arrayList.add(hashMap3);
                    for (Node node3 : hashMap3.values()) {
                        node3.index = arrayList.size() - 1;
                    }
                    arrayList2 = new ArrayList<HashMap<Integer, Node>>();
                    return arrayList2;
                }
                arrayList2 = new ArrayList();
                arrayList2.add(hashMap4);
                arrayList2.add(hashMap3);
                return arrayList2;
            }

            private void identifyRootsAndTrees(ArrayList<HashMap<Integer, Node>> arrayList, HashMap<Integer, Integer> hashMap, HashMap<Integer, Node> hashMap2, Node node, Node node2, int n, boolean bl, boolean bl2) {
                block7: {
                    if (node.isAccessed != !bl2) break block7;
                    node.isAccessed = bl2;
                    if (hashMap2.containsKey(node.object.hashCode())) {
                        Node node3;
                        Object object;
                        if (bl) {
                            object = new HashMap<Integer, Node>();
                            ((HashMap)object).put(node.object.hashCode(), node);
                            arrayList.add((HashMap<Integer, Node>)object);
                            node.index = arrayList.size() - 1;
                            hashMap.put(node.object.hashCode(), arrayList.size() - 1);
                            n = arrayList.size() - 1;
                        } else {
                            node.index = n;
                            arrayList.get(n).put(node.object.hashCode(), node);
                        }
                        bl = false;
                        for (object = node.getFirstEdge(); object != null; object = ((Edge)object).getNext(node)) {
                            if (((Edge)object).isAccessed == this.edgeVisitedValue) continue;
                            Node node4 = node3 = ((Edge)object).target == node ? ((Edge)object).source : ((Edge)object).target;
                            if (node3 == node2 || hashMap2.containsKey(node3.object.hashCode())) continue;
                            bl = true;
                            break;
                        }
                        for (object = node.getFirstEdge(); object != null; object = ((Edge)object).getNext(node)) {
                            if (((Edge)object).isAccessed == this.edgeVisitedValue) continue;
                            ((Edge)object).isAccessed = this.edgeVisitedValue;
                            Node node5 = node3 = ((Edge)object).target == node ? ((Edge)object).source : ((Edge)object).target;
                            if (node3 == node2) continue;
                            this.identifyRootsAndTrees(arrayList, hashMap, hashMap2, node3, node, n, bl, bl2);
                        }
                    } else {
                        bl = true;
                        for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                            Node node6;
                            if (edge.isAccessed == this.edgeVisitedValue) continue;
                            edge.isAccessed = this.edgeVisitedValue;
                            Node node7 = node6 = edge.target == node ? edge.source : edge.target;
                            if (node6 == node2) continue;
                            this.identifyRootsAndTrees(arrayList, hashMap, hashMap2, node6, node, 0, bl, bl2);
                        }
                    }
                }
            }

            private void treeLikeLayout(HashMap<Integer, Node> hashMap, ArrayList<HashMap<Integer, Node>> arrayList, Node node, int n, boolean bl) {
                int n2;
                Node node2;
                Object object;
                HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
                ArrayList<HashMap<Integer, Node>> arrayList2 = new ArrayList<HashMap<Integer, Node>>();
                ArrayList<Object> arrayList3 = new ArrayList<HashMap<Integer, Node>>();
                block0: for (int i = 0; i < arrayList.size(); ++i) {
                    object = arrayList.get(i).values();
                    Iterator<Node> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        node2 = iterator.next();
                        if (GeneralPurposeLayout.this.oldNodes.containsKey(node2.object.hashCode())) continue;
                        arrayList3.add(arrayList.get(i));
                        continue block0;
                    }
                }
                this.identifyRootsAndTrees(arrayList2, hashMap2, hashMap, node, null, 0, true, bl);
                bl = !bl;
                this.edgeVisitedValue = !this.edgeVisitedValue;
                Set<Integer> set = hashMap2.keySet();
                object = set.iterator();
                while (object.hasNext()) {
                    int n3 = (Integer)object.next();
                    node2 = hashMap.get(n3);
                    n2 = hashMap2.get(n3);
                    this.subTree(node2, 0.0f, 0.0f, arrayList2.get(n2), bl);
                }
                boolean bl2 = false;
                if (arrayList3.isEmpty()) {
                    arrayList3 = arrayList;
                    bl2 = true;
                }
                if (GeneralPurposeLayout.this.fast) {
                    if (!bl2) {
                        for (int i = 0; i < arrayList3.size(); ++i) {
                            this.fastLoopLayout(arrayList.get(i), bl);
                        }
                    }
                } else {
                    int n4;
                    int n5 = 0;
                    int n6 = 0;
                    for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                        n4 = ((HashMap)arrayList3.get(n2)).size();
                        if (n4 <= 3) continue;
                        n5 += n4;
                        ++n6;
                    }
                    if (n <= n5 || n6 == 0) {
                        for (n2 = 0; n2 < arrayList.size(); ++n2) {
                            this.fastLoopLayout((HashMap)arrayList3.get(n2), bl);
                        }
                    } else {
                        float f = n / n5;
                        n4 = 0;
                        int n7 = 0;
                        for (int i = 0; i < arrayList3.size(); ++i) {
                            if (((HashMap)arrayList3.get(i)).size() <= 3) {
                                this.fastLoopLayout((HashMap)arrayList3.get(i), bl);
                                continue;
                            }
                            int n8 = n6 - n7 > 1 ? (int)Math.floor(f * (float)((HashMap)arrayList3.get(i)).size()) : n - n4;
                            this.loopLayout((HashMap)arrayList3.get(i), n8, bl, !bl2);
                            n4 += n8;
                            ++n7;
                        }
                    }
                }
                this.treeForStructure(node, arrayList2, arrayList, 0.0f, 0.0f, hashMap, bl);
                if (!bl2) {
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        Collection collection = ((HashMap)arrayList3.get(i)).values();
                        for (Node node3 : collection) {
                            GeneralPurposeLayout.this.oldNodes.put(node3.object.hashCode(), 0);
                        }
                    }
                }
                Collection<Node> collection = hashMap.values();
                for (Node node4 : collection) {
                    GeneralPurposeLayout.this.oldNodes.put(node4.object.hashCode(), 0);
                }
            }

            private int simulatedAnnealing(ArrayList<Node> arrayList, ArrayList<Node> arrayList2, int n, int n2, float f, float f2, float f3, boolean bl) {
                int n3;
                float f4;
                float f5;
                float f6 = f5 = (f4 = this.computeTotalEnergy(arrayList, bl, true));
                float f7 = f;
                float f8 = 1.0f;
                float f9 = 0.5f * (GeneralPurposeLayout.this.idealDistance - this.springLength) * (GeneralPurposeLayout.this.idealDistance - this.springLength) + 2.0f * this.forceConst / GeneralPurposeLayout.this.idealDistance;
                for (n3 = 0; n3 < n; ++n3) {
                    float[] fArray = this.stepSA(arrayList, arrayList2, f6, f5, f8, f9, f7, n2, bl);
                    f6 = fArray[0];
                    f5 = fArray[1];
                    f7 *= f2;
                    f8 *= f3;
                }
                if (f5 < f6) {
                    this.bestLayoutSA(arrayList);
                } else {
                    this.cleanSA(arrayList);
                }
                return n3;
            }

            private float[] stepSA(ArrayList<Node> arrayList, ArrayList<Node> arrayList2, float f, float f2, float f3, float f4, float f5, int n, boolean bl) {
                float f6 = f;
                float f7 = f2;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        Node node = arrayList2.get(j);
                        float f8 = 3.0f * GeneralPurposeLayout.this.idealDistance;
                        float f9 = f3 * f8 + GeneralPurposeLayout.this.idealDistance / 5.0f;
                        float f10 = node.x + (2.0f * (float)Math.random() - 1.0f) * f9;
                        float f11 = node.y + (2.0f * (float)Math.random() - 1.0f) * f9;
                        float f12 = node.initialX;
                        float f13 = this.computeModifiedEnergy(arrayList, node, f10, f11, bl);
                        if (f13 < f12) {
                            this.modifyPosition(arrayList, node, f10, f11, bl);
                            f6 += f13 - f12;
                            if (!(f6 < f7)) continue;
                            f7 = f6;
                            this.elitism(arrayList2);
                            continue;
                        }
                        float f14 = (float)Math.random();
                        if (!(Math.exp((f12 - f13) / (f4 * f5)) >= (double)f14)) continue;
                        this.modifyPosition(arrayList, node, f10, f11, bl);
                        f6 += f13 - f12;
                    }
                }
                float[] fArray = new float[]{f6, f7};
                return fArray;
            }

            private int simulatedAnnealingHM(HashMap<Integer, Node> hashMap, Node[] nodeArray, int n, int n2, float f, float f2, float f3, boolean bl) {
                int n3;
                float f4;
                float f5;
                float f6 = f5 = (f4 = this.computeTotalEnergyHM(hashMap, bl, true));
                float f7 = f;
                float f8 = 1.0f;
                float f9 = 0.5f * (GeneralPurposeLayout.this.idealDistance - this.springLength) * (GeneralPurposeLayout.this.idealDistance - this.springLength) + 2.0f * this.forceConst / GeneralPurposeLayout.this.idealDistance;
                for (n3 = 0; n3 < n; ++n3) {
                    float[] fArray = this.stepSAHM(hashMap, nodeArray, f6, f5, f8, f9, f7, n2, bl);
                    f6 = fArray[0];
                    f5 = fArray[1];
                    f7 *= f2;
                    f8 *= f3;
                }
                if (f5 < f6) {
                    this.bestLayoutSA(nodeArray);
                } else {
                    this.cleanSA(nodeArray);
                }
                return n3;
            }

            private float[] stepSAHM(HashMap<Integer, Node> hashMap, Node[] nodeArray, float f, float f2, float f3, float f4, float f5, int n, boolean bl) {
                float f6 = f;
                float f7 = f2;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < hashMap.size(); ++j) {
                        Node node = nodeArray[j];
                        float f8 = 3.0f * GeneralPurposeLayout.this.idealDistance;
                        float f9 = f3 * f8 + GeneralPurposeLayout.this.idealDistance / 5.0f;
                        float f10 = node.x + (2.0f * (float)Math.random() - 1.0f) * f9;
                        float f11 = node.y + (2.0f * (float)Math.random() - 1.0f) * f9;
                        float f12 = node.initialX;
                        float f13 = this.computeModifiedEnergyHM(hashMap, nodeArray, node, f10, f11, bl);
                        if (f13 < f12) {
                            this.modifyPositionHM(hashMap, nodeArray, node, f10, f11, bl);
                            f6 += f13 - f12;
                            if (!(f6 < f7)) continue;
                            f7 = f6;
                            this.elitism(nodeArray);
                            continue;
                        }
                        float f14 = (float)Math.random();
                        if (!(Math.exp((f12 - f13) / (f4 * f5)) >= (double)f14)) continue;
                        this.modifyPositionHM(hashMap, nodeArray, node, f10, f11, bl);
                        f6 += f13 - f12;
                    }
                }
                float[] fArray = new float[]{f6, f7};
                return fArray;
            }

            void bestLayoutSA(ArrayList<Node> arrayList) {
                for (Node node : arrayList) {
                    node.x = node.finalX;
                    node.y = node.finalY;
                    node.finalX = 0.0f;
                    node.finalY = 0.0f;
                }
            }

            void bestLayoutSA(Node[] nodeArray) {
                for (Node node : nodeArray) {
                    node.x = node.finalX;
                    node.y = node.finalY;
                    node.finalX = 0.0f;
                    node.finalY = 0.0f;
                }
            }

            private void elitism(ArrayList<Node> arrayList) {
                for (Node node : arrayList) {
                    node.finalX = node.x;
                    node.finalY = node.y;
                }
            }

            private void elitism(Node[] nodeArray) {
                for (Node node : nodeArray) {
                    node.finalX = node.x;
                    node.finalY = node.y;
                }
            }

            void cleanSA(Node[] nodeArray) {
                for (Node node : nodeArray) {
                    node.finalX = 0.0f;
                    node.finalY = 0.0f;
                    node.initialX = 0.0f;
                }
            }

            void cleanSA(ArrayList<Node> arrayList) {
                for (Node node : arrayList) {
                    node.finalX = 0.0f;
                    node.finalY = 0.0f;
                    node.initialX = 0.0f;
                }
            }

            private float computeTotalEnergy(ArrayList<Node> arrayList, boolean bl, boolean bl2) {
                float f = 0.0f;
                for (int i = 0; i < arrayList.size() - 1; ++i) {
                    float f2;
                    float f3;
                    Node node;
                    Node node2 = arrayList.get(i);
                    for (Edge edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                        if (edge.isAccessed == this.edgeVisitedValue) continue;
                        edge.isAccessed = this.edgeVisitedValue;
                        node = edge.source == node2 ? edge.target : edge.source;
                        node.isAccessed = bl;
                        f3 = (float)Math.sqrt((node.x - node2.x) * (node.x - node2.x) + (node.y - node2.y) * (node.y - node2.y));
                        if (f3 <= this.criticalDistance) {
                            f3 = this.criticalDistance;
                        }
                        f2 = 0.25f * (f3 - this.springLength) * (f3 - this.springLength) + this.forceConst / f3;
                        node2.initialX += f2;
                        node.initialX += f2;
                        f += f2;
                    }
                    for (int j = i + 1; j < arrayList.size(); ++j) {
                        node = arrayList.get(j);
                        if (node.isAccessed == bl) {
                            node.isAccessed = !bl;
                            continue;
                        }
                        f3 = (float)Math.sqrt((node.x - node2.x) * (node.x - node2.x) + (node.y - node2.y) * (node.y - node2.y));
                        if (f3 <= this.criticalDistance) {
                            f3 = this.criticalDistance;
                        }
                        f2 = this.forceConst / f3;
                        node.initialX += f2;
                        node2.initialX += f2;
                        f += f2;
                    }
                }
                boolean bl3 = this.edgeVisitedValue = !this.edgeVisitedValue;
                if (bl2) {
                    for (Node node2 : arrayList) {
                        node2.finalX = node2.x;
                        node2.finalY = node2.y;
                    }
                }
                return f;
            }

            /*
             * WARNING - void declaration
             */
            private float computeTotalEnergyHM(HashMap<Integer, Node> hashMap, boolean bl, boolean bl2) {
                void var7_10;
                float f = 0.0f;
                Node[] nodeArray = new Node[hashMap.size()];
                hashMap.values().toArray(nodeArray);
                for (int i = 0; i < nodeArray.length - 1; ++i) {
                    float f2;
                    float f3;
                    Node node;
                    Node object = nodeArray[i];
                    for (Edge edge = object.getFirstEdge(); edge != null; edge = edge.getNext(object)) {
                        Node node2 = node = edge.source == object ? edge.target : edge.source;
                        if (!hashMap.containsKey(node.object.hashCode())) continue;
                        if (edge.isAccessed == this.edgeVisitedValue) {
                            edge.isAccessed = !this.edgeVisitedValue;
                            continue;
                        }
                        edge.isAccessed = this.edgeVisitedValue;
                        node.isAccessed = bl;
                        f3 = (float)Math.sqrt((node.x - object.x) * (node.x - object.x) + (node.y - object.y) * (node.y - object.y));
                        if (f3 <= this.criticalDistance) {
                            f3 = this.criticalDistance;
                        }
                        f2 = 0.25f * (f3 - this.springLength) * (f3 - this.springLength) + this.forceConst / f3;
                        object.initialX += f2;
                        node.initialX += f2;
                        f += f2;
                    }
                    for (int j = i + 1; j < nodeArray.length; ++j) {
                        node = nodeArray[j];
                        if (node.isAccessed == bl) {
                            node.isAccessed = !bl;
                            continue;
                        }
                        f3 = (float)Math.sqrt((node.x - object.x) * (node.x - object.x) + (node.y - object.y) * (node.y - object.y));
                        if (f3 <= this.criticalDistance) {
                            f3 = this.criticalDistance;
                        }
                        f2 = this.forceConst / f3;
                        node.initialX += f2;
                        object.initialX += f2;
                        f += f2;
                    }
                }
                Node node = nodeArray[nodeArray.length - 1];
                Edge edge = node.getFirstEdge();
                while (var7_10 != null) {
                    var7_10.isAccessed = !this.edgeVisitedValue;
                    Edge edge2 = var7_10.getNext(node);
                }
                if (bl2) {
                    for (Node node3 : nodeArray) {
                        node3.finalX = node3.x;
                        node3.finalY = node3.y;
                    }
                }
                return f;
            }

            private float computeModifiedEnergy(ArrayList<Node> arrayList, Node node, float f, float f2, boolean bl) {
                float f3;
                float f4 = 0.0f;
                for (Object object = node.getFirstEdge(); object != null; object = ((Edge)object).getNext(node)) {
                    Node node2 = ((Edge)object).source == node ? ((Edge)object).target : ((Edge)object).source;
                    node2.isAccessed = bl;
                    f3 = (float)Math.sqrt((node2.x - f) * (node2.x - f) + (node2.y - f2) * (node2.y - f2));
                    if (f3 <= this.criticalDistance) {
                        f3 = this.criticalDistance;
                    }
                    f4 += 0.25f * (f3 - this.springLength) * (f3 - this.springLength) + this.forceConst / f3;
                }
                for (Node node2 : arrayList) {
                    if (node2 == node) continue;
                    if (node2.isAccessed == bl) {
                        node2.isAccessed = !bl;
                        continue;
                    }
                    f3 = (float)Math.sqrt((node2.x - f) * (node2.x - f) + (node2.y - f2) * (node2.y - f2));
                    if (f3 <= this.criticalDistance) {
                        f3 = this.criticalDistance;
                    }
                    f4 += this.forceConst / f3;
                }
                return f4;
            }

            /*
             * WARNING - void declaration
             */
            private float computeModifiedEnergyHM(HashMap<Integer, Node> hashMap, Node[] nodeArray, Node node, float f, float f2, boolean bl) {
                void var8_9;
                float f3 = 0.0f;
                Edge object = node.getFirstEdge();
                while (var8_9 != null) {
                    Node node2;
                    Node node3 = node2 = var8_9.source == node ? var8_9.target : var8_9.source;
                    if (hashMap.containsKey(node2.object.hashCode())) {
                        node2.isAccessed = bl;
                        float f4 = (float)Math.sqrt((node2.x - f) * (node2.x - f) + (node2.y - f2) * (node2.y - f2));
                        if (f4 <= this.criticalDistance) {
                            f4 = this.criticalDistance;
                        }
                        f3 += 0.25f * (f4 - this.springLength) * (f4 - this.springLength) + this.forceConst / f4;
                    }
                    Edge edge = var8_9.getNext(node);
                }
                for (Node node4 : nodeArray) {
                    if (node4 == node) continue;
                    if (node4.isAccessed == bl) {
                        node4.isAccessed = !bl;
                        continue;
                    }
                    float f5 = (float)Math.sqrt((node4.x - f) * (node4.x - f) + (node4.y - f2) * (node4.y - f2));
                    if (f5 <= this.criticalDistance) {
                        f5 = this.criticalDistance;
                    }
                    f3 += this.forceConst / f5;
                }
                return f3;
            }

            private void modifyPosition(ArrayList<Node> arrayList, Node node, float f, float f2, boolean bl) {
                float f3;
                float f4;
                float f5;
                node.initialX = 0.0f;
                for (Object object = node.getFirstEdge(); object != null; object = ((Edge)object).getNext(node)) {
                    Node node2 = ((Edge)object).source == node ? ((Edge)object).target : ((Edge)object).source;
                    node2.isAccessed = bl;
                    f5 = (float)Math.sqrt((node2.x - f) * (node2.x - f) + (node2.y - f2) * (node2.y - f2));
                    f4 = (float)Math.sqrt((node2.x - node.x) * (node2.x - node.x) + (node2.y - node.y) * (node2.y - node.y));
                    if (f5 <= this.criticalDistance) {
                        f5 = this.criticalDistance;
                    }
                    if (f4 <= this.criticalDistance) {
                        f4 = this.criticalDistance;
                    }
                    f3 = 0.25f * (f5 - this.springLength) * (f5 - this.springLength) + this.forceConst / f5;
                    node2.initialX += -0.25f * (f4 - this.springLength) * (f4 - this.springLength) - this.forceConst / f4 + f3;
                    node.initialX += f3;
                }
                for (Node node2 : arrayList) {
                    if (node2 == node) continue;
                    if (node2.isAccessed == bl) {
                        node2.isAccessed = !bl;
                        continue;
                    }
                    f5 = (float)Math.sqrt((node2.x - f) * (node2.x - f) + (node2.y - f2) * (node2.y - f2));
                    f4 = (float)Math.sqrt((node2.x - node.x) * (node2.x - node.x) + (node2.y - node.y) * (node2.y - node.y));
                    if (f5 <= this.criticalDistance) {
                        f5 = this.criticalDistance;
                    }
                    if (f4 <= this.criticalDistance) {
                        f4 = this.criticalDistance;
                    }
                    f3 = this.forceConst / f5;
                    node2.initialX += -this.forceConst / f4 + f3;
                    node.initialX += f3;
                }
                node.x = f;
                node.y = f2;
            }

            /*
             * WARNING - void declaration
             */
            private void modifyPositionHM(HashMap<Integer, Node> hashMap, Node[] nodeArray, Node node, float f, float f2, boolean bl) {
                float f3;
                void var7_8;
                node.initialX = 0.0f;
                Edge object = node.getFirstEdge();
                while (var7_8 != null) {
                    Node node2;
                    Node node3 = node2 = var7_8.source == node ? var7_8.target : var7_8.source;
                    if (hashMap.containsKey(node2.object.hashCode())) {
                        node2.isAccessed = bl;
                        float f4 = (float)Math.sqrt((node2.x - f) * (node2.x - f) + (node2.y - f2) * (node2.y - f2));
                        float f5 = (float)Math.sqrt((node2.x - node.x) * (node2.x - node.x) + (node2.y - node.y) * (node2.y - node.y));
                        if (f4 <= this.criticalDistance) {
                            f4 = this.criticalDistance;
                        }
                        if (f5 <= this.criticalDistance) {
                            f5 = this.criticalDistance;
                        }
                        f3 = 0.25f * (f4 - this.springLength) * (f4 - this.springLength) + this.forceConst / f4;
                        node2.initialX += -0.25f * (f5 - this.springLength) * (f5 - this.springLength) - this.forceConst / f5 + f3;
                        node.initialX += f3;
                    }
                    Edge edge = var7_8.getNext(node);
                }
                for (Node node4 : nodeArray) {
                    if (node4 == node) continue;
                    if (node4.isAccessed == bl) {
                        node4.isAccessed = !bl;
                        continue;
                    }
                    f3 = (float)Math.sqrt((node4.x - f) * (node4.x - f) + (node4.y - f2) * (node4.y - f2));
                    float f6 = (float)Math.sqrt((node4.x - node.x) * (node4.x - node.x) + (node4.y - node.y) * (node4.y - node.y));
                    if (f3 <= this.criticalDistance) {
                        f3 = this.criticalDistance;
                    }
                    if (f6 <= this.criticalDistance) {
                        f6 = this.criticalDistance;
                    }
                    float f7 = this.forceConst / f3;
                    node4.initialX += -this.forceConst / f6 + f7;
                    node.initialX += f7;
                }
                node.x = f;
                node.y = f2;
            }

            private int newtonPlacement(ArrayList<Node> arrayList, ArrayList<Node> arrayList2, int n, float f, boolean bl) {
                int n2 = 0;
                this.computeTotalEnergy(arrayList2, bl, false);
                while (n2 < n) {
                    int n3 = this.initOptimisation(arrayList2, arrayList, bl);
                    Node node = arrayList2.get(n3);
                    float f2 = node.finalX;
                    node.finalX = 0.0f;
                    if (f2 < f) break;
                    boolean bl2 = true;
                    boolean bl3 = node.isAccessed;
                    float f3 = node.initialX;
                    float f4 = node.x;
                    float f5 = node.y;
                    while (bl2 && n2 < n) {
                        f3 = this.newtonOpimisationStep(arrayList2, node, f3, f, bl);
                        bl2 = node.isAccessed;
                        ++n2;
                    }
                    float f6 = node.x;
                    float f7 = node.y;
                    node.x = f4;
                    node.y = f5;
                    this.modifyPosition(arrayList2, node, f6, f7, bl);
                    node.isAccessed = bl3;
                }
                this.cleanNewton(arrayList2);
                return n2;
            }

            private int newtonOptimisationHM(HashMap<Integer, Node> hashMap, Node[] nodeArray, int n, float f, boolean bl) {
                int n2 = 0;
                this.computeTotalEnergyHM(hashMap, bl, false);
                while (n2 < n) {
                    int n3 = this.initOptimisationHM(hashMap, nodeArray, bl);
                    Node node = nodeArray[n3];
                    float f2 = node.finalX;
                    node.finalX = 0.0f;
                    if (f2 < f) break;
                    boolean bl2 = true;
                    boolean bl3 = node.isAccessed;
                    float f3 = node.initialX;
                    float f4 = node.x;
                    float f5 = node.y;
                    while (bl2 && n2 < n) {
                        f3 = this.newtonOpimisationStepHM(hashMap, nodeArray, node, f3, f, bl);
                        bl2 = node.isAccessed;
                        ++n2;
                    }
                    node.isAccessed = bl3;
                    float f6 = node.x;
                    float f7 = node.y;
                    node.x = f4;
                    node.y = f5;
                    this.modifyPositionHM(hashMap, nodeArray, node, f6, f7, bl);
                }
                this.cleanNewton(nodeArray);
                return n2;
            }

            private int initOptimisation(ArrayList<Node> arrayList, ArrayList<Node> arrayList2, boolean bl) {
                float f = 0.0f;
                int n = 1;
                int n2 = arrayList.size() - arrayList2.size();
                for (int i = 0; i < arrayList.size() - 1; ++i) {
                    float f2;
                    float f3;
                    float f4;
                    float f5;
                    float f6;
                    float f7;
                    float f8;
                    Node node;
                    Node node2 = arrayList.get(i);
                    for (Edge edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                        if (edge.isAccessed == this.edgeVisitedValue) continue;
                        edge.isAccessed = this.edgeVisitedValue;
                        node = edge.source == node2 ? edge.target : edge.source;
                        node.isAccessed = bl;
                        f8 = node2.x - node.x;
                        f7 = node2.y - node.y;
                        f6 = f8 * f8 + f7 * f7;
                        f5 = (float)Math.sqrt(f6);
                        if (f5 <= this.criticalDistance) {
                            f5 = this.criticalDistance;
                            f6 = this.criticalDistance * this.criticalDistance;
                            f4 = f8 != 0.0f ? Math.signum(f8) : (float)Math.signum(2.0 * Math.random() - 1.0);
                            f3 = f7 != 0.0f ? Math.signum(f7) : (float)Math.signum(2.0 * Math.random() - 1.0);
                            f8 = f4 * this.criticalDistance / (float)Math.sqrt(2.0);
                            f7 = f3 * this.criticalDistance / (float)Math.sqrt(2.0);
                        }
                        f4 = 0.5f * (f5 - this.springLength) - this.forceConst / f6;
                        f3 = f4 * f8 / f5;
                        f2 = f4 * f7 / f5;
                        node2.finalX += f3;
                        node2.finalY += f2;
                        node.finalX += -f3;
                        node.finalY += -f2;
                    }
                    for (int j = i + 1; j < arrayList.size(); ++j) {
                        node = arrayList.get(j);
                        if (node.isAccessed == bl) {
                            node.isAccessed = !bl;
                            continue;
                        }
                        f8 = node2.x - node.x;
                        f7 = node2.y - node.y;
                        f6 = f8 * f8 + f7 * f7;
                        f5 = (float)Math.sqrt(f6);
                        if (f5 <= this.criticalDistance) {
                            f5 = this.criticalDistance;
                            f6 = this.criticalDistance * this.criticalDistance;
                            f4 = f8 != 0.0f ? Math.signum(f8) : (float)Math.signum(2.0 * Math.random() - 1.0);
                            f3 = f7 != 0.0f ? Math.signum(f7) : (float)Math.signum(2.0 * Math.random() - 1.0);
                            f8 = f4 * this.criticalDistance / (float)Math.sqrt(2.0);
                            f7 = f3 * this.criticalDistance / (float)Math.sqrt(2.0);
                        }
                        f4 = -this.forceConst / f6;
                        f3 = f4 * f8 / f5;
                        f2 = f4 * f7 / f5;
                        node2.finalX += f3;
                        node2.finalY += f2;
                        node.finalX += -f3;
                        node.finalY += -f2;
                    }
                    float f9 = node2.finalX * node2.finalX + node2.finalY * node2.finalY;
                    if (n2 <= i && f9 > f) {
                        n = i;
                        f = f9;
                    }
                    node2.finalX = 0.0f;
                    node2.finalY = 0.0f;
                }
                Node node = arrayList.get(arrayList.size() - 1);
                if (node.finalX * node.finalX + node.finalY * node.finalY > f) {
                    n = arrayList.size() - 1;
                    f = node.finalX * node.finalX + node.finalY * node.finalY;
                }
                node.finalX = 0.0f;
                node.finalY = 0.0f;
                arrayList.get((int)n).finalX = f;
                this.edgeVisitedValue = !this.edgeVisitedValue;
                return n;
            }

            private int initOptimisationHM(HashMap<Integer, Node> hashMap, Node[] nodeArray, boolean bl) {
                Object object;
                float f = 0.0f;
                int n = 1;
                for (int i = 0; i < nodeArray.length - 1; ++i) {
                    float f2;
                    float f3;
                    float f4;
                    float f5;
                    float f6;
                    float f7;
                    float f8;
                    Node node;
                    object = nodeArray[i];
                    for (Edge edge = ((Node)((Object)object)).getFirstEdge(); edge != null; edge = edge.getNext((Node)((Object)object))) {
                        Node node2 = node = edge.source == object ? edge.target : edge.source;
                        if (!hashMap.containsKey(node.object.hashCode())) continue;
                        if (edge.isAccessed == this.edgeVisitedValue) {
                            edge.isAccessed = !this.edgeVisitedValue;
                            continue;
                        }
                        edge.isAccessed = this.edgeVisitedValue;
                        node.isAccessed = bl;
                        f8 = ((Node)((Object)object)).x - node.x;
                        f7 = ((Node)((Object)object)).y - node.y;
                        f6 = f8 * f8 + f7 * f7;
                        f5 = (float)Math.sqrt(f6);
                        if (f5 <= this.criticalDistance) {
                            f5 = this.criticalDistance;
                            f6 = this.criticalDistance * this.criticalDistance;
                            f4 = f8 != 0.0f ? Math.signum(f8) : (float)Math.signum(2.0 * Math.random() - 1.0);
                            f3 = f7 != 0.0f ? Math.signum(f7) : (float)Math.signum(2.0 * Math.random() - 1.0);
                            f8 = f4 * this.criticalDistance / (float)Math.sqrt(2.0);
                            f7 = f3 * this.criticalDistance / (float)Math.sqrt(2.0);
                        }
                        f4 = 0.5f * (f5 - this.springLength) - this.forceConst / f6;
                        f3 = f4 * f8 / f5;
                        f2 = f4 * f7 / f5;
                        ((Node)((Object)object)).finalX += f3;
                        ((Node)((Object)object)).finalY += f2;
                        node.finalX += -f3;
                        node.finalY += -f2;
                    }
                    for (int j = i + 1; j < nodeArray.length; ++j) {
                        node = nodeArray[j];
                        if (node.isAccessed == bl) {
                            node.isAccessed = !bl;
                            continue;
                        }
                        f8 = ((Node)((Object)object)).x - node.x;
                        f7 = ((Node)((Object)object)).y - node.y;
                        f6 = f8 * f8 + f7 * f7;
                        f5 = (float)Math.sqrt(f6);
                        if (f5 <= this.criticalDistance) {
                            f5 = this.criticalDistance;
                            f6 = this.criticalDistance * this.criticalDistance;
                            f4 = f8 != 0.0f ? Math.signum(f8) : (float)Math.signum(2.0 * Math.random() - 1.0);
                            f3 = f7 != 0.0f ? Math.signum(f7) : (float)Math.signum(2.0 * Math.random() - 1.0);
                            f8 = f4 * this.criticalDistance / (float)Math.sqrt(2.0);
                            f7 = f3 * this.criticalDistance / (float)Math.sqrt(2.0);
                        }
                        f4 = -this.forceConst / f6;
                        f3 = f4 * f8 / f5;
                        f2 = f4 * f7 / f5;
                        ((Node)((Object)object)).finalX += f3;
                        ((Node)((Object)object)).finalY += f2;
                        node.finalX += -f3;
                        node.finalY += -f2;
                    }
                    float f9 = ((Node)((Object)object)).finalX * ((Node)((Object)object)).finalX + ((Node)((Object)object)).finalY * ((Node)((Object)object)).finalY;
                    if (f9 > f) {
                        n = i;
                        f = f9;
                    }
                    ((Node)((Object)object)).finalX = 0.0f;
                    ((Node)((Object)object)).finalY = 0.0f;
                }
                Node node = nodeArray[nodeArray.length - 1];
                if (node.finalX * node.finalX + node.finalY * node.finalY > f) {
                    n = nodeArray.length - 1;
                    f = node.finalX * node.finalX + node.finalY * node.finalY;
                }
                node.finalX = 0.0f;
                node.finalY = 0.0f;
                for (object = node.getFirstEdge(); object != null; object = ((Edge)object).getNext(node)) {
                    ((Edge)object).isAccessed = !this.edgeVisitedValue;
                }
                nodeArray[n].finalX = f;
                return n;
            }

            private void computeGradientHessian(ArrayList<Node> arrayList, Node node, boolean bl) {
                float f;
                float f2;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                float f9;
                float f10;
                float f11;
                for (Object object = node.getFirstEdge(); object != null; object = ((Edge)object).getNext(node)) {
                    Node node2 = ((Edge)object).source == node ? ((Edge)object).target : ((Edge)object).source;
                    node2.isAccessed = bl;
                    f11 = node.x - node2.x;
                    f10 = f11 * f11;
                    f9 = node.y - node2.y;
                    f8 = f9 * f9;
                    f7 = f10 + f8;
                    f6 = (float)Math.sqrt(f7);
                    if (f6 <= this.criticalDistance) {
                        f6 = this.criticalDistance;
                        f7 = this.criticalDistance * this.criticalDistance;
                        f5 = f11 != 0.0f ? Math.signum(f11) : (float)Math.signum(2.0 * Math.random() - 1.0);
                        f4 = f9 != 0.0f ? Math.signum(f9) : (float)Math.signum(2.0 * Math.random() - 1.0);
                        f11 = f5 * this.criticalDistance / (float)Math.sqrt(2.0);
                        f9 = f4 * this.criticalDistance / (float)Math.sqrt(2.0);
                    }
                    f5 = 0.5f * (f6 - this.springLength);
                    f4 = 0.5f * this.springLength;
                    f3 = 0.5f * (1.0f - this.springLength / f6);
                    f2 = this.forceConst / f7;
                    node.finalX += (f5 += -f2) * f11 / f6;
                    node.finalY += f5 * f9 / f6;
                    f = (f4 += 3.0f * f2) * f10 - this.forceConst;
                    float f12 = f4 * f8 - this.forceConst;
                    f2 = f6 * f7;
                    node.layoutVarX += f / f2 + f3;
                    node.layoutVarY += f12 / f2 + f3;
                    node.initialY += f4 / f2 * f11 * f9;
                }
                for (Node node2 : arrayList) {
                    if (node2 == node) continue;
                    if (node2.isAccessed == bl) {
                        node2.isAccessed = !bl;
                        continue;
                    }
                    f11 = node.x - node2.x;
                    f10 = f11 * f11;
                    f9 = node.y - node2.y;
                    f8 = f9 * f9;
                    f7 = f10 + f8;
                    f6 = (float)Math.sqrt(f7);
                    if (f6 <= this.criticalDistance) {
                        f6 = this.criticalDistance;
                        f7 = this.criticalDistance * this.criticalDistance;
                        f5 = f11 != 0.0f ? Math.signum(f11) : (float)Math.signum(2.0 * Math.random() - 1.0);
                        f4 = f9 != 0.0f ? Math.signum(f9) : (float)Math.signum(2.0 * Math.random() - 1.0);
                        f11 = f5 * this.criticalDistance / (float)Math.sqrt(2.0);
                        f9 = f4 * this.criticalDistance / (float)Math.sqrt(2.0);
                    }
                    f5 = this.forceConst / f7;
                    f4 = -f5;
                    f3 = 3.0f * f5;
                    node.finalX += f4 * f11 / f6;
                    node.finalY += f4 * f9 / f6;
                    f2 = f3 * f10 - this.forceConst;
                    f = f3 * f8 - this.forceConst;
                    f5 = f6 * f7;
                    node.layoutVarX += f2 / f5;
                    node.layoutVarY += f / f5;
                    node.initialY += f3 / f5 * f11 * f9;
                }
            }

            private void computeGradientHessianHM(HashMap<Integer, Node> hashMap, Node node, boolean bl) {
                float f;
                float f2;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                float f9;
                float f10;
                float f11;
                Collection<Node> collection = hashMap.values();
                for (Object object = node.getFirstEdge(); object != null; object = ((Edge)object).getNext(node)) {
                    Node node2;
                    Node node3 = node2 = ((Edge)object).source == node ? ((Edge)object).target : ((Edge)object).source;
                    if (!hashMap.containsKey(node2.object.hashCode())) continue;
                    node2.isAccessed = bl;
                    f11 = node.x - node2.x;
                    f10 = f11 * f11;
                    f9 = node.y - node2.y;
                    f8 = f9 * f9;
                    f7 = f10 + f8;
                    f6 = (float)Math.sqrt(f7);
                    if (f6 <= this.criticalDistance) {
                        f6 = this.criticalDistance;
                        f7 = this.criticalDistance * this.criticalDistance;
                        f5 = f11 != 0.0f ? Math.signum(f11) : (float)Math.signum(2.0 * Math.random() - 1.0);
                        f4 = f9 != 0.0f ? Math.signum(f9) : (float)Math.signum(2.0 * Math.random() - 1.0);
                        f11 = f5 * this.criticalDistance / (float)Math.sqrt(2.0);
                        f9 = f4 * this.criticalDistance / (float)Math.sqrt(2.0);
                    }
                    f5 = 0.5f * (f6 - this.springLength);
                    f4 = 0.5f * this.springLength;
                    f3 = 0.5f * (1.0f - this.springLength / f6);
                    f2 = this.forceConst / f7;
                    node.finalX += (f5 += -f2) * f11 / f6;
                    node.finalY += f5 * f9 / f6;
                    f = (f4 += 3.0f * f2) * f10 - this.forceConst;
                    float f12 = f4 * f8 - this.forceConst;
                    f2 = f6 * f7;
                    node.layoutVarX += f / f2 + f3;
                    node.layoutVarY += f12 / f2 + f3;
                    node.initialY += f4 / f2 * f11 * f9;
                }
                for (Node node2 : collection) {
                    if (node2 == node) continue;
                    if (node2.isAccessed == bl) {
                        node2.isAccessed = !bl;
                        continue;
                    }
                    f11 = node.x - node2.x;
                    f10 = f11 * f11;
                    f9 = node.y - node2.y;
                    f8 = f9 * f9;
                    f7 = f10 + f8;
                    f6 = (float)Math.sqrt(f7);
                    if (f6 <= this.criticalDistance) {
                        f6 = this.criticalDistance;
                        f7 = this.criticalDistance * this.criticalDistance;
                        f5 = f11 != 0.0f ? Math.signum(f11) : (float)Math.signum(2.0 * Math.random() - 1.0);
                        f4 = f9 != 0.0f ? Math.signum(f9) : (float)Math.signum(2.0 * Math.random() - 1.0);
                        f11 = f5 * this.criticalDistance / (float)Math.sqrt(2.0);
                        f9 = f4 * this.criticalDistance / (float)Math.sqrt(2.0);
                    }
                    f5 = this.forceConst / f7;
                    f4 = -f5;
                    f3 = 3.0f * f5;
                    node.finalX += f4 * f11 / f6;
                    node.finalY += f4 * f9 / f6;
                    f2 = f3 * f10 - this.forceConst;
                    f = f3 * f8 - this.forceConst;
                    f5 = f6 * f7;
                    node.layoutVarX += f2 / f5;
                    node.layoutVarY += f / f5;
                    node.initialY += f3 / f5 * f11 * f9;
                }
            }

            private float newtonOpimisationStep(ArrayList<Node> arrayList, Node node, float f, float f2, boolean bl) {
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                float f9;
                float f10;
                float f11;
                float f12;
                this.computeGradientHessian(arrayList, node, bl);
                float f13 = node.finalX;
                float f14 = node.finalY;
                float f15 = node.layoutVarX;
                float f16 = node.layoutVarY;
                float f17 = node.initialY;
                node.finalX = 0.0f;
                node.finalY = 0.0f;
                node.layoutVarX = 0.0f;
                node.layoutVarY = 0.0f;
                node.initialY = 0.0f;
                if (f13 * f13 + f14 * f14 < f2) {
                    node.isAccessed = false;
                    return -1.0f;
                }
                float f18 = f17 * f17;
                float f19 = (f15 - f16) * (f15 - f16) + 4.0f * f18;
                float f20 = 0.5f * (f15 + f16 + f19);
                float f21 = 0.5f * (f15 + f16 - f19);
                float f22 = 1.0E-5f;
                if (f20 >= f22 && f21 >= f22) {
                    f12 = f15 * f16 - f18;
                    f11 = f16 / f12;
                    f10 = f15 / f12;
                    f9 = -f17 / f12;
                } else {
                    f12 = (f20 - f15) * (f20 - f15);
                    f8 = (f21 - f15) * (f21 - f15);
                    f7 = f18 + f12;
                    f6 = f18 + f8;
                    f5 = (float)Math.sqrt(f7);
                    f4 = (float)Math.sqrt(f6);
                    f20 = Math.max(f22, Math.abs(f20));
                    f21 = Math.max(f22, Math.abs(f21));
                    f3 = f18 / f20;
                    f11 = (f3 + f12 / f21) / f7;
                    f10 = (f3 + f8 / f21) / f6;
                    f9 = (f3 + (f20 - f15) * (f21 - f15) / f21) / (f5 * f4);
                }
                f12 = -f11 * f13 - f9 * f14;
                f8 = -f9 * f13 - f10 * f14;
                f7 = 1.0f;
                f6 = 0.001f;
                f5 = 0.7f;
                f4 = node.x + f7 * f12;
                f3 = node.y + f7 * f8;
                float f23 = this.computeModifiedEnergy(arrayList, node, f4, f3, bl);
                for (int i = 0; f23 > f + f7 * f6 * (f12 * f13 + f8 * f14) && i < 30; ++i) {
                    f7 = f5 * f7;
                    f4 = node.x + f7 * f12;
                    f3 = node.y + f7 * f8;
                    f23 = this.computeModifiedEnergy(arrayList, node, f4, f3, bl);
                }
                node.x = f4;
                node.y = f3;
                node.isAccessed = true;
                return f23;
            }

            private float newtonOpimisationStepHM(HashMap<Integer, Node> hashMap, Node[] nodeArray, Node node, float f, float f2, boolean bl) {
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                float f9;
                float f10;
                float f11;
                float f12;
                this.computeGradientHessianHM(hashMap, node, bl);
                float f13 = node.finalX;
                float f14 = node.finalY;
                float f15 = node.layoutVarX;
                float f16 = node.layoutVarY;
                float f17 = node.initialY;
                node.finalX = 0.0f;
                node.finalY = 0.0f;
                node.layoutVarX = 0.0f;
                node.layoutVarY = 0.0f;
                node.initialY = 0.0f;
                if (f13 * f13 + f14 * f14 < f2) {
                    node.isAccessed = false;
                    return -1.0f;
                }
                float f18 = f17 * f17;
                float f19 = (f15 - f16) * (f15 - f16) + 4.0f * f18;
                float f20 = 0.5f * (f15 + f16 + f19);
                float f21 = 0.5f * (f15 + f16 - f19);
                float f22 = 1.0E-5f;
                if (f20 >= f22 && f21 >= f22) {
                    f12 = f15 * f16 - f18;
                    f11 = f16 / f12;
                    f10 = f15 / f12;
                    f9 = -f17 / f12;
                } else {
                    f12 = (f20 - f15) * (f20 - f15);
                    f8 = (f21 - f15) * (f21 - f15);
                    f7 = f18 + f12;
                    f6 = f18 + f8;
                    f5 = (float)Math.sqrt(f7);
                    f4 = (float)Math.sqrt(f6);
                    f20 = Math.max(f22, Math.abs(f20));
                    f21 = Math.max(f22, Math.abs(f21));
                    f3 = f18 / f20;
                    f11 = (f3 + f12 / f21) / f7;
                    f10 = (f3 + f8 / f21) / f6;
                    f9 = (f3 + (f20 - f15) * (f21 - f15) / f21) / (f5 * f4);
                }
                f12 = -f11 * f13 - f9 * f14;
                f8 = -f9 * f13 - f10 * f14;
                f7 = 1.0f;
                f6 = 0.001f;
                f5 = 0.7f;
                f4 = node.x + f7 * f12;
                f3 = node.y + f7 * f8;
                float f23 = this.computeModifiedEnergyHM(hashMap, nodeArray, node, f4, f3, bl);
                for (int i = 0; f23 > f + f7 * f6 * (f12 * f13 + f8 * f14) && i < 30; ++i) {
                    f7 = f5 * f7;
                    f4 = node.x + f7 * f12;
                    f3 = node.y + f7 * f8;
                    f23 = this.computeModifiedEnergyHM(hashMap, nodeArray, node, f4, f3, bl);
                }
                node.x = f4;
                node.y = f3;
                node.isAccessed = true;
                return f23;
            }

            void cleanNewton(Node[] nodeArray) {
                for (Node node : nodeArray) {
                    node.initialX = 0.0f;
                }
            }

            void cleanNewton(ArrayList<Node> arrayList) {
                for (Node node : arrayList) {
                    node.initialX = 0.0f;
                }
            }
        };
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Layout.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 7;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(GeneralPurposeLayout generalPurposeLayout, SCOType sCOType) {
            super(generalPurposeLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Layout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 5: {
                    ((GeneralPurposeLayout)((Object)object)).fast = bl;
                    return;
                }
                case 6: {
                    ((GeneralPurposeLayout)((Object)object)).startAgain = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 5: {
                    return ((GeneralPurposeLayout)((Object)object)).fast;
                }
                case 6: {
                    return ((GeneralPurposeLayout)((Object)object)).startAgain;
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 4: {
                    ((GeneralPurposeLayout)((Object)object)).maxNbOfSteps = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 4: {
                    return ((GeneralPurposeLayout)((Object)object)).maxNbOfSteps;
                }
            }
            return super.getInt(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((GeneralPurposeLayout)((Object)object)).idealDistance = f;
                    return;
                }
                case 3: {
                    ((GeneralPurposeLayout)((Object)object)).yIdealDistance = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((GeneralPurposeLayout)((Object)object)).idealDistance;
                }
                case 3: {
                    return ((GeneralPurposeLayout)((Object)object)).yIdealDistance;
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new GeneralPurposeLayout();
        }
    }
}

