/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

public class MinimizerPolyLogBarnesHut {
    private int nodeNr;
    private float[][] pos;
    private float[][] attr;
    private int[][] attrIndexes;
    private float[][] attrValues;
    private float attrExponent = 3.0f;
    private float[] baryCenter = new float[3];
    private float gravitationFactor = 0.001f;
    private float repuFactor = 1.0f;
    private static final float[] repuStrategy = new float[]{0.95f, 0.9f, 0.85f, 0.8f, 0.75f, 0.8f, 0.85f, 0.9f, 0.95f, 1.0f, 1.1f, 1.2f, 1.3f, 1.4f, 1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
    private OctTree octTree = null;

    public MinimizerPolyLogBarnesHut(int n, float[][] fArray, float[][] fArray2) {
        this.nodeNr = n;
        this.attr = fArray;
        this.pos = fArray2;
    }

    public void setAttractionExponent(float f) {
        this.attrExponent = f;
    }

    public void setGravitationFactor(float f) {
        this.gravitationFactor = f;
    }

    public void minimizeEnergy(int n) {
        if (this.nodeNr <= 1) {
            return;
        }
        this.computeRepuFactor();
        float f = this.repuFactor;
        this.attrMatrixToAttrList();
        this.buildOctTree();
        float f2 = 0.0f;
        for (int i = 0; i < this.nodeNr; ++i) {
            f2 += this.getEnergy(i);
        }
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        for (int i = 1; i <= n; ++i) {
            this.computeBaryCenter();
            this.buildOctTree();
            this.repuFactor = i / repuStrategy.length < (n - 20) / repuStrategy.length ? f * (float)Math.pow(repuStrategy[i % repuStrategy.length], this.attrExponent) : f;
            f2 = 0.0f;
            for (int j = 0; j < this.nodeNr; ++j) {
                float f3;
                int n2;
                float f4 = this.getEnergy(j);
                this.getDirection(j, fArray2);
                fArray[0] = this.pos[j][0];
                fArray[1] = this.pos[j][1];
                fArray[2] = this.pos[j][2];
                float f5 = f4;
                int n3 = 0;
                fArray2[0] = fArray2[0] / 32.0f;
                fArray2[1] = fArray2[1] / 32.0f;
                fArray2[2] = fArray2[2] / 32.0f;
                for (n2 = 32; n2 >= 1 && (n3 == 0 || n3 / 2 == n2); n2 /= 2) {
                    this.pos[j][0] = fArray[0] + fArray2[0] * (float)n2;
                    this.pos[j][1] = fArray[1] + fArray2[1] * (float)n2;
                    this.pos[j][2] = fArray[2] + fArray2[2] * (float)n2;
                    f3 = this.getEnergy(j);
                    if (!(f3 < f5)) continue;
                    f5 = f3;
                    n3 = n2;
                }
                for (n2 = 64; n2 <= 128 && n3 == n2 / 2; n2 *= 2) {
                    this.pos[j][0] = fArray[0] + fArray2[0] * (float)n2;
                    this.pos[j][1] = fArray[1] + fArray2[1] * (float)n2;
                    this.pos[j][2] = fArray[2] + fArray2[2] * (float)n2;
                    f3 = this.getEnergy(j);
                    if (!(f3 < f5)) continue;
                    f5 = f3;
                    n3 = n2;
                }
                this.pos[j][0] = fArray[0] + fArray2[0] * (float)n3;
                this.pos[j][1] = fArray[1] + fArray2[1] * (float)n3;
                this.pos[j][2] = fArray[2] + fArray2[2] * (float)n3;
                if (n3 > 0) {
                    this.octTree.moveNode(fArray, this.pos[j], 1.0f);
                }
                f2 += f5;
            }
        }
    }

    private float getDist(float[] fArray, float[] fArray2) {
        float f = fArray[0] - fArray2[0];
        float f2 = fArray[1] - fArray2[1];
        float f3 = fArray[2] - fArray2[2];
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    private float getDistToBaryCenter(int n) {
        float f = this.pos[n][0] - this.baryCenter[0];
        float f2 = this.pos[n][1] - this.baryCenter[1];
        float f3 = this.pos[n][2] - this.baryCenter[2];
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    private float getRepulsionEnergy(int n, OctTree octTree) {
        if (octTree == null || octTree.index == n) {
            return 0.0f;
        }
        float f = this.getDist(this.pos[n], octTree.position);
        if (octTree.index < 0 && f < octTree.width()) {
            float f2 = 0.0f;
            for (int i = 0; i < octTree.children.length; ++i) {
                f2 += this.getRepulsionEnergy(n, octTree.children[i]);
            }
            return f2;
        }
        return -this.repuFactor * octTree.weight * (float)Math.log(f);
    }

    private float getEnergy(int n) {
        float f = this.getRepulsionEnergy(n, this.octTree);
        for (int i = 0; i < this.attrIndexes[n].length; ++i) {
            if (this.attrIndexes[n][i] == n) continue;
            float f2 = this.getDist(this.pos[this.attrIndexes[n][i]], this.pos[n]);
            f = (float)((double)f + (double)this.attrValues[n][i] * Math.pow(f2, this.attrExponent) / (double)this.attrExponent);
        }
        float f3 = this.getDistToBaryCenter(n);
        return f += this.gravitationFactor * this.repuFactor * (float)(this.nodeNr - 1) * 0.5f * f3 * f3;
    }

    private float addRepulsionDir(int n, OctTree octTree, float[] fArray) {
        if (octTree == null || octTree.index == n) {
            return 0.0f;
        }
        float f = this.getDist(this.pos[n], octTree.position);
        if (octTree.index < 0 && f < octTree.width()) {
            float f2 = 0.0f;
            for (int i = 0; i < octTree.children.length; ++i) {
                f2 += this.addRepulsionDir(n, octTree.children[i], fArray);
            }
            return f2;
        }
        if ((double)f != 0.0) {
            float f3 = -this.repuFactor * octTree.weight / (f * f);
            for (int i = 0; i < 3; ++i) {
                int n2 = i;
                fArray[n2] = fArray[n2] + (octTree.position[i] - this.pos[n][i]) * f3;
            }
            return -f3;
        }
        return 0.0f;
    }

    private void getDirection(int n, float[] fArray) {
        int n2;
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        float f = this.addRepulsionDir(n, this.octTree, fArray);
        for (n2 = 0; n2 < this.attrIndexes[n].length; ++n2) {
            if (this.attrIndexes[n][n2] == n) continue;
            float f2 = this.getDist(this.pos[this.attrIndexes[n][n2]], this.pos[n]);
            float f3 = this.attrValues[n][n2] * (float)Math.pow(f2, this.attrExponent - 2.0f);
            f += f3 * (this.attrExponent - 1.0f);
            for (int i = 0; i < 3; ++i) {
                int n3 = i;
                fArray[n3] = fArray[n3] + (this.pos[this.attrIndexes[n][n2]][i] - this.pos[n][i]) * f3;
            }
        }
        f += this.gravitationFactor * this.repuFactor * (float)(this.nodeNr - 1);
        for (n2 = 0; n2 < 3; ++n2) {
            int n4 = n2;
            fArray[n4] = fArray[n4] + this.gravitationFactor * this.repuFactor * (float)(this.nodeNr - 1) * (this.baryCenter[n2] - this.pos[n][n2]);
        }
        fArray[0] = fArray[0] / f;
        fArray[1] = fArray[1] / f;
        fArray[2] = fArray[2] / f;
        float f4 = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        if (f4 > this.octTree.width() / 8.0f) {
            fArray[0] = fArray[0] / (f4 /= this.octTree.width() / 8.0f);
            fArray[1] = fArray[1] / f4;
            fArray[2] = fArray[2] / f4;
        }
    }

    private void buildOctTree() {
        int n;
        float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
        float[] fArray2 = new float[]{Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE};
        for (n = 0; n < this.nodeNr; ++n) {
            for (int i = 0; i < 3; ++i) {
                if (this.pos[n][i] < fArray[i]) {
                    fArray[i] = this.pos[n][i];
                }
                if (!(this.pos[n][i] > fArray2[i])) continue;
                fArray2[i] = this.pos[n][i];
            }
        }
        this.octTree = new OctTree(0, this.pos[0], 1.0f, fArray, fArray2);
        for (n = 1; n < this.nodeNr; ++n) {
            this.octTree.addNode(n, this.pos[n], 1.0f, 0);
        }
    }

    private void computeRepuFactor() {
        this.repuFactor = 0.0f;
        for (int i = 1; i < this.nodeNr; ++i) {
            for (int j = 0; j < i; ++j) {
                this.repuFactor += this.attr[i][j];
            }
        }
        this.repuFactor /= (float)(this.nodeNr * (this.nodeNr - 1) / 2);
        if (this.repuFactor == 0.0f) {
            this.repuFactor = 1.0f;
        }
    }

    private void computeBaryCenter() {
        this.baryCenter[0] = 0.0f;
        this.baryCenter[1] = 0.0f;
        this.baryCenter[2] = 0.0f;
        for (int i = 0; i < this.nodeNr; ++i) {
            this.baryCenter[0] = this.baryCenter[0] + this.pos[i][0];
            this.baryCenter[1] = this.baryCenter[1] + this.pos[i][1];
            this.baryCenter[2] = this.baryCenter[2] + this.pos[i][2];
        }
        this.baryCenter[0] = this.baryCenter[0] / (float)this.nodeNr;
        this.baryCenter[1] = this.baryCenter[1] / (float)this.nodeNr;
        this.baryCenter[2] = this.baryCenter[2] / (float)this.nodeNr;
    }

    private void analyzeDistances() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        for (int i = 1; i < this.nodeNr; ++i) {
            for (int j = 0; j < i; ++j) {
                float f6 = this.getDist(this.pos[i], this.pos[j]);
                float f7 = (float)Math.log(f6);
                f += this.attr[i][j] * f6;
                f2 += this.attr[i][j] * f7;
                f3 += this.attr[i][j];
                f5 += f7;
            }
        }
        System.out.println("Number of Nodes: " + this.nodeNr);
        System.out.println("Overall Attraction: " + f3);
        System.out.println("Arithmetic mean of edge lengths: " + f / f3);
        System.out.println("Geometric mean of edge lengths: " + (float)Math.exp(f2 / f3));
        System.out.println("Geometric mean of distances: " + (float)Math.exp(2.0f * f5 / (float)(this.nodeNr * this.nodeNr)));
    }

    private void attrMatrixToAttrList() {
        this.attrIndexes = new int[this.nodeNr][];
        this.attrValues = new float[this.nodeNr][];
        for (int i = 0; i < this.nodeNr; ++i) {
            int n;
            int n2 = 0;
            for (n = 0; n < this.nodeNr; ++n) {
                if (!(this.attr[i][n] > 0.0f)) continue;
                ++n2;
            }
            this.attrIndexes[i] = new int[n2];
            this.attrValues[i] = new float[n2];
            n2 = 0;
            for (n = 0; n < this.nodeNr; ++n) {
                if (!(this.attr[i][n] > 0.0f)) continue;
                this.attrIndexes[i][n2] = n;
                this.attrValues[i][n2] = this.attr[i][n];
                ++n2;
            }
        }
    }

    class OctTree {
        private int index;
        private OctTree[] children = new OctTree[8];
        private float[] position;
        private float weight;
        private float[] minPos;
        private float[] maxPos;
        private static final int MAX_DEPTH = 20;

        public OctTree(int n, float[] fArray, float f, float[] fArray2, float[] fArray3) {
            this.index = n;
            this.position = new float[]{fArray[0], fArray[1], fArray[2]};
            this.weight = f;
            this.minPos = fArray2;
            this.maxPos = fArray3;
        }

        public void addNode(int n, float[] fArray, float f, int n2) {
            if (f == 0.0f) {
                return;
            }
            if (n2 > 20) {
                return;
            }
            if (this.index >= 0) {
                this.addNode2(this.index, this.position, this.weight, n2);
                this.index = -1;
            }
            for (int i = 0; i < 3; ++i) {
                this.position[i] = (this.position[i] * this.weight + fArray[i] * f) / (this.weight + f);
            }
            this.weight += f;
            this.addNode2(n, fArray, f, n2);
        }

        private void addNode2(int n, float[] fArray, float f, int n2) {
            int n3 = 0;
            for (int i = 0; i < 3; ++i) {
                if (!(fArray[i] > (this.minPos[i] + this.maxPos[i]) / 2.0f)) continue;
                n3 += 1 << i;
            }
            if (this.children[n3] == null) {
                float[] fArray2 = new float[3];
                float[] fArray3 = new float[3];
                for (int i = 0; i < 3; ++i) {
                    if ((n3 & 1 << i) == 0) {
                        fArray2[i] = this.minPos[i];
                        fArray3[i] = (this.minPos[i] + this.maxPos[i]) / 2.0f;
                        continue;
                    }
                    fArray2[i] = (this.minPos[i] + this.maxPos[i]) / 2.0f;
                    fArray3[i] = this.maxPos[i];
                }
                this.children[n3] = new OctTree(n, fArray, f, fArray2, fArray3);
            } else {
                this.children[n3].addNode(n, fArray, f, n2 + 1);
            }
        }

        public void moveNode(float[] fArray, float[] fArray2, float f) {
            int n;
            for (n = 0; n < 3; ++n) {
                int n2 = n;
                this.position[n2] = this.position[n2] + (fArray2[n] - fArray[n]) * (f / this.weight);
            }
            n = 0;
            for (int i = 0; i < 3; ++i) {
                if (!(fArray[i] > (this.minPos[i] + this.maxPos[i]) / 2.0f)) continue;
                n += 1 << i;
            }
            if (this.children[n] != null) {
                this.children[n].moveNode(fArray, fArray2, f);
            }
        }

        public float width() {
            float f = 0.0f;
            for (int i = 0; i < 3; ++i) {
                if (!(this.maxPos[i] - this.minPos[i] > f)) continue;
                f = this.maxPos[i] - this.minPos[i];
            }
            return f;
        }
    }
}

