/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.GraphUtilities;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.util.LinkedList;

public class SquareLayout
extends Layout {
    private int layerCount = 3;
    private int r;
    private int eachLayerNodes;
    private double layerDistance = 1.0;
    private double nodeDistance = 1.2f;
    private boolean topDown = false;
    public static final Type $TYPE = new Type(SquareLayout.class);
    public static final SCOType.Field layerCount$FIELD = Type._addManagedField($TYPE, "layerCount", 0x200002, de.grogra.reflect.Type.INT, null, 2);
    public static final SCOType.Field layerDistance$FIELD = Type._addManagedField($TYPE, "layerDistance", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 3);
    public static final SCOType.Field nodeDistance$FIELD = Type._addManagedField($TYPE, "nodeDistance", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 4);
    public static final SCOType.Field topDown$FIELD = Type._addManagedField($TYPE, "topDown", 0x200002, de.grogra.reflect.Type.BOOLEAN, null, 5);

    protected Layout.Algorithm createAlgorithm() {
        return new Layout.Algorithm(){

            protected void layout(Node node) {
                int n;
                GraphUtilities graphUtilities = new GraphUtilities();
                LinkedList linkedList = graphUtilities.getNodesListDFS(node);
                if (SquareLayout.this.layerCount < 1) {
                    SquareLayout.this.layerCount = 1;
                }
                int n2 = 0;
                double d = 1.0;
                SquareLayout.this.r = 0;
                for (n = 0; n < linkedList.size(); ++n) {
                    Node node2 = (Node)((Object)linkedList.get(n));
                    ++n2;
                    d = (float)Math.max(d, (double)Math.max(node2.height, node2.width));
                }
                SquareLayout.this.layerDistance = Math.max(d + 1.0, SquareLayout.this.layerDistance);
                SquareLayout.this.nodeDistance = Math.max(SquareLayout.this.nodeDistance, d);
                SquareLayout.this.eachLayerNodes = Math.max(1, n2 / SquareLayout.this.layerCount);
                if (n2 % SquareLayout.this.layerCount > 0) {
                    SquareLayout.this.eachLayerNodes += 1;
                }
                n = 0;
                for (int i = 0; i < linkedList.size(); ++i) {
                    Node node3 = (Node)((Object)linkedList.get(i));
                    if (SquareLayout.this.topDown) {
                        node3.x = SquareLayout.this.r;
                        node3.y = -((float)((double)n * SquareLayout.this.nodeDistance));
                    } else {
                        node3.x = -((float)((double)(-n) * SquareLayout.this.nodeDistance));
                        node3.y = -SquareLayout.this.r;
                    }
                    if (n + 1 == SquareLayout.this.eachLayerNodes) {
                        SquareLayout.this.r = (int)((double)SquareLayout.this.r + SquareLayout.this.layerDistance);
                        n = -1;
                    }
                    ++n;
                }
            }
        };
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public int getLayerCount() {
        return this.layerCount;
    }

    public void setLayerCount(int n) {
        this.layerCount = n;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Layout.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 6;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(SquareLayout squareLayout, SCOType sCOType) {
            super(squareLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Layout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 5: {
                    ((SquareLayout)((Object)object)).topDown = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 5: {
                    return ((SquareLayout)((Object)object)).topDown;
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 2: {
                    ((SquareLayout)((Object)object)).layerCount = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((SquareLayout)((Object)object)).getLayerCount();
                }
            }
            return super.getInt(object, n);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 3: {
                    ((SquareLayout)((Object)object)).layerDistance = d;
                    return;
                }
                case 4: {
                    ((SquareLayout)((Object)object)).nodeDistance = d;
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((SquareLayout)((Object)object)).layerDistance;
                }
                case 4: {
                    return ((SquareLayout)((Object)object)).nodeDistance;
                }
            }
            return super.getDouble(object, n);
        }

        public Object newInstance() {
            return new SquareLayout();
        }
    }
}

