/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.GraphUtilities;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.util.Hashtable;
import javax.vecmath.Point2d;

public class TouchLayout
extends Layout {
    private double damper = 1.0;
    private Hashtable fDeltas = new Hashtable();
    private Hashtable fPositions = new Hashtable();
    private double lastMaxMotion = 0.0;
    private double maxMotion = 0.0;
    private double motionRatio = 0.0;
    private double rigidity = 5.0E-5;
    private int count = 100;
    public static final Type $TYPE = new Type(TouchLayout.class);
    public static final SCOType.Field damper$FIELD = Type._addManagedField($TYPE, "damper", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 2);
    public static final SCOType.Field rigidity$FIELD = Type._addManagedField($TYPE, "rigidity", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 3);
    public static final SCOType.Field count$FIELD = Type._addManagedField($TYPE, "count", 0x200002, de.grogra.reflect.Type.INT, null, 4);

    protected Layout.Algorithm createAlgorithm() {
        return new Layout.Algorithm(){

            protected void layout(Node node) {
                for (int i = 0; i < TouchLayout.this.count; ++i) {
                    this.relaxEdges(node);
                    this.avoidLabels(node);
                    this.moveNodes(node);
                }
            }

            private synchronized void relaxEdges(Node node) {
                GraphUtilities graphUtilities = new GraphUtilities();
                graphUtilities.setAllEdgesAccessed(node, false);
                Node node2 = node;
                while (node2 != null) {
                    for (Edge edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                        if (edge.isAccessed) continue;
                        edge.isAccessed = true;
                        double d = edge.target.distance(edge.source);
                        double d2 = (double)(edge.target.x - edge.source.x) * TouchLayout.this.rigidity * d;
                        double d3 = (double)(edge.target.y - edge.source.y) * TouchLayout.this.rigidity * d;
                        this.movePointSet(edge.target, -d2, -d3);
                        this.movePointSet(edge.source, d2, d3);
                    }
                    node2 = node2.next;
                }
            }

            private void movePointSet(Node node, double d, double d2) {
                Point2d point2d = this.getDelta(node);
                if (d + point2d.x == Double.NaN || d2 + point2d.y == Double.NaN) {
                    return;
                }
                point2d.set(point2d.x + d, point2d.y + d2);
            }

            public Point2d getDelta(Node node) {
                Point2d point2d = (Point2d)TouchLayout.this.fDeltas.get((Object)node);
                if (point2d == null) {
                    point2d = new Point2d(0.0, 0.0);
                    TouchLayout.this.fDeltas.put(node, point2d);
                }
                return point2d;
            }

            private synchronized void avoidLabels(Node node) {
                Node node2 = node;
                while (node2 != null) {
                    Node node3 = node2.next;
                    while (node3 != null) {
                        double d = node2.x - node3.x;
                        double d2 = node2.y - node3.y;
                        double d3 = node2.distance(node3);
                        double d4 = 0.0;
                        double d5 = 0.0;
                        if (d3 == 0.0) {
                            d4 = 0.01;
                            d5 = 0.01;
                        } else if (d3 < 5.0) {
                            d4 = d / d3;
                            d5 = d2 / d3;
                        }
                        double d6 = Math.max(node2.width, node3.width);
                        double d7 = Math.max(node2.height, node2.height);
                        d6 = Math.pow(d6 * 5.0, 2.0);
                        d7 = Math.pow(d7 * 5.0, 2.0);
                        d6 = Math.max(d6, d7);
                        if (Math.random() > 0.03) {
                            this.movePointSet(node2, d4 * d6, d5 * d7);
                            this.movePointSet(node3, -d4 * d7, -d5 * d6);
                        } else {
                            this.movePointSet(node2, d4 * d6 * 3.0, d5 * d7 * 3.0);
                            this.movePointSet(node3, -d4 * d6 * 3.0, -d5 * d7 * 3.0);
                        }
                        node3 = node3.next;
                    }
                    node2 = node2.next;
                }
            }

            public Point2d getTouchPosition(Node node) {
                if (node == null) {
                    return null;
                }
                Point2d point2d = (Point2d)TouchLayout.this.fPositions.get((Object)node);
                Point2d point2d2 = new Point2d((double)(node.x + node.width / 2.0f), (double)(node.y + node.height / 2.0f));
                if (point2d != null) {
                    if (Math.abs(point2d.x - point2d2.x) > 0.05 || Math.abs(point2d.y - point2d2.y) > 0.05) {
                        point2d.set(point2d2.x, point2d2.y);
                    }
                    return point2d;
                }
                TouchLayout.this.fPositions.put(node, point2d2);
                return point2d2;
            }

            private synchronized void moveNodes(Node node) {
                TouchLayout.this.lastMaxMotion = TouchLayout.this.maxMotion;
                double d = 0.0;
                Node node2 = node;
                while (node2 != null) {
                    Point2d point2d = this.getDelta(node2);
                    Point2d point2d2 = this.getTouchPosition(node2);
                    if (point2d2 == null || point2d == null) {
                        return;
                    }
                    double d2 = point2d.x;
                    double d3 = point2d.y;
                    if ((float)((d2 *= TouchLayout.this.damper) / 2.0) == Float.NaN || (float)((d3 *= TouchLayout.this.damper) / 2.0) == Float.NaN) {
                        return;
                    }
                    node2.x = (float)(d2 / 2.0);
                    node2.y = (float)(d3 / 2.0);
                    double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                    if (d2 != 0.0 || d3 != 0.0) {
                        point2d2.x += Math.max(-0.05, Math.min(0.05, d2));
                        point2d2.y += Math.max(-0.05, Math.min(0.05, d3));
                        double d5 = Math.max(0.0, point2d2.x - (double)(node2.width / 2.0f));
                        double d6 = Math.max(0.0, point2d2.y - (double)(node2.height / 2.0f));
                        if (d5 != Double.NaN && d6 != Double.NaN) {
                            node2.x = (float)d5;
                            node2.y = (float)d6;
                        } else {
                            return;
                        }
                    }
                    d = Math.max(d4, d);
                    node2 = node2.next;
                }
                TouchLayout.this.maxMotion = d;
                if (TouchLayout.this.maxMotion > 0.0) {
                    TouchLayout.this.motionRatio = TouchLayout.this.lastMaxMotion / TouchLayout.this.maxMotion - 1.0;
                } else {
                    TouchLayout.this.motionRatio = 0.0;
                }
                this.damp();
            }

            public void damp() {
                if (TouchLayout.this.motionRatio <= 0.001) {
                    if ((TouchLayout.this.maxMotion < 0.2 || TouchLayout.this.maxMotion > 1.0 && TouchLayout.this.damper < 0.9) && TouchLayout.this.damper > 0.01) {
                        TouchLayout.this.damper -= 0.01;
                    } else if (TouchLayout.this.maxMotion < 0.4 && TouchLayout.this.damper > 0.003) {
                        TouchLayout.this.damper -= 0.003;
                    } else if (TouchLayout.this.damper > 1.0E-4) {
                        TouchLayout.this.damper -= 1.0E-4;
                    }
                }
                if (TouchLayout.this.maxMotion < 0.001) {
                    TouchLayout.this.damper = 0.0;
                }
            }
        };
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Layout.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 5;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(TouchLayout touchLayout, SCOType sCOType) {
            super(touchLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Layout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 4: {
                    ((TouchLayout)((Object)object)).count = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 4: {
                    return ((TouchLayout)((Object)object)).count;
                }
            }
            return super.getInt(object, n);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 2: {
                    ((TouchLayout)((Object)object)).damper = d;
                    return;
                }
                case 3: {
                    ((TouchLayout)((Object)object)).rigidity = d;
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((TouchLayout)((Object)object)).damper;
                }
                case 3: {
                    return ((TouchLayout)((Object)object)).rigidity;
                }
            }
            return super.getDouble(object, n);
        }

        public Object newInstance() {
            return new TouchLayout();
        }
    }
}

