/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp2d.AWTCanvas2D;
import de.grogra.imp2d.DragEvent2D;
import de.grogra.imp2d.edit.EditTool;
import de.grogra.imp2d.edit.Editable;
import de.grogra.imp2d.objects.Attributes;
import de.grogra.imp2d.objects.FillableShape2D;
import de.grogra.math.Pool;
import de.grogra.math.Transform2D;
import de.grogra.persistence.ManageableType;
import de.grogra.pf.ui.event.EditEvent;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.FieldChain;
import de.grogra.reflect.Type;
import de.grogra.vecmath.Math2;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;

public class Shape2D
extends FillableShape2D
implements Editable {
    Shape shape = new Rectangle2D.Float(-0.5f, -0.3f, 1.0f, 0.6f);
    public static final Node.NType $TYPE = new Node.NType((Node)new Shape2D());
    public static final Node.NType.Field shape$FIELD = new _Field("shape", 0x200000, (Type)ClassAdapter.wrap(Shape.class), null, 0);
    private static final int HANDLE_COUNT = 8;
    private static final float[] W_FACTORS;
    private static final float[] H_FACTORS;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Shape2D();
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        shape$FIELD.setObject((Object)this, (Object)shape);
    }

    protected Editable getEditable() {
        return this;
    }

    protected Shape getShape(Object object, boolean bl, Pool pool, GraphState graphState) {
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                return this.shape;
            }
            return (Shape)graphState.checkObject((Object)this, true, Attributes.SHAPE_2D, (Object)this.shape);
        }
        return (Shape)graphState.getObject(object, bl, Attributes.SHAPE_2D);
    }

    public void pickTool(Point2d point2d, Matrix3d matrix3d, PickList pickList, EditTool editTool) {
        Shape shape = this.getShape(editTool.getToolTarget(), editTool.isTargetNode(), (Pool)pickList, pickList.getGraphState());
        if (shape instanceof Editable) {
            ((Editable)((Object)shape)).pickTool(point2d, matrix3d, pickList, editTool);
            if (editTool.getPickId() != -2) {
                return;
            }
        } else if (shape instanceof RectangularShape && Attributes.SHAPE_2D.isWritable(editTool.getToolTarget(), editTool.isTargetNode(), pickList.getGraphState())) {
            RectangularShape rectangularShape = (RectangularShape)shape;
            for (int i = 0; i < 8; ++i) {
                if (!editTool.pickHandle(matrix3d, pickList, rectangularShape.getCenterX() + rectangularShape.getWidth() * (double)W_FACTORS[i], rectangularShape.getCenterY() + rectangularShape.getHeight() * (double)H_FACTORS[i], i)) continue;
                return;
            }
        }
        this.pick(editTool.getToolTarget(), editTool.isTargetNode(), point2d, matrix3d, pickList);
        if (pickList.containsCurrent()) {
            editTool.setPickId(-1);
        }
    }

    public void drawTool(AWTCanvas2D aWTCanvas2D, Matrix3d matrix3d, EditTool editTool) {
        Shape shape = this.getShape(editTool.getToolTarget(), editTool.isTargetNode(), aWTCanvas2D.pool, aWTCanvas2D.getRenderGraphState());
        if (shape instanceof Editable) {
            ((Editable)((Object)shape)).drawTool(aWTCanvas2D, matrix3d, editTool);
        } else if (shape instanceof RectangularShape && Attributes.SHAPE_2D.isWritable(editTool.getToolTarget(), editTool.isTargetNode(), aWTCanvas2D.getRenderGraphState())) {
            RectangularShape rectangularShape = (RectangularShape)shape;
            for (int i = 0; i < 8; ++i) {
                EditTool.drawHandle(aWTCanvas2D, matrix3d, rectangularShape.getCenterX() + rectangularShape.getWidth() * (double)W_FACTORS[i], rectangularShape.getCenterY() + rectangularShape.getHeight() * (double)H_FACTORS[i]);
            }
        }
    }

    public void toolEventOccured(EditEvent editEvent, EditTool editTool) {
        int n = editTool.getPickId();
        if (n == -2) {
            return;
        }
        if (n == -1) {
            super.toolEventOccured(editEvent, editTool);
            return;
        }
        Shape shape = this.getShape(editTool.getToolTarget(), editTool.isTargetNode(), editTool.pool, editTool.getGraphState());
        if (shape instanceof Editable) {
            ((Editable)((Object)shape)).toolEventOccured(editEvent, editTool);
        } else {
            if (!(shape instanceof RectangularShape)) {
                return;
            }
            RectangularShape rectangularShape = (RectangularShape)shape;
            double d = rectangularShape.getWidth();
            double d2 = rectangularShape.getHeight();
            if (editEvent instanceof DragEvent2D) {
                DragEvent2D dragEvent2D = (DragEvent2D)editEvent;
                if (dragEvent2D.draggingStarted()) {
                    if (n >= 0 && n < 8) {
                        Point2d point2d = new Point2d(dragEvent2D.point);
                        Math2.invTransformPoint((Matrix3d)editTool.getTargetTransformation(), (Tuple2d)point2d);
                        point2d.x -= d * (double)W_FACTORS[n];
                        point2d.y -= d2 * (double)H_FACTORS[n];
                        editTool.setObject(point2d);
                    } else {
                        editTool.setObject(null);
                    }
                } else if (dragEvent2D.draggingContinued()) {
                    Point2d point2d = editTool.pool.p2d0;
                    Point2d point2d2 = (Point2d)editTool.getObject();
                    if (point2d2 == null) {
                        return;
                    }
                    point2d.set((Tuple2d)dragEvent2D.point);
                    Math2.invTransformPoint((Matrix3d)editTool.getTargetTransformation(), (Tuple2d)point2d);
                    point2d.x -= d * (double)W_FACTORS[n];
                    point2d.y -= d2 * (double)H_FACTORS[n];
                    point2d.sub((Tuple2d)point2d2);
                    Matrix3d matrix3d = editTool.pool.m3d1;
                    Transform2D transform2D = (Transform2D)editTool.getTool().getObjectOfObject(Attributes.TRANSFORM, null);
                    if (transform2D != null) {
                        editTool.pool.m3d0.setIdentity();
                        transform2D.transform(editTool.pool.m3d0, matrix3d);
                    } else {
                        matrix3d.setIdentity();
                    }
                    if (n >= 0 && n < 8) {
                        ManageableType manageableType = ManageableType.forClass(rectangularShape.getClass());
                        if (manageableType == null) {
                            return;
                        }
                        Vector2d vector2d = editTool.pool.v2d0;
                        vector2d.set((double)Math.abs(W_FACTORS[n]) * point2d.x, (double)Math.abs(H_FACTORS[n]) * point2d.y);
                        if (vector2d.lengthSquared() > 0.0) {
                            double d3 = d + (double)(2.0f * W_FACTORS[n]) * point2d.x;
                            double d4 = d2 + (double)(2.0f * H_FACTORS[n]) * point2d.y;
                            Math2.transformVector((Matrix3d)matrix3d, (Tuple2d)vector2d);
                            matrix3d.m02 += vector2d.x;
                            matrix3d.m12 += vector2d.y;
                            editTool.setTransform(matrix3d);
                            if (d4 != d2) {
                                editTool.getTool().setSubfield(Attributes.SHAPE_2D, (FieldChain)manageableType.getManagedField("height"), null, (Object)new Double(d4));
                            }
                            if (d3 != d) {
                                editTool.getTool().setSubfield(Attributes.SHAPE_2D, (FieldChain)manageableType.getManagedField("width"), null, (Object)new Double(d3));
                            }
                        }
                    }
                }
            }
        }
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)shape$FIELD);
        $TYPE.declareFieldAttribute(shape$FIELD, (Attribute)Attributes.SHAPE_2D);
        $TYPE.validate();
        W_FACTORS = new float[]{-0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f, -0.5f, -0.5f};
        H_FACTORS = new float[]{-0.5f, -0.5f, -0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f};
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((Shape2D)object).shape = (Shape)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Shape2D)object).getShape();
                }
            }
            return super.getObject(object);
        }
    }
}

