/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.GraphState;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp2d.AWTCanvas2D;
import de.grogra.imp2d.AWTDrawable;
import de.grogra.imp2d.BoundedShape;
import de.grogra.imp2d.Connectable;
import de.grogra.imp2d.DragEvent2D;
import de.grogra.imp2d.Pickable;
import de.grogra.imp2d.View2D;
import de.grogra.imp2d.edit.EditTool;
import de.grogra.imp2d.edit.Editable;
import de.grogra.imp2d.objects.Attributes;
import de.grogra.imp2d.objects.Null;
import de.grogra.imp2d.objects.StrokeAdapter;
import de.grogra.math.Pool;
import de.grogra.math.Transform2D;
import de.grogra.math.Tuple3fType;
import de.grogra.persistence.ManageableType;
import de.grogra.pf.ui.event.EditEvent;
import de.grogra.reflect.Type;
import de.grogra.vecmath.Math2;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2d;

public abstract class Shape2DBase
extends Null
implements AWTDrawable,
Pickable,
BoundedShape,
Connectable {
    private static final Color3f DEFAULT_COLOR = new Color3f(0.0f, 0.0f, 0.0f);
    Color3f color = new Color3f(DEFAULT_COLOR);
    StrokeAdapter stroke = new StrokeAdapter();
    public static final Node.NType $TYPE = new Node.NType(Shape2DBase.class);
    public static final Node.NType.Field color$FIELD = new _Field("color", 0x200000, (Type)Tuple3fType.COLOR, null, 0);
    public static final Node.NType.Field stroke$FIELD;
    private static final StrokeAdapter DEFAULT_STROKE;
    private transient Color awtColor = Color.BLACK;

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Editable.ATTRIBUTE));
    }

    public Color3f getColor() {
        return this.color;
    }

    public void setColor(Color3f color3f) {
        color$FIELD.setObject((Object)this, (Object)color3f);
    }

    public StrokeAdapter getStroke() {
        return this.stroke;
    }

    public void setStroke(StrokeAdapter strokeAdapter) {
        stroke$FIELD.setObject((Object)this, (Object)strokeAdapter);
    }

    protected Object getObject(ObjectAttribute objectAttribute, Object object, GraphState graphState) {
        if (objectAttribute == Editable.ATTRIBUTE) {
            return this.getEditable();
        }
        return super.getObject(objectAttribute, object, graphState);
    }

    protected abstract Editable getEditable();

    protected abstract Shape getShape(Object var1, boolean var2, Pool var3, GraphState var4);

    public void getBounds(Object object, boolean bl, Rectangle2D rectangle2D, Pool pool, GraphState graphState) {
        rectangle2D.setFrame(this.getShape(object, bl, pool, graphState).getBounds2D());
    }

    protected void drawShape(Object object, boolean bl, AWTCanvas2D aWTCanvas2D, Shape shape) {
        aWTCanvas2D.getGraphics().draw(shape);
    }

    public void draw(Object object, boolean bl, AWTCanvas2D aWTCanvas2D, Matrix3d matrix3d, int n) {
        StrokeAdapter strokeAdapter;
        Color3f color3f;
        GraphState graphState = aWTCanvas2D.getRenderGraphState();
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                color3f = this.color;
                strokeAdapter = this.stroke;
            } else {
                color3f = (Tuple3f)graphState.checkObject((Object)this, true, Attributes.COLOR, (Object)this.color);
                strokeAdapter = (StrokeAdapter)((Object)graphState.checkObject((Object)this, true, Attributes.STROKE, (Object)this.stroke));
            }
        } else {
            if (!aWTCanvas2D.isCurrentLayer(graphState.getIntDefault(object, bl, Attributes.LAYER, 0))) {
                return;
            }
            color3f = (Tuple3f)graphState.getObjectDefault(object, bl, Attributes.COLOR, (Object)DEFAULT_COLOR);
            strokeAdapter = (StrokeAdapter)((Object)graphState.getObjectDefault(object, bl, Attributes.STROKE, (Object)DEFAULT_STROKE));
        }
        Shape shape = this.getShape(object, bl, aWTCanvas2D.pool, graphState);
        this.awtColor = AWTCanvas2D.getColor((Tuple3f)color3f, (Color)this.awtColor);
        aWTCanvas2D.setColor(this.awtColor, n, true);
        if (n == 0) {
            aWTCanvas2D.setGraphicsTransform(matrix3d);
            aWTCanvas2D.getGraphics().setStroke(strokeAdapter.getStroke());
            this.drawShape(object, bl, aWTCanvas2D, shape);
        } else {
            aWTCanvas2D.draw(shape, matrix3d, AWTCanvas2D.STROKE_3);
        }
    }

    public void pick(Object object, boolean bl, Point2d point2d, Matrix3d matrix3d, PickList pickList) {
        Shape shape = this.getShape(object, bl, (Pool)pickList, pickList.getGraphState());
        if (this.pickBoundary() && Shape2DBase.testBoundary(shape, matrix3d, 25, pickList) || shape.contains(point2d.x, point2d.y)) {
            pickList.add();
        }
    }

    protected boolean pickBoundary() {
        return false;
    }

    public static boolean testBoundary(Shape shape, Matrix3d matrix3d, int n, PickList pickList) {
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        Point2d point2d = pickList.q2d0;
        Point2d point2d2 = pickList.q2d1;
        Point2d point2d3 = pickList.q2d2;
        Vector2d vector2d = pickList.w2d0;
        Vector2d vector2d2 = pickList.w2d1;
        point2d3.set((double)pickList.getViewX(), (double)pickList.getViewY());
        Matrix3d matrix3d2 = ((View2D)pickList.getView()).getCanvasTransformation();
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    d = dArray[0];
                    d2 = dArray[1];
                    point2d2.set(d, d2);
                    break;
                }
                case 4: {
                    point2d2.set(d, d2);
                    break;
                }
                case 1: {
                    point2d2.set(dArray[0], dArray[1]);
                    break;
                }
                case 2: {
                    point2d2.set(dArray[2], dArray[3]);
                    break;
                }
                case 3: {
                    point2d2.set(dArray[4], dArray[5]);
                    break;
                }
                default: {
                    throw new AssertionError(n2);
                }
            }
            Math2.transformPoint((Matrix3d)matrix3d, (Tuple2d)point2d2);
            Math2.transformPoint((Matrix3d)matrix3d2, (Tuple2d)point2d2);
            if (n2 != 0) {
                if (point2d3.distanceSquared(point2d) < (double)n || point2d3.distanceSquared(point2d2) < (double)n) {
                    return true;
                }
                vector2d2.sub((Tuple2d)point2d3, (Tuple2d)point2d);
                vector2d.sub((Tuple2d)point2d2, (Tuple2d)point2d);
                double d3 = vector2d2.dot(vector2d) / vector2d.lengthSquared();
                if (d3 >= 0.0 && d3 <= 1.0) {
                    point2d.scaleAdd(d3, (Tuple2d)vector2d, (Tuple2d)point2d);
                    if (point2d3.distanceSquared(point2d) < (double)n) {
                        return true;
                    }
                }
            }
            Point2d point2d4 = point2d;
            point2d = point2d2;
            point2d2 = point2d4;
            pathIterator.next();
        }
        return false;
    }

    public void getConnectionPoint(Object object, boolean bl, Tuple2d tuple2d, Object object2, boolean bl2, Tuple2d tuple2d2, Pool pool, GraphState graphState) {
        Shape2DBase.getConnectionPoint(this.getShape(object, bl, pool, graphState).getPathIterator(null), false, true, tuple2d2, tuple2d);
    }

    public static void getConnectionPoint(PathIterator pathIterator, boolean bl, boolean bl2, Tuple2d tuple2d, Tuple2d tuple2d2) {
        tuple2d2.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        while (!pathIterator.isDone()) {
            double d5 = d3;
            double d6 = d4;
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    d3 = d = dArray[0];
                    d4 = d2 = dArray[1];
                    break;
                }
                case 4: {
                    d3 = d;
                    d4 = d2;
                    n = 1;
                    break;
                }
                case 1: {
                    d3 = dArray[0];
                    d4 = dArray[1];
                    break;
                }
                case 2: {
                    d3 = dArray[2];
                    d4 = dArray[3];
                    break;
                }
                case 3: {
                    d3 = dArray[4];
                    d4 = dArray[5];
                }
            }
            if (n != 0) {
                if (bl) {
                    Shape2DBase.setIfCloser(tuple2d2, d3, d4, tuple2d);
                }
                if (bl2) {
                    switch (n) {
                        case 1: {
                            Shape2DBase.findClosest(d5, d6, d3, d4, tuple2d, tuple2d2);
                            break;
                        }
                        case 2: {
                            Shape2DBase.findClosest(d5, d6, dArray[0], dArray[1], d3, d4, tuple2d, tuple2d2);
                            break;
                        }
                        case 3: {
                            Shape2DBase.findClosest(d5, d6, dArray[0], dArray[1], dArray[2], dArray[3], d3, d4, tuple2d, tuple2d2);
                        }
                    }
                }
            }
            pathIterator.next();
        }
    }

    private static void findClosest(double d, double d2, double d3, double d4, Tuple2d tuple2d, Tuple2d tuple2d2) {
        double d5 = (tuple2d.x * d2 - tuple2d.y * d) / ((d3 -= d) * tuple2d.y - (d4 -= d2) * tuple2d.x);
        if (d5 >= 0.0 && d5 <= 1.0) {
            Shape2DBase.setIfCloser(tuple2d2, d + d5 * d3, d2 + d5 * d4, tuple2d);
        }
    }

    private static void findClosest(double d, double d2, double d3, double d4, double d5, double d6, Tuple2d tuple2d, Tuple2d tuple2d2) {
        double d7;
        double d8;
        double d9;
        double d10 = d > d3 ? (d > d5 ? d : d5) : (d9 = d3 > d5 ? d3 : d5);
        double d11 = d2 > d4 ? (d2 > d6 ? d2 : d6) : (d8 = d4 > d6 ? d4 : d6);
        double d12 = d < d3 ? (d < d5 ? d : d5) : (d7 = d3 < d5 ? d3 : d5);
        double d13 = d2 < d4 ? (d2 < d6 ? d2 : d6) : (d4 < d6 ? d4 : d6);
        d9 = 0.02 * (d9 + d8 - d7 - d13);
        if (Line2D.ptLineDistSq(d, d2, d5, d6, d3, d4) <= d9 * d9) {
            Shape2DBase.findClosest(d, d2, d5, d6, tuple2d, tuple2d2);
        } else {
            double d14 = d;
            double d15 = d2;
            d = 0.5 * (d + d3);
            d2 = 0.5 * (d2 + d4);
            d9 = 0.5 * (d5 + d3);
            d3 = 0.5 * (d + d9);
            d8 = 0.5 * (d6 + d4);
            d4 = 0.5 * (d2 + d8);
            Shape2DBase.findClosest(d14, d15, d, d2, d3, d4, tuple2d, tuple2d2);
            Shape2DBase.findClosest(d3, d4, d9, d8, d5, d6, tuple2d, tuple2d2);
        }
    }

    private static void findClosest(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Tuple2d tuple2d, Tuple2d tuple2d2) {
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = d > d3 ? (d > d5 ? d : d5) : (d13 = d3 > d5 ? d3 : d5);
        if (d7 > d13) {
            d13 = d7;
        }
        double d15 = d2 > d4 ? (d2 > d6 ? d2 : d6) : (d12 = d4 > d6 ? d4 : d6);
        if (d8 > d12) {
            d12 = d8;
        }
        double d16 = d < d3 ? (d < d5 ? d : d5) : (d11 = d3 < d5 ? d3 : d5);
        if (d7 < d11) {
            d11 = d7;
        }
        double d17 = d2 < d4 ? (d2 < d6 ? d2 : d6) : (d10 = d4 < d6 ? d4 : d6);
        if (d8 < d10) {
            d10 = d8;
        }
        d13 = 0.02 * (d13 + d12 - d11 - d10);
        d13 *= d13;
        if (Line2D.ptLineDistSq(d, d2, d7, d8, d3, d4) <= d9 && Line2D.ptLineDistSq(d, d2, d7, d8, d5, d6) <= d13) {
            Shape2DBase.findClosest(d, d2, d7, d8, tuple2d, tuple2d2);
        } else {
            double d18 = d;
            double d19 = d2;
            double d20 = 0.5 * (d + d3);
            d = d20;
            double d21 = 0.5 * (d2 + d4);
            d2 = d21;
            double d22 = d;
            d = 0.5 * (d3 + d5);
            d3 = 0.5 * (d22 + d);
            double d23 = d2;
            d2 = 0.5 * (d4 + d6);
            d4 = 0.5 * (d23 + d2);
            d13 = 0.5 * (d5 + d7);
            d11 = 0.5 * (d + d13);
            d5 = 0.5 * (d3 + d11);
            d12 = 0.5 * (d6 + d8);
            d10 = 0.5 * (d2 + d12);
            d6 = 0.5 * (d4 + d10);
            Shape2DBase.findClosest(d18, d19, d20, d21, d3, d4, d5, d6, tuple2d, tuple2d2);
            Shape2DBase.findClosest(d5, d6, d11, d10, d13, d12, d7, d8, tuple2d, tuple2d2);
        }
    }

    public static void setIfCloser(Tuple2d tuple2d, double d, double d2, Tuple2d tuple2d2) {
        double d3;
        double d4 = tuple2d.x - tuple2d2.x;
        double d5 = d4 * d4;
        d4 = tuple2d.y - tuple2d2.y;
        double d6 = d5 + d4 * d4;
        d4 = d - tuple2d2.x;
        double d7 = d4 * d4;
        d4 = d2 - tuple2d2.y;
        if (d6 > d7 + d3 * d4) {
            tuple2d.x = d;
            tuple2d.y = d2;
        }
    }

    public void pickTool(Point2d point2d, Matrix3d matrix3d, PickList pickList, EditTool editTool) {
        this.pick(editTool.getToolTarget(), editTool.isTargetNode(), point2d, matrix3d, pickList);
        if (pickList.containsCurrent()) {
            editTool.setPickId(-1);
        }
    }

    public void drawTool(AWTCanvas2D aWTCanvas2D, Matrix3d matrix3d, EditTool editTool) {
    }

    public void toolEventOccured(EditEvent editEvent, EditTool editTool) {
        int n = editTool.getPickId();
        if (n == -1 && editEvent instanceof DragEvent2D) {
            DragEvent2D dragEvent2D = (DragEvent2D)editEvent;
            if (dragEvent2D.draggingStarted()) {
                Point2d point2d = new Point2d(dragEvent2D.point);
                Math2.invTransformPoint((Matrix3d)editTool.getTargetTransformation(), (Tuple2d)point2d);
                editTool.setObject(point2d);
            } else if (dragEvent2D.draggingContinued()) {
                Point2d point2d = editTool.pool.p2d0;
                Point2d point2d2 = (Point2d)editTool.getObject();
                if (point2d2 == null) {
                    return;
                }
                point2d.set((Tuple2d)dragEvent2D.point);
                Math2.invTransformPoint((Matrix3d)editTool.getTargetTransformation(), (Tuple2d)point2d);
                point2d.sub((Tuple2d)point2d2);
                Matrix3d matrix3d = editTool.pool.m3d1;
                Transform2D transform2D = (Transform2D)editTool.getTool().getObjectOfObject(Attributes.TRANSFORM, null);
                if (transform2D != null) {
                    editTool.pool.m3d0.setIdentity();
                    transform2D.transform(editTool.pool.m3d0, matrix3d);
                } else {
                    matrix3d.setIdentity();
                }
                Math2.transformVector((Matrix3d)matrix3d, (Tuple2d)point2d);
                matrix3d.m02 += point2d.x;
                matrix3d.m12 += point2d.y;
                editTool.setTransform(matrix3d);
            }
        }
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)color$FIELD);
        stroke$FIELD = new _Field("stroke", 0x200000, (Type)StrokeAdapter.$TYPE, null, 1);
        $TYPE.addManagedField((ManageableType.Field)stroke$FIELD);
        $TYPE.declareFieldAttribute(color$FIELD, (Attribute)Attributes.COLOR);
        $TYPE.declareFieldAttribute(stroke$FIELD, (Attribute)Attributes.STROKE);
        Shape2DBase.initType();
        $TYPE.validate();
        DEFAULT_STROKE = new StrokeAdapter();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((Shape2DBase)object).color = (Color3f)Tuple3fType.COLOR.setObject((Object)((Shape2DBase)object).color, object2);
                    return;
                }
                case 1: {
                    ((Shape2DBase)object).stroke = (StrokeAdapter)((Object)StrokeAdapter.$TYPE.setObject((Object)((Shape2DBase)object).stroke, object2));
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Shape2DBase)object).getColor();
                }
                case 1: {
                    return ((Shape2DBase)object).getStroke();
                }
            }
            return super.getObject(object);
        }
    }
}

