/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp3d.PerspectiveProjection;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.RayList;
import de.grogra.util.Quantity;
import de.grogra.vecmath.Math2;
import java.util.Random;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class LensProjection
extends PerspectiveProjection {
    double focalLength = 0.05;
    double fStop = 11.0;
    double subjectDistance = 3.0;
    public static final Type $TYPE = new Type(LensProjection.class);
    public static final SCOType.Field focalLength$FIELD = Type._addManagedField($TYPE, "focalLength", 0x200000, de.grogra.reflect.Type.DOUBLE, null, 2);
    public static final SCOType.Field fStop$FIELD = Type._addManagedField($TYPE, "fStop", 0x200000, de.grogra.reflect.Type.DOUBLE, null, 3);
    public static final SCOType.Field subjectDistance$FIELD = Type._addManagedField($TYPE, "subjectDistance", 0x200000, de.grogra.reflect.Type.DOUBLE, null, 4);

    public LensProjection() {
    }

    public LensProjection(float f, float f2) {
        super(f, f2);
    }

    public void generateRandomOrigins(Environment environment, RayList rayList, Random random, Matrix4d matrix4d) {
        Point3d point3d = environment.tmpPoint0;
        this.getRayInViewCoordinates(environment.uv.x, environment.uv.y, point3d, environment.tmpVector0, matrix4d, null);
        float f = (float)(this.focalLength / (this.fStop * 512.0));
        for (int i = 0; i < rayList.size(); ++i) {
            Point3f point3f = rayList.rays[i].origin;
            point3f.set((Tuple3d)point3d);
            point3f.z = (float)((double)point3f.z - this.focalLength);
            int n = random.nextInt();
            float f2 = (float)Math.sqrt(n >>> 16) * f;
            char c = (char)n;
            point3f.x += Math2.ccos((char)c) * f2;
            point3f.y += Math2.csin((char)c) * f2;
            environment.localToGlobal.transform(point3f);
            rayList.rays[i].spectrum.setIdentity();
        }
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, Random random, Matrix4d matrix4d) {
        Point3d point3d = environment.tmpPoint0;
        Vector3d vector3d = environment.tmpVector0;
        this.getRayInViewCoordinates(environment.uv.x, environment.uv.y, point3d, vector3d, matrix4d, null);
        point3d.scaleAdd(-(this.subjectDistance + point3d.z) / vector3d.z, (Tuple3d)vector3d, (Tuple3d)point3d);
        environment.tmpPoint1.set((Tuple3f)environment.localPoint);
        vector3d.sub((Tuple3d)point3d, (Tuple3d)environment.tmpPoint1);
        vector3d.normalize();
        for (int i = 0; i < rayList.size(); ++i) {
            rayList.rays[i].direction.set((Tuple3d)vector3d);
            environment.localToGlobal.transform(rayList.rays[i].direction);
            rayList.rays[i].spectrum.set(spectrum);
        }
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        focalLength$FIELD.setQuantity(Quantity.LENGTH);
        subjectDistance$FIELD.setQuantity(Quantity.LENGTH);
        $TYPE.validate();
    }

    public static class Type
    extends PerspectiveProjection.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 5;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(LensProjection lensProjection, SCOType sCOType) {
            super(lensProjection, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)PerspectiveProjection.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 2: {
                    ((LensProjection)((Object)object)).focalLength = d;
                    return;
                }
                case 3: {
                    ((LensProjection)((Object)object)).fStop = d;
                    return;
                }
                case 4: {
                    ((LensProjection)((Object)object)).subjectDistance = d;
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((LensProjection)((Object)object)).focalLength;
                }
                case 3: {
                    return ((LensProjection)((Object)object)).fStop;
                }
                case 4: {
                    return ((LensProjection)((Object)object)).subjectDistance;
                }
            }
            return super.getDouble(object, n);
        }

        public Object newInstance() {
            return new LensProjection();
        }
    }
}

