/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp3d.Projection;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.util.Quantity;
import de.grogra.vecmath.Math2;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ParallelProjection
extends Projection {
    protected float width;
    public static final Type $TYPE = new Type(ParallelProjection.class);
    public static final SCOType.Field width$FIELD = Type._addManagedField($TYPE, "width", 0x200004, de.grogra.reflect.Type.FLOAT, null, 1);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public ParallelProjection() {
        this(10.0f, 1.0f);
    }

    public ParallelProjection(float f, float f2) {
        this.aspect = f2;
        this.setWidth(f);
    }

    void setWidth(float f) {
        this.width = f;
        this.update();
    }

    public float getWidth() {
        return this.width;
    }

    protected void update() {
        this.sx = 2.0f / this.width;
        this.sy = this.sx / this.aspect;
    }

    protected void getTransformation(float f, float f2, Matrix4d matrix4d, Matrix4d matrix4d2) {
        matrix4d.setIdentity();
        matrix4d.m00 = this.sx;
        matrix4d.m11 = this.sy;
        matrix4d.m22 = -2.0f / (f2 - f);
        matrix4d.m23 = -(f2 + f) / (f2 - f);
        if (matrix4d2 != null) {
            Math2.makeAffine((Matrix4d)matrix4d2);
            Math2.invertAffine((Matrix4d)matrix4d, (Matrix4d)matrix4d2);
        }
    }

    public float getScaleAt(float f) {
        return (float)Math.sqrt(Math.abs(this.sx * this.sy));
    }

    protected void getRayInViewCoordinates(float f, float f2, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, Tuple2d tuple2d) {
        point3d.x = matrix4d.m03;
        point3d.y = matrix4d.m13;
        point3d.z = matrix4d.m23;
        vector3d.set((double)f, (double)f2, 0.0);
        matrix4d.transform(vector3d);
        point3d.add((Tuple3d)vector3d);
        vector3d.set(0.0, 0.0, 1.0);
        matrix4d.transform(vector3d);
        point3d.scaleAdd(-point3d.z / vector3d.z, (Tuple3d)vector3d, (Tuple3d)point3d);
        if (tuple2d != null) {
            tuple2d.x = 0.25;
            tuple2d.y = 1.0E10;
        }
    }

    static {
        width$FIELD.setQuantity(Quantity.LENGTH);
        $TYPE.validate();
    }

    public static class Type
    extends Projection.Type {
        private static final int SUPER_FIELD_COUNT = 1;
        protected static final int FIELD_COUNT = 2;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(ParallelProjection parallelProjection, SCOType sCOType) {
            super(parallelProjection, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Projection.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 1: {
                    ((ParallelProjection)((Object)object)).setWidth(f);
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((ParallelProjection)((Object)object)).width;
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new ParallelProjection();
        }
    }
}

