/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp3d.Projection;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.util.Quantity;
import de.grogra.vecmath.Math2;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PerspectiveProjection
extends Projection {
    protected float fieldOfView;
    public static final Type $TYPE = new Type(PerspectiveProjection.class);
    public static final SCOType.Field fieldOfView$FIELD = Type._addManagedField($TYPE, "fieldOfView", 0x200004, de.grogra.reflect.Type.FLOAT, null, 1);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public PerspectiveProjection() {
        this(1.0471976f, 1.0f);
    }

    public PerspectiveProjection(float f, float f2) {
        this.aspect = f2;
        this.setFieldOfView(f);
    }

    public void setFieldOfView(float f) {
        this.fieldOfView = f;
        this.update();
    }

    public static float clampFieldOfView(float f) {
        return Math.max(Math.min(f, 1.5393804f), 0.003141593f);
    }

    public float getFieldOfView() {
        return this.fieldOfView;
    }

    protected void update() {
        this.sx = 1.0f / (float)Math.tan(0.5 * (double)PerspectiveProjection.clampFieldOfView(this.fieldOfView));
        this.sy = this.sx / this.aspect;
    }

    protected void getTransformation(float f, float f2, Matrix4d matrix4d, Matrix4d matrix4d2) {
        matrix4d.setIdentity();
        matrix4d.m00 = this.sx;
        matrix4d.m11 = this.sy;
        matrix4d.m22 = -(f2 + f) / (f2 - f);
        matrix4d.m23 = -2.0f * f2 * f / (f2 - f);
        matrix4d.m32 = -1.0;
        matrix4d.m33 = 0.0;
        if (matrix4d2 != null) {
            matrix4d2.set(matrix4d);
            matrix4d2.m20 = matrix4d2.m30;
            matrix4d2.m21 = matrix4d2.m31;
            matrix4d2.m22 = matrix4d2.m32;
            matrix4d2.m23 = matrix4d2.m33;
            Math2.invertAffine((Matrix4d)matrix4d2, (Matrix4d)matrix4d2);
        }
    }

    public float getScaleAt(float f) {
        return (float)Math.sqrt(Math.abs(this.sx * this.sy) / (f * f));
    }

    protected void getRayInViewCoordinates(float f, float f2, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, Tuple2d tuple2d) {
        point3d.x = matrix4d.m03;
        point3d.y = matrix4d.m13;
        point3d.z = matrix4d.m23;
        vector3d.set((double)f, (double)f2, 1.0);
        matrix4d.transform(vector3d);
        point3d.scaleAdd(-point3d.z / vector3d.z, (Tuple3d)vector3d, (Tuple3d)point3d);
        if (tuple2d != null) {
            tuple2d.x = 1.0E10;
            double d = vector3d.length() / -vector3d.z;
            tuple2d.y = 0.25 * d * d * d;
        }
    }

    static {
        fieldOfView$FIELD.setQuantity(Quantity.ANGLE);
        $TYPE.validate();
    }

    public static class Type
    extends Projection.Type {
        private static final int SUPER_FIELD_COUNT = 1;
        protected static final int FIELD_COUNT = 2;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(PerspectiveProjection perspectiveProjection, SCOType sCOType) {
            super(perspectiveProjection, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Projection.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 1: {
                    ((PerspectiveProjection)((Object)object)).setFieldOfView(f);
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((PerspectiveProjection)((Object)object)).fieldOfView;
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new PerspectiveProjection();
        }
    }
}

