/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.edit;

import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.DragEvent3D;
import de.grogra.imp3d.LineArray;
import de.grogra.imp3d.PickRayVisitor;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.edit.TransformTool;
import de.grogra.imp3d.objects.NURBSCurve;
import de.grogra.math.BSplineCurve;
import de.grogra.math.Circle;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.event.EditEvent;
import de.grogra.util.EventListener;
import de.grogra.vecmath.Math2;
import java.util.EventObject;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Rotate
extends TransformTool {
    RotateCircle[] circles = new RotateCircle[3];
    static final Color3f YELLOW = new Color3f(1.0f, 1.0f, 0.0f);
    private static final float CIRCLE_RADIUS = 1.0f;
    public static final Node.NType $TYPE = new Node.NType((Node)new Rotate());
    final LineArray lines = new LineArray();

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Rotate();
    }

    void setHighlight(int n) {
        for (int i = 0; i < 3; ++i) {
            this.circles[i].setHighlight(i == n);
        }
    }

    public Rotate() {
        this.addEdgeBitsTo(new RotateCircle(2, 1, 0, 0, new Color3f(1.0f, 0.0f, 0.0f)), 512, null);
        this.addEdgeBitsTo(new RotateCircle(1, 0, 1, 0, new Color3f(0.0f, 0.0f, 1.0f)), 512, null);
        this.addEdgeBitsTo(new RotateCircle(0, 0, 0, 1, new Color3f(0.0f, 1.0f, 0.0f)), 512, null);
    }

    static {
        $TYPE.validate();
    }

    private class RotateCircle
    extends NURBSCurve
    implements Pickable,
    EventListener,
    Command {
        final int id;
        private final Color3f normalColor;
        private final Vector3d rotateAxis = new Vector3d();
        private final Point3d p = new Point3d();
        private final Vector3d v = new Vector3d();
        private final Vector3d w = new Vector3d();
        private final Vector3d delta0 = new Vector3d();
        private final AxisAngle4d axisAngle = new AxisAngle4d();
        private final Matrix3d scaleShear = new Matrix3d();
        private final Matrix3d rot = new Matrix3d();
        private final Matrix3d newRot = new Matrix3d();
        private boolean disabled;

        RotateCircle(int n, int n2, int n3, int n4, Color3f color3f) {
            this.normalColor = color3f;
            this.setHighlight(false);
            this.id = n;
            Rotate.this.circles[n] = this;
            this.rotateAxis.set((double)n2, (double)n3, (double)n4);
            Circle circle = new Circle(1.0f);
            circle.setPlane(n);
            this.setCurve((BSplineCurve)circle);
        }

        public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
            pickList.getGraphState().setObjectContext(null, false);
            this.segmentize(this.getSegmentizableSource(pickList.getGraphState()), pickList.getGraphState(), Rotate.this.lines, 1.0f);
            PickRayVisitor.pickLines(Rotate.this.lines, point3d, vector3d, matrix4d, pickList, 10);
        }

        public void eventOccured(EventObject eventObject) {
            if (eventObject instanceof DragEvent3D) {
                Rotate.this.executeWithWriteLock(this, (EditEvent)((DragEvent3D)((Object)eventObject)));
            }
        }

        public String getCommandName() {
            return null;
        }

        public void run(Object object, Context context) {
            DragEvent3D dragEvent3D = (DragEvent3D)context;
            if (dragEvent3D.draggingFinished()) {
                Rotate.this.setHighlight(-1);
            } else {
                if (dragEvent3D.draggingStarted()) {
                    Rotate.this.setHighlight(this.id);
                    this.disabled = false;
                } else if (this.disabled) {
                    return;
                }
                Matrix4d matrix4d = Rotate.this.getToolTransformation();
                this.p.set((Tuple3d)dragEvent3D.origin);
                Math2.invTransformPoint((Matrix4d)matrix4d, (Tuple3d)this.p);
                this.v.set((Tuple3d)dragEvent3D.direction);
                Math2.invTransformVector((Matrix4d)matrix4d, (Tuple3d)this.v);
                this.v.normalize();
                if (Math.abs(this.v.dot(this.rotateAxis)) < 0.05) {
                    this.disabled = true;
                    return;
                }
                this.w.set((Tuple3d)this.p);
                this.v.scaleAdd(-this.rotateAxis.dot(this.w) / this.rotateAxis.dot(this.v), (Tuple3d)this.v, (Tuple3d)this.p);
                matrix4d = new Matrix4d();
                Rotate.this.local.getRotationScale(this.scaleShear);
                Math2.decomposeQR((Matrix3d)this.scaleShear, (Matrix3d)this.rot);
                matrix4d.setRotationScale(this.scaleShear);
                matrix4d.m33 = 1.0;
                matrix4d.mul(Rotate.this.getAdjustment());
                Math2.transformPoint((Matrix4d)matrix4d, (Tuple3d)this.v);
                if (dragEvent3D.draggingStarted()) {
                    this.delta0.set((Tuple3d)this.v);
                } else {
                    matrix4d.transform(this.rotateAxis, this.w);
                    this.w.normalize();
                    this.v.normalize();
                    this.v.scaleAdd(-this.v.dot(this.w), (Tuple3d)this.w, (Tuple3d)this.v);
                    if (this.v.lengthSquared() < 0.0025) {
                        this.disabled = true;
                        return;
                    }
                    this.v.normalize();
                    this.axisAngle.set(this.w, 0.0);
                    this.w.cross(this.w, this.v);
                    this.axisAngle.angle = -Math.atan2(this.w.dot(this.delta0), this.v.dot(this.delta0));
                    this.newRot.set(this.axisAngle);
                    this.rot.mul(this.newRot);
                    this.rot.mul(this.scaleShear);
                    matrix4d.set(Rotate.this.local);
                    matrix4d.setRotationScale(this.rot);
                    Rotate.this.setTargetTransform(matrix4d);
                }
            }
            dragEvent3D.consume();
        }

        void setHighlight(boolean bl) {
            this.setColor(bl ? YELLOW : this.normalColor);
        }
    }
}

