/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl;

import de.grogra.imp3d.gl.Texture;
import de.grogra.vecmath.Math2;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.opengl.GL;

public class TextureManager {
    static final int MAX_STAMP_DIFF = 100;
    final Hashtable<Image, Texture> texHash = new Hashtable();
    int stamp;

    public void deleteTexture(GL gL, Image image) {
        Texture texture = this.texHash.get(image);
        if (texture != null) {
            texture.delete(gL);
        }
        this.texHash.remove(image);
    }

    public void deleteTextures(GL gL) {
        Enumeration<Texture> enumeration = this.texHash.elements();
        while (enumeration.hasMoreElements()) {
            Texture texture = enumeration.nextElement();
            texture.delete(gL);
        }
        this.texHash.clear();
    }

    private void cleanupTextures(GL gL, int n) {
        Object[] objectArray = this.texHash.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Texture texture = this.texHash.get(object);
            if (this.stamp - texture.stamp <= n) continue;
            texture.delete(gL);
            this.texHash.remove(object);
        }
    }

    private Texture createTexture(GL gL, Image image) {
        Texture texture = null;
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = Math2.roundUpNextPowerOfTwo((int)Math.max(n, n2));
        int[] nArray = new int[10];
        gL.glGetIntegerv(3379, nArray, 0);
        if (n3 > nArray[0]) {
            n3 = nArray[0];
        }
        image = image.getScaledInstance(n3, n3, 4);
        boolean bl = false;
        int[] nArray2 = new int[n3 * n3];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n3, nArray2, 0, n3);
        try {
            pixelGrabber.grabPixels();
            if ((pixelGrabber.getStatus() & 0x80) == 0) {
                bl = true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (bl) {
            texture = new Texture();
            int n4 = 100;
            do {
                this.cleanupTextures(gL, n4);
                n4 /= 2;
            } while (texture.create(gL, n3, nArray2));
        }
        return texture;
    }

    Texture getTexture(GL gL, Image image) {
        Texture texture = this.texHash.get(image);
        if (texture == null) {
            texture = this.createTexture(gL, image);
            this.texHash.put(image, texture);
        }
        texture.stamp = this.stamp++;
        return texture;
    }
}

