/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.Graph;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.View;
import de.grogra.imp.awt.ViewComponentAdapter;
import de.grogra.imp.edit.Tool;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.gl20.GL20DisplayVisitor;
import de.grogra.imp3d.gl20.GL20GfxServer;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.EventListener;
import de.grogra.util.Lock;
import de.grogra.util.LockProtectedRunnable;
import de.grogra.util.Lockable;
import de.grogra.util.Utils;
import de.grogra.xl.lang.ObjectConsumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.JPanel;
import javax.vecmath.Matrix4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GL20Display
extends ViewComponentAdapter
implements GLEventListener {
    private JPanel wrapperPanel;
    private GLCanvas glCanvas;
    private Lock retainedLock = null;
    private boolean disableRetain = false;
    private Object lockMutex = new Object();
    private volatile int repaintFlags;
    private volatile boolean reshaped = true;
    private GL20DisplayVisitor displayVisitor = new GL20DisplayVisitor();

    public void initView(View view, EventListener eventListener) {
        this.wrapperPanel = new JPanel(new GridLayout(1, 1)){
            private static final long serialVersionUID = 1L;

            public void addNotify() {
                super.addNotify();
                if (GL20Display.this.glCanvas == null) {
                    GLCapabilities gLCapabilities = new GLCapabilities();
                    gLCapabilities.setDoubleBuffered(true);
                    gLCapabilities.setHardwareAccelerated(true);
                    GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
                    GL20Display.this.glCanvas = new GLCanvas(gLCapabilities, null, null, graphicsConfiguration != null ? graphicsConfiguration.getDevice() : null);
                    GL20Display.this.glCanvas.addGLEventListener((GLEventListener)GL20Display.this);
                    GL20Display.this.installListeners((Component)GL20Display.this.glCanvas);
                    GL20Display.this.wrapperPanel.add((Component)GL20Display.this.glCanvas);
                }
            }

            public void removeNotify() {
                super.removeNotify();
                if (GL20Display.this.glCanvas != null) {
                    GL20Display.this.wrapperPanel.remove((Component)GL20Display.this.glCanvas);
                    GL20Display.this.glCanvas = null;
                }
            }
        };
        this.wrapperPanel.setMinimumSize(new Dimension(0, 0));
        this.wrapperPanel.setPreferredSize(new Dimension(640, 480));
        super.initView(view, eventListener);
    }

    public void initRender(int n) {
    }

    public void invokeRender(final int n) {
        Utils.executeForcedlyAndUninterruptibly((Lockable)this.getView().getGraph(), (LockProtectedRunnable)new LockProtectedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(boolean bl, Lock lock) {
                boolean bl2 = false;
                Object object = GL20Display.this.lockMutex;
                synchronized (object) {
                    GL20Display.this.repaintFlags |= n;
                    if (!GL20Display.this.disableRetain) {
                        lock.retain();
                        GL20Display.this.retainedLock = lock;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    GL20Display.this.glCanvas.display();
                }
            }
        }, (boolean)false);
    }

    public View3D getView3D() {
        return (View3D)this.getView();
    }

    protected ImageObserver getObserverForRenderer() {
        return null;
    }

    protected void render(int n) throws InterruptedException {
        GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
        GL gL = this.glCanvas.getGL();
        View3D view3D = this.getView3D();
        int n2 = this.glCanvas.getWidth();
        int n3 = this.glCanvas.getHeight();
        view3D.getCanvasCamera().setDimension(n2, n3);
        Camera camera = view3D.getCamera();
        double d = (double)n2 / (double)n3;
        Matrix4d matrix4d = new Matrix4d();
        camera.getViewToClipTransformation(matrix4d);
        matrix4d.mul(new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, d, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
        gL20GfxServer.setViewToClipMatrix(matrix4d);
        gL20GfxServer.setWorldToViewMatrix(camera.getWorldToViewTransformation());
        gL20GfxServer.beginScene(gL);
        Graph graph = this.getView().getGraph();
        this.displayVisitor.initialize(this.getRenderGraphState(), this.getView3D(), false);
        graph.accept(null, (Visitor)this.displayVisitor, null);
        Tool tool = this.getView().getActiveTool();
        if (tool != null) {
            this.displayVisitor.initialize(GraphManager.STATIC_STATE, this.getView3D(), true);
            ArrayPath arrayPath = new ArrayPath(this.getView().getGraph());
            arrayPath.clear((Graph)GraphManager.STATIC);
            for (int i = 0; i < tool.getToolCount(); ++i) {
                GraphManager.acceptGraph((Node)tool.getRoot(i), (Visitor)this.displayVisitor, (ArrayPath)arrayPath);
            }
        }
        gL20GfxServer.endScene();
    }

    public RenderedImage getSnapshot() {
        return null;
    }

    public Object getComponent() {
        return this.wrapperPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(GLAutoDrawable gLAutoDrawable) {
        Lock lock;
        Object object = this.lockMutex;
        synchronized (object) {
            lock = this.retainedLock;
            this.retainedLock = null;
            if (lock != null) {
                this.disableRetain = true;
            }
        }
        if (lock != null) {
            try {
                Workbench.setCurrent((Workbench)this.getView().getWorkbench());
                Utils.executeForcedlyAndUninterruptibly((Lockable)this.getView().getGraph(), (LockProtectedRunnable)new LockProtectedRunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(boolean bl, Lock lock) {
                        int n;
                        Object object = GL20Display.this.lockMutex;
                        synchronized (object) {
                            GL20Display.this.disableRetain = false;
                            n = GL20Display.this.repaintFlags;
                            GL20Display.this.repaintFlags = 0;
                        }
                        GL20Display.this.invokeRenderSync(n);
                    }
                }, (Lock)lock);
            }
            finally {
                Workbench.setCurrent(null);
                object = this.lockMutex;
                synchronized (object) {
                    this.disableRetain = false;
                }
            }
        }
        this.repaint(this.reshaped ? 15 : 7);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.reshaped = true;
    }

    public void makeSnapshot(ObjectConsumer<? super RenderedImage> objectConsumer) {
    }
}

