/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.gl20.GL20Resource;
import de.grogra.imp3d.gl20.GL20ResourceShapeBox;
import de.grogra.imp3d.gl20.GL20ResourceShapeFrustum;
import de.grogra.imp3d.gl20.GL20ResourceShapeLine;
import de.grogra.imp3d.gl20.GL20ResourceShapeLineStrip;
import de.grogra.imp3d.gl20.GL20ResourceShapeParallelogram;
import de.grogra.imp3d.gl20.GL20ResourceShapePlane;
import de.grogra.imp3d.gl20.GL20ResourceShapePolygons;
import de.grogra.imp3d.gl20.GL20ResourceShapeSphere;
import de.grogra.imp3d.gl20.GL20ResourceTexture;
import java.util.ArrayList;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GL20Node {
    private static Stack<Stack<GL20Node>> nodeStack = new Stack();
    private static Stack<Integer> activeNodeIndexStack = new Stack();
    private static GL20Node currentNode;
    private GL20Node childNode = null;
    private GL20Node brotherNode = null;
    private long nodeID;
    private int stamp = -1;
    private int selectionState = 0;
    private GL20Resource resource = null;

    public static void startNewVisit(GL20Node gL20Node) {
        nodeStack.empty();
        activeNodeIndexStack.empty();
        Stack<GL20Node> stack = new Stack<GL20Node>();
        stack.add(gL20Node);
        nodeStack.push(stack);
        activeNodeIndexStack.push(new Integer(0));
        currentNode = gL20Node;
        Stack<GL20Node> stack2 = new Stack<GL20Node>();
        GL20Node gL20Node2 = GL20Node.currentNode.childNode;
        while (gL20Node2 != null) {
            stack2.add(gL20Node2);
            gL20Node2 = gL20Node2.brotherNode;
        }
        nodeStack.add(stack2);
        activeNodeIndexStack.add(new Integer(0));
    }

    public static void enterNode(long l) {
        GL20Node gL20Node;
        int n;
        Stack<GL20Node> stack = nodeStack.peek();
        int n2 = stack.size();
        int n3 = activeNodeIndexStack.peek();
        boolean bl = false;
        for (n = n3; n < n2; ++n) {
            if (((GL20Node)stack.get((int)n)).nodeID != l) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (n != n3) {
                gL20Node = (GL20Node)stack.remove(n);
                stack.insertElementAt(gL20Node, n3);
            }
        } else {
            gL20Node = new GL20Node(l);
            if (n3 < n2) {
                stack.insertElementAt(gL20Node, n3);
            } else {
                stack.add(gL20Node);
            }
        }
        gL20Node = (GL20Node)stack.get(n3);
        if (n3 == 0) {
            GL20Node.currentNode.childNode = gL20Node;
        }
        currentNode = gL20Node;
        Stack<GL20Node> stack2 = new Stack<GL20Node>();
        GL20Node gL20Node2 = GL20Node.currentNode.childNode;
        while (gL20Node2 != null) {
            stack2.add(gL20Node2);
            gL20Node2 = gL20Node2.brotherNode;
        }
        nodeStack.push(stack2);
        activeNodeIndexStack.push(new Integer(0));
    }

    public static ArrayList<GL20Node> leaveNode() {
        int n;
        ArrayList<GL20Node> arrayList = null;
        Stack<GL20Node> stack = nodeStack.pop();
        int n2 = stack.size();
        int n3 = activeNodeIndexStack.pop();
        for (n = 0; n < n3 - 1; ++n) {
            ((GL20Node)stack.get((int)n)).brotherNode = (GL20Node)stack.get(n + 1);
        }
        if (n3 > 0) {
            ((GL20Node)stack.get((int)(n3 - 1))).brotherNode = null;
        } else {
            GL20Node.currentNode.childNode = null;
        }
        if (n3 < n2) {
            arrayList = new ArrayList<GL20Node>();
            for (n = n3; n < n2; ++n) {
                arrayList.add((GL20Node)stack.get(n));
            }
        }
        int n4 = activeNodeIndexStack.pop();
        int n5 = activeNodeIndexStack.peek();
        activeNodeIndexStack.push(new Integer(++n4));
        currentNode = (GL20Node)((Stack)nodeStack.get(nodeStack.size() - 2)).get(n5);
        return arrayList;
    }

    public static GL20Node getCurrentNode() {
        return currentNode;
    }

    public GL20Node(long l) {
        this.nodeID = l;
    }

    public final long getID() {
        return this.nodeID;
    }

    public final int getStamp() {
        return this.stamp;
    }

    public final void setStamp(int n) {
        this.stamp = n;
    }

    public final void setSelectionState(int n) {
        this.selectionState = n;
    }

    public final int getSelectionState() {
        return this.selectionState;
    }

    public final GL20Resource createResource(int n) {
        if (this.resource != null && this.resource.getResourceClassType() != n) {
            this.resource.destroy();
            this.resource = null;
        }
        if (this.resource == null) {
            switch (n) {
                case 65537: {
                    this.resource = new GL20ResourceShapeBox();
                    break;
                }
                case 65538: {
                    this.resource = new GL20ResourceShapeFrustum();
                    break;
                }
                case 65539: {
                    this.resource = new GL20ResourceShapeLine();
                    break;
                }
                case 65540: {
                    this.resource = new GL20ResourceShapeLineStrip();
                    break;
                }
                case 65541: {
                    this.resource = new GL20ResourceShapeParallelogram();
                    break;
                }
                case 65542: {
                    this.resource = new GL20ResourceShapePlane();
                    break;
                }
                case 65543: {
                    this.resource = new GL20ResourceShapePolygons();
                    break;
                }
                case 65544: {
                    this.resource = new GL20ResourceShapeSphere();
                    break;
                }
                case 393217: {
                    this.resource = new GL20ResourceTexture();
                }
            }
        }
        return this.resource;
    }

    public final GL20Resource getResource() {
        return this.resource;
    }

    public final boolean isUpToDate(int n) {
        if (this.stamp != n) {
            return false;
        }
        return this.resource == null || this.resource.isUpToDate();
    }

    public final void update(int n) {
        if (this.resource != null) {
            this.resource.update();
        }
        this.stamp = n;
    }

    public final void destroy() {
        if (this.resource != null) {
            this.resource.destroy();
        }
    }
}

