/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.gl20.GL20GfxServer;
import de.grogra.imp3d.gl20.GL20Resource;

public class GL20ResourceMesh
extends GL20Resource {
    private static final int POLYGON_ARRAY = 1;
    private static final int FIRST_POLYGON_INDEX = 2;
    private static final int LAST_POLYGON_INDEX = 4;
    private int changeMask = -1;
    private PolygonArray polygonArray = null;
    private int firstPolygonIndex = -1;
    private int lastPolygonIndex = -1;
    private int startElementIndex;
    private int elementUsedCount;
    private int elementsPerPrimitive;
    private int primitivePolygonRatio;
    private int drawingFlags = 0;
    private int elementArrayBufferIndex = -1;
    private int arrayBufferIndex = -1;
    private int lastContextID = -1;

    protected GL20ResourceMesh(int n) {
        super(n);
        assert ((n & 0xFFFF0000) == 196608);
    }

    public final void setPolygonArray(PolygonArray polygonArray) {
        if (this.polygonArray != null) {
            if (polygonArray == null) {
                this.polygonArray = null;
                this.changeMask |= 1;
            } else if (polygonArray.userObject != this) {
                this.polygonArray = null;
            }
        }
        if (this.polygonArray == null && polygonArray != null) {
            this.polygonArray = polygonArray;
            this.polygonArray.userObject = this;
            this.changeMask |= 1;
            this.setUsedPolygonArea(0, 0);
        }
    }

    public final boolean setUsedPolygonArea(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        if (this.polygonArray != null && n >= 0 && n < (n3 = this.polygonArray.getPolygonCount())) {
            int n4 = 0;
            if (n2 > 0) {
                if (n + n2 <= n3) {
                    n4 = n + n2;
                }
            } else if (n2 == 0) {
                n4 = n3;
            } else if (n3 + n2 > n) {
                n4 = n3 + n2;
            }
            if (n4 > 0) {
                this.firstPolygonIndex = n;
                this.lastPolygonIndex = n4;
                this.changeMask |= 6;
                bl = true;
            }
        }
        return bl;
    }

    public void draw() {
        if (this.drawingFlags != 0) {
            GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
            gL20GfxServer.drawElementArrayBuffer(this.elementArrayBufferIndex, this.arrayBufferIndex, this.startElementIndex, this.elementUsedCount, this.drawingFlags);
        }
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0 || GL20GfxServer.getInstance().getContextID() != this.lastContextID) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
        int n = gL20GfxServer.getContextID();
        if (this.changeMask != 0 || n != this.lastContextID) {
            if (n == this.lastContextID && (this.changeMask & 1) != 0) {
                gL20GfxServer.deleteElementArrayBuffer(this.elementArrayBufferIndex);
                this.elementArrayBufferIndex = -1;
                gL20GfxServer.deleteArrayBuffer(this.arrayBufferIndex);
                this.arrayBufferIndex = -1;
            }
            if ((this.changeMask & 1) != 0 || n != this.lastContextID) {
                this.drawingFlags = 0;
                this.arrayBufferIndex = -1;
                this.elementArrayBufferIndex = -1;
                if (this.polygonArray != null) {
                    int n2;
                    int n3;
                    this.elementArrayBufferIndex = gL20GfxServer.createElementArrayBuffer();
                    this.arrayBufferIndex = gL20GfxServer.createArrayBuffer();
                    boolean bl = true;
                    if (this.polygonArray.edgeCount == 3) {
                        bl = false;
                    } else if (this.polygonArray.planar) {
                        bl = false;
                    }
                    int n4 = this.polygonArray.dimension * 4 + 8 + 12;
                    int n5 = this.polygonArray.getVertexCount();
                    gL20GfxServer.openArrayBuffer(this.arrayBufferIndex, n5 * n4);
                    float[] fArray = new float[3];
                    for (n3 = 0; n3 < n5; ++n3) {
                        if (this.polygonArray.dimension == 3) {
                            gL20GfxServer.writeArrayBuffer3f(this.polygonArray.vertices.get(n3 * 3), this.polygonArray.vertices.get(n3 * 3 + 1), this.polygonArray.vertices.get(n3 * 3 + 2));
                        } else {
                            gL20GfxServer.writeArrayBuffer4f(this.polygonArray.vertices.get(n3 * 4), this.polygonArray.vertices.get(n3 * 4 + 1), this.polygonArray.vertices.get(n3 * 4 + 2), this.polygonArray.vertices.get(n3 * 4 + 3));
                        }
                        this.polygonArray.getNormal(fArray, n3);
                        gL20GfxServer.writeArrayBuffer3f(-fArray[0], -fArray[1], -fArray[2]);
                        gL20GfxServer.writeArrayBuffer2f(this.polygonArray.uv.get(n3 * 2), this.polygonArray.uv.get(n3 * 2 + 1));
                    }
                    gL20GfxServer.closeArrayBuffer(this.arrayBufferIndex);
                    this.drawingFlags = this.polygonArray.dimension == 3 ? (this.drawingFlags |= 0x2000) : (this.drawingFlags |= 0x4000);
                    this.drawingFlags |= 0x10000;
                    this.drawingFlags |= 0x20;
                    this.drawingFlags |= 0x200;
                    int n6 = n3 = this.polygonArray.getPolygonCount();
                    if (this.polygonArray.edgeCount == 3) {
                        n6 *= 3;
                        n2 = 0;
                        this.elementsPerPrimitive = 3;
                        this.primitivePolygonRatio = 1;
                        this.drawingFlags |= 1;
                    } else if (bl) {
                        n6 *= 6;
                        n2 = 1;
                        this.elementsPerPrimitive = 3;
                        this.primitivePolygonRatio = 2;
                        this.drawingFlags |= 1;
                    } else {
                        n6 *= 4;
                        n2 = 2;
                        this.elementsPerPrimitive = 4;
                        this.primitivePolygonRatio = 1;
                        this.drawingFlags |= 2;
                    }
                    gL20GfxServer.openElementArrayBuffer(this.elementArrayBufferIndex, n6 * 4);
                    int[] nArray = new int[4];
                    int[] nArray2 = new int[4];
                    block6: for (int i = 0; i < n3; ++i) {
                        this.polygonArray.getPolygon(i, nArray, nArray2);
                        switch (n2) {
                            case 0: {
                                gL20GfxServer.writeElementArrayBufferiv(nArray, 3);
                                continue block6;
                            }
                            case 1: {
                                gL20GfxServer.writeElementArrayBufferiv(nArray, 3);
                                gL20GfxServer.writeElementArrayBuffer3i(nArray[0], nArray[2], nArray[3]);
                                continue block6;
                            }
                            case 2: {
                                gL20GfxServer.writeElementArrayBufferiv(nArray, 4);
                            }
                        }
                    }
                    gL20GfxServer.closeElementArrayBuffer(this.elementArrayBufferIndex);
                    this.drawingFlags |= 0x300000;
                }
                this.lastContextID = n;
            }
            if (((this.changeMask & 2) != 0 || (this.changeMask & 4) != 0) && this.polygonArray != null) {
                this.startElementIndex = this.firstPolygonIndex * this.primitivePolygonRatio * this.elementsPerPrimitive;
                this.elementUsedCount = (this.lastPolygonIndex - this.firstPolygonIndex) * this.primitivePolygonRatio * this.elementsPerPrimitive;
            }
            this.changeMask = 0;
        }
        super.update();
    }

    public void destroy() {
        GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
        gL20GfxServer.deleteArrayBuffer(this.arrayBufferIndex);
        gL20GfxServer.deleteElementArrayBuffer(this.elementArrayBufferIndex);
        super.destroy();
    }
}

