/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.gl20.GL20GLSLCode;
import de.grogra.imp3d.gl20.GL20GfxServer;
import de.grogra.imp3d.gl20.GL20Resource;
import de.grogra.imp3d.gl20.GL20ShaderServer;
import de.grogra.imp3d.shading.Material;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;

abstract class GL20ResourceShader
extends GL20Resource {
    public static final int NON_OPAQUE = 1;
    public static final int NEEDS_NORMAL = 2;
    public static final int NEEDS_TEXCOORD = 4;
    public static final int NEEDS_WORLD_TO_VIEW_MATRIX = 8;
    public static final int NEEDS_LIGHTS = 16;
    private static final int SHADER = 1;
    private int changeMask = -1;
    private Shader shader = null;
    private int shaderStamp = -1;
    private boolean isShaderValid = false;
    private int vertexShaderIndex = 0;
    private int fragmentShaderIndex = 0;
    private int shaderProgramIndex = 0;
    private int userCount = 0;

    public GL20ResourceShader(int n) {
        super(n);
        assert ((n & 0x40000) != 0);
    }

    public final Shader getShader() {
        return this.shader;
    }

    public abstract int getEnvironmentDependencies();

    public abstract int getScalarFromShader(GL20GLSLCode var1, int var2);

    public abstract int getVector3FromShader(GL20GLSLCode var1, int var2);

    public abstract int getVector4FromShader(GL20GLSLCode var1, int var2);

    public boolean setShader(Shader shader) {
        boolean bl = false;
        if (this.shader != shader) {
            this.shader = shader;
            this.changeMask |= 1;
        } else {
            bl = true;
        }
        return bl;
    }

    public void registerUser() {
        ++this.userCount;
    }

    public void unregisterUser() {
        if (this.userCount == 1) {
            this.destroy();
        }
        --this.userCount;
    }

    public void applyShader(boolean bl) {
        if (!this.isShaderValid) {
            Object object;
            GL20GLSLCode gL20GLSLCode = new GL20GLSLCode();
            int n = this.getVector4FromShader(gL20GLSLCode, 24);
            if (n != -1) {
                object = new String("gl_FragColor = " + gL20GLSLCode.getVector4Name(n) + ";\n");
                gL20GLSLCode.freeVector4(n);
                gL20GLSLCode.appendCode((String)object);
            }
            object = GL20GfxServer.getInstance();
            ((GL20GfxServer)object).createShader(gL20GLSLCode);
            this.isShaderValid = true;
        }
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0) {
            return false;
        }
        if (this.shader != null && this.shader instanceof Material && ((Material)this.shader).getStamp() != this.shaderStamp || this.shader instanceof RGBAShader && ((RGBAShader)this.shader).getStamp() != this.shaderStamp) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        if (this.shader != null) {
            int n = -1;
            if (this.shader instanceof Material) {
                n = ((Material)this.shader).getStamp();
            } else if (this.shader instanceof RGBAShader) {
                n = ((RGBAShader)this.shader).getStamp();
            }
            if (n != this.shaderStamp) {
                this.shaderStamp = n;
                this.isShaderValid = false;
            }
        }
        if (this.changeMask != 0) {
            this.changeMask = 0;
        }
        super.update();
    }

    public void destroy() {
        GL20ShaderServer.removeShader(this);
    }
}

