/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.gl20.GL20Const;
import de.grogra.imp3d.gl20.GL20GfxServer;
import de.grogra.imp3d.gl20.GL20Resource;
import de.grogra.imp3d.gl20.GL20ResourceShader;
import javax.vecmath.Matrix4d;

public abstract class GL20ResourceShape
extends GL20Resource {
    private static final int WORLD_MATRIX = 1;
    private static final int SHAPE_MATRIX = 2;
    private static final int SHADER = 4;
    private int changeMask = -1;
    private Matrix4d worldMatrix = new Matrix4d(GL20Const.identityMatrix4d);
    private Matrix4d shapeMatrix = new Matrix4d(GL20Const.identityMatrix4d);
    private GL20ResourceShader shader = null;
    private Matrix4d finalMatrix = new Matrix4d(GL20Const.identityMatrix4d);

    protected GL20ResourceShape(int n) {
        super(n);
        assert ((n & 0xFFFF0000) == 65536);
    }

    public final void setWorldTransformationMatrix(Matrix4d matrix4d) {
        if (!this.worldMatrix.equals(matrix4d)) {
            this.worldMatrix.set(matrix4d);
            this.changeMask |= 1;
        }
    }

    public final Matrix4d getWorldTransformationMatrix() {
        return this.worldMatrix;
    }

    public final void setShapeTransformationMatrix(Matrix4d matrix4d) {
        if (!this.shapeMatrix.equals(matrix4d)) {
            this.shapeMatrix.set(matrix4d);
            this.changeMask |= 2;
        }
    }

    public final Matrix4d getShapeTransformationMatrix() {
        return this.shapeMatrix;
    }

    public final void setShader(GL20ResourceShader gL20ResourceShader) {
        if (this.shader != gL20ResourceShader) {
            if (this.shader != null) {
                this.shader.unregisterUser();
            }
            this.shader = gL20ResourceShader;
            if (this.shader != null) {
                this.shader.registerUser();
            }
            this.changeMask |= 4;
        }
    }

    public final GL20ResourceShader getShader() {
        return this.shader;
    }

    public void applyGeometry() {
        GL20GfxServer.getInstance().setWorldTransformationMatrix(this.finalMatrix);
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        if (this.changeMask != 0) {
            this.finalMatrix.set(this.worldMatrix);
            this.finalMatrix.mul(this.shapeMatrix);
            this.changeMask = 0;
        }
        super.update();
    }

    public void destroy() {
        if (this.shader != null) {
            this.shader.unregisterUser();
        }
        super.destroy();
    }
}

