/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.gl20.GL20GfxServer;
import de.grogra.imp3d.gl20.GL20Resource;
import de.grogra.vecmath.Math2;
import java.awt.Image;
import java.awt.image.PixelGrabber;

class GL20ResourceTexture
extends GL20Resource {
    private static final int IMAGE = 1;
    private int changeMask = -1;
    private Image image = null;
    private int textureIndex = 0;
    private int textureDimensions = 0;
    private boolean opaqueTexture = true;

    public GL20ResourceTexture() {
        super(393217);
    }

    public final boolean isTextureOpaque() {
        return this.textureIndex != 0 && this.textureDimensions != 0 && this.image != null ? this.opaqueTexture : true;
    }

    public final int getTextureDimensions() {
        return this.textureIndex != 0 && this.image != null ? this.textureDimensions : 0;
    }

    public boolean setImage(Image image) {
        boolean bl = false;
        if (this.image != image) {
            GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
            if (this.textureIndex != 0) {
                gL20GfxServer.deleteTextureIndex(this.textureDimensions, this.textureIndex);
                this.textureIndex = 0;
                this.textureDimensions = 0;
                this.opaqueTexture = true;
                image = null;
            }
            if (image != null) {
                int n = 1;
                int n2 = Math2.roundUpNextPowerOfTwo((int)image.getWidth(null));
                int n3 = Math2.roundUpNextPowerOfTwo((int)image.getHeight(null));
                Image image2 = image.getScaledInstance(n2, n3, 4);
                int[] nArray = new int[n2 * n3];
                PixelGrabber pixelGrabber = new PixelGrabber(image2, 0, 0, n2, n3, nArray, 0, n2);
                try {
                    pixelGrabber.grabPixels();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (bl && (pixelGrabber.getStatus() & 0x80) != 0) {
                    bl = false;
                }
                if (bl) {
                    if (n3 > 1) {
                        n = 2;
                    }
                    this.textureIndex = gL20GfxServer.createTextureIndex(n);
                    int n4 = 0;
                    n4 = gL20GfxServer.setTextureImage(this.textureIndex, n2, n3, 1, nArray);
                    if (n4 == 0) {
                        bl = false;
                    } else if (n4 == n) {
                        this.textureDimensions = n4;
                    } else {
                        bl = false;
                    }
                }
                if (!bl) {
                    if (this.textureIndex != 0) {
                        gL20GfxServer.deleteTextureIndex(n, this.textureIndex);
                        this.textureIndex = 0;
                    }
                    this.textureDimensions = 0;
                    this.opaqueTexture = true;
                } else {
                    this.image = image;
                    this.opaqueTexture = true;
                    int n5 = 0;
                    for (int i = 0; i < 1 && this.opaqueTexture; ++i) {
                        for (int j = 0; j < n3 && this.opaqueTexture; ++j) {
                            for (int k = 0; k < n2 && this.opaqueTexture; ++k) {
                                if ((nArray[n5] >> 24 & 0xFF) != 255) {
                                    this.opaqueTexture = false;
                                }
                                ++n5;
                            }
                        }
                    }
                }
            } else {
                bl = true;
            }
            this.changeMask |= 1;
        } else {
            bl = true;
        }
        return bl;
    }

    public final boolean bindTexture(int n) {
        boolean bl = false;
        if (this.textureIndex != 0 && this.textureDimensions != 0 && this.image != null) {
            GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
            bl = gL20GfxServer.bindTextureIndex(this.textureDimensions, this.textureIndex, n);
        }
        return bl;
    }

    public final void unbindTexture(int n) {
        if (this.textureIndex != 0 && this.textureDimensions != 0 && this.image != null) {
            GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
            gL20GfxServer.unbindTexture(this.textureDimensions, n);
        }
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        if (this.changeMask != 0) {
            if ((this.changeMask & 1) != 0) {
                // empty if block
            }
            this.changeMask = 0;
        }
        super.update();
    }

    public void destroy() {
        if (this.textureIndex != 0 && this.textureDimensions != 0 && this.image != null) {
            GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
            gL20GfxServer.deleteTextureIndex(this.textureDimensions, this.textureIndex);
            this.textureIndex = 0;
        }
        super.destroy();
    }
}

